//////////////////////////////////////////////////////////////////////
// objs.c - Object code for Ghetto War
// Copyright Joe Kopena 1998
//////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include <allegro.h>
#include <noflick.h>

#include "gwar.h"
#include "data.h"

#include "ostats.h"
#include "objs.h"
#include "objai.h"

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void drawBasicObject(objPtr me) {
int x, y;
BITMAP *nasty;

   nasty = (BITMAP *)(dataFile[me->currFrame].dat);

   x = (me->x/GAME_GRID_SIZE) - (nasty->w/2);
   y = (me->y/GAME_GRID_SIZE) - (nasty->h/2);

   ff_pushDrawn(x, y, nasty->w, nasty->h);

   rotate_sprite(double_buffer, nasty, x, y, itofix(me->angle));

// end drawBasicObject
}

//////////////////////////////////////////////////////////////////////
void drawNonRotObject(objPtr me) {
int x, y;
BITMAP *nasty;

   nasty = (BITMAP *)(dataFile[me->currFrame].dat);

   x = (me->x/GAME_GRID_SIZE) - (nasty->w/2);
   y = (me->y/GAME_GRID_SIZE) - (nasty->h/2);

   ff_pushDrawn(x, y, nasty->w, nasty->h);

   draw_sprite(double_buffer, nasty, x, y);

// end drawNonRotObject
}

//////////////////////////////////////////////////////////////////////
void drawExplosion(objPtr me) {
int x, y;
RLE_SPRITE *nasty;

   nasty = explosion[me->currFrame];

   x = (me->x/GAME_GRID_SIZE) - (nasty->w/2);
   y = (me->y/GAME_GRID_SIZE) - (nasty->h/2);

   ff_pushDrawn(x, y, nasty->w, nasty->h);
   draw_rle_sprite(double_buffer, nasty, x, y);

//end drawExplosion
}

// OBJ_INIT_ARGS      objPtr me, int x, int y, fixed angle

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int initPlayer1(OBJ_INIT_ARGS) {
int err = 0;

   me->currFrame = SHIP0;
   me->x = x;
   me->y = y;
   me->angle = angle;
   me->speed = 0;
   me->health = 50;
   me->damage = 75;
   me->fireDelay = 100;  // In millis

   me->drawFunc = drawBasicObject;
   me->deathFunc = shipDeath;
   me->thinkFunc = player1Think;
   me->thinkTime = 10;  // In millis
   me->touchFunc = player1ShipTouch; //player1ShotTouch;

//   me->bbox[0].x = -120;
//   me->bbox[0].y = -140;
//   me->bbox[1].x = 190;
//   me->bbox[1].y = -140;
//   me->bbox[1].x = 190;
//   me->bbox[1].y = 140;
//   me->bbox[3].x = -120;
//   me->bbox[3].y = 140;

   me->radius = 16641; // 129;

// end initPlayer1
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int initPlayer1Bullet(OBJ_INIT_ARGS) {
int err = 0;

   me->currFrame = P1SHOT0;
   me->x = x;
   me->y = y;
   me->angle = angle;
   me->speed = 30;            // He goes slower
   me->health = 1;
   me->damage = 17;

   me->drawFunc = drawNonRotObject;
   me->deathFunc = NULL;
   me->thinkFunc = player1ShotThink;
   me->thinkTime = 3;               // But he moves more often
   me->touchFunc = player1ShotTouch;

//   me->bbox[0].x = -20;  // He's got a nice little box :)
//   me->bbox[0].y = -20;  // Remember, these are in game co-ords (I hope :)
//   me->bbox[1].x = 20;
//   me->bbox[1].y = -20;
//   me->bbox[1].x = 20;
//   me->bbox[1].y = 20;
//   me->bbox[3].x = -20;
//   me->bbox[3].y = 20;

   me->radius = 400; // 20;

// end initPlayer1Bullet
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int initPlayer2(OBJ_INIT_ARGS) {
int err = 0;

   me->currFrame = P2SHIP0;
   me->x = x;
   me->y = y;
   me->angle = angle;
   me->speed = 0;
   me->health = 100;
   me->damage = 175;
   me->fireDelay = 250;  // In millis

   me->drawFunc = drawBasicObject;
   me->deathFunc = shipDeath;
   me->thinkFunc = player2Think;
   me->thinkTime = 10;  // In millis
   me->touchFunc = player2ShipTouch; // player2ShotTouch;

//   me->bbox[0].x = -140;
//   me->bbox[0].y = -190;
//   me->bbox[1].x = 190;
//   me->bbox[1].y = -140;
//   me->bbox[1].x = 160;
//   me->bbox[1].y = 190;
//   me->bbox[3].x = -120;
//   me->bbox[3].y = 140;

   me->radius = 22500; // 150;

// end initPlayer2
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int initPlayer2Bullet(OBJ_INIT_ARGS) {
int err = 0;

   me->currFrame = P2SHOT0;
   me->x = x;
   me->y = y;
   me->angle = angle;
   me->speed = 20;            // He goes slower
   me->health = 1;
   me->damage = 50;

   me->drawFunc = drawBasicObject;
   me->deathFunc = NULL;
   me->thinkFunc = player2ShotThink;
   me->thinkTime = 3;               // But he moves more often
   me->touchFunc = player2ShotTouch;

//   me->bbox[0].x = -80;  // He's got a nice little box :)
//   me->bbox[0].y = -50;  // Remember, these are in game co-ords (I hope :)
//   me->bbox[1].x = 20;
//   me->bbox[1].y = -20;
//   me->bbox[1].x = 80;
//   me->bbox[1].y = 50;
//   me->bbox[3].x = -20;
//   me->bbox[3].y = 20;

   me->radius = 3481; // 59;

// end initPlayer2Bullet
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int initExplosion(OBJ_INIT_ARGS) {
int err = 0;

   me->currFrame = 0;
   me->x = x;
   me->y = y;
   me->angle = angle;
   me->speed = 0;
   me->health = 200; // Not needed, so doesn't matter
   me->damage = 0;

   me->thinkFunc = explosionThink;
   me->thinkTime = 5;
   me->drawFunc = drawExplosion;
   me->deathFunc = NULL;
   me->touchFunc = NULL;

   me->radius = 0;

// end initExplosion
return err;
}


