//////////////////////////////////////////////////////////////////////
// gwar.h - Main code header for Ghetto War
// Copyright Joe Kopena 1998
//////////////////////////////////////////////////////////////////////

#ifndef GWAR_MAIN_HEADER
#define GWAR_MAIN_HEADER

#define GAME_TIME_BASE     1     // In milliseconds

#define GAME_GRID_W        (6400)   // The visible portion
#define GAME_GRID_H        (4800)
#define GAME_GRID_SIZE     (10)
#define GG_LBORDER         (-100)
#define GG_RBORDER         (6500)
#define GG_TBORDER         (-100)
#define GG_BBORDER         (4900)

#define UP_DIR          192
#define DOWN_DIR        64
#define LEFT_DIR        128
#define RIGHT_DIR       0
#define DRIGHT_DIR      256

#define NUM_EXPLO_FRAMES   64

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
extern DATAFILE *dataFile;
extern RLE_SPRITE *explosion[];
extern char gameDone;
extern volatile unsigned long gameTime;
extern double sinTable[], cosTable[];

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void worldThink(void);

int setup(int argc, char *argv[]);
void shutdown(void);

void incGameTime(void);

#endif // GWAR_MAIN_HEADER

