// GET 2 THE DOOR - by Kristoffer Relling, 1999.

#include <stdlib.h>
#include <conio.h>
#include "allegro.h"
#include "door.h"

BEGIN_JOYSTICK_DRIVER_LIST
END_JOYSTICK_DRIVER_LIST

typedef struct gameobject {
  int        X, Y;
  int        direction;
  int        frame;
  RLE_SPRITE *Sprite;
};

#define LEFT  0
#define RIGHT 1
#define UP    2
#define DOWN  3

#define MAX_ENEMIES 80
#define MAX_CASH    30
#define MAX_SKIES   10
#define MAX_FLAMES  10

#define PAN(x) (((x) * 256) / SCREEN_W)

//-----------------------------------------------------------------------

DATAFILE   *gamedata;
BITMAP     *screenbuffer;
COLOR_MAP  transtable;
int        cur_choice;
int        finito = FALSE;
int        paused = FALSE;
int        killed_by_spider = 0;
int        killed_by_fire_place = 0;
int        steps = 0;
int        total_steps = 0;
int        god_mode = FALSE;
int        cash_collected = 0;
int        gammalevel;
gameobject Hero, Enemy[MAX_ENEMIES], Cash[MAX_CASH], Door, Sky[MAX_SKIES], FirePlace[MAX_FLAMES];

//-----------------------------------------------------------------------

void main_menu              ();
void help_screen            ();
void shut_down              ();
void Error                  (unsigned char Errornumber);
void gameover               ();
void got_2_the_door         ();
void kr_presents            ();
void title_screen           ();
int  hitdetect              (gameobject *A, gameobject *B);
int  hitdetect2             (gameobject *A, gameobject *B);
void set_new_pal            (PALETTE src_pal);
int  save_screenshot        ();
void pause_game             ();
void moveplayer             (char direction);
void resetgame              ();
void move_enemies           ();
void animate_coins          ();
void animate_fire_place     ();
void animate_skies          ();
void check_cash_collision   ();
void initialize_area        ();
void update_area_display    ();
void process_keyboard_input ();
void playgame               ();

//-----------------------------------------------------------------------

void main_menu()
{
  clear(screenbuffer);
  clear(screen);
  set_palette((PALETTE) gamedata[GAME_PAL].dat);

  clear_keybuf();

  while (!key[KEY_SPACE])
  {
    if (key[KEY_UP])  {
                        cur_choice--;
                        play_sample(gamedata[CLICK].dat, 155, 155, 1000, FALSE);
                        if (cur_choice < 0) cur_choice = 2;
                      }
    else
    if (key[KEY_DOWN]){
                        cur_choice++;
                        play_sample(gamedata[CLICK].dat, 155, 155, 1000, FALSE);
                        if (cur_choice > 2) cur_choice = 0;
                      }
    if (key[KEY_ESC]) {
                        cur_choice = 2;
                        play_sample(gamedata[CLICK].dat, 155, 155, 1000, FALSE);
                      }
                      
    rest(100);

    if (cur_choice == 0) draw_rle_sprite(screenbuffer, gamedata[MENU_CH_0].dat,
                                         SCREEN_W / 2 - 80, SCREEN_H / 2 - 30);

    if (cur_choice == 1) draw_rle_sprite(screenbuffer, gamedata[MENU_CH_1].dat,
                                         SCREEN_W / 2 - 80, SCREEN_H / 2 - 30);

    if (cur_choice == 2) draw_rle_sprite(screenbuffer, gamedata[MENU_CH_2].dat,
                                         SCREEN_W / 2 - 80, SCREEN_H / 2 - 30);

    blit(screenbuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  }
  if (cur_choice == 0) {
                         play_sample(gamedata[CLICK_2].dat, 155, 155, 1000, FALSE);
                         fade_out(5);
                         playgame();
                       }
  if (cur_choice == 1) {
                         play_sample(gamedata[CLICK_2].dat, 155, 155, 1000, FALSE);
                         fade_out(5);
                         help_screen();
                       }
  if (cur_choice == 2) {
                         play_sample(gamedata[CLICK_2].dat, 155, 155, 1000, FALSE);
                         fade_out(5);
                         shut_down();
                       }
}

//-----------------------------------------------------------------------

void help_screen()
{
  clear(screenbuffer);
  clear(screen);

  play_midi(gamedata[HELP_SCREEN_MIDI].dat, TRUE);

  ((RGB*) gamedata[BLACK_PAL].dat)[0] = black_palette[0];
  set_palette((RGB*) gamedata[BLACK_PAL].dat);
  set_palette(black_palette);

  blit((BITMAP*) gamedata[HELP_SCREEN_BMP].dat, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

  fade_in((PALETTE) gamedata[HELP_SCREEN_PAL].dat, 3);
  rest(1000);
  clear_keybuf();
  while (!key[KEY_ESC]){}
  play_sample(gamedata[CLICK_2].dat, 155, 155, 1000, FALSE);
  fade_out(5);
  stop_midi();
  cur_choice = 1;
  main_menu();
}

//-----------------------------------------------------------------------

void shut_down()
{
  destroy_bitmap(screenbuffer);
  unload_datafile(gamedata);
  set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
  printf("You did %d steps in total!\n", total_steps);
  printf("Bye-bye...\n");

  exit(0);
}

//-----------------------------------------------------------------------

void Error(unsigned char Errornumber)
{
  set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
  printf("\nERROR %u: ", Errornumber);
  switch(Errornumber) {
    case 1:
      printf("Error initializing sound system (%s)\n", allegro_error);
    break;
    case 2:
      printf("Error reading datafile...\n");
    break;
    case 3:
      printf("Can not set the proper video mode (%s)\n", allegro_error);
    break;
    case 4:
      printf("Error initializing timer (%s)\n", allegro_error);
    break;
    case 5:
      printf("Error initializing keyboard.\n%s\n", allegro_error);
    break;
    default:
      printf("Undetermined error...\n");
    break;
  }
  exit(Errornumber);
}

//-----------------------------------------------------------------------

void gameover()
{
  BITMAP *textbuf, *dispbuf;
  int    angle = 0;

  if (killed_by_fire_place == 1) goto hero_burn;
  if (killed_by_spider == 1) {

    remove_int(move_enemies);
    remove_int(process_keyboard_input);
    remove_int(animate_skies);
    remove_int(animate_coins);
    remove_int(animate_fire_place);
  
    play_sample(gamedata[OH_MY_GOD].dat, 255, PAN(Hero.X), 1000, FALSE);

    /* WARNING! Ugly code ahead! */

    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_2].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_3].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_4].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_5].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_6].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_7].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_8].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_9].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_10].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_11].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_12].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_13].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_14].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_15].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_16].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_17].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_18].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_19].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_20].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_21].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_22].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_23].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_24].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_25].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_26].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_27].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_28].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_29].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_30].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_31].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_32].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_33].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_34].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_35].dat;
    update_area_display();

    /* Finally, this is the end of the nasty, ugly code :) */
  
    rest(200);
    clear_keybuf();
    goto end_of_ugly_nasty_code;
  }

  hero_burn: {
    remove_int(move_enemies);
    remove_int(animate_skies);
    remove_int(animate_coins);
    remove_int(animate_fire_place);

    play_sample(gamedata[OH_MY_GOD].dat, 255, PAN(Hero.X), 1000, FALSE);
    play_sample(gamedata[HERO_ON_FIRE].dat, 255, PAN(Hero.X), 1000, FALSE);

    /* WARNING! Ugly code ahead! */

    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_2].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_3].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_4].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_5].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_6].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_7].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_8].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_2].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_3].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_4].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_5].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_6].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_7].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_8].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_2].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_3].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_4].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_5].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_6].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_7].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_8].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_2].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_3].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_4].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_5].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_6].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_7].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_8].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_9].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_10].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_9].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[FLAME_10].dat;
    update_area_display();
    rest(100);

    /* Finally, this is the end of the nasty, ugly code :) */

    remove_int(process_keyboard_input);

    /* Oops! The ugly code is back... */

    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_2].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_3].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_2].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_3].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_2].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_1].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_BURNED_3].dat;
    update_area_display();
    rest(100);
    Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_KILLED_35].dat;
    update_area_display();
    rest(100);

    /* Finally, no more dirty code :) */
  }

  end_of_ugly_nasty_code: {
  
    // allocate display buffer
    dispbuf = create_bitmap(screenbuffer->w, screenbuffer->h);
    blit(screenbuffer, dispbuf, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  
    // make a text bitmap
    textbuf = create_bitmap(200, 100);
    clear(textbuf);
    textout_centre(textbuf, (FONT*) gamedata[FONT_GAME_OVER].dat, "GAME OVER", textbuf->w/2+1, textbuf->h/2+1, 4);
    textout_centre(textbuf, (FONT*) gamedata[FONT_GAME_OVER].dat, "GAME OVER", textbuf->w/2, textbuf->h/2, 3);
  
    // rotate the text
    while(!key[KEY_ESC])
    {
      if(angle>255) angle = 0;
      clear(screenbuffer);
      blit(dispbuf, screenbuffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      rotate_sprite(screenbuffer, textbuf, (SCREEN_W-textbuf->w)/2, (SCREEN_H-textbuf->h)/2, itofix(angle));
      blit(screenbuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      rest(3);
      angle++;
    }

    fade_out(2);
    stop_midi();
    cur_choice = 0;
    main_menu();
  }
}

//-----------------------------------------------------------------------

void got_2_the_door()
{
  BITMAP *textbuf, *dispbuf;
  int    angle = 0;

  play_sample(gamedata[WOO_HOO].dat, 255, PAN(Hero.X), 1000, FALSE);
  play_midi(gamedata[THE_END].dat, TRUE);
  rest(200);
  clear_keybuf();
  
  // allocate display buffer
  dispbuf = create_bitmap(screenbuffer->w, screenbuffer->h);
  blit(screenbuffer, dispbuf, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  
  // make a text bitmap
  textbuf = create_bitmap(250, 100);
  clear(textbuf);
  textout_centre(textbuf, (FONT*) gamedata[FONT_GAME_OVER].dat, "LEVEL COMPLETE", textbuf->w/2+1, textbuf->h/2+1, 4);
  textout_centre(textbuf, (FONT*) gamedata[FONT_GAME_OVER].dat, "LEVEL COMPLETE", textbuf->w/2, textbuf->h/2, 3);
  
  // rotate the text
  while(!key[KEY_ESC])
  {
    if(angle > 255) angle = 0;
    clear(screenbuffer);
    blit(dispbuf, screenbuffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    rotate_sprite(screenbuffer, textbuf, (SCREEN_W - textbuf->w)/2, (SCREEN_H - textbuf->h)/2, itofix(angle));
    blit(screenbuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    rest(3);
    angle++;
  }
  fade_out(2);
  stop_midi();

  set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);

  cputs(gamedata[CONGRATULATION].dat);

  play_midi(gamedata[CONGRATS].dat, TRUE);
  clear_keybuf();
  readkey();
  stop_midi();
  shut_down();
}

//-----------------------------------------------------------------------

volatile int scroll_count;

void scroll_counter()
{
  scroll_count++;
}

END_OF_FUNCTION(scroll_counter);

//-----------------------------------------------------------------------

void kr_presents()
{
  play_midi(gamedata[INTRO_TUNE].dat, TRUE);
  set_palette(gamedata[TITLE_PAL].dat);
  blit((BITMAP*) gamedata[TITLE_BMP1].dat, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  rest(2000);
}

//-----------------------------------------------------------------------

void title_screen()
{
  int c;

  scroll_count = 1;
  install_int(scroll_counter, 5);

  while ((c = scroll_count) < 160)
    stretch_blit(gamedata[TITLE_BMP2].dat, screen, 0, 0, 320, 128,
      SCREEN_W/2 - c, SCREEN_H/2 - c * 64/160 - 32, c * 2, c * 128/160);

  remove_int(scroll_counter);
  blit((BITMAP*) gamedata[TITLE_BMP2].dat, screen, 0, 0, SCREEN_W/2-160, SCREEN_H/2-96, 320, 128);

  clear_keybuf();
  scroll_count = 0;

  play_sample(gamedata[SHAWN_WELCOME].dat, 155, 155, 1000, FALSE);
  rest(2000);
  readkey();
  fade_out(5);
  stop_midi();
}

//-----------------------------------------------------------------------

int hitdetect(gameobject *A, gameobject *B)
{
  if((A->X > B->X + B->Sprite->w-1) || (B->X > A->X + A->Sprite->w-1) ||
     (A->Y > B->Y + B->Sprite->h-1) || (B->Y > A->Y + A->Sprite->h-1))
    return FALSE; else return TRUE;
}

//-----------------------------------------------------------------------

int hitdetect2(gameobject *A, gameobject *B)
{
  if((A->X > B->X + B->Sprite->w + 10) ||
     (B->X > A->X + A->Sprite->w + 10) ||
     (A->Y > B->Y + B->Sprite->h + 10) ||
     (B->Y > A->Y + A->Sprite->h + 10))
    return FALSE; else return TRUE;
}

//-----------------------------------------------------------------------

void set_new_pal(PALETTE src_pal)
{
  PALETTE gamma_pal;      
  int i, j;
  float amount;

    switch (gammalevel) {
	case 0:
		amount = 0.25;
		break;
	case 1:
		amount = 0.50;
		break;
	case 2:
		amount = 0.75;
		break;
	case 3:
		amount = 1.00;
		break;
	case 4:
		amount = 1.25;
 		break;
  	case 5:
                amount = 1.50;
		break;
	case 6:
		amount = 1.75;
		break;
	case 7:
		amount = 2.00;
		break;
	default:
		amount = 1.00;
		break;
    }

    for (i = 0; i < 256; i++)
    {
      j = (int) (((float) src_pal[i].r) * amount);
      if (j < 0) j = 0; if (j > 63) j = 63;
      gamma_pal[i].r = j;
      j = (int) (((float) src_pal[i].g) * amount);
      if (j < 0) j = 0; if (j > 63) j = 63;
      gamma_pal[i].g = j;
      j = (int) (((float) src_pal[i].b) * amount);
      if (j < 0) j = 0; if (j > 63) j = 63;
      gamma_pal[i].b = j;
    }
  set_palette(gamma_pal);
}

//-----------------------------------------------------------------------

int save_screenshot()
{
  int err = 0, i;
  char filename[80];
  BITMAP *bmp;

  for (i = 0; i < 10000; i++)
  {
    strcpy(filename, "shot");
    itoa(i, &filename[4], 10);
    strcat(filename, ".bmp");
   
    if (!__file_exists(filename))
       break;
  }

  bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
  err = save_bitmap(filename, bmp, gamedata[GAME_PAL].dat);
  destroy_bitmap(bmp);

  return err;
}

//-----------------------------------------------------------------------

void pause_game()
{
  remove_int(move_enemies);
  remove_int(animate_skies);
  remove_int(animate_coins);
  remove_int(animate_fire_place);

  midi_pause();
  play_sample(gamedata[PAUSE].dat, 155, 155, 1000, FALSE);
  rest(1000);
  clear_keybuf();
  readkey();
  clear_keybuf();
  midi_resume();

  install_int_ex(animate_coins, BPS_TO_TIMER(15));
  install_int_ex(animate_skies, BPS_TO_TIMER(20));
  install_int_ex(move_enemies, BPS_TO_TIMER(20));
  install_int_ex(animate_fire_place, BPS_TO_TIMER(20));
}

//-----------------------------------------------------------------------

void moveplayer(int direction)
{
  if(!Hero.frame)
  {
    Hero.frame = 10;
    Hero.direction = direction;

    if (Hero.X < 0)
    {
      play_sample(gamedata[CANT_DO_THAT].dat, 155, 155, 1000, FALSE);
      Hero.X = 0;
    }
    if (Hero.Y < 0)
    {
      play_sample(gamedata[CANT_DO_THAT].dat, 155, 155, 1000, FALSE);
      Hero.Y = 0;
    }
    if (Hero.X > 620)
    {
      play_sample(gamedata[CANT_DO_THAT].dat, 155, 155, 1000, FALSE);
      Hero.X = 620;
    }
    if (Hero.Y > 460)
    {
      play_sample(gamedata[CANT_DO_THAT].dat, 155, 155, 1000, FALSE);
      Hero.Y = 460;
    }
  }

  switch(Hero.direction)
  {
    case LEFT:
      Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_LEFT].dat;
      Hero.X--;
    break;
    case RIGHT:
      Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_RIGHT].dat;
      Hero.X++;
    break;
    case UP:
      Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_UP].dat;
      Hero.Y--;
    break;
    case DOWN:
      Hero.Sprite = (RLE_SPRITE*) gamedata[HERO_DOWN].dat;
      Hero.Y++;
    break;
  }

  Hero.frame--;
}

//-----------------------------------------------------------------------

void resetgame()
{
  steps = 0;
  cash_collected = 0;
  clear(screen);
  clear(screenbuffer);
}

//-----------------------------------------------------------------------

void move_enemies()
{
  int what_enemy;

  for(what_enemy = 0; what_enemy < MAX_ENEMIES; what_enemy++)
  {
    Enemy[what_enemy].X += (rand()%3 - 1);
    Enemy[what_enemy].Y += (rand()%3 - 1);
  }
}
END_OF_FUNCTION(move_enemies);

//-----------------------------------------------------------------------

void animate_coins()
{
  int what_coin;

  for (what_coin = 0; what_coin < MAX_CASH; what_coin++)
  {
    if (Cash[what_coin].Sprite == gamedata[CASH_1].dat)
      Cash[what_coin].Sprite = (RLE_SPRITE*) gamedata[CASH_2].dat;
    else if (Cash[what_coin].Sprite == gamedata[CASH_2].dat)
      Cash[what_coin].Sprite = (RLE_SPRITE*) gamedata[CASH_3].dat;
    else if (Cash[what_coin].Sprite == gamedata[CASH_3].dat)
      Cash[what_coin].Sprite = (RLE_SPRITE*) gamedata[CASH_4].dat;
    else if (Cash[what_coin].Sprite == gamedata[CASH_4].dat)
      Cash[what_coin].Sprite = (RLE_SPRITE*) gamedata[CASH_5].dat;
    else if (Cash[what_coin].Sprite == gamedata[CASH_5].dat)
      Cash[what_coin].Sprite = (RLE_SPRITE*) gamedata[CASH_6].dat;
    else if (Cash[what_coin].Sprite == gamedata[CASH_6].dat)
      Cash[what_coin].Sprite = (RLE_SPRITE*) gamedata[CASH_1].dat;
  }
}
END_OF_FUNCTION(animate_coins);

//-----------------------------------------------------------------------

void animate_fire_place()
{
  int what_fire_place;

  for (what_fire_place = 0; what_fire_place < MAX_FLAMES; what_fire_place++)
  {
    if (FirePlace[what_fire_place].Sprite == gamedata[FIRE_PLACE_1].dat)
      FirePlace[what_fire_place].Sprite = (RLE_SPRITE*) gamedata[FIRE_PLACE_2].dat;
    else if (FirePlace[what_fire_place].Sprite == gamedata[FIRE_PLACE_2].dat)
      FirePlace[what_fire_place].Sprite = (RLE_SPRITE*) gamedata[FIRE_PLACE_1].dat;
  }
}
END_OF_FUNCTION(animate_fire_place);

//-----------------------------------------------------------------------

void animate_skies()
{
  int count;

  for(count = 0; count < MAX_SKIES; count++)
  {
    if(Sky[count].X >= SCREEN_W)
      Sky[count].X = -Sky[count].Sprite->w;
    if(Sky[count].Y<=-Sky[count].Sprite->h)
      Sky[count].Y = SCREEN_H + Sky[count].Sprite->h;

    if(Sky[count].Sprite == gamedata[SKY_1].dat)
      Sky[count].X++;
    else
      Sky[count].X += 2;
    if(Sky[count].Sprite == gamedata[SKY_1].dat)
      Sky[count].Y--;
    else
      Sky[count].Y -= 2;
  }
}
END_OF_FUNCTION(animate_skies);

//-----------------------------------------------------------------------

void check_cash_collision()
{
  int count;
  
  for(count = 0; count < MAX_CASH; count++)
  if(Cash[count].Sprite && hitdetect(&Hero, &Cash[count]))
  {
    Cash[count].Sprite = NULL;
    play_sample(gamedata[GOT_CASH].dat, 255, PAN(Hero.X), 1000, FALSE);
    cash_collected++;
  }
}

//-----------------------------------------------------------------------

void initialize_area()
{
  int count, count2, isOK, what_enemy;

  Hero.X         = rand()%32*20;
  Hero.Y         = rand()%24*20;
  Hero.direction = DOWN;
  Hero.frame     = 0;
  Hero.Sprite    = (RLE_SPRITE*) gamedata[HERO_DOWN].dat;
  
  Door.X         = rand()%32*20;
  Door.Y         = rand()%24*20;
  Door.Sprite    = (RLE_SPRITE*) gamedata[DOOR].dat;

  // Here we are preventing the money to get laid over each other.

  for (count = 0; count < MAX_CASH; count++)
  {
    isOK = TRUE;
    while (isOK)
    {
      Cash[count].Sprite = (RLE_SPRITE*) gamedata[CASH_1+rand()%6].dat;
      Cash[count].X      = rand()%32*20;
      Cash[count].Y      = rand()%24*20;

      // Is the random coordinates OK?
      isOK = FALSE;
      for (count2 = 0; count2 < count; count2++)
      if (hitdetect(&Cash[count], &Cash[count2])) isOK = TRUE;
    }
  }

  // And here we prevents that the hero gets burned in the very beginning.

  for (count = 0; count < MAX_FLAMES; count++)
  {
    isOK = TRUE;

    while (isOK)
    {
      FirePlace[count].Sprite = (RLE_SPRITE*) gamedata[FIRE_PLACE_1+rand()%2].dat;
      FirePlace[count].X      = rand()%32*20;
      FirePlace[count].Y      = rand()%24*20;

      // Is the random coordinates OK?
      isOK = FALSE;
      for (count2 = 0; count2 < count; count2++)
      if (!hitdetect2(&Hero, &FirePlace[count])) isOK = FALSE;
    }
  }

  // And here we prevents that the fire-places get laid over the money.

  for (count = 0; count < MAX_FLAMES; count++)
  {
    isOK = TRUE;

    while (isOK)
    {
      FirePlace[count].Sprite = (RLE_SPRITE*) gamedata[FIRE_PLACE_1+rand()%2].dat;
      FirePlace[count].X      = rand()%32*20;
      FirePlace[count].Y      = rand()%24*20;

      // Is the random coordinates OK?
      isOK = FALSE;
      for (count2 = 0; count2 < count; count2++)
      if (!hitdetect2(&Cash[count], &FirePlace[count])) isOK = FALSE;
    }
  }

  // And here we prevents that the fire-places get laid over each other.

  for (count = 0; count < MAX_FLAMES; count++)
  {
    isOK = TRUE;

    while (isOK)
    {
      FirePlace[count].Sprite = (RLE_SPRITE*) gamedata[FIRE_PLACE_1+rand()%2].dat;
      FirePlace[count].X      = rand()%32*20;
      FirePlace[count].Y      = rand()%24*20;

      // Is the random coordinates OK?
      isOK = FALSE;
      for (count2 = 0; count2 < count; count2++)
      if (!hitdetect2(&FirePlace[count], &FirePlace[count])) isOK = FALSE;
    }
  }

  // And here we prevents that the hero gets killed in the very beginning.

  for (count = 0; count < MAX_ENEMIES; count++)
  {
    isOK = TRUE;

    while (isOK)
    {
      Enemy[count].Sprite = (RLE_SPRITE*) gamedata[ENEMY].dat;
      Enemy[count].X      = rand()%32*20;
      Enemy[count].Y      = rand()%24*20;

      // Is the random coordinates OK?
      if (!hitdetect2(&Hero, &Enemy[count])) isOK = FALSE;
    }
  }

  for (count = 0; count < MAX_SKIES; count++)
  {
    Sky[count].Sprite = (RLE_SPRITE*) gamedata[SKY_1 + rand()%2].dat;
    Sky[count].X      = rand()%320;
    Sky[count].Y      = rand()%200;
  }
  
  update_area_display();
}

//-----------------------------------------------------------------------

void update_area_display()
{
  int  count;
  char statusbar[80];
  char buffer[80];

  clear((BITMAP*) screenbuffer);

  for (count = 0; count < MAX_ENEMIES; count++)
  draw_rle_sprite(screenbuffer, Enemy[count].Sprite, Enemy[count].X, Enemy[count].Y);

  for (count = 0; count < MAX_CASH; count++)
  if (Cash[count].Sprite)
  draw_rle_sprite(screenbuffer, Cash[count].Sprite, Cash[count].X, Cash[count].Y);

  for (count = 0; count < MAX_FLAMES; count++)
  if (FirePlace[count].Sprite)
  draw_rle_sprite(screenbuffer, FirePlace[count].Sprite, FirePlace[count].X, FirePlace[count].Y);

  draw_rle_sprite(screenbuffer, Hero.Sprite, Hero.X, Hero.Y);

  if (cash_collected >= 30)
  draw_rle_sprite(screenbuffer, Door.Sprite, Door.X, Door.Y);

  for (count = 0; count < MAX_SKIES; count++)
  draw_trans_rle_sprite (screenbuffer, Sky[count].Sprite, Sky[count].X, Sky[count].Y);

  strcpy(statusbar, "Steps taken: ");
  strcat(statusbar, itoa(steps, buffer, 10));
  strcat(statusbar, "   Cash collected: $ ");
  strcat(statusbar, itoa(cash_collected, buffer, 10));
  textout(screenbuffer, font, statusbar, 11, 11, makecol(127,127,127));
  textout(screenbuffer, font, statusbar, 10, 10, makecol(255,255,255));

  blit(screenbuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

//-----------------------------------------------------------------------

void process_keyboard_input()
{
  if(!Hero.frame)
  {
    if (key[KEY_LEFT])  { moveplayer(LEFT);  steps++; total_steps++; } else
    if (key[KEY_RIGHT]) { moveplayer(RIGHT); steps++; total_steps++; } else
    if (key[KEY_UP])    { moveplayer(UP);    steps++; total_steps++; } else
    if (key[KEY_DOWN])  { moveplayer(DOWN);  steps++; total_steps++; } else
    if (key[KEY_ESC])   { finito = TRUE;                             }
  }
  else
  {
    moveplayer(Hero.direction);
  }
}
END_OF_FUNCTION(process_keyboard_input);

//-----------------------------------------------------------------------

void playgame()
{
  int what_enemy, what_fire_place;
  int count;

  finito = FALSE;

  resetgame();

  set_palette((PALETTE) gamedata[GAME_PAL].dat);
  initialize_area();
  play_midi(gamedata[GAME_TUNE].dat, TRUE);
  install_int_ex(animate_coins, BPS_TO_TIMER(15));
  install_int_ex(animate_skies, BPS_TO_TIMER(20));
  install_int_ex(process_keyboard_input, BPS_TO_TIMER(50));
  install_int_ex(move_enemies, BPS_TO_TIMER(20));
  install_int_ex(animate_fire_place, BPS_TO_TIMER(20));

  while(!finito)
  {
    if (key[KEY_P])     pause_game();
    if (key[KEY_F11])
    {
      gammalevel++;
      if (gammalevel == 8) gammalevel = 0;
      set_new_pal(gamedata[GAME_PAL].dat);
      rest(100);
      clear_keybuf();
    }
    if (key[KEY_F12]) save_screenshot();

    for (what_enemy = 0; what_enemy < MAX_ENEMIES; what_enemy++)
    if (hitdetect(&Hero, &Enemy[what_enemy]))
      {
        killed_by_fire_place = 0;
        if (!god_mode) {killed_by_spider = 1; gameover();}
        if (god_mode) killed_by_spider = 0;
      }

    for (what_fire_place = 0; what_fire_place < MAX_FLAMES; what_fire_place++)
    if (hitdetect(&Hero, &FirePlace[what_fire_place]))
      {
        killed_by_spider = 0;
        if (!god_mode) {killed_by_fire_place = 1; gameover();}
        if (god_mode) killed_by_fire_place = 0;
      }

    if (cash_collected >= 30) if (hitdetect(&Hero, &Door)) got_2_the_door();
    update_area_display();
    check_cash_collision();
  }

  remove_int(move_enemies);
  remove_int(process_keyboard_input);
  remove_int(animate_skies);
  remove_int(animate_coins);
  remove_int(animate_fire_place);
  
  clear_keybuf();
  stop_midi();
  fade_out(5);
  cur_choice = 0;
  main_menu();
}

//-----------------------------------------------------------------------

int main(int argc, char *argv[])
{
  int c;

  for (c = 1; c < argc; c++) {
    if (stricmp(argv[c], "-iddqd") == 0)
       god_mode = TRUE;
  }
  printf("\nGET 2 THE DOOR - BY KRISTOFFER RELLING, 1999.\n");
  printf("BUILD: %s (%s)\n\n", __DATE__, __TIME__);

  delay(3000);

  printf("Initializing Allegro...\n");
  if (allegro_init())
  {
    printf("Critical error.\n%s\n", allegro_error);
    exit(1);
  }

  printf("Initializing timers...\n");
  if (install_timer()) Error(4);

  printf("Locking data...\n");
  LOCK_FUNCTION(animate_coins);
  LOCK_FUNCTION(animate_fire_place);
  LOCK_FUNCTION(animate_skies);
  LOCK_FUNCTION(process_keyboard_input);
  LOCK_FUNCTION(move_enemies);
  
  printf("Initializing keyboard...\n");
  if (install_keyboard()) Error(5);

  printf("Loading datafile...\n");
  gamedata = load_datafile("DOOR.DAT");
  if (!gamedata) Error(2);

  printf("Initializing sound system...\n");
  if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, ".")) Error(1);
  set_volume(255, 130);
  
  printf("Creating translucency table...\n");
  create_trans_table(&transtable, gamedata[GAME_PAL].dat, 100, 100, 100, NULL);
  color_map = &transtable;

  printf("Set GFX mode...\n");
  if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0)) Error(3);
  screenbuffer = create_bitmap(SCREEN_W, SCREEN_H);
  text_mode(-1);

  rest(500);

  kr_presents();
  title_screen();

  main_menu();
  shut_down();
  
}

//-----------------------------------------------------------------------


