// core.c
void init_beginning (int screen_x_size, int screen_y_size, int color_depth);
void load_palette (PALETTE *pal, char *filename);
void load_sprites (BITMAP *sprites[]);
void load_icons (void);
void load_config_file (int *screen_x, int *screen_y);
void respond_to_keyboard_input ();
void respond_to_mouse_input ();

// utility.c
void copy_page (BITMAP *source, BITMAP *dest);
void cycle_sprite_array (int forwards);
void save_image_to_file (void);
int load_image_from_file(char filename[]);
void init_newly_loaded_image ();
void write_bitmap_file (char *filename, BITMAP *image);
void sort_string_array(char unsorted_strings[][MAX_MENU_OPTION_LENGTH], int num_elements);
void save_config_file (void);
void shout (char *str);     // Used in debugging
void snum (int num);
void sort_filenames (char choices[][MAX_MENU_OPTION_LENGTH], int num_choices);
void get_str_from_int (char *str, int num, int length);
void help_text (char * text);
void init_grid_cell_size (void);
int add_current_color (int col);
void increment_drawing_color (int color_add);
void restore_magnified_area (void);

// gui.c
int get_width(char choices[][MAX_MENU_OPTION_LENGTH], int num_choices);
void get_string(char *return_string, int x, int y, char *default_str, 
    unsigned int max_chars);
int get_menu_option (int x1, int y1, int x2, int y2, int num_choices,
    char choices[][MAX_MENU_OPTION_LENGTH]);
void main_menu(void);
void do_sprite_menu (void);
void do_view_menu (void);
void do_tools_menu (void);
void display_help (void);
void display_splash_screen (void);
void toggle_grid (void);
void toggle_background (void);
void toggle_solid_paste (void);
void toggle_fullscreen_window (void);
void toggle_mirror_horizontal ();
void toggle_mirror_vertical ();

// sprites.c
void flip_horizontal (void);
void flip_vertical (void);
void rotate_90_degrees (void);
void rotate_spr (int init, int angle);
void clear_sprite_image (void);
void shift_sprite (int x_shift, int y_shift);
void resize_sprite (void);
void mirror_image (int type, int mouse_x_cell, int mouse_y_cell);
void draw_border (void);

// drawing.c
void draw_grids (void);
void update_info_area (void);
void refresh_cur_color_boxes (void);
void refresh_image_grid (void);
void view_sprite_tiled (void);
void checker_area (int x1, int y1, int x2, int y2);
void refresh_color_grid (void);
void refresh_colors_main_square ();
void dotted_rect (BITMAP *bmp, int x1, int y1, int x2, int y2);
void draw_icons (void);
void redraw_core (void);
void draw_pixel_t (BITMAP * bmp, int x, int y, int d);
void change_video_mode (void);
