#include "headers.h"

// Global variable definitions

PALETTE pal;                    // Stores the current palette in memory
BITMAP *buffer;                 // Video memory buffer
BITMAP *sprites[NUM_SPRITES];   // Holds the sprite data
BITMAP *image[NUM_IMAGES];      // Holds the image data for the image in progress
BITMAP *buffer_image;           // Holds the image for temporary drawing operations
BITMAP *copy_image;             // Holds the image for copy/paste operations

int cur_color[MAX_CUR_COLORS];  // Current drawing colors in the palette
int separate_cur_color;         // For the separate cur color box

int draw_color;                 // Which of the cur_color[]s are being used to draw with
int grid_cell_size;             // How many pixels tall and wide the grid cells are
int cur_tool;                   // The current drawing tool in use

char cur_filename[200];         // The filename of the sprite being edited
int prev_x_cell, prev_y_cell;   // Previous mouse cell; used for drawing functions
int screen_type;                // Toggles between fullscreen and windowed view
int background_style;           // Toggles between black or checkered background pixels
int grid_activated;             // Toggles between visible or invisible sprite grid
int drawing_operation;          // Indicates to use buffer_image instead of image[0] to
                                       // draw from. TRUE means use buffer_image;

int color_strips_on;            // TRUE draw color strips; FALSE draw all possible colors
int solid_paste;                // TRUE solid pastes using blit, FALSE transparent pastes
int pbrush_size;                // Width of the circles drawn by the paintbrush
char load_fail_filename[1000];  // Holds the filename of the sprite that failed to load

char filename_was_passed;
char passed_filename[2000]; // Pointer to the filename passed in

char *tool_descriptions[] = {"Pencil", "Brush", "Line", "Rect.", "Box", "Oval", "Fill", 
                            "Copy", "Magnify", "Paste"};

char *icon_filenames[] = { "icon-pencil.bmp", "icon-brush.bmp", "icon-line.bmp", 
    "icon-rectangle.bmp", "icon-fillrect.bmp", "icon-oval.bmp",
    "icon-fill.bmp", "icon-select.bmp", "icon-magnify.bmp", "icon-paste.bmp", 
    "icon-pencil-in.bmp", "icon-brush-in.bmp", "icon-line-in.bmp", 
    "icon-rectangle-in.bmp", "icon-fillrect-in.bmp", "icon-oval-in.bmp",
    "icon-fill-in.bmp", "icon-select-in.bmp", "icon-magnify-in.bmp",
    "icon-paste-in.bmp" };

BITMAP *icon_images [NUM_ICON_FILES];
int num_icon_files;
char icons_enabled = TRUE;

char magnified;                 // Whether or not the current bitmap is a magnified
                                // piece of another bitmap
BITMAP * magnify_original;      // When working on a magnified bitmap, holds a pointer
                                // to the original bitmap
int prev_tool;                  // Drawing tool before magnification
int mag_x_pixel, mag_y_pixel;   // Coords of the upper left pixel where mag. started

int drawing_color_base;         // Base color to draw the lightness/darkness square w/

int mirror_horizontal, mirror_vertical;	// If TRUE, copy the image while drawing
