// Global variable declarations

extern PALETTE pal;                    // Stores the current palette in memory
extern BITMAP *buffer;                 // Video memory buffer
extern BITMAP *sprites[NUM_SPRITES];   // Holds the sprite data
extern BITMAP *image[NUM_IMAGES];      // Holds the image data for the image in progress
extern BITMAP *buffer_image;           // Holds the image for temporary drawing operations
extern BITMAP *copy_image;             // Holds the image for copy/paste operations

extern int cur_color[MAX_CUR_COLORS];  // Current drawing colors in the palette
extern int separate_cur_color;         // For the separate cur color box

extern int draw_color;                 // Which of the cur_color[]s are being used to draw with
extern int grid_cell_size;             // How many pixels tall and wide the grid cells are
extern int cur_tool;                   // The current drawing tool in use

extern char cur_filename[200];         // The filename of the sprite being edited
extern int prev_x_cell, prev_y_cell;   // Previous mouse cell; used for drawing functions
extern int screen_type;                // Toggles between fullscreen and windowed view
extern int background_style;           // Toggles between black or checkered background pixels
extern int grid_activated;             // Toggles between visible or invisible sprite grid
extern int drawing_operation;          // Indicates to use buffer_image instead of image[0] to
                                       // draw from. TRUE means use buffer_image;

extern int color_strips_on;            // TRUE draw color strips; FALSE draw all possible colors
extern int solid_paste;                // TRUE solid pastes using blit, FALSE transparent pastes
extern int pbrush_size;                // Width of the circles drawn by the paintbrush
extern char load_fail_filename[1000];  // Holds the filename of the sprite that failed to load

extern char filename_was_passed;
extern char passed_filename[2000]; // Pointer to the filename passed in

extern char *tool_descriptions[];
extern char *icon_filenames[];

extern BITMAP *icon_images [NUM_ICON_FILES];
extern int num_icon_files;
extern char icons_enabled;
extern char magnified;                 // Whether or not the current bitmap is a magnified
                                // piece of another bitmap
extern BITMAP * magnify_original;      // When working on a magnified bitmap, holds a pointer
                                // to the original bitmap
extern int prev_tool;                  // Drawing tool before magnification
extern int mag_x_pixel, mag_y_pixel;   // Coords of the upper left pixel where mag. started

extern int drawing_color_base;         // Base color to draw the lightness/darkness square w/

extern int mirror_horizontal;			// If TRUE, copy the image while editing
extern int mirror_vertical;
