#include <allegro.h>

#define PLAYERS_MAX 32

#define PID_NO       0
#define PID_TAIL     1
#define PID_PLAYER   2
#define PID_DIAM     3
#define PID_SHOT     4
#define PID_REMOVE   5
#define PID_BUG     11 // stupid, non eating
#define PID_BUG2    12 // clever, non eating
#define PID_BUG3    13 // stupid, eating

typedef struct Player {
	int id;
	int ox, oy, odx, ody;
   int x, y;
   int c;
   int dirx, diry;
	int step;
	
	int ammo;		
	
	int attached;
	
	int pathx[1024];
	int pathy[1024];
	int pathpos;
	int time;
	
	int dead;		
	
} Player;

extern Player players[PLAYERS_MAX];

void PlayersInit(void);
int PlayerCreate(int id, int x, int y);
void PlayerAttach(int p, int p2);

void PlayerDraw(int p, BITMAP *bmp);

void PlayerMove(int p);
int PlayerCanMove(int p, int dirx, int diry);
void PlayerChangePosition(int p, int dirx, int diry);

void PlayerRestoreAll(BITMAP *bmp);
void PlayerDrawAll(BITMAP *bmp);
void PlayerMoveAll(void);
