#include <allegro.h>

#include "main.h"
#include "game.h"
#include "dirty.h"
#include "map.h"
#include "player.h"
#include "menu.h"
#include "data.h"

/* The level number. */
int levelnum = 1;
int completed = 0;
int mapnew;

int life_away;
int diams_left;
int getready;
int shooting;
int score;

int show_fps = 0;

int controls[5] = { KEY_LEFT, KEY_RIGHT, KEY_UP, KEY_DOWN, KEY_SPACE };

void level(void) {
	completed = 0;
	mapnew = 1;
	life_away = 0;	
	getready = 1;
	MapCreate(levelnum);		
}

/* Initialize the game. */
void Init(void) {
					
	levelnum = 1;	
	level();		
	
	score = 0;
	shooting = 0;	
				
}

/* Exit the game. */
void Exit() {
	
	unload_datafile(data);		
	
	exit(0);
}

/* Handle keyboard input for the player. */
void PlayerInput() {
	int kx = 0, ky = 0;

	if(key[controls[0]]) kx = -1;
	if(key[controls[1]]) kx = 1;
	if(key[controls[2]]) ky = -1;
	if(key[controls[3]]) ky = 1;
	
	if(key[controls[4]] && !shooting && players[0].ammo) {
		int s;
		shooting = 1;	
		
		s = PlayerCreate(PID_SHOT,
			players[0].x,
			players[0].y);						
			
		if(PlayerCanMove(s, players[0].dirx, players[0].diry)) {
			players[0].ammo--;
			PlayerChangePosition(s, players[0].dirx, players[0].diry);
			players[s].ammo = 1;
		} else {		
			players[s].id = 0;
		}
			
	} else shooting = 0;

	/* We only allow 4 directions, so if 2 keys are pressed, ignore them. */
	if(kx && ky) kx = ky = 0;

	if(kx || ky)
		if(PlayerCanMove(0, kx, ky))
			PlayerChangePosition(0, kx, ky);
}

/* Handle one single time frame of the game logic. */
void Frame() {

	while(keypressed()) {
		int k = readkey();
		k >>= 8;
		if(k == KEY_ESC) {
			Menu();
			mapnew = 1;
		}
		
		if(k == KEY_SPACE || k == KEY_ENTER) {
			if(life_away) {
				score = 0;
				life_away = 0;
				if(levelnum <= 10) level();
			}
		}
		
		//if(k == KEY_D) clear(screen);
		//if(k == KEY_C) diams_left--;
		//if(k == KEY_S) diams_left = 1;
		if(k == KEY_F) show_fps = 1;
		//if(k == KEY_E) completed = 1;
		
	}
	
	if(getready) {
		if(!key[controls[0]] &&
			!key[controls[1]] &&
			!key[controls[2]] &&
			!key[controls[3]] &&
			!key[controls[4]]) getready = 0;
	}
	
	if(!life_away && !getready && !completed) PlayerInput();	
	
	if(!getready && !completed && !life_away) PlayerMoveAll();
	
	if(completed) {
		int a = frames & 31;
		if(a & 1) { if(a < 16) players[0].x--; else players[0].x++; }
		if(a == 0) players[0].y--;
		if(players[0].y < -50) {
			Menu();
			mapnew = 1;
		}
	}
		
}

/* Update the screen contents of the game. */
void Draw(BITMAP *page) {
	if(mapnew || completed) { MapDraw(page); mapnew = 0; }
	PlayerRestoreAll(page);
	MapDrawPart(page, 0, 0, 3, 1); // Restore background for points.
	MapDrawPart(page, 17, 0, 22, 1); // Restore background for diams left.
	MapDrawPart(page, 36, 0, 39, 1); // Restore ammo display.
	
	if(life_away || completed) { MapDrawPart(page, 10, 15, 29, 16); }
	
	PlayerDrawAll(page);
	text_mode(-1);	
	textprintf(page, font, 0, 0, -1, "%04d", score);	
	textprintf_right(page, font, SCREEN_W, 0, -1, "%04d", players[0].ammo);				
	textprintf_centre(page, font, SCREEN_W / 2, 0, -1, "%04d", diams_left);			
	
	text_mode(0);
	if(show_fps) textprintf_right(page, oldfont, SCREEN_W, 0, -1, "%04d", fps);
	
	if(diams_left == 0) {
		levelnum++;
		if(levelnum <= 10) level(); else completed = 1;
	}
	
	text_mode(-1);
	if(completed) {	
		textprintf_centre(page, font, SCREEN_W / 2, SCREEN_H / 2, -1, "You Win!");			
		
		draw_sprite(page, (BITMAP *)data[FLY_BMP].dat,
			players[0].x * 16 - 7 - 24, players[0].y * 16 - 7 - 24);
							
	}
	else if(life_away)	
		textprintf_centre(page, font, SCREEN_W / 2, SCREEN_H / 2, -1, "Restarting Level");	
}
