#include <allegro.h>

#include "game.h"
#include "data.h"
#include "player.h"
#include "map.h"
#include "main.h"
#include "bug.h"

/* A list of all the players (human + AI) in the game. */
Player players[PLAYERS_MAX];

void PlayersInit(void) {
	int p;
	for(p = 0; p < PLAYERS_MAX; p++) {
		players[p].id = 0;
	}
}

/* Create a new, active player. */
int PlayerCreate(int id, int x, int y) {

	int p;

	for(p = 0; p < PLAYERS_MAX; p++) {
		if(players[p].id == 0) break;
	}
	if(p == PLAYERS_MAX) return -1;

	players[p].id = id;
	
	players[p].ox = players[p].x = x;
	players[p].oy = players[p].y = y;
	players[p].odx = players[p].dirx = -1;
	players[p].ody = players[p].diry = 0;
	
	players[p].step = 0;		
		
	players[p].ammo = 0;
	
	players[p].attached = -1;	
	
	players[p].dead = 0;
	
	players[p].pathpos = 0;
	players[p].time = 0;
	
	PlayerChangePosition(p, 0, 0);	

	return p;
}

/* Attach a player to another (used to create the tail). */
void PlayerAttach(int p, int p2) {
	players[p].attached = p2;
}

/* Draw a player. */
void PlayerDraw(int p, BITMAP *bmp) {
	int x, y;
	
	int a = players[p].attached;
	int d = players[p].dead;

	x = players[p].x * 16 + 7 - players[p].dirx * players[p].step;
	y = players[p].y * 16 + 7 - players[p].diry * players[p].step;        
                      
   switch(players[p].id) {
   	case PID_PLAYER: {   		   		
   	
   		int anim = abs(((frames * 4) & 255) - 128);
   	   		
   	   if(completed) break;   	   		
   	   		
   		circlefill(bmp, x, y, 7, makecol(0, 255,0 ));
   	
	   	circlefill(bmp,
	   		x - players[p].diry * 3 + players[p].dirx * 3,
	   		y + players[p].dirx * 3 + players[p].diry * 3, 3,
	   		d?0:makecol(0, 0, 100 + anim));
	   	circlefill(bmp,
	   		x + players[p].diry * 3 + players[p].dirx * 3,
	   		y - players[p].dirx * 3 + players[p].diry * 3, 3,
	   		d?0:makecol(0, 0, 100 + anim));	   		   	
	   		
	   	if(a >= 0) {
		   	int ax = players[a].x * 16 + 7 - players[a].dirx * players[a].step;
				int ay = players[a].y * 16 + 7 - players[a].diry * players[a].step;
				
				circlefill(bmp, (x + ax)/2, (y + ay) / 2, 4, makecol(0, 200,0 ));
		   }
			break;
		}
	   
	   case PID_TAIL:
	   
	   	if(completed) break;
	   
	   	circlefill(bmp, x, y, 7, makecol(d?100:0, d?100:255,0 ));
   
		   if(a >= 0) {
		   	int ax = players[a].x * 16 + 7 - players[a].dirx * players[a].step;
				int ay = players[a].y * 16 + 7 - players[a].diry * players[a].step;
				
				circlefill(bmp, (x + ax)/2, (y + ay) / 2, 4, makecol(0, 200,0 ));
		   }
		break;
		case PID_SHOT:
	   
	   	if(players[p].ammo) circlefill(bmp, x, y, 3 + abs(((frames / 2) & 3) - 2), makecol(0, 255, 0));
	   	else circlefill(bmp, x, y, 3, makecol(255, 255, 0));
   		   
		break;
		case PID_BUG: {
			int anim = abs(((frames * 4) & 255) - 128) / 2;	
	   
	   	circlefill(bmp, x, y, 7, makecol(150, 200,0 ));
	   
	   	circlefill(bmp,
	   		x - players[p].diry * 3 + players[p].dirx * 3,
	   		y + players[p].dirx * 3 + players[p].diry * 3, 3,
	   		d?0:makecol(150 + anim, 100, 50));
	   	circlefill(bmp,
	   		x + players[p].diry * 3 + players[p].dirx * 3,
	   		y - players[p].dirx * 3 + players[p].diry * 3, 3,
	   		d?0:makecol(150 + anim, 100, 50));
		   
			break;
		}
		case PID_BUG2: {
			int anim = abs(((frames * 4) & 255) - 128);
	   
	   	circlefill(bmp, x, y, 7, makecol(150, 0, 50 ));
	   
	   	circlefill(bmp,
	   		x - players[p].diry * 3 + players[p].dirx * 3,
	   		y + players[p].dirx * 3 + players[p].diry * 3, 3,
	   		d?0:makecol(255, anim, anim));
	   	circlefill(bmp,
	   		x + players[p].diry * 3 + players[p].dirx * 3,
	   		y - players[p].dirx * 3 + players[p].diry * 3, 3,
	   		d?0:makecol(255, anim, anim));
		   
			break;
		}
		case PID_BUG3: {
			int anim = abs(((frames * 4) & 255) - 128);
	   
	   	circlefill(bmp, x, y, 7, makecol(200, 150, 0 ));
	   
	   	circlefill(bmp,
	   		x - players[p].diry * 3 + players[p].dirx * 3,
	   		y + players[p].dirx * 3 + players[p].diry * 3, 3,
	   		d?0:makecol(100 + anim, 0, 0));
	   	circlefill(bmp,
	   		x + players[p].diry * 3 + players[p].dirx * 3,
	   		y - players[p].dirx * 3 + players[p].diry * 3, 3,
	   		d?0:makecol(100 + anim, 0, 0));
		   
			break;
		}
		case PID_DIAM:
			draw_sprite(bmp, diam, x - 7, y - 7);
		break;
   }
}

/* A simple Dirty Rectangles System. */
void PlayerRestoreAll(BITMAP *bmp) {
	
	/* Restore the active players. */
	{
		int n;

		for(n = 0; n < PLAYERS_MAX; n++) {
			if(players[n].id) {												
				MapDrawPart(bmp, players[n].ox - players[n].odx, players[n].oy - players[n].ody, players[n].ox, players[n].oy);				
				//MapDrawPart(bmp, players[n].ox, players[n].oy, players[n].ox, players[n].oy);				
				
				if(players[n].id == PID_REMOVE) players[n].id = 0;
			}
		}		
	}
}

/* Draw the tilemap and all active players. */
void PlayerDrawAll(BITMAP *bmp) {
	
	/* Draw the active players. */
	{
		int n;

		for(n = 0; n < PLAYERS_MAX; n++) {
			if(players[n].id) {
				PlayerDraw(n, bmp);
				players[n].ox = players[n].x;
   			players[n].oy = players[n].y; 
   			players[n].odx = players[n].dirx;
   			players[n].ody = players[n].diry; 				    	 
   		}
		}
	}
}

/* Check if a player can move. */
int PlayerCanMove(int p, int dirx, int diry) {

	int newx, newy;
	
	/* Can't move if already moving. */
	if(players[p].step) return 0;

	newx = players[p].x + dirx;
	newy = players[p].y + diry;

	/* Detect collision with border. */
	if(newx < 0 || newy < 0 || newx > 39 || newy > 29) return 0;

	/* Detect collision with other players. */
	{
		int n;
		for(n = 0; n < PLAYERS_MAX; n++) {
			if(players[n].id && n != p) {
				if(newx == players[n].x && newy == players[n].y) {
					 
					// alive bug 
					if(players[p].id >= PID_BUG && !players[p].dead) {
						// bites player
						if(players[n].id <= PID_PLAYER) {
							players[n].dead = 0;
							life_away = 1;
							play_sample((SAMPLE *)data[CRUNCH_WAV].dat, 255, 128, 1000, 0);
						}
					}
					
					// falling diamond or falling dead bug
					if((players[p].id == PID_DIAM ||
					   (players[p].id >= PID_BUG && players[p].dead)) &&
					   players[p].diry) {
					   	
					   // hits bug	
						if(players[n].id >= PID_BUG) {
							score += 200;
							players[n].dead = 1;
						}
						
						// hits player
						if(players[n].id <= PID_PLAYER) {
							players[n].dead = 1;
							life_away = 1;
						}
					}
					
					// shot hits bug
					if(players[p].id == PID_SHOT && players[n].id >= PID_BUG) {
						// shot ammo means it already has been fired
						if(players[p].ammo && !players[n].dead) {
							score += 200;
							players[n].dead = 1;
							players[p].id = PID_REMOVE;
						}
					}
					
					return 0;
				}
			}
		}
	}
		
	// these can't dig	
	if(players[p].id == PID_BUG || players[p].id == PID_BUG2 ||
		players[p].id == PID_SHOT || (players[p].id == PID_BUG3 && players[p].dead)) {
		int c;
		c = getpixel(map, newx, newy);
		if(c && c != 1) return 0;		
	}
	
	// can't dig nor go through diamonds
	if(players[p].id == PID_DIAM) {
		int c, d;
		c = getpixel(map, newx, newy);
		d = getpixel(diams, newx, newy);
		if((c && c != 1) || d) return 0;
	}

	return 1;
}

/* Change the position of a player. */
void PlayerChangePosition(int p, int dirx, int diry) {

	int a = players[p].attached;
	
	if(dirx || diry) {
						
		players[p].x += dirx;
		players[p].y += diry;
	
		players[p].dirx = dirx;
		players[p].diry = diry;
		players[p].step = 16;
	}

	{
		int c = getpixel(map, players[p].x, players[p].y);			
		if(c && c != 1) {
			score++;			
			putpixel(map, players[p].x, players[p].y, 0);
		}
		if(players[p].id == PID_PLAYER) {
			int d = getpixel(diams, players[p].x, players[p].y);
			int e = 0;
			if(players[p].y > 0)
				e = getpixel(diams, players[p].x, players[p].y - 1);	
			if(d) {
				diams_left--;
				play_sample((SAMPLE *)data[DIAM_WAV].dat, 255, 128, 1000, 0);
				score += 100;
				putpixel(diams, players[p].x, players[p].y, 0);
			} else if(c) play_sample((SAMPLE *)data[PUSH_WAV].dat, 255, 128, 1000, 0);
			if(e) {
				if(PlayerCreate(PID_DIAM, players[p].x, players[p].y - 1) != -1) {
					putpixel(diams, players[p].x, players[p].y - 1, 0);				
				}
			}
		}
	}
	
	if(a >= 0) {
		if(dirx || diry) {
			PlayerChangePosition(
				a,
				players[p].x - dirx - players[a].x,
				players[p].y - diry - players[a].y);
		}
	}

}

/* Handle movement of a player. */
void PlayerMove(int p) {	

	if(players[p].step) {
		players[p].step--;
		return;
	}
	
	if(players[p].id == PID_BUG || players[p].id == PID_BUG3) {
		BugMove(p);
	}
	
	if(players[p].id == PID_BUG2) {
		Bug2Move(p);
	}
	
	if(players[p].id == PID_DIAM) {
		if(PlayerCanMove(p, 0, 1)) PlayerChangePosition(p, 0, 1);
		else {
			if(players[p].diry) {
				players[p].id = PID_REMOVE;
				putpixel(diams, players[p].x, players[p].y, 1);
			}
		}
	}
	
	if(players[p].id == PID_SHOT) {
		if(PlayerCanMove(p, players[p].dirx, players[p].diry)) {
			PlayerChangePosition(p, players[p].dirx, players[p].diry);			
		} else {			
			players[p].id = PID_REMOVE;				
		}
	}

}

/* Handle movement of all active players. */
void PlayerMoveAll(void) {
	int n;

	for(n = 0; n < PLAYERS_MAX; n++) {
		if(players[n].id) PlayerMove(n);
	}
}
