#include <allegro.h>

#include "dirty.h"
#include "data.h"
#include "game.h"
#include "map.h"
#include "player.h"

/* A simple 2-layer tilemap. */
BITMAP *back = NULL;
BITMAP *map = NULL;
BITMAP *diams = NULL;
BITMAP *diam = NULL;

void MapCreate(int l) {
	
	int x, y;
	int monsters = 0;
	int got_start = 0;
			
	int backnames[] = {
		BACK1_BMP, BACK2_BMP, BACK3_BMP, BACK4_BMP, BACK5_BMP, 
		BACK6_BMP, BACK7_BMP, BACK8_BMP, BACK9_BMP, BACK10_BMP
	};
	
	int mapnames[] = {
		LEVEL1_BMP, LEVEL2_BMP, LEVEL3_BMP, LEVEL4_BMP, LEVEL5_BMP, 
		LEVEL6_BMP, LEVEL7_BMP, LEVEL8_BMP, LEVEL9_BMP, LEVEL10_BMP
	};
	
	int diamnames[] = {
		DIAM1_BMP, DIAM2_BMP, DIAM3_BMP, DIAM4_BMP, DIAM5_BMP, 
		DIAM6_BMP, DIAM7_BMP, DIAM8_BMP, DIAM9_BMP, DIAM10_BMP
	};
	
	int diamsnames[] = {
		DIAMS1_BMP, DIAMS2_BMP, DIAMS3_BMP, DIAMS4_BMP, DIAMS5_BMP, 
		DIAMS6_BMP, DIAMS7_BMP, DIAMS8_BMP, DIAMS9_BMP, DIAMS10_BMP
	};
	
	if(l == 0) return;					
		
	back = (BITMAP *)data[backnames[l - 1]].dat;
	diam = (BITMAP *)data[diamnames[l - 1]].dat;
		
	if(map) destroy_bitmap(map);	
	map = (BITMAP *)data[mapnames[l - 1]].dat;
	{
		BITMAP *t = create_bitmap(map->w, map->h);
		blit(map, t, 0, 0, 0, 0, map->w, map->h);
		map = t;
	}	
	
	if(diams) destroy_bitmap(diams);			
	diams = (BITMAP *)data[diamsnames[l - 1]].dat;		
	{
		BITMAP *t = create_bitmap(diams->w, diams->h);
		blit(diams, t, 0, 0, 0, 0, diams->w, diams->h);
		diams = t;
	}
	
	if(!back || !map || !diams || !diam)  {		
		allegro_message("Failed Loading map %d.", l);
		return;
	}
	
	diams_left = 0;
	
	PlayersInit();
	
	for(y = 0; y < 30; y++) {
		for(x = 0; x < 40; x++) {
	
			int c = getpixel(diams, x, y);
			int r = getr(c);
			int g = getg(c);
			int b = getb(c);						
			
			if(r > 200 && g > 200 && b < 100) { // yellow
				diams_left++;
			}
			
			if(r < 100 && g > 200 && b < 100) { // green
										
				putpixel(diams, x, y, 0);
			
				if(!got_start) {
					int n;
					PlayerCreate(PID_PLAYER, x, y);	
					got_start = 1;										
									
					for(n = 1; n < l; n++) {
						putpixel(diams, x + n, y, 0);
						PlayerCreate(PID_TAIL, x + n, y);	
						PlayerAttach(n - 1, n);			
					}
				}
			}
						
		}
	}		
	
	for(y = 0; y < 30; y++) {
		for(x = 0; x < 40; x++) {
			
			int c = getpixel(diams, x, y);
			int r = getr(c);
			int g = getg(c);
			int b = getb(c);
			
			if(r > 200 && g < 100 && b < 100) { // red
			
				putpixel(diams, x, y, 0);
			
				PlayerCreate(PID_BUG, x, y);	
				
				monsters++;
			}
			
			if(r > 200 && g < 100 && b > 200) { // magenta
			
				putpixel(diams, x, y, 0);
			
				PlayerCreate(PID_BUG2, x, y);	
				
				monsters++;
			}
			
			if(r < 100 && g < 100 && b > 200) { // blue
			
				putpixel(diams, x, y, 0);
			
				PlayerCreate(PID_BUG3, x, y);	
				
				monsters++;
			}
			
		}
	}	
	
	players[0].ammo = monsters + l;
	
}

/* Draw the tilemap */
void MapDrawPart(BITMAP *bmp, int x1, int y1, int x2, int y2) {
	int y;
		
	if(y1 > y2) {
		int d = y1;
		y1 = y2;
		y2 = d;
	}	
	
	if(x1 > x2) {
		int d = x1;
		x1 = x2;
		x2 = d;
	}	
	
	if(y1 < 0) y1 = 0;
	if(y2 > 29) y2 = 29;
	if(x1 < 0) x1 = 0;
	if(x2 > 39) x2 = 39;

	for(y = y1; y <= y2; y++) {
		int x;

		for(x = x1; x <= x2; x++) {
			int c, d;
			c = getpixel(map, x, y);
			if(c <= 1) c = getpixel(back, x, y);
			d = getpixel(diams, x, y); 
			rectfill(bmp, x * 16, y * 16, x * 16 + 15, y * 16 + 15, c);			
			if(d) draw_sprite(bmp, diam, x * 16, y * 16);
			
			dirty[y][x] = 1;
			
		}
	}	
}

void MapDraw(BITMAP *bmp) {
	MapDrawPart(bmp, 0, 0, 39, 29);
}