#include <allegro.h>
#include <aldumb.h>
#include <time.h>
#include <stdlib.h>

#include "main.h"
#include "dirty.h"
#include "menu.h"
#include "game.h"
#include "data.h"

int frames = 0;
int fps = 0;
static volatile int ticks = 0;
void ticker(void) {
	ticks++;
}
END_OF_FUNCTION(ticker);

AL_DUH_PLAYER *musicplayer;

int main(void) {			

	srand(time(NULL));

	allegro_init();

	set_color_depth(16);
	
	if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) < 0) {		
		allegro_message("Cannot create graphics screen.\n");
		exit(-1);
	}
	
	install_keyboard();
	install_mouse();
	install_timer();

	LOCK_VARIABLE(ticks);
	LOCK_FUNCTION(ticker);
	install_int_ex(ticker, BPS_TO_TIMER(FPS));
	
	dumb_init();
	set_volume_per_voice(0);
	install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
	
	Data();
	
	musicplayer = al_start_duh(data[NETWORM3_IT].dat, 2, 0, 1.0);
					
	Init();
	
	Menu();

	{		
		BITMAP *page = create_bitmap(SCREEN_W, SCREEN_H);
		int gframetime = ticks;
		int gframes = 0;

		frames = ticks;		
		while(1) {

			/* Never lose frames. */
			while(frames <= ticks) {
				Frame();
				frames++;
			}
			
			al_poll_duh(musicplayer);
			
			{
				Draw(page);
				gframes++;
				if(ticks - gframetime > FPS) {
					fps = gframes;
					gframes = 0;
					gframetime = ticks;
				}
				DirtyDraw(page, screen);				
			}

		}
	}
	
	al_stop_duh(musicplayer);	

	Exit();
	return -1;
} END_OF_MAIN();
