
#define GPF_MAX 1024

typedef struct GPF_NODE {
	int x, y;
	int next;
	int cost;
	int distance;
	int from;
} GPF_NODE;

typedef struct GPF {
	int nodenum;	
	int firstnode;	
	
	int dx, dy;
	
	GPF_NODE nodes[GPF_MAX];
	
	int (*check)(int x, int y);
} GPF;

GPF *GPF_create(int sx, int sy, int dx, int dy, int (*check)(int x, int y));
int GPF_search(GPF *gpf);
int GPF_getpath(GPF *gpf, int node, int *x, int *y);
int GPF_globalpath(int sx, int sy, int dx, int dy, int (*check)(int x, int y), int *x, int *y);
