#include <stdlib.h>

#include "gpf.h"

static GPF globalgpf;

/* Insert a new node in the list of possible path nodes. */
static void newnode(GPF *gpf, int x, int y, int cost, int from)
{
	int n; // new node
	int i; // iterate through nodes
	int p; // previous node
	
	if(gpf->nodenum == GPF_MAX || gpf->check(x, y)) return;	
		
	n = gpf->nodenum;			
	gpf->nodenum++;
	
	gpf->nodes[n].x = x;
	gpf->nodes[n].y = y;
	gpf->nodes[n].cost = cost;
	gpf->nodes[n].distance = abs(x - gpf->dx) + abs(y - gpf->dy);
	gpf->nodes[n].from = from;	
	
	// insert node into sorted list	
	p = -1;	
	for(i = gpf->firstnode; i != -1; i = gpf->nodes[i].next) {			
		if(gpf->nodes[n].cost + gpf->nodes[n].distance <=
			gpf->nodes[i].cost + gpf->nodes[i].distance) break;
		p = i;
	}	
	gpf->nodes[n].next = i;
	if(p != -1) gpf->nodes[p].next = n; else gpf->firstnode = n;		
			
}

static int expand(GPF *gpf)
{
	int n = gpf->firstnode;
	int x, y, c;
	
	gpf->firstnode = gpf->nodes[n].next;		

	x = gpf->nodes[n].x;
	y = gpf->nodes[n].y;
	c = gpf->nodes[n].cost;

	if(x == gpf->dx && y == gpf->dy) return n;

	newnode(gpf, x, y - 1, c + 1, n);
	newnode(gpf, x - 1, y, c + 1, n);
	newnode(gpf, x, y + 1, c + 1, n);
	newnode(gpf, x + 1, y, c + 1, n);
	
	return -1;

}

GPF *GPF_create(int sx, int sy, int dx, int dy, int (*check)(int x, int y))
{
		
	GPF *gpf = malloc(sizeof *gpf);	
		
	gpf->nodenum = 0;
	gpf->firstnode = -1;
	
	gpf->dx = dx;
	gpf->dy = dy;
	
	gpf->check = check;
	
	newnode(gpf, sx, sy, 0, -1);
	
	return gpf;
}

int GPF_search(GPF *gpf)
{
	if(gpf->firstnode != -1) {		
		return expand(gpf);		
	} else return GPF_MAX;
}

int GPF_getpath(GPF *gpf, int node, int *x, int *y) {
	int i;
	int n = node;
	for(i = 0; n != -1; i++) {
		x[i] = gpf->nodes[n].x;
		y[i] = gpf->nodes[n].y;
		n = gpf->nodes[n].from;
	}
	return i;
}

int GPF_globalpath(int sx, int sy, int dx, int dy, int (*check)(int x, int y), int *x, int *y) {
	
	int r;
	
	globalgpf.nodenum = 0;
	globalgpf.firstnode = -1;
	
	globalgpf.dx = dx;
	globalgpf.dy = dy;
	
	globalgpf.check = check;
	
	newnode(&globalgpf, sx, sy, 0, -1);
	
	for(;;) {
		r = GPF_search(&globalgpf);
		if(r == GPF_MAX) return -1;
		if(r != -1) break;
	}		
	return GPF_getpath(&globalgpf, r, x, y);
}