#include "player.h"
#include "map.h"
#include "bug.h"
#include "gpf.h"

static int pathmap[30][40];
static void pathinit(void) {
	int x, y;
	for(y = 0; y < 30; y++) {
		for(x = 0; x < 40; x++) {			
			pathmap[y][x] = getpixel(map, x, y) == 0 ? 0 : 1;
		}
	}
}
static int pathcallback(int x, int y) {
	if(y < 0 || x < 0 || y >= 30 || x >= 40 || pathmap[y][x] != 0) return 1;
	pathmap[y][x] = 1;
	return 0;
}

void DeadMove(int p) {
	if(PlayerCanMove(p, 0, 1)) PlayerChangePosition(p, 0, 1);
	else {
		int d = getpixel(diams, players[p].x, players[p].y);
		if(d) players[p].id = PID_REMOVE;
		players[p].diry = 0;
		if(!players[p].dirx) players[p].dirx = rand()&1?1:-1;
		putpixel(map, players[p].x, players[p].y, 1);
	}
}

void BugMove(int p) {
	int kx = players[p].dirx;
	int ky = players[p].diry;
	
	if(players[p].dead) {
		DeadMove(p);
		return;
	}		
	
	if(PlayerCanMove(p, kx, ky)) {
		int dx = 0, dy = 0;
		int r;
		
		dx = players[0].x - players[p].x;
		dy = players[0].y - players[p].y;			
								
		if(dx > 0) dx = 1;
		if(dy > 0) dy = 1;
		if(dx < 0) dx = -1;
		if(dy < 0) dy = -1;						
		
		if(dx && dy) {
			if(rand()&1) dx = 0; else dy = 0;
		}
		
		r = rand() & 3;
		if(r == 0) {
										
			if(PlayerCanMove(p, dx, dy)) {
				kx = dx;
				ky = dy;
			}
			
		}
		
		PlayerChangePosition(p, kx, ky);
	} else {
					
		do {
			kx = (rand()%3) - 1;
			ky = (rand()%3) - 1;
		} while((kx && ky) || (!kx && !ky));
		players[p].dirx = kx;
		players[p].diry = ky;
	}		
}	

void Bug2Move(int p) {
			
	if(players[p].dead) {		
		DeadMove(p);
		return;
	}		
			
	if(players[p].time) {
		int kx, ky;			
		do {
			kx = (rand()%3) - 1;
			ky = (rand()%3) - 1;
		} while((kx && ky) || (!kx && !ky));
		
		if(PlayerCanMove(p, kx, ky)) {
			PlayerChangePosition(p, kx, ky);
			players[p].time--;
		}
		
	} else {
	
		if(players[p].pathpos <= 0) {
			
			pathinit();
													
			players[p].pathpos = GPF_globalpath(
				players[p].x,
				players[p].y,
				players[0].x,
				players[0].y,
				pathcallback,
				players[p].pathx,
				players[p].pathy);
			
			if(players[p].pathpos <= 0) players[p].time = 10;		
			else players[p].time = 0;
									
		} else {
			int kx, ky;
											
			players[p].pathpos--;
			kx = players[p].pathx[players[p].pathpos] - players[p].x;
			ky = players[p].pathy[players[p].pathpos] - players[p].y;
			
			if(PlayerCanMove(p, kx, ky)) {
				PlayerChangePosition(p, kx, ky);
			} else {
				players[p].pathpos = -1;
				players[p].time = 5;
			}
								
		}				
	}
}