#ifndef RB_PLAYER_H
#define RB_PLAYER_H

#include "rb_object.h"

enum{ LEFT, RIGHT };

class Player: public Rb_object{
      private:
              bool spinning;
              int state, state_counter;
              int rl;
              int weapon, ammo, delay;
              unsigned int health, score;
              bool overheated;
              int max_weapon;
      public: 
              Player(int _max_weapon);
              
              void move_up();
              void move_down();
              void move_left(int dx);
              void move_right(int dx);
              void spin(int rol);
              
              void switch_state(int ds);
              void update_state();
              
              void set_delay(int d);
              void update_weapons();
              void update_ammo(int a);
              
              void swap_weapons();
              
              void set_score(int s){ score = s; };
              void update_score(int d){ score += d; };
              void update_health(int h){ health += h; };
              void overheat(){ overheated = true; };
              
              bool Spinning(){ return spinning; };
              int State(){ return state; };
              int Weapon(){ return weapon; };
              int Ammo(){ return ammo; };
              int Delay(){ return delay; };
              int Health(){ return health; };
              int Score(){ return score; };
              bool Overheated(){ return overheated; };
};

#endif
