#include "rb_player.h"

Player::Player(int _max_weapon)
{
    x = 350; y = 500;
    state = 0;
    state_counter = 0;
    spinning = false;
    overheated = false;
    weapon = 1;
    ammo = 100;
    delay = 0;
    health = 100;
    max_weapon = _max_weapon;
}

void Player::move_up()
{
     if(y>0)
        y -= 3;
}

void Player::move_down()
{
     if(y<518)
        y += 3;
}

void Player::move_left(int dx)
{
     if(x>0)
        x -= dx;
     
     if(!spinning)
     {
           if(state != 2)
           {
                    switch_state(1);
                    state_counter = 6;
           }
           rl = LEFT;
     }
}

void Player::move_right(int dx)
{
     if(x<740)
        x += dx;
     
     if(!spinning)   
     {
           if(state != 10)
           {
                    switch_state(-1);
                    state_counter = 6;
           }
           rl = RIGHT;
     }
}

void Player::spin(int rol)
{
     spinning = true;
     state_counter = 0;
     rl = rol;
}

void Player::switch_state(int ds)
{
     state += ds;
     
     if(state==-1)
       state = 11;
     if(state==12)
       state = 0;
}

void Player::update_state()
{
     if(!spinning)
     {
            if(state_counter==0 && state != 0)
            {
                 if(rl==RIGHT)
                   switch_state(1);
                 if(rl==LEFT)
                   switch_state(-1);
                 state_counter = 6;
            }else{
             state_counter--;
            }
     }else{
            if(rl==RIGHT)
              move_right(8);
            if(rl==LEFT)
              move_left(8);
            
            if(state_counter==0)
            {
                 if(rl==RIGHT)
                    switch_state(-1);
                 if(rl==LEFT)
                    switch_state(1);
                 state_counter = 2;
            }else{
                 state_counter--;
            }
            if(state==0)
                 spinning = false;
     }
}

void Player::set_delay(int d)
{
     delay = d;
}

void Player::update_weapons()
{
     if(ammo<100)
       ammo++;
     if(delay>0)
       delay--;
     if(ammo>70 && overheated)
       overheated = false;
}

void Player::update_ammo(int a)
{
     ammo += a;
     if(ammo<1)
       overheated = true;
}

void Player::swap_weapons()
{
     weapon = (weapon % max_weapon) + 1;
}
