#ifndef RB_GFX_H
#define RB_GFX_H

#include <sstream>
#include <allegro.h>
#include <alfont.h>
#include <string>
#include <fstream>
#include "rb_player.h"
#include "rb_bullet.h"
#include "rb_enemy.h"
#include "rb_exp.h"
#include "music_data.h"

#include "main_data.h"

#include "pmask.h"

#define EVR 5
#define BVR 4

class Gfx{
      
      private:
              BITMAP *buffer, *text, *bg;
              DATAFILE *main_data, *player_data, *exp_data, *music_data;
              ALFONT_FONT *tiewing, *massassi;
              Player *player;
              Bullet *bullets[40];
              Enemy *enemys[40];
              Exp *exps[20];
              struct PMASK *enemy_mask[EVR], *bullet_mask[BVR], *player_mask[12];
              int noe;
              std::string titles[5];
              std::string briefing[11];
      public: 
              Gfx();
              ~Gfx();
              
              void pass_player(Player *p);
              void pass_bullet(Bullet *b, int i);
              
              void pass_noe(int number_of_enemys);
              void pass_enemy(Enemy *e, int i);
              
              void pass_exp(Exp *e, int i);
              
              void pass_mission(int m);
              
              void create_masks();
              
              void draw_buffer();
              void draw_buffer_no_clear();
              void draw_game(int bg_y);
              
              void start_exp(int x, int y);
              void start_exp(int x, int y, int fr);
              void collision();
              
              void intro(int a);
              
              void midi(int m);
              void digi(int d);
              
              void draw_game_over(int sc, std::string text);
              
              void draw_main_menu(int selected1, int selected2, int hiscore, int unlocked, int hiscores[5]);
              void draw_text();
              
              void read_briefing(int m);
              void draw_briefing(int m);
              
              std::string random_char();
              std::string rank(int hiscores[5]);
};

#endif
