#include "rb_gfx.h"

Gfx::Gfx()
{
      set_color_depth( 16 );
      set_gfx_mode(GFX_AUTODETECT , 800, 600, 0, 0);
      
      install_sound( DIGI_AUTODETECT, MIDI_AUTODETECT, NULL );
      
      buffer = create_bitmap( 800, 600);
      text = create_bitmap( 800, 600);
      
      if(buffer == NULL)
      {
            set_gfx_mode(GFX_TEXT,0,0,0,0);
            allegro_message("Could not create buffer - check your stuff");
            exit(EXIT_FAILURE);
      }
      
      main_data = load_datafile("data/main.dat");
      player_data = load_datafile("data/player.dat");
      exp_data = load_datafile("data/exp.dat");
      music_data = load_datafile("data/music.dat");
      
      if( main_data == NULL || player_data == NULL ||
          exp_data == NULL || music_data == NULL )
      {
            set_gfx_mode(GFX_TEXT,0,0,0,0);
            allegro_message("Oh dear. You ruined the datafiles.");
            exit(EXIT_FAILURE);
      }
      
      alfont_init();
      
      tiewing = alfont_load_font("data/TIEWING.TTF");
      massassi = alfont_load_font("data/massassi.ttf");
      
      if( tiewing == NULL || massassi == NULL)
      {
            set_gfx_mode(GFX_TEXT,0,0,0,0);
            allegro_message("<_< What happened to the fonts, honey?");
            exit(EXIT_FAILURE);
      }
      
      titles[0] = "At first sight";
      titles[1] = "birth of the rebellion";
      titles[2] = "hunting on hoth";
      titles[3] = "liberation of the cloud city";
      titles[4] = "the finishing touch";
}

Gfx::~Gfx()
{
      for(int i=0; i<EVR; i++)
         destroy_pmask( enemy_mask[i] );
      for(int i=0; i<BVR; i++)
         destroy_pmask( bullet_mask[i] );
      for(int i=0; i<12; i++)
         destroy_pmask( player_mask[i] );
      stop_midi();
      unload_datafile(main_data);
      unload_datafile(player_data);
      unload_datafile(exp_data);
      unload_datafile(music_data);
      destroy_bitmap(buffer);
      destroy_bitmap(text);
      alfont_destroy_font(tiewing);
      alfont_destroy_font(massassi);
      alfont_exit();
      allegro_exit();
}

void Gfx::pass_player(Player *p)
{
      player = p;
}

void Gfx::pass_bullet(Bullet *b, int i)
{
      bullets[i] = b;
}

void Gfx::pass_enemy(Enemy *e, int i)
{
     enemys[i] = e;
}

void Gfx::pass_noe(int number_of_enemys)
{
      noe = number_of_enemys;
}

void Gfx::pass_exp(Exp *e, int i)
{
      exps[i] = e;
}

void Gfx::pass_mission(int m)
{
      switch(m)
      {
          case 0:
               bg = (BITMAP*) main_data[stars_bg].dat;
               break;
          case 1:
               bg = (BITMAP*) main_data[tatooine_bg].dat;
               break;
          case 2:
               bg = (BITMAP*) main_data[hoth_bg].dat;
               break;
          case 3:
               bg = (BITMAP*) main_data[bespin_bg].dat;
               break;
          case 4:
               bg = (BITMAP*) main_data[stars_bg].dat;
               break;
      }
}

void Gfx::create_masks()
{
      install_pmask();
      for(int i=0; i<EVR; i++)
         enemy_mask[i] = create_allegro_pmask( (BITMAP*) main_data[enemy1+i].dat );
      for(int i=0; i<BVR; i++)
         bullet_mask[i] = create_allegro_pmask( (BITMAP*) main_data[bullet1+i].dat );
      for(int i=0; i<12; i++)
         player_mask[i] = create_allegro_pmask( (BITMAP*) player_data[i].dat );
}

void Gfx::draw_buffer()
{
      blit( buffer, screen, 0, 0, 0, 0, 800, 600);
      clear_bitmap(buffer);
}

void Gfx::draw_game(int bg_y)
{
      
      //achtergrond
      draw_sprite( buffer, (BITMAP*)main_data[bg0].dat, 0, 0);
      masked_blit( bg, buffer, 0, 0, 0, bg_y, 800, 600-bg_y);
      masked_blit( bg, buffer, 0, 600-bg_y, 0, 0, 800, bg_y);
      
      //kogels
      for(int i=0; i<40; i++)
      {
           if(bullets[i]->Type()!=0)
           {
                 draw_sprite( buffer, (BITMAP*) main_data[(bullet1-1)+bullets[i]->Type()].dat,
                              bullets[i]->X(), bullets[i]->Y() );
           }
      }
      
      //vijanden
      for(int i=0; i<noe; i++)
      {
           if(enemys[i]->Type()!=0)
           {
                 draw_sprite( buffer, (BITMAP*)main_data[(enemy1-1)+enemys[i]->Type()].dat,
                              enemys[i]->X(), enemys[i]->Y() );
           }
      }
      
      //speler
      draw_sprite( buffer, (BITMAP*)player_data[player->State()].dat, player->X(), player->Y());
      
      //explosies
      for(int i=0; i<20; i++)
      {
          if(exps[i]->Present())
          {
              draw_sprite( buffer, (BITMAP*)exp_data[exps[i]->Frame()].dat, 
                           exps[i]->X(), exps[i]->Y() );
          }
      }
      
      //bar
        //achtergrond
        draw_sprite( buffer, (BITMAP*)main_data[bar_bg].dat, 10, 510);
        //score
        std::stringstream score;
        score << player->Score();
        alfont_set_font_size( tiewing, 20 );
        alfont_textout_right_ex( buffer, tiewing, score.str().c_str(), 130, 520, makecol(0, 0, 0), -1);
        //levens
        
        if(player->Health()>30)
           masked_blit( (BITMAP*)main_data[greenbar].dat, buffer, 0, 0,  30, 545, player->Health(), 15);
        else
           masked_blit( (BITMAP*)main_data[redbar].dat, buffer, 0, 0,  30, 545, player->Health(), 15);        
        //ammo
        if(player->Overheated())
           masked_blit( (BITMAP*)main_data[redbar].dat, buffer, 0, 0,  30, 565, player->Ammo(), 15);
        else
           masked_blit( (BITMAP*)main_data[yellowbar].dat, buffer, 0, 0,  30, 565, player->Ammo(), 15);
        //geselecteerd wapen
        circlefill( buffer, 165, 550, 20, makecol(0, 0, 0));
        draw_sprite( buffer, (BITMAP*)main_data[(bullet1-1)+player->Weapon()].dat, 163, 540);
}

void Gfx::start_exp(int x, int y)
{
       int i=0;
       
       for(i; exps[i]->Present() && (i<20) ; i++)
       {}
       
       exps[i]->start(x, y);
}

void Gfx::start_exp(int x, int y, int fr)
{
       int i=0;
       
       for(i; exps[i]->Present() && (i<20) ; i++)
       {}
       
       exps[i]->start(x, y, fr);
}

void Gfx::collision()
{
       //ENEMY
       for(int i=0; i<noe; i++)
       {
           //BULLETS
           for(int b=0; b<40; b++)
           {
               if(bullets[b]->Type()!=0 && bullets[b]->Type()!=4)
               {      
                      if( check_pmask_collision( enemy_mask[enemys[i]->Type()-1],
                                                             bullet_mask[bullets[b]->Type()-1],
                                                             enemys[i]->X(), enemys[i]->Y(),
                                                             bullets[b]->X(), bullets[b]->Y() ))
                      {
                            int ex = enemys[i]->X(); int ey = enemys[i]->Y();
                            int et = enemys[i]->Type();
                            int score = enemys[i]->update_health(bullets[b]->Damage());
                            
                            if(score>0)
                            {
                                start_exp( ex,  ey );
                                if(et!=1)
                                    start_exp( ex+40,  ey );
                                player->update_score(score);
                            }else{
                                start_exp(bullets[b]->X()-15, bullets[b]->Y()-15, 15);
                            }
                            bullets[b]->destroy();
                      }
               }
               if(bullets[b]->Type()==4)
               {      
                      if( check_pmask_collision( player_mask[player->State()],
                                                             bullet_mask[bullets[b]->Type()-1],
                                                             player->X(), player->Y(),
                                                             bullets[b]->X(), bullets[b]->Y() ))
                      {

                            player->update_health(-10);
                            start_exp(bullets[b]->X()-15, bullets[b]->Y()-15, 15);
                            bullets[b]->destroy();
                      }
               }
               
               
           }
           
           //PLAYER
           if( check_pmask_collision( enemy_mask[enemys[i]->Type()-1],
                                      player_mask[player->State()],
                                      enemys[i]->X(), enemys[i]->Y(),
                                      player->X(), player->Y() ))
           {
                int ex = enemys[i]->X(); int ey = enemys[i]->Y();
                int et = enemys[i]->Type();
                enemys[i]->spawn();
                player->update_health(-20);
                start_exp( ex,  ey );
                if(et!=1)
                   start_exp(ex+40, ey);
                
           }
       }
}

void Gfx::intro(int a)
{
      //achtergrond
      draw_sprite( buffer, (BITMAP*)main_data[bg0].dat, 0, 0);
      draw_sprite( buffer, (BITMAP*)main_data[stars_bg].dat, 0, a%600);
      draw_sprite( buffer, (BITMAP*)main_data[stars_bg].dat, 0, (a%600)-600);
      
      if(a>200 && a< 700)
      {
        draw_sprite( buffer, (BITMAP*)main_data[enemy2].dat, 100, -600+a*2.4);
        draw_sprite( buffer, (BITMAP*)main_data[enemy4].dat, 200, -580+a*2.1);
        draw_sprite( buffer, (BITMAP*)main_data[enemy3].dat, 340, -600+a*2.3);
        draw_sprite( buffer, (BITMAP*)main_data[enemy2].dat, 430, -620+a*2.5);
        draw_sprite( buffer, (BITMAP*)main_data[enemy5].dat, 660, -587+a*2.6);

          draw_sprite( buffer, (BITMAP*)main_data[enemy5].dat, 100, -930+a*2.3);
          draw_sprite( buffer, (BITMAP*)main_data[enemy3].dat, 200, -830+a*2.2);
          draw_sprite( buffer, (BITMAP*)main_data[enemy4].dat, 340, -910+a*2.4);
          draw_sprite( buffer, (BITMAP*)main_data[enemy3].dat, 430, -900+a*2.5);
          draw_sprite( buffer, (BITMAP*)main_data[enemy2].dat, 660, -867+a*2.6);
      }
      
      alfont_set_font_size(tiewing, 40);
      
      if(a>700 && a<900)
      {
        alfont_textout_centre_ex( buffer, tiewing, "Repsa_Jih software presents",
                                  400, 250, makecol(232, 202, 30), -1);
      }
      if(a>800 && a<900)
      {
        alfont_textout_centre_ex( buffer, tiewing, "Beta testing by Fire Slyzer",
                                  400, 300, makecol(232, 202, 30), -1);
      }
      if(a>950)
      {
        alfont_set_font_size(tiewing, 80);
        alfont_textout_centre_ex( buffer, tiewing, "Flight for Freedom",
                                  400, 250, makecol(232, 202, 30), -1);
      } 
      if(a>1050)
      {
        alfont_set_font_size(tiewing, 40);
        alfont_textout_centre_ex( buffer, tiewing, "RB project 2006",
                                        400, 340, makecol(232, 202, 30), -1);
      }
}

void Gfx::midi(int m)
{
     play_midi( (MIDI*) music_data[m].dat , 1); 
}

void Gfx::digi(int d)
{
     play_sample( (SAMPLE*) music_data[d].dat, 200, rand()%256, 1000, 0);
}

void Gfx::draw_game_over(int sc, std::string text)
{
     alfont_set_font_size(tiewing, 80);
     alfont_textout_centre_ex( buffer, tiewing , text.c_str(), 400, 240, makecol(255, 255, 255),
                               -1);
     std::stringstream scs;
     scs << "Score: " << sc;
     alfont_textout_centre_ex( buffer, tiewing , scs.str().c_str(), 400, 330, makecol(255, 255, 255),
                               -1);
}

void Gfx::draw_text()
{
     clear_bitmap(text);
     alfont_set_font_size(massassi, 20);
     for(int i=0; i<32; i++)
     {
        for(int a=0; a<24; a++)
        {
           alfont_textout_ex( text, massassi, random_char().c_str() , 5+25*i, 5+a*25, makecol(55, 55, 55), -1);
        }
     }
}

std::string Gfx::random_char()
{
     int i = rand()% 26;
     char alpha[] = "abcdefghijklmnopqrstuvwqyz";
     std::string temp;
     temp = alpha[i];
     return temp;
}

void Gfx::draw_main_menu(int selected1, int selected2, int hiscore, int unlocked, int hiscores[5])
{
     draw_sprite( buffer, text, 0, 0);
     alfont_set_font_size(tiewing, 50);
     alfont_textout_centre( buffer, tiewing, "flight  for  freedom", 400, 100, makecol(232, 202, 30));
     
     alfont_set_font_size(tiewing, 25);
     alfont_textout( buffer, tiewing, "career info", 50, 200, makecol(232, 202, 30));
     alfont_textout( buffer, tiewing, "select mission", 50, 250, makecol(232, 202, 30));
     alfont_textout( buffer, tiewing, "hiscore mode", 50, 300, makecol(232, 202, 30));
     alfont_textout( buffer, tiewing, "quit game", 50, 350, makecol(232, 202, 30));
     
     alfont_textout_centre( buffer, tiewing, "repsa_jih software", 400, 400, makecol(232, 202, 30));
     
     alfont_set_font_size(massassi, 25);
     alfont_textout( buffer, massassi, "m", 30, 200+selected1*50, makecol(200, 0, 0));
     
     std::stringstream sc[4];
     switch(selected1)
     {
        case 0:
             sc[0] << "rank: " << rank(hiscores);
             sc[1] << "missions completed: " << unlocked;
             break;
        case 1: //missie
             sc[0] << "mission " << (selected2+1) << " : " << titles[selected2];
             sc[1] << "your hiscore for this level is " << hiscores[selected2];
             sc[2] << "use left and right to choose a mission";
             break;
        case 2:
             sc[0] << "your current hiscore is " << hiscore;
             break;
        case 3:
             sc[0] << "Thanks for playing";
             break;
     }
     alfont_textout_right( buffer, tiewing, sc[0].str().c_str(), 750, 200, makecol(255, 255, 255));
     alfont_textout_right( buffer, tiewing, sc[1].str().c_str(), 750, 250, makecol(232, 202, 30));
     alfont_textout_right( buffer, tiewing, sc[2].str().c_str(), 750, 300, makecol(232, 202, 30));
     alfont_textout_right( buffer, tiewing, sc[3].str().c_str(), 750, 350, makecol(232, 202, 30));
}

std::string Gfx::rank(int hiscores[5])
{
     int temp =0;
     for(int i=0; i<5; i++)
      temp += hiscores[i];
      
     std::string r;
     
     if(temp < 100)
      r = "second class pilot";
     if(temp>99 && temp < 300)
      r = "first class pilot";
     if(temp>299 && temp < 500)
      r = "red team member";
     if(temp>499 && temp < 700)
      r = "red leader";
     if(temp>699 && temp < 1000)
      r = "space commander";
     if(temp>999)
      r = "general";
      
     return r;
}

void Gfx::read_briefing(int m)
{
     for(int i=0; i<11; i++)
       briefing[i] = "";
     
     std::stringstream filename;
     filename << "data/mission" << m << ".mis";
     
     std::ifstream mission(filename.str().c_str());
     
     std::string lines[10];
     
     for(int i=0; i<11; i++)
       getline(mission, briefing[i]);
       
     mission.close();
}
     
void Gfx::draw_briefing(int m)
{    
     draw_sprite( buffer, text, 0, 0);
     alfont_set_font_size(tiewing, 25);
     
     alfont_textout( buffer, tiewing, titles[m].c_str(), 50, 50, makecol(255, 255, 255));
     for(int i=0; i<11; i++)
       alfont_textout( buffer, tiewing, briefing[i].c_str(), 50, 100+i*50, makecol(232, 202, 30));
}
