#include "rb_game.h"

volatile long speed_counter;

void increment_speed_counter()
{
     speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter)

Rb_app::Rb_app()
{
     allegro_init();
     install_keyboard();
     install_timer();
     
     LOCK_VARIABLE(speed_counter);
     LOCK_FUNCTION(increment_speed_counter);
     
     install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
     
     gfx = new Gfx();
     
     gfx->create_masks();
}
END_OF_FUNCTION(Rb_app::Rb_app)

void Rb_app::intro()
{
     int t=0;
     
     gfx->midi(swintro);
     
     while(t<1300)
     {
         while(speed_counter>0)
         {
              if(key[KEY_ENTER])
              {
                 while(key[KEY_ENTER])
                 {}
                 return;
              }
              if(key[KEY_ESC])
                 end();
              
              t++;
              speed_counter--;
         }
         gfx->intro(t);
         gfx->draw_buffer();
     }    
}
END_OF_FUNCTION(Rb_app::intro)

void Rb_app::menu()
{
     read_file();
     intro();
     gfx->midi(empire);
     bool menu_finished = false;
     int selected1 = 0;
     int selected2 = 0;
     bool key_pressed = false;
     int text_switch = 0;
     while(!menu_finished)
     {
        while(speed_counter>0)
        {
          if(key[KEY_ESC])
             end();
          if(key[KEY_UP] && !key_pressed)
          {
             selected1--;
             key_pressed = true;
          }
          if(key[KEY_DOWN] && !key_pressed)
          {
             selected1++;
             key_pressed = true;
          }
          if(key[KEY_LEFT] && !key_pressed && selected1==1)
          {
             selected2--;
             key_pressed = true;
          }
          if(key[KEY_RIGHT] && !key_pressed && selected1==1 && selected2<unlocked)
          {
             selected2++;
             key_pressed = true;
          }
          if(key[KEY_ENTER])
          {
              while(key[KEY_ENTER]){}
              if(selected1==1)
              {
                int sc=0;
                if(briefing(selected2))
                {
                    switch(selected2)
                    {
                        case 0:
                             sc = start_game(3000, 1, 20, 1, 0);
                             break;
                        case 1:
                             sc = start_game(4000, 2, 8, 2, 1);
                             break;
                        case 2:
                             sc = start_game(4000, 2, 10, 3, 2);
                             break;
                        case 3:
                             sc = start_game(5000, 3, 12, 4, 3);
                             break;
                        case 4:
                             sc = start_game(6000, 3, 14, 5, 4);
                             break;
                    }
                
                    if(sc>hiscores[selected2])
                    {
                        hiscores[selected2] = sc;
                        save_file();
                    }
                    if(selected2==unlocked && sc > 0 && selected2<5)
                    {
                        unlocked++;
                        save_file();
                    }
                    if(sc > 0)
                     vgame_over(sc, "misson completed");
                }
              }
              if(selected1==2)
              {
                int sc = start_game( 0, 3, 14, 5, 0);
                if(sc>hiscore)
                {
                  hiscore = sc;
                  save_file();
                }
              }
              if(selected1==3)
                end();
                
              gfx->midi(empire);
          }
          if(!key[KEY_DOWN] && !key[KEY_UP] && !key[KEY_LEFT] && !key[KEY_RIGHT])
             key_pressed = false;
          
          if(selected1==-1)
             selected1++;
          if(selected1==4)
             selected1--;
          if(selected2==-1)
             selected2++;
          if(selected2==5)
             selected2--;
          
          if(text_switch==0)
          {
            text_switch = 10;
            gfx->draw_text();
          }
          text_switch--;
          speed_counter--;
        }
        gfx->draw_main_menu(selected1, selected2, hiscore, unlocked, hiscores);
        gfx->draw_buffer();
     }
}
END_OF_FUNCTION(Rb_app::menu)

int Rb_app::start_game(int mission_time, int max_weapon, int noe, int max_enemy, int mission)
{             
     int time = 1;
     
     gfx->midi(battle);
     
     Player *player = new Player(max_weapon);
     Ai *ai = new Ai(noe);
     gfx->pass_player(player);
     ai->pass_player(player);
     
     gfx->pass_noe(noe);
     gfx->pass_mission(mission);
     
     player->set_score(0);
     
     Bullet *bullets[40];
     for(int i=0; i<40; i++)
     {
        bullets[i] = new Bullet();
        gfx->pass_bullet(bullets[i], i);
        ai->pass_bullet(bullets[i], i);
     }
     
     Enemy *enemys[noe];
     for(int i=0; i<noe; i++)
     {
        enemys[i] = new Enemy(max_enemy);
        gfx->pass_enemy(enemys[i], i);
        ai->pass_enemy(enemys[i], i);
     }
     
     Exp *exps[20];
     for(int i=0; i<20; i++)
     {
        exps[i] = new Exp();
        gfx->pass_exp(exps[i], i);
        ai->pass_exp(exps[i], i);
     }
     
     
     gameloop_finished = false;
     bg_y = 0;
     bool swap_pressed = false;
     int slowmotion_time = 0;
     
     while(!gameloop_finished)
     {
           while(speed_counter>0)
           {
               //CHECKING KEYS
                 if(key[KEY_ESC])
                 {
                      while(key[KEY_ESC]){}
                      return -1;
                 }
                 if(key[KEY_UP])
                 {
                      player->move_up();
                 }
                 if(key[KEY_DOWN])
                 {
                      player->move_down();
                 }
                 if(key[KEY_Q] && !swap_pressed)
                 {
                      player->swap_weapons();
                      swap_pressed = true;
                 }
                 if(!key[KEY_Q])
                 {
                      swap_pressed = false;
                 }
                      
                 if(!player->Spinning())
                 {
                    if(key[KEY_A])
                    {
                      if(key[KEY_LEFT])
                      {
                           player->spin(LEFT);
                      }
                      if(key[KEY_RIGHT])
                      {
                           player->spin(RIGHT);
                      }
                    }else{
                      if(key[KEY_LEFT])
                      {
                           player->move_left(4);
                      }
                      if(key[KEY_RIGHT])
                      {
                           player->move_right(4);
                      }
                      if(key[KEY_S])
                      {
                           if(player->Delay()==0 && !player->Overheated())
                           {
                               ai->fire();
                               gfx->digi(blaster);
                           }
                      }
                    }
                 }
                 
                 if(slowmotion_time==0 && ai->no_exps()>2)
                 {
                     slowmotion_time = 300;
                     set_volume(0, 100);
                     install_int_ex( increment_speed_counter, BPS_TO_TIMER(30));
                 }
                 if(slowmotion_time>0)
                 {
                     slowmotion_time--;
                     if(slowmotion_time==0)
                     {
                         set_volume(255, 255);
                         install_int_ex( increment_speed_counter, BPS_TO_TIMER(60));
                     }
                 }
                 if(ai->no_frame0_exps() > 0)
                     gfx->digi(explosion);
                     
                 //enemy vuurt?
                 int e=rand()%noe;
                 if(rand()%6==0 && enemys[e]->Type()>1 && enemys[e]->Type()<5)
                 {
                   ai->enemy_fire(enemys[e]);
                   gfx->digi(blaster);
                 }
                   
                 
                 ai->move_bullets();
                 if(time>300)
                    ai->move_enemys();
                 ai->update_exps();
                 gfx->collision();
                 player->update_state();
                 player->update_weapons();
                 bg_y = ((bg_y+1) % 600);
                 
                 if(time==mission_time)
                      return player->Score();
                      
                 if(player->Health()<=0)
                 {
                      vgame_over(player->Score(), "game over");
                      if(mission_time!=0)
                          return 0;
                      else
                          return player->Score();
                 }
                      
                 time++;
                 speed_counter--;
           }
           
           gfx->draw_game(bg_y);
           gfx->draw_buffer();
     }
     
     return player->Score();
}
END_OF_FUNCTION(Rb_app::start_game)

void Rb_app::vgame_over(int sc, std::string text)
{
     set_volume(255, 255);
     install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
     gfx->midi(game_over);
     while(!key[KEY_ENTER] && !key[KEY_ESC])
     {
         gfx->draw_game_over(sc, text);
         gfx->draw_buffer();
     }
     while(key[KEY_ENTER] || key[KEY_ESC]){}
}
END_OF_FUNCTION(Rb_app::vgame_over)

void Rb_app::end()
{
     save_file();
     exit(0);
     delete gfx;
}
END_OF_FUNCTION(Rb_app::end)

void Rb_app::read_file()
{
     std::ifstream file("data/rb.dat");
     file >> hiscore;
     for(int i=0; i<5; i++)
       file >> hiscores[i];
     file >> unlocked;
     file.close();
}
END_OF_FUNCTION(Rb_app::read_file)

void Rb_app::save_file()
{
     std::ofstream file("data/rb.dat", std::ios::trunc);
     file << hiscore << "\n";
     for(int i=0; i<5; i++)
       file << hiscores[i] << "\n";
     file << unlocked;
     file.close();
}
END_OF_FUNCTION(Rb_app::save_file)

bool Rb_app::briefing(int m)
{
     gfx->read_briefing(m);
     int text_switch = 0;
     while(!key[KEY_ENTER])
     {
         while(speed_counter>0)
         {
              if(text_switch==0)
              {
                 gfx->draw_text();
                 text_switch = 10;
              }
              text_switch--;
              
              if(key[KEY_ESC])
              {
                 while(key[KEY_ESC]){}
                 return false;
              }
         speed_counter--;
         }
         gfx->draw_briefing(m);
         gfx->draw_buffer();
     }
     
     while(key[KEY_ENTER]){}
     return true;
}
