
/*      Display Zoomed picture on screen.

*/
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "data.h"
#include "ll.h"
#include "subs.h"
#include "coord.h"
#include "rect.h"
#include "zoom.h"
#include "butil.h"
#define min(a,b) (a<b ? a:b)
#define max(a,b) (a>b ? a:b)

/* helper functions */
//void display_zoomed_md(void);
//void zoom_disp_rect ( int , int , int , int , char, char *, char * );
//void zoom_display_src_rect( char );
//void zoom_display_dst_rect( char );
/* helper functions */


void display_zoomed_md(void)                            /* display zoom pic */
{
    BITMAP *pspr1=NULL, *pspr2=NULL;
    int x1, y1, sx1, sy1, x2, y2, sx2, sy2;
    int rest_x, rest_y;
    int gsx, gsy;
    int mdsx, mdsy;
    int zoom;
    int x,y;
    int vsx, vsy;   /* scaled sizes, virtual x,y */
    int bkmap_off_override;     /* override bkmap if invalid map */

    pspr1 = ll_get_sprite( g.block_current );
    if(  ScaledMD != NULL ) clear_to_color( ScaledMD, g.syscolor3 );

    bkmap_off_override = FALSE;
    /**** do backgroundmap, fix pspr2 ****/

    g.bkmap.type &= 3;
    if( g.flag_bkmap==TRUE ){
    pspr2 = NULL;
    if( g.bkmap.type==0 ){      // 0 = "number", 1 = "-1", 2 = "+1", 3 = "file"
        if( g.bkmap.nr > (g.block_count-1) )  g.bkmap.nr = g.block_count-1;
        pspr2 = ll_get_sprite( g.bkmap.nr );
        }
    if( g.bkmap.type==1 ){      // -1
        if( g.block_current==0 ) bkmap_off_override=TRUE;
        if( g.block_current!=0 ) pspr2 = ll_get_sprite( g.block_current-1 );
        }
    if( g.bkmap.type==2 ){      // +1
        if( g.block_current ==(g.block_count-1) ) bkmap_off_override=TRUE;
        if( g.block_current != g.block_count    ) pspr2 = ll_get_sprite( g.block_current+1 );
        }
    if( g.bkmap.type==3 )  pspr2 = g.bkmap.map;
    }

    if( g.flag_bkmap==TRUE && g.bkmap.sMD == NULL ){
        g.flag_bkmap = FALSE;
        return;
    }
    // pspr2 is background map if enabled.

    if( g.layer0==NULL) g.layer0 = create_bitmap_clear( g.sx, g.sy );
    if( g.layer0==NULL) return;


if(g.zoom == 0){

    if( pspr1 == NULL || ScaledMD == NULL ) return;

    sx1 = g.sx - g.ox;
    sy1 = g.sy - g.oy;
    md_unzoom_x  = g.ox;
    md_unzoom_y  = g.oy;
    md_unzoom_sx = sx1;
    md_unzoom_sy = sy1;

    /** bkmap **/
    if( g.flag_bkmap==TRUE && bkmap_off_override==FALSE && pspr2!=NULL ){
        blit( pspr2, ScaledMD      , g.ox, g.oy, 0, 0, sx1, sy1 );


        if( g.flag_grid == TRUE ){
            clear_bitmap( g.layer0 );
            grid_display_rect2( g.layer0 );
            masked_blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        }else{
            blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        }

        text_display_rect2( g.layer0 );
        blit( g.layer0, g.bkmap.sMD   , g.ox, g.oy, 0, 0, sx1, sy1 );// pspr1
        masked_blit( g.bkmap.sMD, ScaledMD, 0,0,0,0,  sx1, sy1 );
    }else{

        if( g.flag_grid == TRUE ){
            clear_bitmap( g.layer0 );
            grid_display_rect2( g.layer0 );
            masked_blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        }else{
            blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        }

        text_display_rect2( g.layer0 );
        blit( g.layer0, ScaledMD, g.ox, g.oy, 0, 0, sx1, sy1 ); }   // pspr1
    }


if(g.zoom > 0)
        {
        zoom = g.zoom+1;
        gsx = g.sx;
        gsy = g.sy;
        mdsx = ((md_sx/zoom+1)*zoom);
        mdsy = ((md_sy/zoom+1)*zoom);

        vsx = gsx * zoom;
        vsy = gsy * zoom;
        x1 = y1 = y2 = x2 = 0;
        sx1 = sy1 = sx2 = sy2 = 0;

        /***************/
        /* normal case */
        /* small bitmap */
        if( gsx <= mdsx ){                     /****  X  ****/
                if( vsx > mdsx ){ /* Zoomed Image is bigger than Window */

                    rest_x =  (vsx - mdsx) / zoom;
                    x1 = g.ox;
                    x2 = 0;

                    sx1 = gsx - rest_x;
                    sx2 = mdsx;

                    if( g.ox > rest_x ){
                        sx1 = gsx - g.ox;
                        sx2 = sx1 * zoom;
                        }
                    sx1 = sx2 / zoom;
                    sx2 = sx1 * zoom;
                    }
                if( vsx <= mdsx ){ /* Zoomed Image is NOT bigger than Window */
                    x1 = g.ox;
                    x2 = 0;
                    sx1 = gsx - g.ox;
                    sx2 = vsx - (g.ox * zoom);
                    }
                }                              /****  X  ****/

        if( gsy <= mdsy ){                     /****  Y  ****/
                if( vsy > mdsy ){ /* Zoomed Image is bigger than Window */
                    rest_y =  (vsy - mdsy) / zoom;
                    y1 = g.oy;
                    y2 = 0;
                    sy1 = gsy - rest_y;
                    sy2 = mdsy;
                    if( g.oy > rest_y ){
                        sy1 = gsy - g.oy;
                        sy2 = sy1 * zoom;
                        }
                    sy1 = sy2 / zoom;
                    sy2 = sy1 * zoom;
                    }
                if( vsy <= mdsy ){ /* Zoomed Image is NOT bigger than Window */
                    y1 = g.oy;
                    y2 = 0;
                    sy1 = gsy - g.oy;
                    sy2 = vsy - (g.oy * zoom);
                    }
                }                              /****  Y  ****/
        /**************/
        /**************/
        /**************/
        /**************/
        /**************/
        /**************/

        vsx = mdsx / zoom;
        vsy = mdsy / zoom;

        /* big picture case when pic is bigger than zoom window */
        /* BIG bitmap */
        if( gsx > mdsx ){                      /****  X  ****/
                    x1 = g.ox;
                    x2 = 0;

                    sx1 = vsx;
                    sx2 = mdsx;
                    if( g.ox > ( gsx - vsx )  ){
                        sx1 = gsx - g.ox;
                        sx2 = sx1 * zoom;
                        }
                    sx1 = sx2 / zoom;
                    sx2 = sx1 * zoom;
                    }
        if( gsy > mdsy ){                      /****  Y  ****/
                    y1 = g.oy;
                    y2 = 0;

                    sy1 = vsy;
                    sy2 = mdsy;
                    if( g.oy > ( gsy - vsy )  ){
                        sy1 = gsy - g.oy;
                        sy2 = sy1 * zoom;
                        }
                    sy1 = sy2 / zoom;
                    sy2 = sy1 * zoom;
                    }
   x2 = y2 = 0;
   md_unzoom_x  = x1;
   md_unzoom_y  = y1;
   md_unzoom_sx = sx1;
   md_unzoom_sy = sy1;


    // pspr2 is background map if enabled.

    /** bkmap **/
    if( g.flag_bkmap==TRUE && bkmap_off_override==FALSE ){
        if(pspr2==NULL){
            clear_bitmap( ScaledMD );
        }else{
            stretch_blit( pspr2,   ScaledMD,    x1, y1, sx1, sy1, x2, y2, sx2, sy2 );
        }
        if( g.flag_grid == TRUE ){
            clear_bitmap( g.layer0 );
            display_animate_bkgr( g.layer0 );
            grid_display_rect2( g.layer0 );
            masked_blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        }else{
            clear_bitmap( g.layer0 );
            display_animate_bkgr( g.layer0 );
            if( g.flag_animate==TRUE)
                masked_blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
            else
                blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        }

        text_display_rect2( g.layer0 );
        stretch_blit( g.layer0,       g.bkmap.sMD, x1, y1, sx1, sy1, x2, y2, sx2, sy2 );
        masked_blit(  g.bkmap.sMD, ScaledMD,    0,0,0,0,sx2,sy2);
    }else{
        if( g.flag_grid == TRUE ){
            clear_bitmap( g.layer0 );
            display_animate_bkgr( g.layer0 );
            grid_display_rect2( g.layer0 );
            masked_blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        }else{
        clear_bitmap( g.layer0 );
        display_animate_bkgr( g.layer0 );
        if( g.flag_animate==TRUE)
            masked_blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        else
            blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy );
        }
        text_display_rect2( g.layer0 );
        stretch_blit( g.layer0, ScaledMD, x1, y1, sx1, sy1, x2, y2, sx2, sy2 );
    }






    /**  pixel grid  **/
    if(g.flag_pixelgrid == TRUE && zoom > 1 )
    {
        for( x = 0 ; x < (sx1+1) ; x++ )
                vline( ScaledMD, x2+x*zoom, 0, sy2, 0);
        for( y = 0 ; y < (sy1+1) ; y++ )
                hline( ScaledMD, 0, y2+y*zoom, sx2, 0);

        for( x = 0 ; x < sx1 ; x++ ){
        for( y = 0 ; y < sy1 ; y++ ){
                putpixel( ScaledMD, x*zoom+zoom, y*zoom+zoom,  g.syscolor1 );
        }}

    } /**  pixel grid  **/
    }
    zoom_display_src_rect( 1 );
    zoom_display_dst_rect( 1 );
    text_display_rect( ScaledMD );

    scare_mouse();
    acquire_screen();
    blit( ScaledMD, screen, 0,0,md_x,md_y, md_sx, md_sy );
    release_screen();
    unscare_mouse();
}







/* display source rectangle */
// input: ?
//
void zoom_display_src_rect( char p )
{
    char    message[80];

    p &= 1;

    sprintf( (char *)&message, "W=%d H=%d",clips.sx, clips.sy);

    /* display on all blocks */
    if( g.flag_all == TRUE &&\
        g.flag_src == TRUE &&\
        clips.flag == TRUE ){
    zoom_disp_rect ( clips.x1,clips.y1,clips.x2,clips.y2, p, "SRC",(char *)&message );
    return;
    }
    /* display on single block */
    if( clips.flag == TRUE && clips.block == g.block_current ){
    zoom_disp_rect ( clips.x1,clips.y1,clips.x2,clips.y2, p, "SRC",(char *)&message );

    }
}

void zoom_display_dst_rect( char p )
{
    char    message[80];
    p &= 1;

    sprintf( (char *)&message, "W=%d H=%d",clipd.sx, clipd.sy);
    /* display on all blocks */
    if( g.flag_all == TRUE &&\
        g.flag_dst == TRUE &&\
        clipd.flag == TRUE ){
    zoom_disp_rect ( clipd.x1,clipd.y1,clipd.x2,clipd.y2, p, "DST",(char *)&message  );
    return;
    }
    /* display on single block */
    if( clipd.flag == TRUE && clipd.block == g.block_current ){
    zoom_disp_rect ( clipd.x1,clipd.y1,clipd.x2,clipd.y2, p, "DST",(char *)&message  );
    }
}










/* display rectangle with handles on current zoom factor.
 * coordinates are in pixel buffer format (not zoomed).
 * p - color 0 or 1.
 *
 */
void zoom_disp_rect ( int ix1, int iy1, int ix2, int iy2, char p, char *caption, char *caption2 )
{
    int     x1,y1,x2,y2,sx,sy, i;
    int     draw_color=0;
    VRECT   vr1,vr2, vo;
    int     retval;
//    int     lsx, lsy;


    if( (p&1) == 0 ) draw_color = 0;
    if( (p&1) == 1 ) draw_color = g.syscolor2;
    x1 = min ( ix1, ix2 );
    x2 = max ( ix1, ix2 );
    y1 = min ( iy1, iy2 );
    y2 = max ( iy1, iy2 );
    sx = x2 - x1;
    sy = y2 - y1;
    vr1.x  = x1;            // clip rectangle
    vr1.y  = y1;
    vr1.sx = sx;
    vr1.sy = sy;
    vr2.x  = md_unzoom_x ;  // screen block
    vr2.y  = md_unzoom_y ;
    vr2.sx = md_unzoom_sx;
    vr2.sy = md_unzoom_sy;
    retval = rect_intersection(  (VRECT *)&vr1, (VRECT *)&vr2, (VRECT *)&vo );

    if(retval==TRUE){       // valid rectangle
    drawing_mode(DRAW_MODE_COPY_PATTERN, g.fillmap3, 0, 0);

//    text_mode( 0 );    strux[0] = 0;
//    sprintf( (char *)&strux, "p1is = %d,%d,%d,%d ", vo.p1inside,vo.p2inside,vo.p3inside,vo.p4inside );
//    textout(screen, font, (char *)&strux,0,22, 255 );
//    sprintf( (char *)&strux, "clips:   %d,%d,%d,%d sx=%d sy=%d", clips.x1,clips.y1,clips.x2,clips.y2,clips.sx,clips.sy );
//    textout(screen, font, (char *)&strux,0,22, 255 );

    if( vo.line1_valid == 1 ){
        coord_bin2screen( vo.line1_x1, vo.line1_y1, (int *)&vo.line1_x1, (int *)&vo.line1_y1 );
        coord_bin2screen( vo.line1_x2, vo.line1_y2, (int *)&vo.line1_x2, (int *)&vo.line1_y2 );
        line( ScaledMD, vo.line1_x1, vo.line1_y1, vo.line1_x2, vo.line1_y2, draw_color );
/*
    lsx = vo.line1_x2 - vo.line1_x1;
    lsy = vo.line1_y2 - vo.line1_y1;
    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
    rect( ScaledMD, vo.line1_x1+lsx/2-g.hs/2, vo.line1_y1, vo.line1_x2-lsx/2+g.hs/2, vo.line1_y2+g.hs, draw_color );
    drawing_mode(DRAW_MODE_COPY_PATTERN, g.fillmap3, 0, 0);
*/

    }
    if( vo.line2_valid == 1 ){
        coord_bin2screen( vo.line2_x1, vo.line2_y1, (int *)&vo.line2_x1, (int *)&vo.line2_y1 );
        coord_bin2screen( vo.line2_x2, vo.line2_y2, (int *)&vo.line2_x2, (int *)&vo.line2_y2 );
        line( ScaledMD, vo.line2_x1, vo.line2_y1, vo.line2_x2, vo.line2_y2, draw_color );

/*
    lsx = vo.line2_x2 - vo.line2_x1;
    lsy = vo.line2_y2 - vo.line2_y1;
    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
    rect( ScaledMD, vo.line2_x1, vo.line2_y1+lsy/2-g.hs/2, vo.line2_x2, vo.line2_y2+g.hs-lsy/2+g.hs/2, draw_color );
    drawing_mode(DRAW_MODE_COPY_PATTERN, g.fillmap3, 0, 0);
*/

    }
    if( vo.line3_valid == 1 ){
        coord_bin2screen( vo.line3_x1, vo.line3_y1, (int *)&vo.line3_x1, (int *)&vo.line3_y1 );
        coord_bin2screen( vo.line3_x2, vo.line3_y2, (int *)&vo.line3_x2, (int *)&vo.line3_y2 );
        line( ScaledMD, vo.line3_x1, vo.line3_y1, vo.line3_x2, vo.line3_y2, draw_color );
    }
    if( vo.line4_valid == 1 ){
        coord_bin2screen( vo.line4_x1, vo.line4_y1, (int *)&vo.line4_x1, (int *)&vo.line4_y1 );
        coord_bin2screen( vo.line4_x2, vo.line4_y2, (int *)&vo.line4_x2, (int *)&vo.line4_y2 );
        line( ScaledMD, vo.line4_x1, vo.line4_y1, vo.line4_x2, vo.line4_y2, draw_color );
    }
    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
        if( vo.p1inside == 1 ){
        rect( ScaledMD,  vo.line1_x1,        vo.line1_y1,
                         vo.line1_x1 + g.hs, vo.line1_y1 + g.hs, draw_color );
        i = text_mode(-1);
        textout( ScaledMD, font, caption, vo.line1_x1+g.hs+1, vo.line1_y1 + g.hs+1, draw_color);
        textout( ScaledMD, font, caption2,vo.line1_x1+g.hs+1, vo.line1_y1 + g.hs+1+10, draw_color );
        text_mode(i);
        }
        if( vo.p2inside == 1 ){
        rect( ScaledMD,  vo.line2_x2,        vo.line2_y1,
                         vo.line2_x2 - g.hs, vo.line2_y1 + g.hs, draw_color );
        }
        if( vo.p3inside == 1 ){
        rect( ScaledMD,  vo.line3_x2,        vo.line3_y2,
                         vo.line3_x2 - g.hs, vo.line3_y2 - g.hs, draw_color );
        }
        if( vo.p4inside == 1 ){
        rect( ScaledMD,  vo.line4_x1,        vo.line4_y2,
                         vo.line4_x1 + g.hs, vo.line4_y2 - g.hs, draw_color );
        }
    }
}




void text_display_rect( BITMAP *map )
{
    int     x1,y1,x2,y2,sx1,sy1,sx2,sy2;
    VRECT   vr1,vr2, vo;
    int     retval, draw_color;

    draw_color = g.syscolor3;

    if( text.enabled==FALSE ) return;
    if( text.block != g.block_current ) return;
    if( text.map == NULL ) return;

    vr1.x  = text.x1;            // clip rectangle
    vr1.y  = text.y1;
    vr1.sx = text.sx;
    vr1.sy = text.sy;
    vr2.x  = md_unzoom_x ;  // screen block
    vr2.y  = md_unzoom_y ;
    vr2.sx = md_unzoom_sx;
    vr2.sy = md_unzoom_sy;
    retval = rect_intersection(  (VRECT *)&vr1, (VRECT *)&vr2, (VRECT *)&vo );
    if(retval==TRUE){       // valid rectangle

    if( vo.line1_valid == 1 ){
        coord_bin2screen( vo.line1_x1, vo.line1_y1, (int *)&vo.line1_x1, (int *)&vo.line1_y1 );
        coord_bin2screen( vo.line1_x2, vo.line1_y2, (int *)&vo.line1_x2, (int *)&vo.line1_y2 );
        line( map, vo.line1_x1, vo.line1_y1, vo.line1_x2, vo.line1_y2, draw_color );
    }
    if( vo.line2_valid == 1 ){
        coord_bin2screen( vo.line2_x1, vo.line2_y1, (int *)&vo.line2_x1, (int *)&vo.line2_y1 );
        coord_bin2screen( vo.line2_x2, vo.line2_y2, (int *)&vo.line2_x2, (int *)&vo.line2_y2 );
        line( map, vo.line2_x1, vo.line2_y1, vo.line2_x2, vo.line2_y2, draw_color );
    }
    if( vo.line3_valid == 1 ){
        coord_bin2screen( vo.line3_x1, vo.line3_y1, (int *)&vo.line3_x1, (int *)&vo.line3_y1 );
        coord_bin2screen( vo.line3_x2, vo.line3_y2, (int *)&vo.line3_x2, (int *)&vo.line3_y2 );
        line( map, vo.line3_x1, vo.line3_y1, vo.line3_x2, vo.line3_y2, draw_color );
    }
    if( vo.line4_valid == 1 ){
        coord_bin2screen( vo.line4_x1, vo.line4_y1, (int *)&vo.line4_x1, (int *)&vo.line4_y1 );
        coord_bin2screen( vo.line4_x2, vo.line4_y2, (int *)&vo.line4_x2, (int *)&vo.line4_y2 );
        line( map, vo.line4_x1, vo.line4_y1, vo.line4_x2, vo.line4_y2, draw_color );
    }

    if( vo.line1_valid == 1 && vo.line2_valid == 1 ){
        x1  = vo.line1_x1;
        y1  = vo.line1_y1;
        sx1 = text.sx;
        sy1 = text.sy;
        x2  = vo.line2_x2;
        y2  = vo.line2_y2;
        sx2 = vo.line2_x2 - vo.line1_x1;
        sy2 = vo.line2_y2 - vo.line1_y1;
//        textprintf(screen,font, md_x, md_y, 255, "%d %d %d %d %d %d %d %d",x1,y1,sx1,sx2, x2,y2,sy2,sx2  );
    }


        if( vo.p1inside == 1 ){
//        rect( map,  vo.line1_x1, vo.line1_y1,  vo.line1_x1 + g.hs, vo.line1_y1 + g.hs, draw_color );

// *********************
//      disabled because we are using new method now.
//        blit( text.map, map, 0,0, vo.line1_x1, vo.line1_y1, text.sx, text.sy );
// *********************
        }
        if( vo.p2inside == 1 ){
//        rect( map,  vo.line2_x2,        vo.line2_y1,                         vo.line2_x2 - g.hs, vo.line2_y1 + g.hs, draw_color );
        }
        if( vo.p3inside == 1 ){
//        rect( map,  vo.line3_x2,        vo.line3_y2,                         vo.line3_x2 - g.hs, vo.line3_y2 - g.hs, draw_color );
        }
        if( vo.p4inside == 1 ){
//        rect( map,  vo.line4_x1,        vo.line4_y2,                         vo.line4_x1 + g.hs, vo.line4_y2 - g.hs, draw_color );
        }
    }
}







void text_display_rect2( BITMAP *map )
{

    if( text.enabled == FALSE ) return;
    if( text.block != g.block_current ) return;
    if( map == NULL || text.map == NULL ) return;
    masked_blit( text.map, map, 0,0, text.x1, text.y1, text.sx, text.sy );
}


void grid_display_rect2( BITMAP *map )
{
    int x,y;

    if( g.flag_grid == FALSE ) return;
    if( g.grid_sx <= 1 ) return;
    if( g.grid_sy <= 1 ) return;

    if( map == NULL ) return;
    for( x = 0 ; x < g.sx ; x+=g.grid_sx )
        vline( map, x,0,g.sy, g.syscolor3 );
    for( y = 0 ; y < g.sy ; y+=g.grid_sy )
        hline( map, 0,y,g.sx, g.syscolor3 );
}


void display_animate_bkgr( BITMAP *map )
{
    int i0,i1,i2,i3,i4;
    BITMAP  *ta;

    if( g.flag_animate == FALSE ) return;


    if( g.bmp0 == NULL ) g.bmp0 = create_bitmap( g.sx, g.sy );
    if( g.bmp1 == NULL ) g.bmp1 = create_bitmap( g.sx, g.sy );
    if( g.bmp2 == NULL ) g.bmp2 = create_bitmap( g.sx, g.sy );
    if( g.bmp3 == NULL ) g.bmp3 = create_bitmap( g.sx, g.sy );
    if( g.bmp4 == NULL ) g.bmp4 = create_bitmap( g.sx, g.sy );
    clear_bitmap(g.bmp0);
    clear_bitmap(g.bmp1);
    clear_bitmap(g.bmp2);
    clear_bitmap(g.bmp3);
    clear_bitmap(g.bmp4);


    // use 32 colors for each background map, shifted 32 positions.
    // ( not ready yet )
    i0 =  g.block_current - 5;
    i1 =  g.block_current - 4;
    i2 =  g.block_current - 3;
    i3 =  g.block_current - 2;
    i4 =  g.block_current - 1;

    if( i0 >= 0 ){
        ta = ll_get_sprite( i0 );       /* return BITMAP pointer to sprite object in memory */
        blit( ta, g.bmp0, 0,0,0,0, g.sx,g.sy );
        shift_bitmap_32pos( g.bmp0, 5 );
        masked_blit( g.bmp0, map, 0,0,0,0,g.sx,g.sy);
    }
    if( i1 >= 0 ){
        ta = ll_get_sprite( i1 );       /* return BITMAP pointer to sprite object in memory */
        blit( ta, g.bmp1, 0,0,0,0, g.sx,g.sy );
        shift_bitmap_32pos( g.bmp1, 4 );
        masked_blit( g.bmp1, map, 0,0,0,0,g.sx,g.sy);
    }
    if( i2 >= 0 ){
        ta = ll_get_sprite( i2 );       /* return BITMAP pointer to sprite object in memory */
        blit( ta, g.bmp2, 0,0,0,0, g.sx,g.sy );
        shift_bitmap_32pos( g.bmp2, 3 );
        masked_blit( g.bmp2, map, 0,0,0,0,g.sx,g.sy);
    }
    if( i3 >= 0 ){
        ta = ll_get_sprite( i3 );       /* return BITMAP pointer to sprite object in memory */
        blit( ta, g.bmp3, 0,0,0,0, g.sx,g.sy );
        shift_bitmap_32pos( g.bmp3, 2 );
        masked_blit( g.bmp3, map, 0,0,0,0,g.sx,g.sy);
    }
    if( i4 >= 0 ){
        ta = ll_get_sprite( i4 );       /* return BITMAP pointer to sprite object in memory */
        blit( ta, g.bmp4, 0,0,0,0, g.sx,g.sy );
        shift_bitmap_32pos( g.bmp4, 1 );
        masked_blit( g.bmp4, map, 0,0,0,0,g.sx,g.sy);
    }




}

