/*
 * date: 2004/01/11
 *
 * Link handling
 *
 *
 */
#ifndef _H_LINK_H
#define _H_LINK_H

// linked list structure unit
typedef struct LINKITEM {
    void    *prev;          // previous link
    void    *next;          // next link
    void    *userdata;      // points to user allocated data or structure
}LINKITEM __attribute__ ((packed)); ;

// unit to handle a linked list
typedef struct LINKS {
LINKITEM    *firstlink;     //
LINKITEM    *lastlink;      //
LINKITEM    *currentlink;   //
void        *userdata;      // points to user allocated data or structure (not used yet)
int         links;          // Total number of links
}LINKEDLIST __attribute__ ((packed));

LINKITEM    *link_alloc_linkitem();        // not really needed by user...
void         link_free_linkitem( LINKITEM * );  // not really needed by user...
LINKEDLIST  *link_alloc_linkedlist(void);
void         link_free_linkedlist( LINKEDLIST *);
LINKEDLIST  *init_linkedlist(void);
void        deinit_linkedlist( LINKEDLIST *);
LINKITEM    *link_append( LINKEDLIST *le );                 // add a new link and chain it automatically
LINKITEM    *link_append_at( LINKEDLIST *le, int index );
LINKITEM    *link_append_head( LINKEDLIST *le );
LINKITEM    *link_append_tail( LINKEDLIST *le );
LINKITEM    *link_delete( LINKEDLIST *le );    // remove current link
LINKITEM    *link_swap( LINKEDLIST *le );      // swap two links, rechaining automatically
LINKITEM    *link_first( LINKEDLIST *le );     // link_rewind() - link_head()
LINKITEM    *link_prev( LINKEDLIST *le );
LINKITEM    *link_next( LINKEDLIST *le );
LINKITEM    *link_last( LINKEDLIST *le );      // link_tail()
LINKITEM    *link_goto( LINKEDLIST *le  ,int );
LINKITEM    *link_current( LINKEDLIST *le );   // return link on current position
int         link_get_current_index( LINKEDLIST *le );
int         link_get_index( LINKEDLIST *le, LINKITEM *t );

#endif
