/*
 * date: 2004/01/11
 *
 * Doubly linked, Linked List.
 *
 *
 *
 */
#include <stdio.h>      // for NULL definition
#include <stdlib.h>     // malloc/free
#include "link.h"

/*
 * Allocate a link without initializing data, actually the code only
 * handles, prev, next.
 * returns the new link, NULL on error
 */
LINKITEM *link_alloc_linkitem()
{
    LINKITEM *t;

    t = (LINKITEM *) malloc( sizeof(LINKITEM) );    if(t==NULL) return NULL;
    t->prev = NULL;
    t->next = NULL;
    t->userdata = NULL;
    return t;
}

/*
 * the userdata void pointer must be returned NULL by the user, otherwise
 * the code will deallocate it by itself.
 *
 */
void link_free_linkitem( LINKITEM *t )
{
    if( t==NULL ) return;
    if( t->userdata != NULL ){ free( t->userdata ); t->userdata=NULL; }
    free( t );
}






LINKEDLIST *link_alloc_linkedlist(void)
{
    LINKEDLIST  *t;

    t = (LINKEDLIST *) malloc( sizeof(LINKEDLIST) );    if(t==NULL) return NULL;
    t->firstlink   = NULL;
    t->lastlink    = NULL;
    t->currentlink = NULL;
    t->userdata    = NULL;
    t->links       = 0;
    return t;
}
void link_free_linkedlist( LINKEDLIST *t )
{
    int i,j;

    if(t==NULL) return;
    link_first( t );
    j = t->links;
    if(j>0){  for(i=0;i<(j+1);i++)  link_delete( t );}
    if( t->userdata != NULL ) free(t->userdata);
    t->firstlink   = NULL;
    t->lastlink    = NULL;
    t->currentlink = NULL;
    t->userdata    = NULL;
    t->links       = 0;
}


/*
 * Add a link in current position, pushing links forward.
 * The link user data is uninitialized (userdata) and is NULL,
 * the user must initialize the
 * userdata void pointer to point to a allocated structure.
 * The link is chained automatically to the linked list.
 * returns newly allocated and linked link.
 *
 */
LINKITEM *link_append( LINKEDLIST *le )
{
    LINKITEM     *lnk1=NULL, *lnk2=NULL, *lnk3=NULL;

    if( le == NULL ) return NULL;
    // distinguish four cases:
    // no links, first, last, middle

    if( ((le->firstlink==NULL) && (le->lastlink==NULL)) || (le->links==0) ){           // ! no links !
        lnk1 = link_alloc_linkitem();    le->links++;
        le->firstlink   = lnk1;
        le->lastlink    = lnk1;
        le->currentlink = lnk1;
        lnk1->prev = NULL;
        lnk1->next = NULL;
        le->currentlink = lnk1;
    return lnk1;
    }

    if( le->firstlink!=NULL ){      // we have at least one link
        if(le->currentlink==NULL) return NULL;                           // ERROR
        lnk1 = le->currentlink;
        lnk3 = lnk1->next;
        lnk2 = link_alloc_linkitem();    le->links++;
        if(lnk3 ==NULL){    // we are at the last link in list
            lnk1->next = lnk2;
            lnk2->prev = lnk1;
            lnk2->next = NULL;
            le->currentlink = lnk2;
            le->lastlink    = lnk2;
        return lnk2;
        }else{              // regular case
            lnk1->next = lnk2;
            lnk2->prev = lnk1;
            lnk2->next = lnk3;
            lnk3->prev = lnk2;
            le->currentlink = lnk2;
        return lnk2;
        }
    return NULL;
    }
    return NULL;
}

/* METHOD from LL.C
 * newly created link is inserted at the position in link list that
 * user specifies from beginning of linked list.
 */
LINKITEM *link_append_at(  LINKEDLIST *le, int index )
{
    int     i;
    LINKITEM *tmp1=NULL;
    LINKITEM *tmp3=NULL;
    LINKITEM *tmp4=NULL;
    LINKITEM *tmp5=NULL;

    if( le == NULL ) return NULL;
//    le->current = index;
    if(le->firstlink == NULL){ return NULL; }
    if(le->firstlink != NULL){
        tmp1 = le->firstlink;
        if(index != 0)
        {
        for(i=0;i<index;i++)
            {
            if(tmp1->next == NULL ) return( link_append_tail( le ) );
            tmp1 = tmp1->next;
            }
        }
        if(index==0){
        tmp5  = link_alloc_linkitem();       le->links++;
        if (tmp5 == NULL) return NULL;
        tmp5->prev = NULL;
        tmp5->next = tmp1;
        tmp1->prev= tmp5;
        le->firstlink = tmp5;
        le->links++;
        return tmp5;
        }
        tmp4  =  tmp1;
        tmp3  =  tmp1->prev;
        tmp5  =  link_alloc_linkitem();    le->links++;
        if (tmp5 == NULL) return NULL;
        tmp5->prev = tmp3;
        tmp5->next = tmp4;
        tmp3->next = tmp5;
        tmp4->prev = tmp5;
        le->links++;
        return tmp5;
    }
    return NULL;
}

/* METHOD from LL.C
 * newly created link is inserted at first position in link list (first chain).
 */
LINKITEM *link_append_head( LINKEDLIST *le )
{
    LINKITEM *tmp1 = NULL, *tmp2 = NULL;

    if( le == NULL ) return NULL;
    if(le->firstlink == NULL){
        tmp1 = le->firstlink;
        tmp1 = link_alloc_linkitem();    le->links++;
        if (tmp1 == NULL) return NULL;
        tmp1->prev = NULL;
        tmp1->next = NULL;
        le->firstlink = tmp1;
        le->lastlink =  tmp1;
        le->links++;
    return tmp1;
    }
    if(le->firstlink != NULL){
        tmp1 = le->firstlink;
        tmp2 = link_alloc_linkitem();    le->links++;
        if( tmp2 == NULL ) return NULL;
        tmp1->prev = tmp2;
        tmp2->prev = NULL;
        tmp2->next = tmp1;
        le->firstlink = tmp2;
        le->links++;
        return tmp2;
    }
    return NULL;
}

/* METHOD from LL.C
 * newly created link is inserted at last position in link list (last chain).
 */
LINKITEM *link_append_tail( LINKEDLIST *le )
{
    LINKITEM *tmp1 = NULL, *tmp2 = NULL;

    if( le == NULL ) return NULL;
    if(le->firstlink == NULL){
        tmp1 = le->firstlink;
        tmp1 = link_alloc_linkitem();    le->links++;
        if (tmp1 == NULL) return NULL;
        tmp1->prev = NULL;
        tmp1->next = NULL;
        le->firstlink = tmp1;
        le->lastlink =  tmp1;
        le->links++;
        return tmp1;
    }
    if(le->firstlink != NULL){
        tmp1 = le->lastlink;
        tmp2 = link_alloc_linkitem();    le->links++;
        if( tmp2 == NULL ) return NULL;
        tmp1->next = tmp2;
        tmp2->prev = tmp1;
        tmp2->next = NULL;
        le->lastlink = tmp2;
        le->links++;
        return tmp2;
    }
    return NULL;
}

























/*
 * remove a link at current position in linked list, pushing
 * links backwards.
 */
LINKITEM *link_delete( LINKEDLIST *le )
{
    LINKITEM     *lnk1=NULL, *lnk2=NULL, *lnk3=NULL;

    if( le == NULL ) return NULL;
    if( (le->firstlink==NULL&&le->lastlink==NULL) || le->links==0 ) return NULL; //no links!
    lnk2 = le->currentlink;    if (lnk2 == NULL ) return NULL;
    lnk1 = lnk2 -> prev;
    lnk3 = lnk2 -> next;

    link_free_linkitem( lnk2 );    if( le->links!=0 )  le->links--;
    lnk2 = NULL;


    if( lnk1 == NULL && lnk3 == NULL ){     // case0: wow! last link in linked list is gone
        le->firstlink = le->lastlink = le->currentlink = NULL;
        return le->currentlink;
    }
    if( lnk1 == NULL ){     // case1: first in link
        lnk3 -> prev = NULL;
        le->currentlink = le->firstlink = lnk3;
        return le->currentlink ;
    }
    if( lnk3 == NULL ){     // case2: last in link
        lnk1 -> next = NULL;
        le->currentlink = le->lastlink = lnk1;
        return le->currentlink ;
    }
    lnk1 -> next = lnk3;    // case3: in midlink
    lnk3 -> prev = lnk1;
    le->currentlink = lnk1;
    return le->currentlink;
}









/*
 * Swap links at current links with next link
 *
 */
LINKITEM *link_swap( LINKEDLIST *le )
{
    LINKITEM     *lnk, *lak;
    LINKITEM     *prev1, *next1;
    LINKITEM     *prev2, *next2;

    if( le == NULL ) return NULL;
    lnk = le->currentlink;
    prev1 = lnk->prev;      // NULL
    next1 = lnk->next;      // LAK
    if( prev1 == NULL && next1 == NULL) return NULL;
    if( next1 == NULL )     return NULL;            // can't swap
    lak   = next1;
    prev2 = lak->prev;      // LNK
    next2 = lak->next;
    if( prev1 == NULL ) le->firstlink = lak;    // first link!
    if( next2 == NULL ) le->lastlink = lnk;     // last link!
    // now swap links
    lnk->prev = lak;
    lnk->next = next2;
    lak->prev = prev1;
    lak->next = lnk;
    if(prev1!=NULL)    prev1->next = lak;
    if(next2!=NULL)    next2->prev = lnk;
    le->currentlink = lak;
    return lnk;
}



/*
 *  rewind current link pointer
 *
 */
LINKITEM *link_first( LINKEDLIST *le )
{
    if( le == NULL ) return NULL;
    le->currentlink = le->firstlink;
    return le->currentlink;
}
/*
 */
LINKITEM *link_last( LINKEDLIST *le )
{
    if( le == NULL ) return NULL;
    le->currentlink = le->lastlink;
    return le->currentlink;
}

/*
 *  prev
 *  return link to "prev" in link.
 *  return NULL if begin of link.
 */
LINKITEM *link_prev( LINKEDLIST *le )
{
    LINKITEM *lnk;

    if( le == NULL ) return NULL;
    if( le->currentlink == NULL ) return NULL;
    lnk = le->currentlink -> prev;
    if (lnk != NULL ) le->currentlink = lnk;    // step backward
    return lnk;
}



/*
 *  next
 *  return link to "next" in link.
 *  return NULL if end of link.
 */
LINKITEM *link_next( LINKEDLIST *le )
{
    LINKITEM *lnk;

    if( le == NULL ) return NULL;
    if( le->currentlink == NULL ) return NULL;
    lnk = le->currentlink -> next;
    if (lnk != NULL ) le->currentlink = lnk;    // step forward
    return lnk;
}

/*
 * go to a specific index
 * 0 if the first link from beginning of link
 * Return NULL on out-of-link situation or NULL if no links available.
 *
 * input:  Index value
 *
 */
LINKITEM *link_goto(  LINKEDLIST *le ,int _index )
{
    int         index = _index;
    LINKITEM    *lnk=NULL;
    int         i=0;

    if( le == NULL ) return NULL;
    if( index<0 ) index=0;
    if( index>le->links ) return NULL;
    if( le->currentlink == NULL ) return NULL;
    lnk = le->firstlink;    if(lnk==NULL) return NULL;
    for(i=0;i<index;i++){
        lnk = lnk->next;
        if(lnk==NULL) break;
    }
    if( lnk != NULL ){
        le->currentlink = lnk;
        return le->currentlink;
    }
    return NULL;
}


/*
 *  return current link
 */
LINKITEM *link_current( LINKEDLIST *le )
{
    if( le == NULL ) return NULL;
    return le->currentlink;
}


/*
 * Return index in link for current link.
 *
 * return -1 if no links available or any error.
 *
 */
int link_get_current_index( LINKEDLIST *le )
{
    if( le == NULL ) return -1;
    if( le->currentlink == NULL ) return -1;
    return link_get_index( le, le->currentlink );
}


/*
 * Return index in link for this link.
 *
 * input:  Link
 * return -1 if no links available or any error.
 *
 */
int link_get_index( LINKEDLIST *le, LINKITEM *t )
{
    LINKITEM    *lnk  = NULL;
    int         index = 0;

    if( le == NULL ) return -1;
    if( le->currentlink == NULL ) return -1;
    lnk = le->firstlink;    if(lnk==NULL) return -1;
    lnk = link_first( le );
    for(index=0;;index++){
    if( index > le->links ) return -1;
    if( le->currentlink == t ){ return index; }
    lnk = link_next( le );    if(lnk==NULL) return -1;
    }
    return -1;
}




