#ifndef _fli_subs_h_
#define _fli_subs_h_

#include "flilib.h"

FLI *alloc_fli_struc(int verbose_flag);
void free_fli_struc(FLI *f);

FILE *openfliload( char *filename, FLI *f );
FLI *read_fli_header( FLI *f );
void  do_fli_unbrun( FLI *f );
void  do_delta_unflc( FLI *f );
void  do_delta_unfli( FLI *f );
void  do_dta_unbrun( FLI *f );
void  do_dta_copy( FLI *f );
void  do_dta_unlc( FLI *f );

FILE *openflisave( char *filename, FLI *f );
FLI *write_fli_header( FLI *f );

int compress_palette( FLI *f);
int compress_image( FLI *f);
long write_chunk_header( FLI *f, int frame_type, int subchunks  );
void trim_chunk_header( FLI *f, DWORD oldposition );


void  do_fli_brun( FLI *f );
void  do_delta_fli( FLI *f );
void  do_delta_flc( FLI *f );
void  do_dta_brun( FLI *f );
void  do_dta_lc( FLI *f );

#ifdef NEVER
        write_subchunk( f, BLACK    ,1);
        write_subchunk( f, BYTE_RUN ,1);/* FLI_BRUN */
        write_subchunk( f, FLI_COPY ,1);/* FLI_COPY */
        write_subchunk( f, DELTA_FLI,1);/* FLI_LC   */
        write_subchunk( f, DELTA_FLC,1);/* FLI_SS2  */
        write_subchunk( f, DTA_BRUN ,1);
        write_subchunk( f, DTA_COPY ,1);
        write_subchunk( f, DTA_LC   ,1);
#endif

#endif
