/*
 *
 * grey methods
 *
 *
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "data.h"
#include "grey.h"
#include "dlg.h"
#include "subs.h"
#include "ll.h"

// -------------------------------------------------------------------------

/*
 * Do gamma correction on palette.
 * Input parameters is not used at all
 *  Input: Gamma value. 0.0 to 9.9
 */
void do_gamma_pal( BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     i;
    double ig=0.0, gamma = 0.0;

    gamma = dlg_request_float(NULL,0.1,1.0,9.0); if(gamma<0.0) return;
    if( gamma !=0.0)  ig = 1.0/gamma;  else  ig = 0.0;
    for(i=0;i<256;i++)
    {
    g.palette[i].r = pow(g.palette[i].r/63.0, ig) * 63.0;
    g.palette[i].g = pow(g.palette[i].g/63.0, ig) * 63.0;
    g.palette[i].b = pow(g.palette[i].b/63.0, ig) * 63.0;
    }
    set_palette((RGB *)&g.palette);
    refix_all_display();
}

// -------------------------------------------------------------------------



