/*
 * included by all source files
 * definition for global data structures
 *
 */

#ifndef _H_MAINGLOBALHDRX_HH_
#define _H_MAINGLOBALHDRX_HH_

#include "fnt.h"

// brush structure
typedef struct {
int     size;   // pixelsize of brush, valid for: square, circle
int     type;   // 0 = square, 1 = circle, 2 = bitmap, 3 = undef
int     sx;     // size x for bitmapped brushes
int     sy;     // size y for bitmapped brushes
BITMAP *bmp;    // brush bitmap
}EXA_BRUSH;

// backgroundmap structure
typedef struct {
int     type;       // 0 = "number", 1 = "-1", 2 = "+1", 3 = "file"
int     nr;         // bkmap number
char    *file;      // filename
int     sx;         // size x
int     sy;         // size y
BITMAP  *map;       // backgroundmap
BITMAP  *sMD;       // main edit screen bitmap,  size: md_sx, md_sy
}EXA_BKMAP;

typedef struct {    // *******************************************
int x1, y1;         // startpoint
int sx, sy;         // size in pixels of block
int enabled;        // TRUE/FALSE, enabled/disabled
int block;          // which sprite block this struct refers to
FNT *fnt;           // type of font
BITMAP  *map;       // graphic to float above md
char    *string;    //
}EXA_TEXT;          // *****************************************

                    /**** Source /destination clip rectangle ****/
typedef struct {    /********************************************/
int x1, y1;         /* startpoint                               */
int x2, y2;         /* endpoint                                 */
int sx, sy;         /* size of block                            */
int flag;           /* TRUE/FALSE, enabled/disabled             */
int block;          /* which sprite block this struct refers to */
int areaselected;   /* which part of the block is clicked on (or selected) */
}EXA_CLIP;       /********************************************/

typedef struct {    /****************************************/
int     enabled;    /* TRUE/FALSE                           */
char    *filefixed; /* filename of bitmap block file        */
int     sx,sy;      /* sizes of blocks for class:free       */
int     type;       /* 0=solid, 1=Black/white, 2=color      */
int     operation;  /* 0=normal, 1=mask, 2=xor,             */
int     blocks;     /* number of fill blocks                */
int     selected;   /* current selected block               */
int     class;      /* 0=8x8, 1 = fill from SOURCE rectangle*/
int     bk,fg;      /* colors used for type:b/w             */
int     fi_group;   /* currently selected group             */
BITMAP  *bmpfixed;  /* pointer to all bitmap blocks         */
BITMAP  *bmpfixed2; /* pointer to all bitmap blocks, secondary copy adapted to current bpp         */
BITMAP  *bmp8x8;    /* small fill graphic                   */
BITMAP  *bmp8x8tmp; /* small fill graphic tmp,cleared,remapped*/
BITMAP  *bmp8x8tmp24; /* small fill graphic tmp,cleared,remapped, for 24 bpp   */
BITMAP  *bmpfree;   /* pointer to SOURCE rect bitmap block   */
}EXA_FILL;          /****************************************/

// for mapping user colors into the global color map
typedef struct {
int     index1;             // palette index. range 0 to 255 or -1 for bestfit
int     index2;             // palette index. returned "bestfit" index.
int     r, g, b;            // color values
int     flag_bestfit;       // 0 = nothing, -1 = bestfit is activated
}COLORMAPPING;



// for mapping user colors into the global color map
typedef struct {
int     index;              // palette index. range 0 to 255 or -1 for bestfit
int     r, g, b;            // color values
int     flag_bestfit;       // 0 = nothing, -1 = bestfit is activated
}COLORMAPPING_TWO;



// (currently unused)
// structure for loading current configuration settings
// different for each screen resolution
// global accesible by all modules
typedef struct {          // for each resolution
int     sx;               // screen size x
int     sy;               // screen size y
int     button_sx;        // buttonarray size x
int     button_sy;        // buttonarray size y
int     button_space_xy;  // space between buttonarray buttons
int     tool_button_sx;   // toolbar button size x
int     tool_button_sy;   //
int     palette_esx;      // palette element size x
int     palette_esy;      //
int     slider_size;      // width of sliders
int     toggle_space_x;   // space x between toggle buttons
// callbacks to perform screen drawing
void (* blank_screen)(void);
void (* redraw_all_objects)(void);
void (* redraw_blocks)(void);
void (* redraw_tool)(void);
void (* redraw_buttonarray)(void);
void (* redraw_info)(void);
void (* redraw_palette)(void);
void (* redraw_main_draw)(void);
void (* undraw_all_objects)(void);
void (* undraw_blocks)(void);
void (* undraw_tool)(void);
void (* undraw_buttonarray)(void);
void (* undraw_info)(void);
void (* undraw_palette)(void);
void (* undraw_main_draw)(void);
} DEFINE_CURRENT_SCREEN;







typedef struct {
int       vga_type;         // 0 to 7
int       bpp;              // Current bitdepth in use, 8,15,16,24,32
int       buttoncolor;      // button color foreground (one of syscolor)

BITMAP   *screen_state_buffer;  // size of md_sx, md_sy used for copying of 2,3,multi-state screen copies
BITMAP   *fillmap1;         // used for fill, 8x8, background
BITMAP   *fillmap2;         // used for fill, 8x8, toolbar background
BITMAP   *fillmap3;         // used for fill, 8x8, edit boxes
BITMAP   *bitmap_buttons;   // all buttons bitmap 30x30, original
BITMAP   *bitmap_buttons_remap;   // all buttons bitmap 30x30, remapped
BITMAP   *mouse_pointer;    // mouse pointer,     23x23
BITMAP   *clipboard;        // clipboard bitmap
BITMAP   *win_clipboard;    // windows clipboard bitmap
BITMAP   *dxe_bitmap;       // temporary bitmap used by dxe/dll code
BITMAP   *layer0;           // unzoomed bitmap, size: g.sx, g.sy

BITMAP  *bmp0;              // used by the animate flag
BITMAP  *bmp1;              // used by the animate flag
BITMAP  *bmp2;              // used by the animate flag
BITMAP  *bmp3;              // used by the animate flag
BITMAP  *bmp4;              // used by the animate flag
PALETTE animate;            // used by the animate flag, sets of 32 colors * 5
PALETTE animate_tmp;        // for storing g.palette

PALETTE   palette;          // global palette
PALETTE   palette_remap;    // extra trash palette
PALETTE   palette_popup;    // for popup windows and other windows (new,unused by now)
int       screen_w;         // main screen width
int       screen_h;         // main screen heigth
int       zoom;             // amount of zoom to apply
int       sx,sy;            // size x,y of sprite block
int       ox,oy;            // slider, zoom, pixel offset
int       draw_method;      // current drawing method, 0=putpixel, 1=fill, 2=...
int       block_current;    //
int       block_count;      // number of sprite blocks

char     *path_init;        // initial program startup directory
char     *path_configfile;  // Full path + configfilename
char     *configfilename;   // filename of config file alone

char     *project_name;     // project name string, allocated
char     *graphic_name;     // graphic file name string, allocated
EXA_BRUSH  brush;           //
EXA_BKMAP  bkmap;           //
int       paletterange_start;// palette index, of start position
int       paletterange_end;  // palette index, of end position
int       flag_palette_range; //if activating palette range feature.
int       flag_animate;     // animate action, draw bkgr's, using 32 colors for each bkgr.
int       flag_cad;         // use "cad" look to draw lines and objects
int       flag_all;         // drawing operation affects all blocks
int       flag_src;         // apply graphic methods on source block
int       flag_dst;         // apply graphic methods on destination block
int       flag_pixelgrid;   // use pixel grid (grid for each pixel)
int       flag_grid;        // larger grid
int       flag_fill;        // use fill on drawing operations
int       flag_brush;       // use brush bitmap for drawing operations
int       flag_bkmap;       // backgroundmap is active
int       flag_verbose;     // if textual output is allowed.
int       flag_alternate;   // alternative slide bar positions (saved and loaded in the global section of the configfile)
int       flag_dialog_init; // TRUE if  main_dialog is active
int       flag_multi_archives;  // if loading multiple archives
int       flag_multi_positive;  // if the count is positive or negative
int       flag_fullscreen;  // FALSE = windowed, TRUE=fullscreen
int       hs;               // handle size in pixels, default 12
int       grid_sx;          // grid size x in pixels
int       grid_sy;          // grid size y in pixels
int       animate_type;     // type, 0=play forward, 1=play reverse, 2=play ping-pong
int       animate_delay;    // delay in milliseconds per frame
// almost everything below is unused




//............extras for color management
int  usercolor1,usercolor2,usercolor3;  // color indexes to use, user color, selectable with mouse
int  syscolor1, syscolor2, syscolor3 ;  // color indexes to use, system color (current)
int  osyscolor1,osyscolor2,osyscolor3;  // color indexes to use, old system color (used for remapping of colors)
RGB  fixed_rgb[3];                      // fixed colors (copied from config file, then copied into main palette at a selected index if flag is TRUE )
RGB  adapt_rgb[3];                      // adapted colors (copied from main palette on bestfit)
RGB  store_rgb[3];                      // stored colors from palette
int  flag_rgb[3];                       // TRUE/FALSE; TRUE = fixed color, FALSE = adapted color

// new for colormapping
COLORMAPPING    usrcol1;    // user color   indexes are unused in 24 bpp
COLORMAPPING    usrcol2;
COLORMAPPING    usrcol3;
COLORMAPPING    syscol1;    // system color
COLORMAPPING    syscol2;
COLORMAPPING    syscol3;
// new for colormapping



/*
//
COLORMAPPING_TWO    syscolor1;
COLORMAPPING_TWO    syscolor2;
COLORMAPPING_TWO    syscolor3;
//
*/





char    *buttonfile;    // allocated in ram
char    *mousefile;     // allocated in ram
char    *fillfile;      // allocated in ram

} GLOBAL_DATA;


#define MOUS_POINTER   0
#define MOUS_HOURWATCH 1
#define MOUS_CROSS1    2
#define MOUS_CROSS2    3



#endif
