
/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\

GBM.C  General Bitmap Code

tga support is weak


*/

/*...sincludes:0:*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <dir.h>        // FA_ARCH
#include <unistd.h>        // FA_ARCH
#include <allegro.h>
#include "dllgbm/gbminit.h"
#include "butil.h"
#include "dll2.h"

#include "gbminit.h"

/*...vgbm\46\h:0:*/
/*...e*/


/*

DXE_EXPORT_TABLE (export_code_symbols2)
    // dxegbm.h
      DXE_EXPORT (u_create_ahead    )
      DXE_EXPORT (u_destroy_ahead   )
      DXE_EXPORT (u_next            )
      DXE_EXPORT (u_open            )
      DXE_EXPORT (u_read            )
      DXE_EXPORT (u_write           )
      DXE_EXPORT (u_lseek           )
      DXE_EXPORT (u_close           )
      DXE_EXPORT (u_malloc          )
      DXE_EXPORT (u_free            )
      DXE_EXPORT (u_same            )
      DXE_EXPORT (u_find_word       )
      DXE_EXPORT (u_find_word_prefix)
DXE_EXPORT_END



   DXE_EXPORT_TABLE (export_h_symbols2)
     //math.h
//      DXE_EXPORT (ceil)
//      DXE_EXPORT (pow)
//    // conio.h
//      DXE_EXPORT (getch)
    // string.h
      DXE_EXPORT (strrchr)
      DXE_EXPORT (strcat)
      DXE_EXPORT (strncat)
      DXE_EXPORT (strcpy)
      DXE_EXPORT (strncpy)
      DXE_EXPORT (memset)
      DXE_EXPORT (memcpy)
    // ctype.h
      DXE_EXPORT (isalnum )
      DXE_EXPORT (isalpha )
      DXE_EXPORT (iscntrl )
      DXE_EXPORT (isdigit )
      DXE_EXPORT (isgraph )
      DXE_EXPORT (islower )
      DXE_EXPORT (isprint )
      DXE_EXPORT (ispunct )
      DXE_EXPORT (isspace )
      DXE_EXPORT (isupper )
      DXE_EXPORT (isxdigit)
      DXE_EXPORT (tolower )
      DXE_EXPORT (toupper )
      DXE_EXPORT (__dj_ctype_flags)

    // stdio.h
      DXE_EXPORT (exit)
      DXE_EXPORT (fopen)
      DXE_EXPORT (printf)
      DXE_EXPORT (fprintf)
      DXE_EXPORT (sprintf)
      DXE_EXPORT (fread)
      DXE_EXPORT (fwrite)
      DXE_EXPORT (fclose)
      DXE_EXPORT (fgets)
      DXE_EXPORT (puts)
      DXE_EXPORT (putchar)
      DXE_EXPORT (gets)
      DXE_EXPORT (sscanf)
    // stdlib.h
      DXE_EXPORT (realloc)
      DXE_EXPORT (malloc)
      DXE_EXPORT (errno)
      DXE_EXPORT (free)
    // allegro.h
      DXE_EXPORT (create_bitmap)
      DXE_EXPORT (create_bitmap_ex)
      DXE_EXPORT (destroy_bitmap)
      DXE_EXPORT (drawing_mode)
      DXE_EXPORT (gui_mouse_b)
      DXE_EXPORT (gui_mouse_x)
      DXE_EXPORT (gui_mouse_y)
      DXE_EXPORT (gui_mg_color)
      DXE_EXPORT (mouse_x)
      DXE_EXPORT (mouse_y)
      DXE_EXPORT (mouse_b)
      DXE_EXPORT (scare_mouse)
      DXE_EXPORT (unscare_mouse)
      DXE_EXPORT (font)
      DXE_EXPORT (screen)
      DXE_EXPORT (rect)
      DXE_EXPORT (rectfill)
      DXE_EXPORT (blit)
      DXE_EXPORT (circle)
      DXE_EXPORT (do_line)
      DXE_EXPORT (do_arc)
      DXE_EXPORT (drawing_mode)
      DXE_EXPORT (textout_centre)
      DXE_EXPORT (text_height)
      DXE_EXPORT (text_mode)
      DXE_EXPORT (textout)
      DXE_EXPORT (text_length)
      DXE_EXPORT (broadcast_dialog_message)
      DXE_EXPORT (getpixel)
      DXE_EXPORT (putpixel)
      DXE_EXPORT (set_palette)
      DXE_EXPORT (set_pallete)
      DXE_EXPORT (get_palette)
      DXE_EXPORT (clear_to_color)
      DXE_EXPORT (hline)
      DXE_EXPORT (vline)
      DXE_EXPORT (line)
      DXE_EXPORT (getr)
      DXE_EXPORT (getg)
      DXE_EXPORT (getb)
      DXE_EXPORT (makecol)
      DXE_EXPORT (clear)
  DXE_EXPORT_END

*/







typedef struct
    {
    GBM_ERR (*query_filetype)(GBMFT *gbmft);
    GBM_ERR (*read_header )(char *fn, int fd, GBM *gbm, char *opt);
    GBM_ERR (*read_palette)(int fd, GBM *gbm, GBMRGB *gbmrgb);
    GBM_ERR (*read_data   )(int fd, GBM *gbm, byte *data);
    GBM_ERR (*write       )(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt);
    char *  (*err         )(GBM_ERR rc);
    } FT;

/*
static FT fts[] =
       {
       {pcx_qft, pcx_rhdr, pcx_rpal, pcx_rdata, pcx_w, pcx_err},
       {xbm_qft, xbm_rhdr, xbm_rpal, xbm_rdata, xbm_w, xbm_err},
       {pbm_qft, pbm_rhdr, pbm_rpal, pbm_rdata, pbm_w, pbm_err},
       {pgm_qft, pgm_rhdr, pgm_rpal, pgm_rdata, pgm_w, pgm_err},
       {ppm_qft, ppm_rhdr, ppm_rpal, ppm_rdata, ppm_w, ppm_err},
       {gif_qft, gif_rhdr, gif_rpal, gif_rdata, gif_w, gif_err},
       {cel_qft, cel_rhdr, cel_rpal, cel_rdata, cel_w, cel_err},
       {lbm_qft, lbm_rhdr, lbm_rpal, lbm_rdata, lbm_w, lbm_err},
       {tga_qft, tga_rhdr, tga_rpal, tga_rdata, tga_w, tga_err},
       {bmp_qft, bmp_rhdr, bmp_rpal, bmp_rdata, bmp_w, bmp_err}
       };

*/
/* room for 20 graphic formats */
static FT fts[] =
       {
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   },
       {NULL,    NULL,     NULL,     NULL,      NULL,  NULL   }
       };



GBM_ERR(* dllgbm_query_filetype)(GBMFT *)                     = NULL;
GBM_ERR(* dllgbm_read_header   )(char *, int, GBM *, char *)  = NULL;
GBM_ERR(* dllgbm_read_palette  )(int, GBM *, GBMRGB *)        = NULL;
GBM_ERR(* dllgbm_read_data     )(int, GBM *, byte *)          = NULL;
GBM_ERR(* dllgbm_write         )(char *, int, GBM *, GBMRGB *, byte *, char *) = NULL;
char  *(* dllgbm_err           )(GBM_ERR)                     = NULL;
void   (* dllgbm_init)( void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void * ) = NULL;




#define N_FT    ( sizeof(fts) / sizeof(fts[0]) )
/*...e*/

/*...sextension:0:*/
static char *extension(char *fn)
	{
    char    *dot=NULL, *slash=NULL;

	if ( (dot = strrchr(fn, '.')) == NULL )
		return ( NULL );

    if ( (slash = strpbrk(fn, "/\\")) == NULL )
        return ( dot + 1 );

	return ( ( slash < dot ) ? dot + 1 : NULL );
	}
/*...e*/
/*...ssame:0:*/










/*...sgbm_init:0:*/






static void *errhandler (const char *input)
{
    printf("* unresolved symbol: '%s'\n", input );
    return NULL;
}
struct al_ffblk info;
static char this_is_firstnext=0;
static void prep_findfirstnext()
{
    this_is_firstnext=0;
}
static int do_findfirstnext( byte *mask )
{
    int i;

    if( this_is_firstnext==0 ){
    this_is_firstnext=1;
    i = al_findfirst( mask, (struct al_ffblk *)&info, FA_ARCH );  // return?: 0=ok, else non-zero
    return i;
    }
    if( this_is_firstnext==1 ){
    i = al_findnext( (struct al_ffblk *)&info );
    return i;
    }
    return -1;
}
static void do_findclose()
{
    al_findclose( (struct al_ffblk *)&info );
}































GBM_ERR gbm_init(void)
	{
    int         i,j;
    //...
    GBMFT       gbmft;
    char        *errstr  = NULL;
    char    *dxefilenames[256]; //storage filenames
    //...
    char        *strfile = NULL;
    char        *strdxedir=NULL;
    char        *strmask  =NULL;
    //...
    int     number_of_dxe=0;
    //...

//msgbox_("000");

    // ************* load all dxe filenames *************
    strfile     = alloc_string( NULL, FILENAME_MAX + 22 );
    strdxedir   = "dllgbm/";       //    strdxedir   = "dxe/";
    strmask     = "*.dll";
    strncpy( strfile, strdxedir, FILENAME_MAX );
    strncat( strfile, strmask,   FILENAME_MAX );//    printf("dxe dir mask: '%s'\n", strfile );
    prep_findfirstnext();
    for(i=0;i<255;i++) dxefilenames[i] = NULL;
    j=0;


    for(;;){
    i = do_findfirstnext( strfile );
        if( i != 0 ) break;
            strncpy( strfile, strdxedir,    FILENAME_MAX );
            strncat( strfile, info.name,    FILENAME_MAX );//  printf("file: <%s>  <%s>\n",info.ff_name ,strfile );
            dxefilenames[j] = alloc_string( strfile, -1 );
//msgbox_("FILE: <%s> i=%d j=%d",dxefilenames[j], i, j);
        j++;
        if( j > 255 ) break;
    }

    do_findclose();


    free_string( strfile );
    dxefilenames[j] = NULL;         // last filename
    number_of_dxe = j;
    if(j==0) return ( GBM_ERR_OK );

    // ************* load all dxe filenames *************

//    if( handle > 0 ) _findclose(handle);


    // ****************************************************************
    // Now try to load the modules and resolve all unresolved symbols
    for(i=0,j=0;i<N_FT;i++){
    if( dxefilenames[ i ]==NULL) break;


// -------------------------------------
//    synchronize with dll.c
    if( dll_load2( dxefilenames[i] ) == 1 ){    // error ocurred
        printf("file: %s  *ERROR*  errstring: %s\n",dxefilenames[i], errstr);
//msgbox_("!!!<ERROR> <%s> !!!",dxefilenames[i]);
    }else{

//msgbox_("   INIT    <%s> !!!",dxefilenames[i]);
        dllgbm_init(
            &u_create_ahead,
            &u_destroy_ahead,
            &u_next,
            &u_open,
            &u_read,
            &u_write,
            &u_lseek,
            &u_close,
            &u_malloc,
            &u_free,
            &u_same,
            &u_find_word,
            &u_find_word_prefix );

        fts[j].query_filetype =  dllgbm_query_filetype;
        fts[j].read_header    =  dllgbm_read_header;
        fts[j].read_palette   =  dllgbm_read_palette;
        fts[j].read_data      =  dllgbm_read_data;
        fts[j].write          =  dllgbm_write;
        fts[j].err            =  dllgbm_err;
        if( fts[j].query_filetype != NULL ){
            fts[j].query_filetype( &gbmft );
//            printf("file: %s  ext: %s\n", dxefilenames[i], gbmft.extensions );
        }
        j++;
    }
// -------------------------------------






    }
    // ****************************************************************










    return ( GBM_ERR_OK );
	}
/*...e*/
/*...sgbm_deinit:0:*/
GBM_ERR gbm_deinit(void)
	{
	return ( GBM_ERR_OK );
	}
/*...e*/
/*...sgbm_query_n_filetypes:0:*/
GBM_ERR gbm_query_n_filetypes(int *n_ft)
	{
	*n_ft = N_FT;
	return ( GBM_ERR_OK );
	}
/*...e*/
/*...sgbm_guess_filetype:0:*/
GBM_ERR gbm_guess_filetype( char *fn, int *ft )
	{
	int	i;
    char    *ext = extension( fn );

    if ( ext == NULL ) ext = "";

	for ( i = 0; i < N_FT; i++ )
		{
		GBMFT	gbmft;
		char	buf [100+1], *s;

        if( fts[i].query_filetype == NULL )     return ( GBM_ERR_NOT_FOUND );
        fts[i].query_filetype( &gbmft );
		for ( s  = strtok(strcpy(buf, gbmft.extensions), " \t,");
		      s != NULL;
		      s  = strtok(NULL, " \t,") )

            if ( u_same(s, ext, strlen(ext) + 1) )
				{
				*ft = i;
                return ( GBM_ERR_OK );
				}
		}
	return ( GBM_ERR_NOT_FOUND );
	}
/*...e*/







/*...sgbm_guess_filetype:0:*/
void gbm_return_fileextensions( void (* callback)(char *) )
	{
	int	i;

    for ( i = 0; i < N_FT; i++ )
		{
		GBMFT	gbmft;
		char	buf [100+1], *s;

        if( fts[i].query_filetype == NULL )     return ;    //    return ( GBM_ERR_NOT_FOUND );
        fts[i].query_filetype( &gbmft );
		for ( s  = strtok(strcpy(buf, gbmft.extensions), " \t,");
		      s != NULL;
		      s  = strtok(NULL, " \t,") )
            (callback)( s );
		}
    return;
	}
/*...e*/




















/*...sgbm_query_filetype:0:*/
GBM_ERR gbm_query_filetype(int ft, GBMFT *gbmft)
	{
    if( fts[ft].query_filetype == NULL)         return ( GBM_ERR_ARRAY );
    return ( (*fts[ft].query_filetype)(gbmft) );
	}
/*...e*/
/*...sgbm_read_header:0:*/
GBM_ERR gbm_read_header(char *fn, int fd, int ft, GBM *gbm, char *opt)
	{
    if( fts[ft].read_header == NULL )           return ( GBM_ERR_ARRAY );
    return ( (*fts[ft].read_header)(fn, fd, gbm, opt) );
	}
/*...e*/
/*...sgbm_read_palette:0:*/
GBM_ERR gbm_read_palette(int fd, int ft, GBM *gbm, GBMRGB *gbmrgb)
	{
    if( fts[ft].read_palette == NULL )          return ( GBM_ERR_ARRAY );
    return ( (*fts[ft].read_palette )(fd, gbm, gbmrgb) );
	}
/*...e*/
/*...sgbm_read_data:0:*/
GBM_ERR gbm_read_data(int fd, int ft, GBM *gbm, byte *data)
	{
    if( fts[ft].read_data == NULL )             return ( GBM_ERR_ARRAY );
    return ( (*fts[ft].read_data)(fd, gbm, data) );
	}
/*...e*/
/*...sgbm_write:0:*/
GBM_ERR gbm_write(char *fn, int fd, int ft, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
	{
    if( fts[ft].write == NULL )                 return ( GBM_ERR_ARRAY );
    return ( (*fts[ft].write)(fn, fd, gbm, gbmrgb, data, opt) );
	}
/*...e*/
/*...sgbm_err:0:*/
char *gbm_err(GBM_ERR rc)
	{
	int ft;
    switch ( (int) rc )
		{
		case GBM_ERR_OK:
			return ( "ok" );
		case GBM_ERR_MEM:
			return ( "out of memory" );
		case GBM_ERR_NOT_SUPP:
			return ( "not supported" );
		case GBM_ERR_BAD_OPTION:
			return ( "bad option(s)" );
		case GBM_ERR_NOT_FOUND:
			return ( "not found" );
		case GBM_ERR_BAD_MAGIC:
            return ( "bad magic number / signature block" );
		case GBM_ERR_BAD_SIZE:
			return ( "bad bitmap size" );
		case GBM_ERR_READ:
			return ( "can't read file" );
		case GBM_ERR_WRITE:
			return ( "can't write file" );
        case GBM_ERR_ARRAY:
            return ( "out of array memory" );
        }
    for ( ft = 0; ft < N_FT; ft++ )
		{
		char *s;

        if ( fts[ft].err == NULL )
            return ( "out of array error" );
        if ( (s = (*fts[ft].err)(rc)) != NULL )
			return ( s );
		}
    return ( "general error" );
	}
/*...e*/





/***************** global accessible stuffs ******************/


/*...sreading ahead:0:*/
AHEAD *u_create_ahead(int fd)
	{
    AHEAD *ahead;
    if ( (ahead = malloc(sizeof(AHEAD))) == NULL ) return ( NULL );
    ahead->inx = AHEAD_BUF;
    ahead->fd  = fd;
    if ( (ahead->buf = (byte *) malloc( AHEAD_BUF )) == NULL ){ u_free(ahead); return ( NULL );}
    return ( ahead );
	}
void u_destroy_ahead(AHEAD *ahead)
	{
    if(ahead->buf!=NULL) u_free(ahead->buf);
    u_free(ahead);
    }
byte u_next(AHEAD *ahead)
	{
    if ( ahead->inx == AHEAD_BUF ) {
        u_read( ahead->fd , (byte *) ahead->buf, AHEAD_BUF);
        ahead->inx = 0;
		}
    return ( ahead->buf [ ahead->inx++] );
    }
/*...e*/






/************ wrappers for unistd.h, fcntl.h ************/

static FILE *filearray[50]={
    NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
    NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
    NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
    NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
    NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL
    };  /* 50 pointers */
static char uopenautoinit=0;

/* returns -1 on failure */
int u_open(char *filename, char *type)
{
    int i;
    FILE *fp;
    if(uopenautoinit==0){ uopenautoinit=1; for(i=0;i<49;i++) filearray[i]=NULL; }


    for(i=1;i<49;i++){
    if(filearray[i]==NULL){
        filearray[i] = fp = fopen(filename, type);  if(fp==NULL) return -1;
//        setvbuf( fp, NULL, _IOFBF, 65536 );   /* full buffer, QUICK writes */
        return i;
        }
    }
    return -1;
}
/* wrapper version of unix's read(...) */
/* returns -1 on failure */
int u_read(int fd, void *_ptr, int size)
{
    FILE *fp;
    unsigned char *ptr;
    int i;

    ptr = (unsigned char *) _ptr;
    fp = filearray[ fd ];
    if(size==0) return 0;
    i = fread( ptr,size,1,fp );
    if(i==0) return -1;
    return size;
}
/* wrapper version of unix's write(...) */
/* returns -1 on failure */
int u_write(int fd, void *_ptr, int size)
{
    FILE *fp;
    unsigned char *ptr=_ptr;
    int i;

    fp = filearray[fd];
    if(size==0) return 0;
    i = fwrite(ptr,size,1,fp);
    if(i==0) return -1;
    return size;
}
int u_lseek(int fd, long offset, int origin)
{
    FILE *fp;
    int i=0;

    fp = filearray[fd]; if( fp==NULL ) return 0;

    if( origin == SEEK_CUR && offset == 0L ) return ftell(fp);

    fflush(fp);
    i = fseek( fp, offset, origin );
//    fflush(fp);
//    i = ftell(fp);
    return i;
}
void u_close(int fd)
{
    FILE *fp;

    fp = filearray[fd];
    fflush(fp);
    fclose(fp);
    filearray[fd] = NULL;
}

/* wrapper for malloc() */
void *u_malloc(int size)
{
    return (void *) malloc(size+3);
}
/* wrapper for free() */
void u_free(void *ptr)
{
    if(ptr!=NULL) free(ptr);
}




/*...ssame:0:*/
BOOLEAN u_same(char *s1, char *s2, int n)
	{
	for ( ; n--; s1++, s2++ )
		if ( tolower(*s1) != tolower(*s2) )
			return ( FALSE );
	return ( TRUE );
	}
/*...e*/
/*...sfind_word_prefix:0:*/
/*...find_word:0:*/
char *u_find_word(char *str, char *substr)
	{
	char	buf [100+1], *s;
	int	len = strlen(substr);

	for ( s  = strtok(strcpy(buf, str), " \t,");
	      s != NULL;
	      s  = strtok(NULL, " \t,") )
        if ( u_same(s, substr, len) && s [len] == '\0' )
			return ( str + (s - buf) );
	return ( NULL );
	}
/*...e*/
char *u_find_word_prefix(char *str, char *substr)
	{
	char	buf [100+1], *s;
	int	len = strlen(substr);

	for ( s  = strtok(strcpy(buf, str), " \t,");
	      s != NULL;
	      s  = strtok(NULL, " \t,") )
        if ( u_same(s, substr, len) )
			return ( str + (s - buf) );
	return ( NULL );
	}
/*...e*/
/*...smapping:0:*/








