#ifndef __EXTRADLGOBJ_H_
#define __EXTRADLGOBJ_H_

// extra dialogs, "ed.c/h"

int ed_win(           int, DIALOG *, int);
int ed_check(         int, DIALOG *, int);
int ed_framecheck(    int, DIALOG *, int);
int ed_rotatebox(     int, DIALOG *, int);
int ed_rotatebox2(    int ,DIALOG *, int);
int ed_slider(        int, DIALOG *, int);
int ed_frame(         int, DIALOG *, int);
int ed_set(           int, DIALOG *, int);
int ed_button(        int, DIALOG *, int);
int ed_label(         int, DIALOG *, int);
int ed_button_exit(   int, DIALOG *, int);
int ed_button_graphic(int, DIALOG *, int);



// **************************************************
// **************************************************
// **************************************************
// **************************************************
// **************************************************
// **************************************************

typedef struct ED_BUTTONARRLNK
{
    int dialog;             // 1= invoke dialog, 0=no
    int mouse_shape_index;  // number of mouse shape, should be 0 for non-sticky
    int stickyflag;         // 1-sticky, 0-nonsticky
    char *main_description;         // normal
    char *tooltips_description;     // short
    BITMAP *shape;                  // normal button shape
    BITMAP *shape_clicked;          // clicked button shape
    void (*button_function)(char,int); // called when button is pressed, argument 1: mouse button number, 2: index of buttonarray object
} ED_BUTTONARRLNK;

typedef struct ED_BUTTONARRAY_WINDOW
{
int linewidth;                // in pixels
int amount_x, amount_y;       // how many buttons in x,y
int array_sx, array_sy;       // total size of whole array windows, including header
int button_sx, button_sy;       // button size (pixels)
int buttonspace_sx, buttonspace_sy; // space between buttons  (pixels)
int header_height;              // default is 12 pixels
int buttons_x, buttons_y;       // how many buttons
unsigned char *caption;         // NULL means "no caption"
char flag_display_header;       // off=0, on=1
char flag_use_fill;             // off=0, on=1
char flag_moveable;             // if window is moveable       off=0, on=1
char flag_shrinkable;           // if window is shrinkeable    off=0, on=1
char flag_display_tooltips;     // off=0, on=1
char flag_visible_state;       // 0=object is visible, 1=object is hidden
char header_position;           // 0=top, 1=bottom, 2=left, 3=right
int (*foreach_button_before)(char,int); // for each call to buttonfunction: called when button is pressed, argument 1: mouse button number, 2: index of buttonarray object
                                         // this function is called before ANY single button function is called
                                         // it is a callback for ALL buttons.
                                         // if returned value is not 0 then the regular button procedure will not happen
ED_BUTTONARRLNK *button_structures;    // array to structures for each button
void (*foreach_button_after)(char,int);  // called after the button has been called
                                         // almost the same as foreach_button_before(...)
                                         // with exception that it don't expect the user to return a value
void (*show_description)(int index, unsigned char *str);  //called function when it's time to display description
int (*proc)(int, DIALOG *, int); // dialog procedure for this buttonarray
int handle;               // handle for this buttonarray object
int linecolor;                // color for line
int fillcolor;                // color for fill (between buttons)
int fgcolor;                  // foreground color in header
int bkcolor;                  // background color in header
int filltype;                 // 0=no fill (solid), pattern 1 to 9
BITMAP *foreground;           // used to store foreground bitmap
BITMAP *background;           // used to store background
BITMAP *bmplx;                // used to store background for drawing up to 5 lines
BITMAP *bmply;                // used to store background for drawing up to 5 lines
DIALOG *dlg;                  // which dialog this buttonarray is connected to
} ED_BUTTONARRAY_WINDOW;

// up to 1024 buttonarrays
#define HARDWIRED_LIMIT_BTNARRS 1024
// data
char all_buttonarray_alloc[ HARDWIRED_LIMIT_BTNARRS+1 ];  // set to 1 if allocated, else 0
ED_BUTTONARRAY_WINDOW *all_buttonarray_structs[ HARDWIRED_LIMIT_BTNARRS+1 ];  //pointer to structure

ED_BUTTONARRAY_WINDOW *allocate_buttonarray(DIALOG *dlg, int x, int y, int sx, int sy, int spcx, int spcy, int amx, int amy, ED_BUTTONARRLNK *buttons, int linecolor,int fillcolor,int fgcolor,int bkcolor, int linewidth, char header_height, char header_position, char filltype,char flag_moveable ,unsigned char *caption);
void ed_free_buttonarray( ED_BUTTONARRAY_WINDOW *mywin );
void ed_hide_buttonarray( int handle );
void ed_show_buttonarray( int handle );
void ed_rerender_buttonarray( int handle,int linecolor,int fillcolor,int fgcolor,int bkcolor );
int ed_buttonarray_proc (int,DIALOG *, int);
int  render_buttonarray_graphic(ED_BUTTONARRAY_WINDOW * );
int  check_mouse_inside_header( ED_BUTTONARRAY_WINDOW *, int x,  int y, int mx, int my, int *button_index, int *rx1, int *ry1 );
void get_buttonarray_line_bk(   ED_BUTTONARRAY_WINDOW *, int cx, int cy );
void put_buttonarray_line_bk(   ED_BUTTONARRAY_WINDOW *, int cx, int cy );
void draw_buttonarray_lines(    ED_BUTTONARRAY_WINDOW *, int cx, int cy );

// **************************************************
// **************************************************
// **************************************************
// **************************************************
// **************************************************
// **************************************************

#endif
