/*
 *   Improved dialog objects
 *  ed = Extra Dialog objects
 *
 */

#define ED_VERSION 1.0
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <allegro.h>
#include "ed.h"

/* checkbutton pixelsize */
#define CHK 12



//...
static BITMAP *edcreate_fill_map( int, int, int );
static void eddestroy_fill_map( BITMAP * );
static void edreflip_90(    BITMAP *, BITMAP * );
static void edreflip_x(     BITMAP * );
static void edrect_dot(     BITMAP *, int, int, int, int, int );
static void edxchg_bitmap_rect( BITMAP *bmp, int, int, int, int, int, int );







/*
 *  If dp2 is not NULL then the user's bitmap will be used instead.This
 *  bitmap must be width+1 and height+1 of window in size.
 *  dp2 is automatically freed when this code exits.
 *.............................
 *  This must be the very first dialog on the dialog structure.
 *  Implements a moveable window.
 *
 *  If d1 field is not zero then filled background is drawn
 *  d1 ranges 1 to 8 for a fill pattern.
 *  If d1 field is zero then no fill is done (clear).
 *
 *
 *  If d2 field is 1 then window is moveable.
 *  If d2 field is 2 then window has a close button.
 *  If d2 field is 3 then window is both moveable and has a close button.
 *
 *
 *  dp contains the caption, string pointer.
 *  If dp is NULL then a single space is written.
 *  dp2 contains BITMAP pointer to background graphics.
 *  dp2 is automatically allocated/freed by the code.
 *  users should not use dp2.
 *  dp3 is free for use.
 *  Limit: 250 objects on window, maximum.
 */
int ed_win( int msg, DIALOG *d, int c )
{
    DIALOG  *extra;
    int     deltax, deltay; /* delta amount to add to coordinates */
    BITMAP  *bmpx, *bmpy;   /* tmp storage for lines */
    char    moved=0, finish;
    int     dx, dy;         /* delta x, y for mouse */
    int     *flags;         /* pointer to flags */
    int     flaggranul=250; /* 250 flags granularity  */
    int     flagtot=0;      /* total number of flags */
    BITMAP  *fillmap1;
    int     x,y,w,h,i,j,sx,sy,ox,oy,mx,my;
    int     x1,y1,x2,y2;

    if(msg==MSG_IDLE) return D_O_K;

    switch( msg ){

    case MSG_CLICK:
    mx = mouse_x;
    my = mouse_y;


    // *************************************** quit button
    x1= d->x + d->w - CHK * 2;
    y1= d->y +4;
    x2= d->x + d->w - CHK * 1;
    y2= d->y +CHK+2;
    if( mx > x1 && mx < x2 && my > y1 && my < y2 && (d->d2&2)==2 ){   //inside quad rectangle
        acquire_screen();
        scare_mouse();
        rectfill( screen, x1,y1,x2,y2, d->fg );
        rectfill( screen, x1 + 3, y1 + 3,x2 - 3, y2 - 3 , d->bg );
        unscare_mouse();
        release_screen();
        do i=mouse_b; while( (i&7) != 0 );
        acquire_screen();
        scare_mouse();
        rectfill( screen, x1,y1,x2,y2, d->bg );
        unscare_mouse();
        release_screen();
        return D_CLOSE;
    }
    // ***************************************


    if( mx > (d->x+1) && mx < (d->x+d->w-1) &&\
        my > (d->y+1) && my < (d->y+18) && d->dp2!=NULL && (d->d2&1)==1 ){






    /* inside clickable rectangle */
    x = ox = d->x;
    y = oy = d->y;
    sx = d->w;
    sy = d->h;
    dx = mouse_x-x;
    dy = mouse_y-y;
    flagtot = flaggranul;

    bmpx = create_bitmap(sx+1,3);
    bmpy = create_bitmap(3,sy+1);
    flags = (int *) malloc( (flagtot+999) * sizeof(int) );

    if( bmpx==NULL || bmpy==NULL || flags==NULL )  return D_O_K;

    extra = d;

    for(i=0;i<999;i++)
    {
    if( extra->proc == 0 || extra->proc == NULL ) break;
    flags[i] = extra->flags;                /* store flags */
    extra->flags = D_HIDDEN | D_DISABLED;   /* disable and hide */
    flagtot++;
    if( flagtot>flaggranul ){
        flagtot=0;
        flags = (int *) realloc( flags, i+flaggranul );
        if( flags==NULL) return D_O_K;
        }
    extra++;
    }
    broadcast_dialog_message( MSG_DRAW, 0 );  /* hide and disable */
    moved = 0;  finish=FALSE;
    for(;;){
    scare_mouse();
    acquire_screen();
    blit( screen, bmpx, x+1, y,      0,0,   sx-1  ,1 );
    blit( screen, bmpx, x+1, y+18,   0,1,   sx-1  ,1 );
    blit( screen, bmpx, x+1, (y+sy), 0,2,   sx-1  ,1 );
    blit( screen, bmpy, x, y,      0,0,   1,sy+1 );
    blit( screen, bmpy, (x+sx), y, 1,0,   1,sy+1 );
    rect(screen, x,y,x+sx,y+sy, d->fg );
    hline(screen,x+1,y+18,x+sx-1,d->fg);
    release_screen();
    unscare_mouse();
    ox = mouse_x;    oy = mouse_y;
        for(;;){
        if( (mouse_x-ox)!=0 || (mouse_y-oy)!=0 ){ moved=1; break;}
        j=mouse_b;
        if( (j&7)==0 ){ finish=TRUE; break; }
        }
    if( moved==1 || finish==TRUE ){    moved=0;
        scare_mouse();
        acquire_screen();
        blit( bmpx,screen, 0,0, x+1, y,      sx-1,1 );
        blit( bmpx,screen, 0,1, x+1, y+18,   sx-1,1 );
        blit( bmpx,screen, 0,2, x+1, (y+sy), sx-1,1 );
        blit( bmpy,screen, 0,0, x, y,        1,sy+1 );
        blit( bmpy,screen, 1,0,(x+sx), y,    1,sy+1 );
        release_screen();
        unscare_mouse();
        if(finish==TRUE) break; /* exit */
    }
    x = mouse_x-dx;  if(x<0)x=0;
    y = mouse_y-dy;  if(y<0)y=0;
    }
    destroy_bitmap( bmpx );
    destroy_bitmap( bmpy );
    deltax = x-d->x;
    deltay = y-d->y;
    ox=d->x; oy=d->y;
    extra = d;
    for(i=0;i<999;i++)          /* move to new position, adding the new deltas */
    {
    if( extra->proc == 0 || extra->proc == NULL ) break;
    extra->x += deltax;
    extra->y += deltay;
    extra->flags = flags[i];    /* restore flags */
    extra++;
    }
    if( flags!=NULL ) free(flags);
    /* update new position */
    scare_mouse();
    acquire_screen();
    blit( d->dp2, screen, 0,0, ox, oy, d->w+1, d->h+1 );
    blit( screen, d->dp2, d->x, d->y, 0,0, d->w+1, d->h+1 );
    release_screen();
    unscare_mouse();
    broadcast_dialog_message( MSG_DRAW, 0 );
    }   /* inside clickable area */
    msg = D_O_K;
    break;
    case MSG_START:
/*    if(d->dp2 != NULL)*/
    d->dp2 = create_bitmap( d->w+1, d->h+1 );
    if( d->dp2 != NULL ) {
        scare_mouse();
        blit( screen, d->dp2, d->x, d->y, 0,0, d->w+1, d->h+1 );
        unscare_mouse();
        }
    msg = D_O_K;
    break;

    case MSG_END:
    if( d->dp2 != NULL) {
        scare_mouse();
        acquire_screen();
        blit( d->dp2, screen,0,0, d->x, d->y, d->w+1, d->h+1 );
        release_screen();
        unscare_mouse();
        destroy_bitmap( d->dp2 );
        d->dp2 = NULL;
        }
    break;

    case MSG_DRAW:
    x = d->x;
    y = d->y;
    w = d->w;
    h = d->h;
    acquire_screen();

    if( d->d1 == 0 ){
    rectfill( screen, x+3, y+3, x+w-3, y+h-3, d->bg );
    }else{
    fillmap1 = edcreate_fill_map( (d->d1-1)&7, d->fg, d->bg );
    drawing_mode(DRAW_MODE_COPY_PATTERN, fillmap1, 0, 0);
    rectfill( screen, x+3, y+3, x+w-3, y+h-3, 0 );
    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
    eddestroy_fill_map( fillmap1 );
    }

    rectfill( screen, x+3, y+3, x+w-3, y+17, d->bg );
    rect( screen, x,y,     x+w,y+h,       d->fg);       /*outline*/
    rect( screen, x+1,y+1, x+w-1,y+h-1,   d->fg);
    rect( screen, x+2,y+2, x+w-2,y+h-2,   d->fg);
    /* lines across screen */
    for( i=4 ; i<17; i+=2) hline( screen, x,y+i, x+w, d->fg);
    hline( screen,   x, y+17,   x+w,    d->fg);


    // *************************************** quit button
    if((d->d2&2)==2){
        x1= x +w - CHK * 2;
        y1= y +4;
        x2= x +w - CHK * 1;
        y2= y +CHK+2;
        rectfill( screen, x1, y1, x2, y2, d->bg );
        rectfill( screen, x1 + 3, y1 + 3,x2 - 3, y2 - 3, d->fg );
    }
    // ***************************************



    /* main centered caption */
    if( d->dp!=NULL)
        w = text_length( font, d->dp );
    else
        w = 8;
    h = text_height( font );
    x = d->x + ( d->w/2 ) - ( w/2 );
    y = d->y + 6;
    rectfill( screen, x-4, y-1, x+w+3, y+h-2,   d->bg);
    text_mode(-1);
    if( d->dp!=NULL)
        textout( screen, font, d->dp ,x, y, d->fg);
    else
        textout( screen, font, " " ,x, y, d->fg);

    release_screen();
    msg = D_O_K;
    break;

    default:
    msg = D_O_K;
    break;
    }
    return msg;
}




/* Alternative checkbox.
 * checkbox is always 12 x height   pixels.
 * The dp field is the caption to use, if dp is NULL, then output is disabled.
 * The dp2 field points to an Integer. This integer changes on click.
 * The integer must be either TRUE or FALSE.
 * The d1 field determines the text mode,
 *   If mode is zero or positive,
 *   text output will be opaque and the background of the characters will be
 *   set to color #mode.
 *   If negative then textoutput is transparent.
 */
int ed_check(int msg,DIALOG *d,int c)           /* check box */
{
    int *flagptr,i,j,y;
    int cx, cy;

    cx = d->w;
    cy = d->h;
// CHK=12

    flagptr = (int *)d->dp2;

    switch( msg ){
    case MSG_IDLE:
    return D_O_K;
    case MSG_DRAW:
        rect( screen, d->x, d->y, d->x+cx, d->y+cy, d->fg );
        if( d->dp != NULL ){
            text_mode( d->d1 );
            textout( screen,font, d->dp, d->x+(cx+4), d->y+3, d->fg );
            }
        if( *flagptr == FALSE)
            rectfill( screen, d->x+2, d->y+2, d->x+(cx-2), d->y+(cy-2), d->bg );
        if( *flagptr == TRUE){
            rectfill( screen, d->x+2, d->y+2, d->x+(cx-2), d->y+(cy-2), d->fg );
            rectfill( screen, d->x+2, d->y+2, d->x+cx/2, d->y+cy/2, d->bg );
            }
    msg = D_O_K;
    break;
    case MSG_CLICK:
        i=j=y=mouse_b;
        if( (i&1)!=0 || (j&2)!=0 || (y&4)!=0 ){
        scare_mouse();
        if( *flagptr == FALSE ){
            *flagptr = TRUE;
            rectfill( screen, d->x+2, d->y+2, d->x+(cx-2), d->y+(cy-2), d->fg );
            rectfill( screen, d->x+2, d->y+2, d->x+cx/2, d->y+cy/2, d->bg );
            }else{
            *flagptr = FALSE;
            rectfill( screen, d->x+2, d->y+2, d->x+(cx-2), d->y+(cy-2), d->bg );
        }
        unscare_mouse();
        do i=mouse_b; while( (i&7) != 0 );
        }
    msg=D_REDRAW;
    msg=D_O_K;
    break;
        default:
    msg = D_O_K;
    break;
    }
    return msg;
}

/*
 * Setbox, sets variable to TRUE.
 * checkbox is always 12xheight pixels.
 * The dp field is the caption to use, if dp is NULL, then output is disabled.
 * The dp2 field points to an Integer. This integer changes on click.
 * The integer must be either TRUE or FALSE.
 * The d1 field determines the text mode,
 *   If mode is zero or positive,
 *   text output will be opaque and the background of the characters will be
 *   set to color #mode.
 *   If negative then textoutput is transparent.
 */
int ed_set(int msg,DIALOG *d,int c)           /* check box */
{
    int *flagptr,i,j,y;


    flagptr = (int *)d->dp2;

    switch( msg ){
    case MSG_IDLE:
    return D_O_K;
    case MSG_DRAW:
        rect( screen, d->x, d->y, d->x+CHK, d->y+CHK, d->fg );
        if( d->dp != NULL ){
            text_mode( d->d1 );
            textout( screen,font, d->dp, d->x+16, d->y+3, d->fg );
            }
        if( *flagptr == FALSE)
            rectfill( screen, d->x+2, d->y+2, d->x+10, d->y+10, d->bg );
        if( *flagptr == TRUE)
            rectfill( screen, d->x+2, d->y+2, d->x+10, d->y+10, d->fg );
    msg = D_O_K;
    break;
    case MSG_CLICK:
        i=j=y=mouse_b;
        if( (i&1)!=0 || (j&2)!=0 || (y&4)!=0 ){
        scare_mouse();
            *flagptr = TRUE;
            rectfill( screen, d->x+2, d->y+2, d->x+10, d->y+10, d->fg );
        unscare_mouse();
        do i=mouse_b; while( (i&7) != 0 );
        }
    msg=D_REDRAW;
    msg=D_O_K;
    break;
        default:
    msg = D_O_K;
    break;
    }
    return msg;
}






/* Alternative checkbox with a frame. like ed_check but contains a frame too.
 * checkbox is always 12x12 pixels.
 * the height must contain value 12.
 * the dp field is the text caption
 * The dp2 field points to an Integer.
 * The integer must be either TRUE or FALSE.
 * The d1 field determines the text mode,
 *   If mode is zero or positive,
 *   text output will be opaque and the background of the characters will be
 *   set to color #mode.
 * The d2 field is the frame height.
 * The flags field determines where the checkbox is on top of frame or bottom
 * if flags is D_USER then top, else bottom.
 */
int ed_framecheck(int msg,DIALOG *d, int c)           /* check box */
{
    int *signaal;
    int x,y,sx,sy;
    int click;
    int mx,my;
    int x1,y1,x2,y2;
    int w,h;
    int i,j;
    w = d->w;
    h = d->d2;
    signaal = (int *)d->dp2;

    switch( msg ){
    case MSG_START:
    if(d->h < CHK || d->h > CHK+4) d->h = CHK;
    return D_O_K;
    break;
    case MSG_IDLE:
    return D_O_K;
    break;
    case MSG_DRAW:
    /* draw frame */
    sx = CHK + 4 + text_length(font, d->dp);
    sy = text_height(font)+1;
    x = (d->x+w/2) - sx/2;
    y = d->y;
    if( (d->flags&D_USER) == 0){    /* top */
    x1=d->x;
    y1=d->y+CHK/2;
    x2=x1+w;
    y2=d->y+h+CHK/2;
    hline(screen, x1,       y2,   x2,  d->fg);
    hline(screen, x1,       y1,  x-4,  d->fg);
    hline(screen, x+sx+4,   y1,   x2,  d->fg);
    }else{              /* bottom */
    x1=d->x;
    y1=d->y-h+CHK/2;
    x2=x1+w;
    y2=d->y+CHK/2;
    hline(screen, x1,     y1, x2,   d->fg);
    hline(screen, x1,     y2, x-4,  d->fg);
    hline(screen, x+sx+4, y2, x2,   d->fg);
    }
    vline(screen, x1, y1, y2, d->fg);
    vline(screen, x2, y1, y2, d->fg);
        rect( screen, x, y, x+CHK, y+CHK, d->fg);
        text_mode( d->d1 );
        textout( screen,font, d->dp, x+16, y+3, d->fg);
        if( *signaal == FALSE)
            rectfill( screen, x+2, y+2, x+10, y+10, d->bg);
        if( *signaal == TRUE)
            rectfill( screen, x+2, y+2, x+10, y+10, d->fg);
    msg = D_O_K;
    break;
    case MSG_CLICK:
    sx = CHK + 4 + text_length(font, d->dp);
    x = (d->x+w/2) - sx/2;
    y = d->y;
    click = FALSE;
    mx = mouse_x;
    my = mouse_y;
    if( mx >= x && mx <= (x+CHK+1) && my >= y && my <= (y+CHK+1) ) click = TRUE;
    if( click==FALSE ){
/*        broadcast_dialog_message( MSG_DRAW, 0 );*/
        scare_mouse();
        ed_framecheck(MSG_DRAW,d,c);     /*TEST, update self*/
        unscare_mouse();
        return D_O_K;
        }

    i=j=mouse_b;
    if( (i&1)!=0 || (j&2)!=0 ){
    scare_mouse();  /*TEST*/
    if( *signaal == FALSE ){
        *signaal = TRUE;
            rectfill( screen, x+2, y+2, x+10, y+10, d->fg);
        }else{
        *signaal = FALSE;
            rectfill( screen, x+2, y+2, x+10, y+10, d->bg);
        }
    unscare_mouse();
        i=mouse_b;
        while( (i & 7) != 0 ) i=mouse_b;
    }
    msg = D_REDRAW;
    msg = D_O_K;




    break;
        default:
    msg = D_O_K;
    break;
    }
    return msg;
}



/* Frame. like ed_framecheck but without the checkbox.
 * The height must contain a value between 1 to 12, any value will do.
 * the dp field is the text caption.
 * The d1 field determines the text mode,
 *   If mode is zero or positive,
 *   text output will be opaque and the background of the characters will be
 *   set to color #mode.
 * The d2 field is the frame height.
 * The flags field determines where the label is on top of frame or bottom.
 * if flags is D_USER then top, else bottom.
 */
int ed_frame(int msg,DIALOG *d, int c)
{
    int x,y,sx,sy;
    int x1,y1,x2,y2;
    int w,h;
    int flags;

    w       = d->w;
    h       = d->d2;
    flags   = d->flags;

    switch( msg ){
    case MSG_START:
    return D_O_K;
    break;
    case MSG_IDLE:
    return D_O_K;
    break;
    case MSG_DRAW:

    /* draw frame */
/*  sx = CHK + 4 + text_length(font, d->dp);*/
    sx =       4 + text_length(font, d->dp);
    sy = text_height(font)+1;
    x = (d->x+w/2) - sx/2;
    y = d->y;

    if( (flags&D_USER) == 0){    /* top */

    x1=d->x;
    y1=d->y+CHK/2;
    x2=x1+w;
    y2=d->y+h+CHK/2;
    hline(screen, x1,       y2,   x2,  d->fg);
    hline(screen, x1,       y1,  x-4,  d->fg);
    hline(screen, x+sx+4,   y1,   x2,  d->fg);

    }else{              /* bottom */

    x1=d->x;
    y1=d->y-h+CHK/2;
    x2=x1+w;
    y2=d->y+CHK/2;
    hline(screen, x1,     y1, x2,   d->fg);
    hline(screen, x1,     y2, x-4,  d->fg);
    hline(screen, x+sx+4, y2, x2,   d->fg);

    }

    vline(screen, x1, y1, y2, d->fg);
    vline(screen, x2, y1, y2, d->fg);
/*    rect( screen, x, y, x+CHK, y+CHK, d->fg);*/
    text_mode( d->d1 );
/*    textout( screen,font, d->dp, x+16, y+3, d->fg);*/
    textout( screen,font, d->dp, x+2, y+3, d->fg);

    msg = D_O_K;
    break;
        default:
    msg = D_O_K;
    break;
    }
    return msg;
}










/* helper functions */
static void rot_getrotbox(BITMAP *, int, int, int);
static void rot_calcrotbox(BITMAP *, int, int, int);
static void rot_dodgexy( BITMAP *, int, int, int);
static void rot_passptr( int *, int *);
static void rot_calcdistance( BITMAP *bmp, int x, int y, int d );
/* helper functions */



/* clicking pad radii */
#define PAD 7
/* minimumdistance to pixel */
#define MINDIST PAD/2

/* dialog object for rotating angle.
 * Rotating angle is in the d1 field. Range 0 to 255 means 0 to 360 degrees.
 * The height and width must be equal. The height determines size.
 * uses dp2 for internal use (contains pointer to dots coordinates).
 * uses d2 for internal use.
 * uses MSG_USER for internal use.
 *
 */
static int rx,ry;      /* returned x,y */
static int rotdots;    /* how many dots in circle */
static int *coordptr1, *coordptr2;
static int distance;

int ed_rotatebox(int msg,DIALOG *d, int c)
{
    int x,y,i,j;
    int x1,y1,x2,y2,w,h;          /* object extent */
    int px1,py1,px2,py2,pw,ph;    /* inner rectangle extent */
    int radius;
    int mx,my,mdx,mdy;
    int *magic1, *magic2;     /* pointer to x,y integers */
    int success;
    int mindist;
    float f1,f2,f3,f4;

    if(msg==MSG_START) d->w = d->h;

    w = d->w;
    h = d->h;
    x1=d->x;
    y1=d->y;
    x2=x1+w;
    y2=y1+h;

    px1 = x1+PAD;
    px2 = x2-PAD;
    py1 = y1+PAD;
    py2 = y2-PAD;
    pw = px2-px1;
    ph = py2-py1;
    radius = pw/2;



    switch( msg ){
    case MSG_IDLE:
    return D_O_K;
    break;

    case MSG_END:
    if(d->dp2!=NULL)free(d->dp2);
    d->d2=0;
    rx=ry=rotdots=0;
    return D_O_K;
    break;


    case MSG_START:
    rx=ry=0;
    rotdots=0;          /* how many dots the circle has */

    do_arc(screen,radius,radius,0,((255)<<(16)),radius,0,rot_calcrotbox ); // calc. main circle

    d->d2 = rotdots;    // amount of dots
    d->dp2 = (int *) malloc( (rotdots+99)*sizeof(int) );    if( d->dp2==NULL ) return D_O_K;
    d->dp3 = (int *) malloc( (rotdots+99)*sizeof(int) );    if( d->dp3==NULL ) return D_O_K;
    rot_passptr( d->dp2, d->dp3 );      // pass pointer to store x,y
    do_arc(screen,radius,radius,0,((255)<<(16)),radius,0,rot_dodgexy ); // get x,y and store...
    msg=D_O_K;
    break;


    case MSG_DRAW:

/* check if flag D_DISABLED is set. If set then suicide. */
    i = d->flags;
    if( (i&D_DISABLED) != 0 );




    /* draw frame */
    rectfill(screen, x1,y1,x2,y2,d->bg);    /* fill background */
    rect(screen, x1,y1,x2,y2,d->fg);        /* outer quadrant */

    case MSG_USER:
    /* undraw */
    if( rx!=0 && ry!=0 && rx<x2 && rx>x1 && ry<y2 && ry>y1 ){
    line(screen,px1+radius,py1+radius, rx,ry, d->bg);
    rect(screen, rx-PAD+1,ry-PAD+1,rx+PAD-1,ry+PAD-1, d->bg);
    }
    vline(screen, px1+radius, py1, py2, d->fg);
    hline(screen, px1, py1+radius, px2, d->fg);
    circle(screen,px1+radius,py1+radius,radius, d->fg); /* main circle */
    do_arc(screen,px1+radius,py1+radius, ((d->d1)<<(16)), (d->d1+1)<<16, radius, 0, rot_getrotbox );/* rx,ry= returned coordinates */
    /* draw */
    line(screen,px1+radius,py1+radius, rx,ry, d->fg);  /* draw angledline */
    rect(screen, rx-PAD+1,ry-PAD+1,rx+PAD-1,ry+PAD-1, d->fg);
    msg = D_O_K;
    break;


    case MSG_CLICK:
    mx = mouse_x;
    my = mouse_y;
/*
    if( !(rx-PAD < mx && mx < rx+PAD && ry-PAD < my && my < ry+PAD) ) return D_O_K;
*/
    /* inside pad */


    mdx=mdy=0;
    for(;;){
    magic1 = (int *)d->dp2;    if(magic1==NULL)return D_O_K;
    magic2 = (int *)d->dp3;    if(magic2==NULL)return D_O_K;
    success = FALSE;
    mindist = PAD;
    /*
     * quadrants:
     *
     *       1     0
     *          *
     *       2     3
     *
     */

    j=0;
    if( mx < x1+radius){    /* case 1 or 2 */
    if( my <= y1+radius){    /* case 1 */
        j = d->d2/4-PAD-2;
        }else{              /* case 2 */
        j = d->d2/2-PAD-2;
        }
    }

    if( mx >= x1+radius){    /* case 0 or 3 */
    if( my <= y1+radius){    /* case 0 */
        j=0;
        }else{              /* case 3 */
        j = d->d2/2+d->d2/4-PAD-2;
        }
    }


    for(i=j; i < d->d2 ;i++){    /* traverse buffer of stored x,y */
    x = d->x + magic1[i];   /* TEST */
    y = d->y + magic2[i];   /* TEST */
    distance=0;
    do_line( screen, x, y, mx, my, 0, rot_calcdistance );
    if( distance < mindist ) {
        mindist = distance;
        j=i;
        success=TRUE;
        }
    if( distance > mindist && success==TRUE ) break;
    }

    if(success==TRUE){
        d->d1 = (i*255)/d->d2;
        d->d1 = (i*255)/d->d2;
        f1=j;
        f2=255.0;
        f3=d->d2;
        f4= (f1*f2)/f3;
        d->d1 = f4;
        scare_mouse();
        ed_rotatebox(MSG_USER,d, 0);
        unscare_mouse();
        }else{
        scare_mouse();
        ed_rotatebox(MSG_USER,d, 0);    //self
        unscare_mouse();
        return D_O_K;
        }
    i=0;
    mdx=mdy=0;
    while( mdx==0 && mdy==0 ){
        mdx = mouse_x - mx;
        mdy = mouse_y - my;
        i=mouse_b;
        i &= 7;
        if( i==0 )break;
        }

    mx = mouse_x;
    my = mouse_y;
    i=mouse_b;
    i &=7;
    if(i==0)break;
    }   /* forever loop... */

    msg = D_O_K;
    break;
        default:
    msg = D_O_K;
    break;
    }
    return msg;
}
static void rot_getrotbox( BITMAP *bmp, int x, int y, int d )
{
    rx = x;
    ry = y;
}
static void rot_calcrotbox( BITMAP *bmp, int x, int y, int d )
{
    rotdots++;
}
static void rot_passptr( int *ptr1, int *ptr2 )
{
    coordptr1 = ptr1;
    coordptr2 = ptr2;
}
static void rot_dodgexy( BITMAP *bmp, int x, int y, int d )
{
    *coordptr1++ = x;
    *coordptr2++ = y;
}
static void rot_calcdistance( BITMAP *bmp, int x, int y, int d )
{
    distance++;
}





/*
 * replacement for the standard slider
 * Reworked original object.
 *  A slider control object. This object returns a value in d2, in the
 *  range from 0 to d1. It will display as a vertical slider if h is
 *  greater than or equal to w; otherwise, it will display as a horizontal
 *  slider. dp can contain an optional bitmap to use for the slider handle; 
 *  dp2 can contain an optional callback function, which is called each 
 *  time d2 changes. The callback function should have the following
 *  prototype:
 *
 *  int function(void *dp3, int d2);
 *
 *  The ed_slider object will return the value of the callback function.
 */
int ed_slider( int msg, DIALOG *d, int c )
{
   BITMAP *slhan = NULL;
   int oldpos, newpos;
   int sfg;                /* slider foreground color */
   int vert = TRUE;        /* flag: is slider vertical? */
   int hh = 7;             /* handle height (width for horizontal sliders) */
   int hmar;               /* handle margin */
   int slp;                /* slider position */
   int mp;                 /* mouse position */
   int irange;
   int slx, sly, slh, slw;
   int msx, msy;
   int retval = D_O_K;
   int upkey, downkey;
   int pgupkey, pgdnkey;
   int homekey, endkey;
   int delta;
   fixed slratio, slmax, slpos;
   int (*proc)(void *cbpointer, int d2value);

   /* check for slider direction */
   if (d->h < d->w)
      vert = FALSE;

   /* set up the metrics for the control */
   if (d->dp != NULL) {
      slhan = (BITMAP *)d->dp;
      if (vert)
	 hh = slhan->h;
      else
	 hh = slhan->w;
   }

   hmar = hh/2;
   irange = (vert) ? d->h : d->w;
   slmax = itofix(irange-hh);
   slratio = slmax / (d->d1);
   slpos = slratio * d->d2;
   slp = fixtoi(slpos);

   switch (msg) {

      case MSG_DRAW:
	 sfg = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;

	 if (vert) {
/*down*/
        rectfill(screen, d->x, d->y, d->x+d->w/2-2, d->y+d->h, d->bg);
	    rectfill(screen, d->x+d->w/2-1, d->y, d->x+d->w/2+1, d->y+d->h, sfg);
	    rectfill(screen, d->x+d->w/2+2, d->y, d->x+d->w, d->y+d->h, d->bg);
        hline(screen, d->x, d->y+d->h/4        , d->x+d->w, d->fg);  /* 25% */
        hline(screen, d->x, d->y+d->h/2        , d->x+d->w, d->fg);  /* 50% */
        hline(screen, d->x, d->y+d->h - d->h/4 , d->x+d->w, d->fg);  /* 75% */
     }
	 else {
/*left*/
        rectfill(screen, d->x, d->y, d->x+d->w, d->y+d->h/2-2, d->bg);
	    rectfill(screen, d->x, d->y+d->h/2-1, d->x+d->w, d->y+d->h/2+1, sfg);
	    rectfill(screen, d->x, d->y+d->h/2+2, d->x+d->w, d->y+d->h, d->bg);
        vline(screen, d->x+d->w/4         , d->y, d->y+d->h, d->fg); /* 25% */
        vline(screen, d->x+d->w/2         , d->y, d->y+d->h, d->fg); /* 50% */
        vline(screen, d->x+d->w - d->w/4  , d->y, d->y+d->h, d->fg); /* 75% */
     }

	 /* okay, background and slot are drawn, now draw the handle */
	 if (slhan) {
	    if (vert) {
	       slx = d->x+(d->w/2)-(slhan->w/2);
	       sly = d->y+d->h-(hh+slp);
	    } 
	    else {
	       slx = d->x+slp;
	       sly = d->y+(d->h/2)-(slhan->h/2);
	    }
	    draw_sprite(screen, slhan, slx, sly);
	 } 
	 else {
	    /* draw default handle */
	    if (vert) {
	       slx = d->x;
	       sly = d->y+d->h-(hh+slp);
	       slw = d->w;
	       slh = hh;
	    } else {
	       slx = d->x+slp;
	       sly = d->y;
	       slw = hh;
	       slh = d->h;
	    }

	    /* draw body */
        rectfill(screen, slx, sly, slx+slw, sly+slh, sfg);
        rectfill(screen, slx+3, sly+3, slx+slw-3, sly+slh-3, d->bg);
	 }

//     if (d->flags & D_GOTFOCUS)
//        dotted_rect(d->x, d->y, d->x+d->w, d->y+d->h, sfg, d->bg);
	 break;

      case MSG_WANTFOCUS:
      case MSG_LOSTFOCUS:
	 return D_WANTFOCUS;

      case MSG_KEY:
	 if (!(d->flags & D_GOTFOCUS))
	    return D_WANTFOCUS;
	 else
	    return D_O_K;

      case MSG_CHAR:
	 /* handle movement keys to move slider */
	 c >>= 8;

	 if (vert) {
	    upkey = KEY_UP;
	    downkey = KEY_DOWN;
	    pgupkey = KEY_PGUP;
	    pgdnkey = KEY_PGDN;
	    homekey = KEY_END;
	    endkey = KEY_HOME;
	 } 
	 else {
	    upkey = KEY_RIGHT;
	    downkey = KEY_LEFT;
	    pgupkey = KEY_PGDN;
	    pgdnkey = KEY_PGUP;
	    homekey = KEY_HOME;
	    endkey = KEY_END;
	 }

	 if (c == upkey)
	    delta = 1;
	 else if (c == downkey)
	    delta = -1;
	 else if (c == pgdnkey)
	    delta = -d->d1 / 16;
	 else if (c == pgupkey)
	    delta = d->d1 / 16;
	 else if (c == homekey)
	    delta = -d->d2;
	 else if (c == endkey)
	    delta = d->d1 - d->d2;
	 else
	    delta = 0;

	 if (delta) {
	    oldpos = slp;

	    while (1) {
	       d->d2 = d->d2+delta;
	       slpos = slratio*d->d2;
	       slp = fixtoi(slpos);
	       if ((slp != oldpos) || (d->d2 <= 0) || (d->d2 >= d->d1))
		  break;
	    }

	    if (d->d2 < 0)
	       d->d2 = 0;
	    if (d->d2 > d->d1)
	       d->d2 = d->d1;

	    retval = D_USED_CHAR;

	    /* call callback function here */
	    if (d->dp2) {
	       proc = d->dp2;
	       retval |= (*proc)(d->dp3, d->d2);
	    }

	    scare_mouse();
        object_message(d, MSG_DRAW, 0);
	    unscare_mouse();
	 }
	 break;

      case MSG_CLICK:
	 /* track the mouse until it is released */
	 mp = slp;

	 while (gui_mouse_b()) {
	    msx = gui_mouse_x();
	    msy = gui_mouse_y();
	    oldpos = d->d2;
	    if (vert)
	       mp = (d->y+d->h-hmar)-msy;
	    else
	       mp = msx-(d->x+hmar);
	    if (mp < 0)
	       mp = 0;
	    if (mp > irange-hh)
	       mp = irange-hh;
	    slpos = itofix(mp);
	    slmax = fdiv(slpos, slratio);
	    newpos = fixtoi(slmax);
	    if (newpos != oldpos) {
	       d->d2 = newpos;

	       /* call callback function here */
	       if (d->dp2 != NULL) {
		  proc = d->dp2;
		  retval |= (*proc)(d->dp3, d->d2);
	       }

	       if (d->d2 != oldpos) {
		  scare_mouse();
          object_message(d, MSG_DRAW, 0);
		  unscare_mouse();
	       }
	    }

	    /* let other objects continue to animate */
	    broadcast_dialog_message(MSG_IDLE, 0);
	 }
	 break;
   }

   return retval;
}

/*
 * Textual window.
 * autoupdate.
 * displayed text should be in dp.
 * Does not write outside window.
 * If d1 is not 0 then the empty space is filled with a patterned character
 * d1 ranges 1 to 8 for a fill pattern.
 * uses dp2 for internal use.
 *
 */
int ed_label(int msg,DIALOG *d, int c)
{
    BITMAP *bm=NULL;
    int w,h,x,y;
    int x1,y1,x2,y2;

    if(msg==MSG_IDLE) return D_O_K;
    w = d->w;
    h = d->h;
    x1 = d->x;
    y1 = d->y;
    x2 = x1+w-1;
    y2 = y1+h-1;
    x = x1 + d->w/2;
    y = y1 + d->h/2;

    switch(msg){

    case MSG_START:
    d->dp2 = create_bitmap(w+1,h+1);
    break;

    case MSG_END:
    if(d->dp2!=NULL) destroy_bitmap(d->dp2); d->dp2=NULL;
    return msg;
    break;

    case MSG_DRAW:
    if(d->dp2!=NULL){
    text_mode(d->bg);

    clear_to_color(d->dp2,d->bg);

    if(d->d1!=0){
    bm = edcreate_fill_map( (d->d1-1)&7 , d->bg, d->fg );
    if(bm!=NULL)    drawing_mode(DRAW_MODE_COPY_PATTERN, bm, 0, 0);
    if(bm!=NULL)    rectfill(d->dp2,2,2,w-2,h-2,d->fg);
    if(bm!=NULL)    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
    }
    if(d->dp != NULL){
        textout(d->dp2,font,d->dp,2,2, d->fg);
    }else{
        textout(d->dp2,font,"",2,2,d->fg);
        }
        rect(d->dp2, 0,0,w-1,h-1, d->fg);
        rect(d->dp2, 1,1,w-2,h-2, d->bg);
        acquire_screen();
        blit(d->dp2,screen, 0,0,x1,y1,w,h);
        release_screen();
    if(d->d1==1) destroy_bitmap(bm);
    }
    break;

    default:
    break;
    }
    return D_O_K;
}


/*
int d_button_proc(int msg, DIALOG *d, int c);
   A button object (the dp field points to the text string). This object can 
   be selected by clicking on it with the mouse or by pressing its keyboard 
   shortcut. If the D_EXIT flag is set, selecting it will close the dialog, 
   otherwise it will toggle on and off. Like d_text_proc(), ampersands can 
   be used to display the keyboard shortcut of the button.
 *
 *
 *
 *  The dp field contains a pointer to a caption text
 *  The dp2 field contains a pointer to a function, will be called
 *  when button is pressed.
 *  if dp2 is NULL then it will be ignored.
 *  The function must have this prototype:
 *
 *    void (*callback)(DIALOG *d);
 *
 */
int ed_button(int msg,DIALOG *d, int c)
{
    int w,h,x,y,j;
    int x1,y1,x2,y2;
    void (*callback)(DIALOG *);


    if(msg==MSG_IDLE) return D_O_K;
    w = d->w;
    h = d->h;
    x1 = d->x;
    y1 = d->y;
    x2 = x1+w-1;
    y2 = y1+h-1;
    x = x1 + d->w/2;
    y = y1 + d->h/2;

    switch(msg){

    case MSG_WANTFOCUS:
    msg=D_WANTFOCUS;
    break;

    case MSG_GOTFOCUS:
    scare_mouse();
    edrect_dot(screen, x1+1,y1+1,x2-2,y2-2,d->fg);
    unscare_mouse();
    msg=D_O_K;
    break;

    case MSG_LOSTFOCUS:
    scare_mouse();
    edrect_dot(screen, x1+1,y1+1,x2-2,y2-2,d->bg);
    unscare_mouse();
    msg=D_O_K;
    break;

    case MSG_START:
    rectfill(screen, x1,y1,x2,y2,d->bg);
    msg=D_O_K;
    break;

    case MSG_END:
    msg=D_EXIT;
    break;

    case MSG_DRAW:
    rectfill(screen, x1+2,y1+2,x2-3,y2-3,d->bg);
    rect(screen, x1,y1,x2,y2,d->fg);
    rect(screen, x1,y1,x2-1,y2-1,d->fg);
    putpixel(screen,x2,y1,d->bg);
    putpixel(screen,x1,y2,d->bg);
    text_mode(d->bg);
    if(d->dp!=NULL)
        textout_centre(screen,font,d->dp,x,y-4,d->fg);
    else
        textout_centre(screen,font,"?",x,y-4,d->fg);
    msg=D_O_K;
    break;

    case MSG_KEY:
    case MSG_CLICK:
    scare_mouse();
    putpixel(screen,x2,y1,d->fg);
    putpixel(screen,x1,y2,d->fg);
    edxchg_bitmap_rect(screen, d->bg, d->fg,x1,y1, w,  h );
    unscare_mouse();
    do j=mouse_b; while((j&7)!=0 );
    /*** call procedure ***/
    if(d->dp2!=NULL){
    callback = d->dp2;
    callback( d );
    }
    do j=mouse_b; while((j&7)!=0 );
    /*** call procedure ***/
    scare_mouse();
    edxchg_bitmap_rect(screen, d->bg, d->fg,x1,y1, w,  h );
    putpixel(screen,x2,y1,d->bg);
    putpixel(screen,x1,y2,d->bg);
    unscare_mouse();
    msg=D_O_K;
    break;

    default:
    msg=D_O_K;
    break;
    }
    return msg;
}





/*
 *  The dp field contains a pointer to a caption text
 *  The dp2 field contains a pointer to a function, will be called
 *  when button is pressed.
 *  if dp2 is NULL then it will be ignored.
 *  The function must have this prototype:
 *
 *    void (*callback)(DIALOG *d);
 *
 *  c  is a copy of the parameter c.
 *  d1 is a copy of the parameter d1.
 *  d2 is a copy of the parameter d2.
 */
int ed_button_exit(int msg,DIALOG *d, int c)
{
    int w,h,x,y,j;
    int x1,y1,x2,y2;
    void (*callback)(DIALOG *);



    if(msg==MSG_IDLE) return D_O_K;
    w = d->w;
    h = d->h;
    x1 = d->x;
    y1 = d->y;
    x2 = x1+w-1;
    y2 = y1+h-1;
    x = x1 + d->w/2;
    y = y1 + d->h/2;

    switch(msg){

    case MSG_WANTFOCUS:
    msg=D_WANTFOCUS;
    break;


    case MSG_GOTFOCUS:
    scare_mouse();
    edrect_dot(screen, x1+1,y1+1,x2-2,y2-2,d->fg);
    unscare_mouse();
    msg=D_O_K;
    break;

    case MSG_LOSTFOCUS:
    scare_mouse();
    edrect_dot(screen, x1+1,y1+1,x2-2,y2-2,d->bg);
    unscare_mouse();
    msg=D_O_K;
    break;

    case MSG_START:
    rectfill(screen, x1,y1,x2,y2,d->bg);
    msg=D_O_K;
    break;

    case MSG_END:
    msg=D_EXIT;
    break;

    case MSG_DRAW:
    rectfill(screen, x1+2,y1+2,x2-3,y2-3,d->bg);
    rect(screen, x1,y1,x2,y2,d->fg);
    rect(screen, x1,y1,x2-1,y2-1,d->fg);
    putpixel(screen,x2,y1,d->bg);
    putpixel(screen,x1,y2,d->bg);
    text_mode(d->bg);
    if(d->dp!=NULL)
        textout_centre(screen,font,d->dp,x,y-4,d->fg);
    else
        textout_centre(screen,font,"?",x,y-4,d->fg);
    msg=D_O_K;
    break;

    case MSG_KEY:
    case MSG_CLICK:
    scare_mouse();
    putpixel(screen,x2,y1,d->fg);
    putpixel(screen,x1,y2,d->fg);
    edxchg_bitmap_rect(screen, d->bg, d->fg,x1,y1, w,  h );
    unscare_mouse();
    do j=mouse_b; while((j&7)!=0 );
    /*** call procedure ***/
    if(d->dp2!=NULL){
    callback = d->dp2;
    callback( d );
    }
    do j=mouse_b; while((j&7)!=0 );
    /*** call procedure ***/
    scare_mouse();
    edxchg_bitmap_rect(screen, d->bg, d->fg,x1,y1, w,  h );
    putpixel(screen,x2,y1,d->bg);
    putpixel(screen,x1,y2,d->bg);
    unscare_mouse();
    msg=D_EXIT;
    break;

    default:
    msg=D_O_K;
    break;
    }
    return msg;
}



/*
 *  The dp field contains a pointer to a caption text,
 *  if NULL nothing is displayed.
 *
 *  The dp2 field contains a pointer to a function, will be called
 *  when button is pressed.
 *  if dp2 is NULL then it will be ignored.
 *  The function must have this prototype:
 *    void (*callback)(DIALOG *d);
 *
 *  The dp3 field contains a pointer to a graphic bitmap
 *   while the d1 and d2 field is the xy offset into the bitmap to use
 *
 */
int ed_button_graphic(int msg,DIALOG *d, int c)
{
    int w,h,x,y,j;
    int x1,y1,x2,y2;
    void (*callback)(DIALOG *);


    if(msg==MSG_IDLE) return D_O_K;
    w = d->w;
    h = d->h;
    x1 = d->x;
    y1 = d->y;
    x2 = x1+w-1;
    y2 = y1+h-1;
    x = x1 + d->w/2;
    y = y1 + d->h/2;

    switch(msg){

    case MSG_WANTFOCUS:
    msg=D_WANTFOCUS;
    break;

    case MSG_GOTFOCUS:
    scare_mouse();
    edrect_dot(screen, x1+1,y1+1,x2-2,y2-2,d->fg);
    unscare_mouse();
    msg=D_O_K;
    break;

    case MSG_LOSTFOCUS:
    scare_mouse();
    edrect_dot(screen, x1+1,y1+1,x2-2,y2-2,d->bg);
    unscare_mouse();
    msg=D_O_K;
    break;

    case MSG_START:
    rectfill(screen, x1,y1,x2,y2,d->bg);
    msg=D_O_K;
    break;

    case MSG_END:
    msg=D_EXIT;
    break;

    case MSG_DRAW:
    acquire_screen();
    rectfill(screen, x1+2,y1+2,x2-3,y2-3,d->bg);
    rect(    screen, x1,y1,x2,y2,d->fg);
    rect(    screen, x1,y1,x2-1,y2-1,d->fg);
    putpixel(screen,x2,y1,d->bg);
    putpixel(screen,x1,y2,d->bg);
    if(d->dp3!=NULL){
        blit( d->dp3, screen, d->d1, d->d2,
              x1+2, y1+2,
              w-5, h-5   );
    }
    text_mode(-1);
    if(d->dp!=NULL){
        textout_centre(screen,font,d->dp,x,y-4,d->fg);
    }
    release_screen();
    msg=D_O_K;
    break;

    case MSG_KEY:
    case MSG_CLICK:
    scare_mouse();
    acquire_screen();
    putpixel(screen,x2,y1,d->fg);
    putpixel(screen,x1,y2,d->fg);
    edxchg_bitmap_rect(screen, d->bg, d->fg,x1,y1, w,  h );
    release_screen();
    unscare_mouse();
    do j=mouse_b; while((j&7)!=0 );
    /*** call procedure ***/
    if(d->dp2!=NULL){
    callback = d->dp2;
    callback( d );
    }
    do j=mouse_b; while((j&7)!=0 );

    /*** call procedure ***/
    scare_mouse();
    acquire_screen();
    edxchg_bitmap_rect(screen, d->bg, d->fg,x1,y1, w,  h );
    putpixel(screen,x2,y1,d->bg);
    putpixel(screen,x1,y2,d->bg);
    release_screen();
    unscare_mouse();
    msg=D_O_K;
    break;

    default:
    msg=D_O_K;
    break;
    }
    return msg;
}












// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************


// The array_handle returned to the user is the index into all_buttonarrays
//
//
//
char all_buttonarray_alloc[ HARDWIRED_LIMIT_BTNARRS+1 ];  // set to 1 if allocated, else 0
ED_BUTTONARRAY_WINDOW *all_buttonarray_structs[ HARDWIRED_LIMIT_BTNARRS+1 ];  //pointer to structure
static int buttonarray_amount = 0;


//prototype

//------------------------------------------------------------------


/*
 * Check mouse coordinates against buttonarray object
 * All coordinates are screen coordinates.
 * input:
 *   ed_btnarr     = pointer to the button array structure
 *   x,y           = position of button array object
 *   mx,my         = mouse position
 *   *button_index = The integer this pointer points to changes if mouse
 *                   coordinates are inside a button.
 *   *rx1,*ry1     = coordinates, the insteger this pointer points to changes
 *                   points to begin of button
 *
 * return values:
 *  0 = non valid mouse coordinates or user pressed on nothing special
 *  1 = mouse coordinates are inside header
 *  2 = mouse coordinates are inside main button area, inside a button.
 * Fills in the button_index value, range from 0 to the total amount of buttons.
 * Button_index is only changed if the mouse coordinate are inside a button.
 */
int check_mouse_inside_header( ED_BUTTONARRAY_WINDOW *ed_btnarr, int x, int y, int mx, int my, int *button_index, int *rx1, int *ry1 )
{
    int sx,sy, amx, amy;
    int x1,y1,x2,y2;
    int spcx, spcy;
    int linewidth;
    int header_sy;
    int asx,asy;
    int linecolor,fillcolor,fgcolor,bkcolor;
    int header_position;
    int hax1=0,hay1=0,hax2=0,hay2=0;
    int bax1=0,bay1=0,bax2=0,bay2=0;
    int bx1,by1,bx2,by2;

    linecolor  = ed_btnarr->linecolor;
    fillcolor  = ed_btnarr->fillcolor;
    fgcolor    = ed_btnarr->fgcolor;
    bkcolor    = ed_btnarr->bkcolor;
    amx        = ed_btnarr->amount_x;
    amy        = ed_btnarr->amount_y;
    linewidth  = ed_btnarr->linewidth;
    header_sy  = ed_btnarr->header_height;
    sx         = ed_btnarr->button_sx;
    sy         = ed_btnarr->button_sy;
    spcx       = ed_btnarr->buttonspace_sx;
    spcy       = ed_btnarr->buttonspace_sy;
    asx        = ed_btnarr->array_sx;
    asy        = ed_btnarr->array_sy;
    header_position = ed_btnarr->header_position;
// --------------------------------------------------------------
    // first let's see if we got a header
    // there can only be two cases
    if( ed_btnarr->flag_display_header == 1){   // valid header
// --------------------------------------------------------------
    // case 0: header is on top
    if(header_position==0){
    // get header area into coordinates
    hax1= x + linewidth;
    hay1= y + linewidth;
    hax2= hax1 + asx - linewidth * 2 - 1;
    hay2= hay1 + header_sy - 1;
    // get button array area into coordinates
    bax1= x + spcx + linewidth;
    bay1= y + spcy + linewidth * 2 + header_sy;
    bax2= bax1 - spcx + asx - linewidth*2 - 1;
    bay2= bay1 - spcy + asy - linewidth*3 - header_sy;
    }
// --------------------------------------------------------------
    // case 1: header is on bottom
    if(header_position==1){
    // get header area into coordinates
    hax1= x + linewidth;
    hay1= y + linewidth*2 + spcy + (sy+spcy)*amy;
    hax2= hax1 + asx - linewidth * 2 - 1;
    hay2= hay1 + header_sy;
    // get button array area into coordinates
    bax1= x + spcx + linewidth;
    bay1= y + spcy + linewidth;
    bax2= bax1 - spcx + asx - linewidth*2 - 1;
    bay2= bay1 - spcy + asy - linewidth*3 - header_sy - 1;
    }
// --------------------------------------------------------------
    // case 2: header is on left
    if(header_position==2){
    hax1= x + linewidth;
    hay1= y + linewidth;
    hax2= hax1 + header_sy;
    hay2= hay1 + spcy + (sy+spcy)*amy;
    // get button array area into coordinates
    bax1= x + header_sy + spcx + linewidth*2;
    bay1= y + spcy + linewidth;
    bax2= bax1 - spcx + asx - linewidth*3 - header_sy - 1;
    bay2= bay1 - spcy + asy - linewidth*2 - 1;
    }
// --------------------------------------------------------------
    // case 3: header is on right
    if(header_position==3){
    hax1= x + linewidth*2 + spcx + (sx+spcx)*amx;
    hay1= y + linewidth;
    hax2= hax1 + header_sy;
    hay2= hay1 + spcy + (sy+spcy)*amy;
    // get button array area into coordinates
    bax1= x + spcx + linewidth;
    bay1= y + spcy + linewidth;
    bax2= bax1 - spcx + asx - linewidth*3 - header_sy - 1;
    bay2= bay1 - spcy + asy - linewidth*2 - 1;
    }
// --------------------------------------------------------------
    if( mx > hax1 &&
        mx < hax2 &&
        my > hay1 &&
        my < hay2 ){
//    scare_mouse();
//    rectfill(screen,hax1,hay1,hax2,hay2, 0);
//    unscare_mouse();
    return 1;           // inside header
    }
// --------------------------------------------------------------
    }else{  // no header, must never return value 1, only buttonarea exist
// --------------------------------------------------------------
    // get button array area into coordinates
    bax1= x + spcx + linewidth;
    bay1= y + spcy + linewidth;
    bax2= bax1 - spcx + asx - linewidth*2 - 1;
    bay2= bay1 - spcy + asy - linewidth*2 - 1;
// --------------------------------------------------------------
    }
// --------------------------------------------------------------
    // we are now inside button array area
    if( mx > bax1 &&
        mx < bax2 &&
        my > bay1 &&
        my < bay2 ){
/******
    scare_mouse();
    rectfill(screen,bax1,bay1,bax2,bay2, 240);
    unscare_mouse();
*******/
    // get button area into coordinates
    // make relative mouse coordinates from top of button array block
    bx1 = mx - bax1;    // always positive
    by1 = my - bay1;    // always positive
    // Get which button was pressed by dividing with
    // button size + button space as one unit.
    bx2 = bx1 / (sx+spcx);              // number of button from left
    by2 = by1 / (sy+spcy);              // number of button from top
    *button_index = (bx2 + by2*amx);    // fill in return value, pressed index
    // rebuild coordinates
    x1 = bax1 + bx2 * (sx+spcx);
    y1 = bay1 + by2 * (sy+spcy);
    x2 = x1 + sx;
    y2 = y1 + sy;
    if( mx > x1 &&
        mx < x2 &&
        my > y1 &&
        my < y2 ){    // inside single button
//  scare_mouse();
//  rectfill(screen,x1,y1,x2-1,y2-1, 240);
    *rx1 = x1;
    *ry1 = y1;
//  unscare_mouse();
    return 2;
    }}
// --------------------------------------------------------------
    //
// --------------------------------------------------------------
    return 0;
}

/*
 * not completely ready yet.
 */
void ed_free_buttonarray( ED_BUTTONARRAY_WINDOW *mywin )
{
    int handle=0;

    if( mywin == NULL ) return;
    if( buttonarray_amount >= HARDWIRED_LIMIT_BTNARRS ) return;

    handle = mywin->handle;

    all_buttonarray_alloc[ handle ] = 0;  // free!
    if(buttonarray_amount!=0)
        buttonarray_amount--;
    free( mywin );
}



/* Create a dialog object called buttonarray with default values
 *
 *
 *
 */
ED_BUTTONARRAY_WINDOW *allocate_buttonarray(DIALOG *dlg, int x, int y, int sx, int sy, int spcx, int spcy, int amx, int amy, ED_BUTTONARRLNK *buttons, int linecolor,int fillcolor,int fgcolor,int bkcolor, int linewidth, char header_height, char header_position, char filltype,char flag_moveable ,unsigned char *caption )
{
    ED_BUTTONARRAY_WINDOW   *ed_btnarr;
    int i,asx=0,asy=0;


    if(dlg==NULL) return NULL;


    if(buttonarray_amount==0){
    for(i=0;i<HARDWIRED_LIMIT_BTNARRS;i++){
        all_buttonarray_alloc[i] = 0;
        all_buttonarray_structs[i]=NULL;
        }
    buttonarray_amount++;
    }


    ed_btnarr = (ED_BUTTONARRAY_WINDOW *) malloc( sizeof(ED_BUTTONARRAY_WINDOW) );
    if(ed_btnarr==NULL) return NULL;

    // fill in default values
    ed_btnarr->amount_x = amx;
    ed_btnarr->amount_y = amy;
    ed_btnarr->linewidth = linewidth;
    ed_btnarr->button_sx = sx;
    ed_btnarr->button_sy = sy;
    ed_btnarr->buttonspace_sx = spcx;
    ed_btnarr->buttonspace_sy = spcy;
    ed_btnarr->header_height = header_height;   // default 12 pixels
    ed_btnarr->buttons_x = x;
    ed_btnarr->buttons_y = y;
    ed_btnarr->caption = caption;
    ed_btnarr->flag_display_header = 1; // default display header
    ed_btnarr->flag_use_fill=0;         // not used yet
    ed_btnarr->flag_moveable=flag_moveable;         // not used yet
    ed_btnarr->flag_shrinkable=0;       // not used yet
    ed_btnarr->flag_display_tooltips=0; // not used yet
    ed_btnarr->flag_visible_state=1;    // visible
    ed_btnarr->foreach_button_before=NULL; // callback for ALL buttons, disabled by default
    ed_btnarr->foreach_button_after =NULL; // callback for ALL buttons, disabled by default
    ed_btnarr->filltype = (int)   filltype;
    ed_btnarr->header_position = header_position & 3;    // 0 to 3

    ed_btnarr->button_structures = buttons;
    ed_btnarr->show_description = NULL;     // not used yet
    ed_btnarr->proc = ed_buttonarray_proc;
    ed_btnarr->linecolor = linecolor;
    ed_btnarr->fillcolor = fillcolor;
    ed_btnarr->fgcolor   = fgcolor;
    ed_btnarr->bkcolor   = bkcolor;
    ed_btnarr->foreground= NULL;        // bitmap, defined later on
    ed_btnarr->background= NULL;        // bitmap, defined later on
    ed_btnarr->bmplx = NULL;            // bitmap, defined later on
    ed_btnarr->bmply = NULL;            // bitmap, defined later on
    ed_btnarr->dlg   = dlg;             // remember the dialog object


    if( ed_btnarr->header_height==0 ){
        ed_btnarr->flag_display_header = 0;   // do not display header
        ed_btnarr->header_position = 0;
        ed_btnarr->flag_moveable=0;
    }


    for(i=0;i<HARDWIRED_LIMIT_BTNARRS;i++){
    // seek to first link that is free and allocate it
        if( all_buttonarray_alloc[i] == 0){     // found free
        all_buttonarray_alloc[i] = 1;           // allocate!
        all_buttonarray_structs[i] = ed_btnarr; // store location
        ed_btnarr->handle = i;            // set handle
        buttonarray_amount++;
        break;
        }
    }
    if( buttonarray_amount >= HARDWIRED_LIMIT_BTNARRS ) return NULL;



    if( ed_btnarr->flag_display_header == 0 ) i=2; else i=3;

    if( ed_btnarr->header_position == 0 || ed_btnarr->header_position == 1 ){
    ed_btnarr->array_sx = asx = spcx+(sx+spcx)*amx + ed_btnarr->linewidth*2;
    ed_btnarr->array_sy = asy = spcy+(sy+spcy)*amy + ed_btnarr->linewidth*i + ed_btnarr->header_height;
    }
    if( ed_btnarr->header_position == 2 || ed_btnarr->header_position == 3 ){
    ed_btnarr->array_sx = asx = spcx+(sx+spcx)*amx + ed_btnarr->linewidth*i + ed_btnarr->header_height;
    ed_btnarr->array_sy = asy = spcy+(sy+spcy)*amy + ed_btnarr->linewidth*2;
    }

    dlg->x = x;
    dlg->y = y;
    dlg->w = ed_btnarr->array_sx;
    dlg->h = ed_btnarr->array_sy;
    dlg->d1 = ed_btnarr->handle;
    dlg->dp  = NULL;        // Used for foreground graphic
    dlg->dp2 = NULL;        // Used for background graphic
    dlg->dp3 = ed_btnarr;   // pointer to our own structure
    dlg->proc = ed_btnarr->proc;

    // allocate bitmap for foreground and background
    dlg->dp = ed_btnarr->foreground = create_bitmap_ex( 8, asx+1,asy+1);
    if( dlg->dp == NULL ) return NULL;
    dlg->dp2 = ed_btnarr->background = create_bitmap(asx+1,asy+1);
    if( dlg->dp2 == NULL ) return NULL;

    // allocate bitmap for drawing lines
    ed_btnarr->bmplx = create_bitmap( asx+5,5);
    ed_btnarr->bmply = create_bitmap( 5,asy+5);
    if( ed_btnarr->bmplx == NULL || ed_btnarr->bmply == NULL ) return NULL;

    render_buttonarray_graphic( ed_btnarr );

    // get background
    blit( screen, ed_btnarr->background,  x, y, 0, 0, asx, asy );

    return ( ed_btnarr );
}

























/* Render buttonarray graphic to bitmap in field foreground of passed structure
 * return TRUE if ok, else FALSE.
 */
int render_buttonarray_graphic( ED_BUTTONARRAY_WINDOW *ed_btnarr )
{
    int     i,j;
    int     x,y,sx,sy, amx, amy;
    int     x1,y1,x2,y2;
    int     spcx, spcy;
    int     linewidth;
    int     header_sy;
    int     asx,asy;
    int     topx=0,topy=0;
    int     linecolor,fillcolor,fgcolor,bkcolor;
    unsigned char   *caption = NULL, filltype;
    BITMAP          *bmp, *fillmap1, *bmp1, *bmp2;

    if( ed_btnarr == NULL ) return FALSE;

    linecolor  = ed_btnarr->linecolor;
    fillcolor  = ed_btnarr->fillcolor;
    fgcolor    = ed_btnarr->fgcolor;
    bkcolor    = ed_btnarr->bkcolor;
    amx        = ed_btnarr->amount_x;
    amy        = ed_btnarr->amount_y;
    linewidth  = ed_btnarr->linewidth;
    header_sy  = ed_btnarr->header_height;
    sx         = ed_btnarr->button_sx;
    sy         = ed_btnarr->button_sy;
    spcx       = ed_btnarr->buttonspace_sx;
    spcy       = ed_btnarr->buttonspace_sy;
    asx        = ed_btnarr->array_sx;
    asy        = ed_btnarr->array_sy;
    caption    = ed_btnarr->caption;
    filltype   = ed_btnarr->filltype;

    bmp = ed_btnarr->foreground;
    if( bmp==NULL ) return FALSE;

// ==============================================================
//
// --------------------------------------------------------------
    x1 = 0;          // main shape FILL
    y1 = 0;
    x2 = asx;
    y2 = asy;
    if( filltype==0 )
    rectfill(bmp, x1,y1,x2,y2, fillcolor);

    if(filltype>0){
    // look good filltypes: 0, 5, 6

    fillmap1 = edcreate_fill_map( filltype-1, fillcolor, bkcolor );    // pattern is 0-8

    drawing_mode(DRAW_MODE_COPY_PATTERN, fillmap1, 0, 0);
//    drawing_mode(DRAW_MODE_MASKED_PATTERN, fillmap1, 0, 0);
//    drawing_mode(DRAW_MODE_SOLID_PATTERN, fillmap1, 0, 0);

    rectfill(bmp, x1,y1,x2,y2, 0 );     // color 0
    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
    eddestroy_fill_map( fillmap1 );
    }

// --------------------------------------------------------------
                // DISPLAY HEADER
    if( ed_btnarr->flag_display_header==1 ){
    if( ed_btnarr->header_position == 0 ){
        topx = linewidth;
        topy = linewidth;
    }
    if( ed_btnarr->header_position == 1 ){
        topx = linewidth;
        topy = linewidth*2 + spcy + (sy+spcy)*amy;
    }
    if( ed_btnarr->header_position == 2 ){
        topx = linewidth;
        topy = linewidth;
    }
    if( ed_btnarr->header_position == 3 ){
        topx = linewidth*2 + spcx + (sx+spcx)*amx;
        topy = linewidth;
    }
    // HEADER FILLED BLOCK
    if( ed_btnarr->header_position == 0 || ed_btnarr->header_position == 1 ){
    x1 = topx;
    y1 = topy;
    x2 = x1 + asx - linewidth*2-1;
    y2 = y1 + header_sy-1;
    rectfill(bmp, x1,y1,x2,y2, bkcolor );
    }
    if( ed_btnarr->header_position == 2 || ed_btnarr->header_position == 3 ){
    x1 = topx;
    y1 = topy;
    x2 = x1 + header_sy;
    y2 = y1 + asy - linewidth*2-1;
    rectfill(bmp, x1,y1,x2,y2, bkcolor );
    }


    if( caption != NULL ){
    // -----------------------------------------------------
        i = text_length(font,caption);    // header text
        j = text_height(font);
        text_mode(bkcolor);

        if( ed_btnarr->header_position==0 || ed_btnarr->header_position==1 ){
            x = (asx/2 - i/2);
            y = topy + header_sy/2 - j/2;
            textout( bmp, font, caption,  x, y, fgcolor );  // only if horizontal
        }

        if( ed_btnarr->header_position==2 || ed_btnarr->header_position==3 ){
        //----------------------------
        x = topx + header_sy/2 - j/2;
        y = topy + asy/2 - linewidth - i/2;
        //...
        bmp1 = create_bitmap(i,j);   clear_to_color( bmp1, bkcolor );
        bmp2 = create_bitmap(j,i);   clear_to_color( bmp1, bkcolor );
        textout( bmp1, font, caption, 0,0, fgcolor );
        if( ed_btnarr->header_position==2) edreflip_x(  bmp1 );
        edreflip_90( bmp1, bmp2 );
        if( ed_btnarr->header_position==3) edreflip_x(  bmp2 );
        blit( bmp2, bmp, 0,0,x,y, j,i );
        destroy_bitmap( bmp1 );
        destroy_bitmap( bmp2 );
        }
    } // if( caption...
    }
// --------------------------------------------------------------
                    // DRAW OUTLINES
    for(i=0;i<linewidth;i++){   // draw outlines
    x1 = i;
    y1 = i;
    x2 = asx - i-1;
    y2 = asy - i-1;
    rect(bmp, x1,y1,x2,y2,  linecolor);

    if( ed_btnarr->flag_display_header==1 ){
        if( ed_btnarr->header_position == 0 ){
            y1 = topy + header_sy + i;
            hline(bmp, x1, y1, x2, linecolor);
        }
        if( ed_btnarr->header_position == 1 ){
            y1 = topy + i - linewidth;
            hline(bmp, x1, y1, x2, linecolor);
        }
        if( ed_btnarr->header_position == 2 ){
            x1 =linewidth + header_sy + i;      // equiv
            vline(bmp, x1, y1, y2, linecolor);
        }
        if( ed_btnarr->header_position == 3 ){
            x1 = linewidth*2 + spcx + (sx+spcx)*amx - linewidth+i;  // topx equiv
            vline(bmp, x1, y1, y2, linecolor);
        }
    }

    }
// --------------------------------------------------------------
                    // DRAW MAIN BUTTONS

    if( ed_btnarr->flag_display_header == 0 ) i=1; else i=2;

    topx = topy = 0;
    if( ed_btnarr->header_position == 0 ){
    topx = spcx + linewidth;
    topy = spcy + linewidth*i + header_sy;
    }
    if( ed_btnarr->header_position == 1 ){
    topx = spcx + linewidth;
    topy = spcy + linewidth;
    }
    if( ed_btnarr->header_position == 2 ){
    topx = spcx + linewidth*i + header_sy;
    topy = spcy + linewidth;
    }
    if( ed_btnarr->header_position == 3 ){
    topx = linewidth + spcx;
    topy = linewidth + spcy;
    }
    for( y=i=0;y<amy; y++ ){     // for each button
    for( x=0;  x<amx; x++ ){
    x1 = topx + (sx+spcx)*x;
    y1 = topy + (sy+spcy)*y;
    x2 = x1 + sx;
    y2 = y1 + sy;
        if( ed_btnarr->button_structures[i].shape != NULL){
            blit( ed_btnarr->button_structures[i].shape, bmp, 0,0,x1,y1,sx,sy);
        }else{
            rectfill(bmp,x1,y1,x2,y2,0); // invalid bitmap, fill with color zero
        }
    i++;
    }}
// --------------------------------------------------------------
//
// ==============================================================
   return TRUE;
}



// ##############################################################
// ##############################################################
// ##############################################################



int ed_buttonarray_proc (int msg,DIALOG *d, int c)
{
    int i,j;
    int index=0;
    int x,y,sx,sy, amx, amy;
    int x1=0,y1=0,x2=0,y2=0;
    int spcx, spcy;
    int linewidth;
    int header_sy;
    int asx,asy;
    int linecolor,fillcolor,fgcolor,bkcolor;
    int mx,my,mb;
    ED_BUTTONARRAY_WINDOW *ed_btnarr;
    int button_index=0;         // changed by function call
    int rx1=0,ry1=0;            // changed by function call

    if(msg==MSG_IDLE) return D_O_K;

    mx = mouse_x;
    my = mouse_y;
    mb = mouse_b;


    ed_btnarr = d->dp3;
    index = d->d1;          // get our index


    linecolor  = ed_btnarr->linecolor;
    fillcolor  = ed_btnarr->fillcolor;
    fgcolor    = ed_btnarr->fgcolor;
    bkcolor    = ed_btnarr->bkcolor;
    amx        = ed_btnarr->amount_x;
    amy        = ed_btnarr->amount_y;
    linewidth  = ed_btnarr->linewidth;
    header_sy  = ed_btnarr->header_height;
    sx         = ed_btnarr->button_sx;
    sy         = ed_btnarr->button_sy;
    spcx       = ed_btnarr->buttonspace_sx;
    spcy       = ed_btnarr->buttonspace_sy;
    asx        = ed_btnarr->array_sx;
    asy        = ed_btnarr->array_sy;
    x = d->x;
    y = d->y;


    switch(msg){

    case MSG_START:
//    rectfill(screen, 5,5,350,400, 211 );
    i = render_buttonarray_graphic( ed_btnarr );
    scare_mouse();
    blit( screen, ed_btnarr->background, x,y, 0,0, asx,asy );   // get bkgr
    unscare_mouse();
    msg=D_O_K;
    break;


    case MSG_END:
    scare_mouse();
    acquire_screen();
    blit( ed_btnarr->background,screen, 0,0, x,y, asx,asy );  // put back bkgr
    release_screen();
    unscare_mouse();
    msg=D_O_K;
    break;


//    case MSG_WANTFOCUS:
//    msg = D_WANTFOCUS;
//    break;

    case MSG_GOTMOUSE:
/*
    i = check_mouse_inside_header( ed_btnarr, d->x, d->y, mx, my, &button_index, &rx1, &ry1 );

    if(i==2){       // 2 if mouse coords are inside main button area

    i = button_index;
        if( ed_btnarr->button_structures[i].tooltips_description != NULL){

        scare_mouse();
        textout(screen, font,
            ed_btnarr->button_structures[i].tooltips_description,
            200,40, 77 );
        unscare_mouse();


        }
    }

*/
    msg=D_O_K;
    break;

    case MSG_LOSTMOUSE:
    msg=D_O_K;
    break;

    case MSG_DRAW:
    acquire_screen();
    blit( ed_btnarr->foreground, screen, 0,0, x,y, asx,asy );
    release_screen();
    msg=D_O_K;
    break;







    case MSG_CLICK:

        if( mx > (d->x+1) &&
            mx < ((d->x+d->w)-1) &&
            my > (d->y+1) &&
            my < (d->y+ header_sy)
            ){
    // inside header, assuming header position 0
        }

    i = check_mouse_inside_header( ed_btnarr, d->x, d->y, mx, my, &button_index, &rx1, &ry1 );
    // i is 0 if invalid mouse coordinates or clicked on nothing
    // i is 1 if mouse coords are inside header
    // i is 2 if mouse coords are inside main button area
    if(i==0) { msg=D_O_K; break; }
// --------------------------------------------------------------
    if( i==1 && ed_btnarr->flag_moveable==1 ){       // move header

    // variables used:
    // dmx,dmy  - delta mouse x,y
    // ox,oy    - old x,y for this dialog object
    // cx,cy    - current x,y for this dialog object
    // bmplx    - linebuffer storage, for storing line background
    // bmply    - linebuffer storage, for storing line background
    // moved    - flag;  0=not moved, 1=moved
    {   //begin section
    int dmx,dmy;
    int ox,oy;
    int cx,cy;
    BITMAP *bmplx, *bmply;
    char  moved=0, finish=0;
    int deltax,deltay;

    bmplx = ed_btnarr->bmplx;
    bmply = ed_btnarr->bmply;

    cx = ox = d->x;     // cx = c
    cy = oy = d->y;     // cy = y
    dmx = mouse_x - cx; // dmx = dx
    dmy = mouse_y - cy; // dmx = dx

    scare_mouse();
    get_buttonarray_line_bk( ed_btnarr, cx, cy );
    draw_buttonarray_lines ( ed_btnarr, cx, cy );
    unscare_mouse();

    for(;;){
    //---------------------------------------
    ox = mouse_x;    oy = mouse_y;
        for(;;){
        i = (mouse_x - ox);
        j = (mouse_y - oy);
            if( i != 0 || j != 0 ){ moved=1; break;}    // there was a delta
        j = mouse_b&7;
        if( j == 0 ){ finish=1; break; }
        }
    //---------------------------------------
        if( finish==1 ){ break; }
        mx = mouse_x;
        my = mouse_y;
        if( moved==1 ){
        moved=0;
        scare_mouse();
        put_buttonarray_line_bk(ed_btnarr, cx, cy );
        cx = mx - dmx;  if(cx<0) cx=0;  // new coords
        cy = my - dmy;  if(cy<0) cy=0;  //
        get_buttonarray_line_bk( ed_btnarr, cx, cy );
        draw_buttonarray_lines ( ed_btnarr, cx, cy );
        unscare_mouse();
        }
    cx = mx - dmx;  if(cx<0) cx=0;
    cy = my - dmy;  if(cy<0) cy=0;
    } // end for(;;)...
    scare_mouse();
    put_buttonarray_line_bk(ed_btnarr, cx, cy );
    unscare_mouse();
    // --------------------------------------------------------------
    // now, do the actual move
    deltax = cx - d->x;
    deltay = cy - d->y;
    ox = d->x;
    oy = d->y;
    d->x += deltax;
    d->y += deltay;

    scare_mouse();
    acquire_screen();
    blit( ed_btnarr->background, screen, 0,0,       ox,oy,  asx,asy ); // put old background
    blit( screen, ed_btnarr->background, d->x,d->y, 0,0,    asx,asy ); // get new background
    release_screen();
    unscare_mouse();
    // --------------------------------------------------------------
    moved=finish=0;
    scare_mouse();
    ed_buttonarray_proc (MSG_DRAW,d,c);     // call self: redraw
    unscare_mouse();
    // --------------------------------------------------------------
    }   //end section
    }
    // --------------------------------------------------------------
    if(i==2){       // clicked button, use button_index
    // perform click action
    i = button_index;
    scare_mouse();
        if( ed_btnarr->button_structures[i].shape_clicked != NULL){
            blit( ed_btnarr->button_structures[i].shape_clicked, screen, 0,0,rx1,ry1,sx,sy);
        }else{
            rectfill(screen,x1,y1,x2,y2,0); // invalid bitmap, fill with color zero
        }
    unscare_mouse();
    // call function
    i = button_index;
        if( ed_btnarr->button_structures[i].button_function != NULL){
        // the index is the number for each button

        j=0;
        // call before
        if( ed_btnarr->foreach_button_before != NULL )
            j = ed_btnarr->foreach_button_before( mb, button_index );

        // call button, but only if allowed to.
        if(j==0)
            ed_btnarr->button_structures[i].button_function( mb, button_index );

        // call after
        if( ed_btnarr->foreach_button_after != NULL )
            ed_btnarr->foreach_button_after( mb, button_index );



        }
    do i=mouse_b; while( (i&7) != 0 );  // wait until mouse button is released
    // perform unclick action
    i = button_index;
    scare_mouse();
    acquire_screen();
        if( ed_btnarr->button_structures[i].shape != NULL){
            blit( ed_btnarr->button_structures[i].shape, screen, 0,0,rx1,ry1,sx,sy);
        }else{
            rectfill(screen,x1,y1,x2,y2,0); // invalid bitmap, fill with color zero
        }
    release_screen();
    unscare_mouse();
        }
// --------------------------------------------------------------
    msg=D_O_K;
    break;


    default:
    msg=D_O_K;
    break;
    }
    return msg;
}













void get_buttonarray_line_bk(ED_BUTTONARRAY_WINDOW *ed_btnarr, int cx, int cy )
{
    int i=0;
    int sx,sy, amx, amy;
    int spcx, spcy;
    int linewidth;
    int header_sy;
    int asx,asy;
    int linecolor,fillcolor,fgcolor,bkcolor;
    BITMAP *bmplx, *bmply;


    linecolor  = ed_btnarr->linecolor;
    fillcolor  = ed_btnarr->fillcolor;
    fgcolor    = ed_btnarr->fgcolor;
    bkcolor    = ed_btnarr->bkcolor;
    amx        = ed_btnarr->amount_x;
    amy        = ed_btnarr->amount_y;
    linewidth  = ed_btnarr->linewidth;
    header_sy  = ed_btnarr->header_height;
    sx         = ed_btnarr->button_sx;
    sy         = ed_btnarr->button_sy;
    spcx       = ed_btnarr->buttonspace_sx;
    spcy       = ed_btnarr->buttonspace_sy;
    asx        = ed_btnarr->array_sx;
    asy        = ed_btnarr->array_sy;
    bmplx      = ed_btnarr->bmplx;
    bmply      = ed_btnarr->bmply;

    acquire_screen();
    if( ed_btnarr->flag_display_header==1 ){
    if( ed_btnarr->header_position == 0 || ed_btnarr->header_position == 1 ){
    if( ed_btnarr->header_position == 0) i = cy+header_sy+linewidth*2-1;
    if( ed_btnarr->header_position == 1) i = cy+linewidth+spcy+(sy+spcy)*amy;
    blit( screen, bmplx,  cx+1, cy,            0,0,   asx-1, 1 );
    blit( screen, bmplx,  cx+1, i,             0,1,   asx-1, 1 );
    blit( screen, bmplx,  cx+1, (cy+asy)-1,    0,2,   asx-1, 1 );
    blit( screen, bmply,  cx, cy,              0,0,   1, asy+1 );
    blit( screen, bmply,  (cx+asx)-1,cy,       1,0,   1, asy+1 );
    }else{
    if( ed_btnarr->header_position == 2) i = cx+header_sy+linewidth*2-1;
    if( ed_btnarr->header_position == 3) i = cx+linewidth+spcx+(sx+spcx)*amx;
    blit( screen, bmply,  cx,         cy,      0,0,   1, asy-1 );
    blit( screen, bmply,  i,          cy+1,    1,0,   1, asy-1 );
    blit( screen, bmply,  (cx+asx)-1, cy,      2,0,   1, asy-1 );
    blit( screen, bmplx,  cx, cy,              0,0,   asx+1, 1 );
    blit( screen, bmplx,  cx,(cy+asy)-1,       0,1,   asx+1, 1 );
    }
    }
    release_screen();
    return;
}







void put_buttonarray_line_bk(ED_BUTTONARRAY_WINDOW *ed_btnarr, int cx, int cy )
{
    int i=0;
    int sx,sy, amx, amy;
    int spcx, spcy;
    int linewidth;
    int header_sy;
    int asx,asy;
    int linecolor,fillcolor,fgcolor,bkcolor;
    BITMAP *bmplx, *bmply;


    linecolor  = ed_btnarr->linecolor;
    fillcolor  = ed_btnarr->fillcolor;
    fgcolor    = ed_btnarr->fgcolor;
    bkcolor    = ed_btnarr->bkcolor;
    amx        = ed_btnarr->amount_x;
    amy        = ed_btnarr->amount_y;
    linewidth  = ed_btnarr->linewidth;
    header_sy  = ed_btnarr->header_height;
    sx         = ed_btnarr->button_sx;
    sy         = ed_btnarr->button_sy;
    spcx       = ed_btnarr->buttonspace_sx;
    spcy       = ed_btnarr->buttonspace_sy;
    asx        = ed_btnarr->array_sx;
    asy        = ed_btnarr->array_sy;
    bmplx      = ed_btnarr->bmplx;
    bmply      = ed_btnarr->bmply;


    acquire_screen();
    if( ed_btnarr->flag_display_header==1 ){
    if( ed_btnarr->header_position == 0 || ed_btnarr->header_position == 1 ){
    if( ed_btnarr->header_position == 0) i = cy+header_sy+linewidth*2-1;
    if( ed_btnarr->header_position == 1) i = cy+linewidth+spcy+(sy+spcy)*amy;
    blit( bmplx, screen,  0,0,  cx+1, cy,             asx-1, 1 );
    blit( bmplx, screen,  0,1,  cx+1, i,              asx-1, 1 );
    blit( bmplx, screen,  0,2,  cx+1, (cy+asy)-1,     asx-1, 1 );
    blit( bmply, screen,  0,0,  cx, cy,               1, asy+1 );
    blit( bmply, screen,  1,0,  (cx+asx)-1,cy,        1, asy+1 );
    }else{
    if( ed_btnarr->header_position == 2) i = cx+header_sy+linewidth*2-1;
    if( ed_btnarr->header_position == 3) i = cx+linewidth+spcx+(sx+spcx)*amx;
    blit( bmply, screen,   0,0,  cx,         cy,      1, asy-1 );
    blit( bmply, screen,   1,0,  i,          cy+1,    1, asy-1 );
    blit( bmply, screen,   2,0,  (cx+asx)-1, cy,      1, asy-1 );
    blit( bmplx, screen,   0,0,  cx, cy,              asx+1, 1 );
    blit( bmplx, screen,   0,1,  cx,(cy+asy)-1,       asx+1, 1 );
    }
    }
    release_screen();
    return;
}

/*
 *
 *
 */
void draw_buttonarray_lines(ED_BUTTONARRAY_WINDOW *ed_btnarr, int cx,int cy )
{
    int i=0;
    int sx,sy, amx, amy;
    int spcx, spcy;
    int linewidth;
    int header_sy;
    int asx,asy;
    int linecolor,fillcolor,fgcolor,bkcolor;

    linecolor  = ed_btnarr->linecolor;
    fillcolor  = ed_btnarr->fillcolor;
    fgcolor    = ed_btnarr->fgcolor;
    bkcolor    = ed_btnarr->bkcolor;
    amx        = ed_btnarr->amount_x;
    amy        = ed_btnarr->amount_y;
    linewidth  = ed_btnarr->linewidth;
    header_sy  = ed_btnarr->header_height;
    sx         = ed_btnarr->button_sx;
    sy         = ed_btnarr->button_sy;
    spcx       = ed_btnarr->buttonspace_sx;
    spcy       = ed_btnarr->buttonspace_sy;
    asx        = ed_btnarr->array_sx;
    asy        = ed_btnarr->array_sy;

    if( ed_btnarr->flag_display_header==1 ){
        rect( screen,  cx, cy,  cx+asx-1, cy+asy-1,  fillcolor );
        if( ed_btnarr->header_position == 0 || ed_btnarr->header_position == 1 ){
        if( ed_btnarr->header_position == 0) i = cy+header_sy+linewidth*2-1;
        if( ed_btnarr->header_position == 1) i = cy+linewidth+spcy+(sy+spcy)*amy;
        hline( screen,  cx+1, i,  cx+asx-1,  fillcolor );
        }else{
        if( ed_btnarr->header_position == 2) i = cx+header_sy+linewidth*2-1;
        if( ed_btnarr->header_position == 3) i = cx+linewidth+spcx+(sx+spcx)*amx;
        vline( screen,  i, cy+1,  cy+asy-1,  fillcolor );
        }
    }
    return;
}




/*
 * hide buttonarray
 */
void ed_hide_buttonarray( int handle )
{
    ED_BUTTONARRAY_WINDOW *ed_btnarr;

    if( all_buttonarray_alloc[ handle ]!=1 ) return; //illegal handle
    ed_btnarr = all_buttonarray_structs[ handle ];

    if( ed_btnarr->flag_visible_state==1 ){ // only disable if already visible
    ed_btnarr->flag_visible_state=0;
    ed_btnarr->dlg->flags = D_HIDDEN | D_DISABLED;
    ed_btnarr->dlg->proc(MSG_END,ed_btnarr->dlg,0);
    }

}

void ed_show_buttonarray( int handle )
{
    ED_BUTTONARRAY_WINDOW *ed_btnarr;

    if( all_buttonarray_alloc[ handle ]!=1 ) return; //illegal handle
    ed_btnarr = all_buttonarray_structs[ handle ];

    if( ed_btnarr->flag_visible_state==0 ){ // only enable if already invisible
    ed_btnarr->flag_visible_state=1;
    ed_btnarr->dlg->flags = ed_btnarr->dlg->flags & ~(D_HIDDEN | D_DISABLED);
    ed_btnarr->dlg->proc(MSG_START,ed_btnarr->dlg,0);
    ed_btnarr->dlg->proc(MSG_DRAW,ed_btnarr->dlg,0);
    }
}



/*
 * Render buttonarray with new colors
 *
 */
void ed_rerender_buttonarray( int handle,int linecolor,int fillcolor,int fgcolor,int bkcolor )
{
    ED_BUTTONARRAY_WINDOW *ed_btnarr;

    if( all_buttonarray_alloc[ handle ]!=1 ) return; //illegal handle
    ed_btnarr = all_buttonarray_structs[ handle ];

    ed_btnarr->linecolor = linecolor ;
    ed_btnarr->fillcolor = fillcolor ;
    ed_btnarr->fgcolor   = fgcolor   ;
    ed_btnarr->bkcolor   = bkcolor   ;

    render_buttonarray_graphic( ed_btnarr );
}




// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************************************************************
// ************************ HELPER FUNCTIONS



static unsigned char edfillpat[][8][8]={
{   "* * * * ",    " * * * *",    "* * * * ",    " * * * *",    "* * * * ",    " * * * *",    "* * * * ",    " * * * *"},
{   "*      *",    "      **",    "     ** ",    "    **  ",    "   **   ",    "  **    ",    " **     ",    "**      "},
{   "****    ",    "****    ",    "****    ",    "****    ",    "    ****",    "    ****",    "    ****",    "    ****"},
{   "*      *",    "**      ",    " **     ",    "  **    ",    "   **   ",    "    **  ",    "     ** ",    "      **"},
{   "        ",    "     *  ",    "    *** ",    "     *  ",    " *      ",    "***     ",    " *      ",    "        "},
{   "**  **  ",    "**  **  ",    "  **  **",    "  **  **",    "**  **  ",    "**  **  ",    "  **  **",    "  **  **"},
{   "********",    "        ",    "********",    "        ",    "********",    "        ",    "********",    "        "},
{   "* * * * ",    "* * * * ",    "* * * * ",    "* * * * ",    "* * * * ",    "* * * * ",    "* * * * ",    "* * * * "},
{   "******* ",    "*     * ",    "*  *  * ",    "* *** * ",    "*  *  * ",    "*     * ",    "******* ",    "        "}
};


static BITMAP  *map = NULL;


/* returns a newly allocated bitmap
 * pattern = 0-8
 */
static BITMAP *edcreate_fill_map( int pattern, int _color1, int _color2 )
{
    int     x,y,c = 0;
    int     color1 = _color1;
    int     color2 = _color2;

//    color1 = makecol( 250,250,250 );
//    color2 = makecol( 170,170,170 );
    pattern &= 7;
    if( map!=NULL ) destroy_bitmap( map ); map = NULL;
    map = create_bitmap( 8,8 );     if(map==NULL) return NULL;
    clear_to_color( map, 0 );
    for (y=0; y < map->h ; y++){
    for (x=0; x < map->w ; x++){
    if( edfillpat[pattern][y][x] == ' ' )
        c = color1;
    else
        c = color2;
    putpixel( map,x,y, c );
    }}
    return map;
}
static void eddestroy_fill_map( BITMAP *fillmap )
{
    if( fillmap!=NULL ) destroy_bitmap( fillmap );
}





/*
 * rotate 90 degrees a bitmap, bmp1 is the reference.
 * if bmp2 is null then create bmp2
 */
static void edreflip_90( BITMAP *bmp1, BITMAP *bmp2 )
{
    int w,h,c,x,y;

    if( bmp1==NULL ) return;
    w = bmp1->w;
    h = bmp1->h;

    if( bmp2==NULL ) {
        bmp2 = create_bitmap( h,w );
        if( bmp2==NULL ) return;
    }
    for(y=0;y<h;y++){
    for(x=0;x<w;x++){
    c = getpixel(bmp1,x,y);
    putpixel(bmp2,y,x,c);
    }}
    return;
}


/*
 * flip in x axis a bitmap
 *
 */
static void edreflip_x( BITMAP *bmp1 )
{
    int w,h,i,x,y;
    int c1,c2;

    w = bmp1->w;
    h = bmp1->h;
    i = w/2;

    for(y=0;y<h;y++){
    for(x=0;x< i ;x++){

    c1 = getpixel(bmp1,w-x-1,y);
    c2 = getpixel(bmp1,x,  y);
    putpixel( bmp1, w-x-1, y, c2);
    putpixel( bmp1, x,   y, c1);
    }}
    return;
}


/*
 *  Draws an outline rectangle with the two points as its opposite corners.
 *  draw dotted line rectangle.
 */
static void edrect_dot(BITMAP *bmp, int x1, int y1, int x2, int y2, int color)
{
    static BITMAP *bm = NULL;

    if( bm==NULL ){
    bm = create_bitmap( 2, 2 );
    if( bm != NULL ){
        putpixel(bm,0,0, 0);
        putpixel(bm,1,1, 0);
        putpixel(bm,0,1, color);
        putpixel(bm,1,0, color);
    }}
    if( bm==NULL ) return;
    drawing_mode(DRAW_MODE_MASKED_PATTERN, bm, 0, 0);
    rect(bmp,x1,y1,x2,y2,color);
    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
}



/* Exchange colors 1 & 2 in bitmap, within a rectangle */
static void edxchg_bitmap_rect(BITMAP *bmp, int color1, int color2,int x1,int y1,int sx, int sy )
{
    int x, y, c;

    for(y = y1 ; y < (y1+sy) ; y++){
    for(x = x1 ; x < (x1+sx) ; x++){
    c = getpixel(bmp,x,y);
    if ( c == color1 ) putpixel(bmp,x,y,color2);
    if ( c == color2 ) putpixel(bmp,x,y,color1);
    }}
}




// ***************************************************************************
// ***************************************************************************
// ***************************************************************************
// ***************************************************************************
// ***************************************************************************
// ***************************************************************************
// ***************************************************************************
// ***************************************************************************







/*
 *
 *
 *
 *  rad * 180                     PI * degree
 * ------------ = degree         ------------ = radians
 *    PI                            180
 *
 *
 *
 *
 */



#ifndef PI
#define PI 3.1415926535897932384626433832795f
#endif

// static const double divratio = 1.41176470588; //    360/255  (angle/fixed 16.16)


/* dialog object for rotating angle, using floating point.
 * Rotating angle is in the d1 field. Range 0 to 255 means 0 to 360 degrees.
 * The height and width must be equal. The height determines size.
 *
 */
int ed_rotatebox2(int msg,DIALOG *d, int c)
{
    double  x,y,  angle, radius, degrees;
//    double  x1,y1,x2,y2,x3,y3;
    int     x1,y1,x2,y2;
    int     mx,my,mb,px,py, flag_reverse, angle2=0, angle3=0, x_center, y_center;

    int     i,w,h,radius0;

    if(msg==MSG_START){ d->w = d->h; d->d1 = 0; }

    w  = d->w;
    h  = d->h;
    x1 = d->x;
    y1 = d->y;
    x2 = x1+w;
    y2 = y1+h;

    x_center = x1 + w/2;
    y_center = y1 + h/2;
    radius0 = w/2;



    switch( msg ){
    case MSG_IDLE:
    return D_O_K;
    break;

    case MSG_END:
    if(d->dp2!=NULL)free(d->dp2);
    d->d2=0;
    rx=ry=rotdots=0;
    return D_O_K;
    break;


    case MSG_START:
    msg=D_O_K;
    break;


    case MSG_DRAW:  // todo: fix this thingy so it displays d->d1 in angles

    rectfill(screen, x1,y1,x2,y2,d->bg);    // fill background
    rect(    screen, x1,y1,x2,y2,d->fg);    // outer quadrant
    circle( screen, x_center, y_center, radius0, d->fg );

/*
    PI * degree
   ------------ = radians
      180
*/
    angle = ( PI * (double) d->d1 ) / 127.0;
    y = sin( angle )*radius0 + y_center;
    x = cos( angle )*radius0 + x_center;
    line( screen, x_center,y_center,x,y, d->fg );

//    f2 = angle2 * divratio;


/*    rad * 180
   ------------ = degree
      PI
*/
    degrees = ( angle * 180.0 ) / PI;
    textprintf_centre( screen, font, x_center,y_center-4, d->fg, "%3d", (int) degrees );
    i = d->flags;    if( (i&D_DISABLED) != 0 );  // do nothing
    msg = D_O_K;
    break;
















    case MSG_CLICK:
    mx = mouse_x;
    my = mouse_y;
    /* inside pad */
    mb = mouse_b;


    flag_reverse = FALSE;

    px = mx - x_center;
    py = my - y_center;

    if( px > 0 && py > 0 ){    // quad 1
//    textprintf(screen,font,10,10,makecol(220,220,0),"*1*");
    }
    if( px > 0 && py <= 0 ){   // quad 2
//    textprintf(screen,font,10,10,makecol(220,220,0),"*2*");
    }
    if( px <= 0 && py <= 0 ){  // quad 3
//    textprintf(screen,font,10,10,makecol(220,220,0),"*3*");
    flag_reverse = TRUE;
    }
    if( px <= 0 && py > 0 ){  // quad 4
//    textprintf(screen,font,10,10,makecol(220,220,0),"*4*");
    flag_reverse = TRUE;
    }


    radius = sqrt (px*px + py*py);
    angle  = asin ( (double) (py/radius) ); // angle in radians
    angle2 = (angle*180.0)/PI;              // angle2 in degrees
    angle3 = (angle*127.0)/PI;              // angle3 in degrees 16.16 fixed data format. 360 degrees is 255.

    if( px > 0 && py > 0 ){    // quad 1
    }
    if( px > 0 && py <= 0 ){   // quad 2
    angle2 = ((360) - -angle2);
    angle3 = ((255) - -angle3);
    }
    if( px <= 0 && py <= 0 ){  // quad 3
    angle2 = (180 + -angle2);
    angle3 = (127 + -angle3);
    }
    if( px <= 0 && py > 0 ){  // quad 4
    angle2 = (180 - angle2);
    angle3 = (127 - angle3);
    }


    y = sin( angle )*radius0 + y_center;
    x = cos( angle )*radius0 + x_center;
    if( flag_reverse == TRUE )
        x = -cos( angle )*radius0 + x_center;


    scare_mouse();
    acquire_screen();
    rectfill(screen, x1,y1,x2,y2,d->bg);    // fill background
    rect(    screen, x1,y1,x2,y2,d->fg);    // outer quadrant
    circle( screen, x_center, y_center, radius0, d->fg );
    line( screen, x_center,y_center,x,y, d->fg );
    textprintf_centre( screen, font, x_center,y_center-4, d->fg, "%3d", angle2 );
    release_screen();
    unscare_mouse();
    d->d1 = angle3;

    msg = D_O_K;
    break;
        default:
    msg = D_O_K;
    break;
    }
    return msg;
}








