/*

GBMPBM.C  Poskanzers PBM format
Ascii(P1) or binary(P4).


     - A "magic number" for identifying the  file  type.   A  pbm
       file's magic number is the two characters "P1".

     - Whitespace (blanks, TABs, CRs, LFs).

     - A width,	formatted as ASCII characters in decimal.

     - Whitespace.

     - A height, again in ASCII	decimal.

     - Whitespace.

     - Width * height bits, each either	'1' or '0',  starting  at
       the  top-left  corner  of the bitmap, proceeding	in normal
       English reading order.

     - The character '1' means black, '0' means	white.

     - Whitespace in the bits section is ignored.

     - Characters from a "#" to	the next end-of-line are  ignored
       (comments).

     - No line should be longer	than 70	characters.

     Here is an	example	of a small bitmap in this format:
     P1
     # feep.pbm
     24	7
     0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
     0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0
     0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0
     0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0
     0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0
     0 1 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0
     0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0

     Programs that read	this format should be as lenient as  pos-
     sible, accepting anything that looks remotely like	a bitmap.

     There is also a variant on	the format, available by  setting
     the  RAWBITS  option  at compile time.  This variant is dif-
     ferent in the following ways:

     - The "magic number" is "P4" instead of "P1".

     - The bits	are stored eight per byte, high	bit first low bit
       last.

     - No whitespace is	allowed	in the bits section, and  only	a
       single  character  of  whitespace (typically a newline) is
       allowed after the height.

     - The files are eight times smaller and many times	faster to
       read and	write.




*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "standard.h"
#include "dxegbm.h"
#define GBM_ERR_PBM_BAD_M   ((GBM_ERR) 100)


/* helper functions */
static void read_posk_header(int);
/* helper functions */




typedef struct HDRtag {
unsigned char t1,t2;    /* Px type, P1,P4 */
int w;              /* width    */
int h;              /* height */
int m;              /* palette offsets */
int offset;         /* file offset after header */
}HDR;
HDR HEADER;


static GBMFT dxe_gbmft =
	{
    "Bitmap",
    "Portable BitMap (binary P4 type)",
    "PBM",
    GBM_FT_R1|
    GBM_FT_W1,
	};



static byte read_byte(int fd)
	{
	byte	b = 0;
    u_read(fd, (byte *)&b, 1);
	return ( b );
	}



static char read_char(int fd)
	{
	char	c;

    while ( (c = read_byte(fd)) == '#' )      /* Discard to end of line */
        while ( (c = read_byte(fd)) != '\n' )   {;}
    return ( c );
	}
static int read_num(int fd)
	{
    char  c;
	int	num;

    while ( isspace(c = read_char(fd)) )    {}
    num = c - '0';
    while ( isdigit(c = read_char(fd)) )    num = num * 10 + (c - '0');
	return ( num );
	}
static void read_posk_header( int fd )
	{
    u_lseek(fd, 0L, SEEK_SET);
    HEADER.t1 = read_byte(fd);
    HEADER.t2 = read_byte(fd);
    HEADER.w  = read_num(fd);
    HEADER.h  = read_num(fd);
    HEADER.m  = 0;
    HEADER.offset = u_lseek(fd, 0L, SEEK_CUR);
//    printf(" w= %d h=%d\n", HEADER.w,  HEADER.h );
    }


DLLEXPORT GBM_ERR dxe_qft(GBMFT *gbmft)
	{
    *gbmft = dxe_gbmft;
	return ( GBM_ERR_OK );
	}


static char flag=0;


DLLEXPORT GBM_ERR dxe_rhdr(char *fn, int fd, GBM *gbm, char *opt)
	{
//    char flag=0;
    fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

    read_posk_header(fd);
    if ( HEADER.t1 == 'P' && HEADER.t2 == '4' )  flag=1;  /* binary */
    if ( HEADER.t1 == 'P' && HEADER.t2 == '1' )  flag=2;  /* ascii  */
    if(flag==0) return ( GBM_ERR_BAD_MAGIC );
    if ( HEADER.w <= 0 || HEADER.h <= 0 ) return ( GBM_ERR_BAD_SIZE );
    gbm -> w   = HEADER.w;
    gbm -> h   = HEADER.h;
    gbm -> bpp = 1;
    return ( GBM_ERR_OK );
	}

DLLEXPORT GBM_ERR dxe_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
	{
//    fd=fd; gbm=gbm; gbmrgb=gbmrgb; /* Suppress 'unref arg' compiler warnings */
    return ( GBM_ERR_OK );
	}








DLLEXPORT GBM_ERR dxe_w( char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt )
{
    int     i,j, stride;
    byte    *p;
    char    s [100+1];

    u_lseek(fd, 0L, SEEK_SET);
    sprintf(s, "P4\n# Written by Generalised Bitmap Module\n%d %d\n", gbm->w, gbm->h);
    u_write(fd, s, strlen(s));
    p = data;
    stride = ((gbm->w/8+3)&~3);
    for ( i = 0 ; i<gbm->h ; i++ )
		{
        for( j=0 ; j<stride ; j++) p[j]=~p[j];
        u_write( fd, p, stride );
        p +=stride;
        }
    return ( GBM_ERR_OK );
}





DLLEXPORT char *dxe_err(GBM_ERR rc)
	{
    switch ( (int) rc )
		{
        case GBM_ERR_PBM_BAD_M:
			return ( "bad maximum pixel intensity" );
		}
	return ( NULL );
	}


DLLEXPORT GBM_ERR dxe_rdata(int fd, GBM *gbm, byte *data)
{
    int     x,y,rx,rrx,accu;
    int     i,j,k, stride;
    byte    *p;
    byte    c;

    p      = data;
    stride = ((gbm->w/8+3)& ~3);
    if(flag==0) return ( GBM_ERR_BAD_MAGIC );
    u_lseek(fd, (long) HEADER.offset, SEEK_SET);






    if(flag==1){  /* binary */
    }

    if(flag==2){  /* ascii */
        for ( y = j = 0 ; y < gbm->h ; y++ ){
        for ( x = 0     ; x < gbm->w ; x++ ){
        k = read_num( fd );
        c = 0;
        if( k&255 ) c=128;
        rx   = (x) & 7;   if( rx==0 ) accu=0;
        rrx  = ((x) & ~7) >> 3;
        accu = accu | ( c >> rx );
        p[ y * stride + rrx ] = accu ^ 255;
        }
        }

    }


/*


    for ( i = 0 ; i < gbm->h ; i++ )
		{
        u_read( fd, p, stride );                            // read scanline
        for( j=0 ; j < stride ; j++){ p[j] = p[j] ^ 255; }  // invert
        p += stride;
        }
*/


    return ( GBM_ERR_OK );
}



