#ifndef _MTDS_DLLGREY_
#define _MTDS_DLLGREY_


/*
 * DXE2
 *
 *
 * This structure is used in both the DXE and the calling code.
 * It is used for communication.
 *
 *     Icon bitmap character types:
 *         background color
 *       * foreground color1
 *       # foreground color2
 *       $ foreground color3
 *       % foreground color4
 *       & foreground color5
 *
 */

typedef struct MTDS {               // all methods are non sticky (sticky flag==0)
unsigned char  class[ 24 ];            // method are sorted in class and type
unsigned char  author[ 24 ];           // Author of this dxe
unsigned char  compiled_date[ 24 ];    // when this module was compiled
unsigned char  version[ 10 ];          // version of this module
unsigned char  tooltips[ 16 ];         //
unsigned char  description[ 64 ];      //
unsigned char  help[ 255 ];            //
unsigned char  icon_unpressed[ 32*32 ];// bitmaps is 30x30 pixels size
unsigned char  icon_pressed[   32*32 ];// bitmaps is 30x30 pixels size
int     pre_callback_type;      // 0=disabled,1=type1,2=type2  ( type of screen update )
int     post_callback_type;     // 0=disabled,1=type1,2=type2  ( type of screen update )
int     invoke_dialog;          // 0=no or 1=yes, This plugin invokes a dialog
int     obey_loop_flag;         // 0=no or 1=yes, multiple invocations
int     type;                   // 0=undefined, 1=grey, 2=rgb, 3=paletted
} MTDS;


#endif
