/*
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"GREY",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"8 level agrey",
"Reduce source to 8 levels grey, low contrast expansion.",
"Turn a grey level image into a 8 range grey level image.Expanding low-contrast images",
"                              "
"                ***           "
"              *****           "
"            *** ***           "
"   ***    ***   ***           "
"   ***  ***********           "
"   **  ****   ****            "
"   **  ****   ****            "
"   **                         "
"   *********       ****       "
"   *********      ******      "
"   **     **     **    **     "
"   **     **     **    **     "
"   **     **     **    **     "
"   *********      **  ***     "
"   *********       ****       "
"   **     **       ****       "
"   **     **      **  **      "
"   **     **     **    **     "
"   *********     **    **     "
"   *********     **    **     "
"   **     **     ***  ***     "
"   **     **      ******      "
"   **     **                  "
"   *********                  "
"   *********                  "
"                              "
"                              "
"                              "
"                              ",
"******************************"
"*********** ******************"
"**********   *****************"
"*********  *  ****************"
"***   **  ***  ***************"
"***   *         **************"
"***  **   ***   **************"
"***  *****  ******************"
"***  *****  ******************"
"***         *******    *******"
"***         ******  **  ******"
"***  *****  *****  ****  *****"
"***  *****  *****  ****  *****"
"***  *****  *****  ****  *****"
"***         *****  ****  *****"
"***         ******  **  ******"
"***  *****  *******    *******"
"***  *****  ******      ******"
"***  *****  *****  ****  *****"
"***         *****  ****  *****"
"***         *****  ****  *****"
"***  *****  ******  **   *****"
"***  *****  *******    *******"
"***  *****  ******************"
"***         ******************"
"***         ******************"
"******************************"
"******************************"
"******************************"
"******************************",
1,2,0,1,0
};


static int  lim0,lim1,lim2,lim3,lim4,lim5,lim6,lim7,lim8;   // source
static int  ran0,ran1,ran2,ran3,ran4,ran5,ran6,ran7,ran8;   // source
static int  zim0,zim1,zim2,zim3,zim4,zim5,zim6,zim7,zim8;   // 0-255
static int  zan0,zan1,zan2,zan3,zan4,zan5,zan6,zan7,zan8;   // 0-255


static int approximate8to255( int color );



/* approximate grayscale to 8 levels greyscale on range 0 to 255
 */
static int approximate8to255( int color )
{
    if( lim0 <= color && color <= lim1 ) return zan0;
    if( lim1 <= color && color <= lim2 ) return zan1;
    if( lim2 <= color && color <= lim3 ) return zan2;
    if( lim3 <= color && color <= lim4 ) return zan3;
    if( lim4 <= color && color <= lim5 ) return zan4;
    if( lim5 <= color && color <= lim6 ) return zan5;
    if( lim6 <= color && color <= lim7 ) return zan6;
    if( lim7 <= color && color <= lim8 ) return zan7;
    if( lim0 > color ) return 0;    // underflow
    return 255;                     // overflow
}


DLLEXPORT void dxemod_init(){}
DLLEXPORT void dxemod_deinit(){}
DLLEXPORT int dxemod_method (BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     x,y, i, j, e;
    int     sum=0, num=0;
    int     minval, maxval, average;
    int     range_median, delta_range;

    if( src==NULL ) return -1;

    maxval = 0;
    minval = 255;
    sum = num = 0;
    for(y=y1; y<(y1+sy); y++){   // get image extremes of sample image
    for(x=x1; x<(x1+sx); x++){
    e = v_getpixel(src,x,y) & 255;
    if(e>maxval) maxval = e;
    if(e<minval) minval = e;
    sum += e;   // the sum of grey levels
    num++;      // number of pixels
    }}
    average      = sum / num;               // average grey value
    delta_range  = maxval - minval;         // range of values
    range_median = (maxval + minval) / 2;   //

    i = delta_range / 8;    j = i / 2;
    lim0 = minval + i * 0;      ran0 = lim0 + j;
    lim1 = minval + i * 1;      ran1 = lim1 + j;
    lim2 = minval + i * 2;      ran2 = lim2 + j;
    lim3 = minval + i * 3;      ran3 = lim3 + j;
    lim4 = minval + i * 4;      ran4 = lim4 + j;
    lim5 = minval + i * 5;      ran5 = lim5 + j;
    lim6 = minval + i * 6;      ran6 = lim6 + j;
    lim7 = minval + i * 7;      ran7 = lim7 + j;
    lim8 = minval + i * 8;      ran8 = lim8 + j;
    i = 255 / 8;    j = i / 2;
    zim0 =          i * 0;      zan0 = zim0 + j;
    zim1 =          i * 1;      zan1 = zim1 + j;
    zim2 =          i * 2;      zan2 = zim2 + j;
    zim3 =          i * 3;      zan3 = zim3 + j;
    zim4 =          i * 4;      zan4 = zim4 + j;
    zim5 =          i * 5;      zan5 = zim5 + j;
    zim6 =          i * 6;      zan6 = zim6 + j;
    zim7 =          i * 7;      zan7 = zim7 + j;
    zim8 =          i * 8;      zan8 = zim8 + j;
    for(y=y1;y<(y1+sy);y++){
    for(x=x1;x<(x1+sx);x++){
    v_putpixel(src,x,y, approximate8to255(  v_getpixel(src,x,y)  ));
    }}
    return 0;
}

