/*
 * uses popup to ask for gamma value,
 * note: must fix multiple invocations
 */
#include <stdio.h>
#include <math.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../dlg.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"GREY",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"Gamma corr.",
"gamma correction ",
"Do gamma correction on image block. Darker values are more enhanced than white values.",
"                              "
"                              "
"  **************************  "
"  *           **         ***  "
"  *                  *******  "
"  *             ******  ** *  "
"  *         *********  **  *  "
"  *       ******      **   *  "
"  *      ***         **    *  "
"  *      **         **     *  "
"  *     ***   **   **      *  "
"  *    **     **  **       *  "
"  *    **        **        *  "
"  *   **        **         *  "
"  **  **  **  *** **  **  **  "
"  **  **  **  **  **  **  **  "
"  *   *      **            *  "
"  *  **     **             *  "
"  *  **    ** **           *  "
"  *  *    **  **           *  "
"  *  *   **                *  "
"  * **  **                 *  "
"  * *  **     **           *  "
"  * * **      **           *  "
"  * ***                    *  "
"  * **                     *  "
"  ***         **           *  "
"  **************************  "
"                              "
"                              ",
"******************************"
"******************************"
"**                          **"
"** ***********  *********   **"
"** ******************       **"
"** *************      **  * **"
"** *********         **  ** **"
"** *******      ******  *** **"
"** ******   *********  **** **"
"** ******  *********  ***** **"
"** *****   ***  ***  ****** **"
"** ****  *****  **  ******* **"
"** ****  ********  ******** **"
"** ***  ********  ********* **"
"**  **  **  **   *  **  **  **"
"**  **  **  **  **  **  **  **"
"** *** ******  ************ **"
"** **  *****  ************* **"
"** **  ****  *  *********** **"
"** ** ****  **  *********** **"
"** ** ***  **************** **"
"** *  **  ***************** **"
"** * **  *****  *********** **"
"** * *  ******  *********** **"
"** *   ******************** **"
"** *  ********************* **"
"**   *********  *********** **"
"**                          **"
"******************************"
"******************************",
1,0,1,1,0
};

static double gammavalue = 1.0, retval = -1.0;

DLLEXPORT void dxemod_init()
{
    retval = v_dlg_request_float(" Gamma value ",0.1, gammavalue , 9.0);
    if( retval >= 0.0 ) gammavalue = retval;
}
DLLEXPORT void dxemod_deinit(){}
DLLEXPORT int dxemod_method ( BITMAP *src, int x1, int y1, int sx, int sy )
{
    int x,y;
    int c=0, ru,gu,bu;
    double ig = 0.0, p ,f;

    if( retval < 0.0 ) return -1;         // cancel was pressed
    if( gammavalue < 0.0 ) return -1;
    if( gammavalue != 0.0 )  ig = 1.0/gammavalue;  else  ig = 0.0;
    for(y=y1; y<(y1+sy); y++) {
    for(x=x1; x<(x1+sx); x++) {
        if(g->bpp<=8){
            c = v_getpixel(src,x,y);
            f = c;
            p = pow( f/255.0, ig ) * 255.0;     // math.h
            c = p;
            v_putpixel(src,x,y, c );
        }else{
            c = v_getpixel(src,x,y);
            f = v_getr(c);
            p = v_pow( f/255.0, ig ) * 255.0;
            ru = p;
            f = v_getg(c);
            p = v_pow( f/255.0, ig ) * 255.0;
            gu = p;
            f = v_getb(c);
            p = v_pow( f/255.0, ig ) * 255.0;
            bu = p;
            v_putpixel(src,x,y,  v_makecol(ru,gu,bu) );
        }
    }}
    return 0;
}

