/*
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../dlg.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"EDGE",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"Emboss XY",
"Emboss Image with diode and range expansion",
"Emboss Horizontally, Vertically.",
"                              "
"                              "
"  **************************  "
"  ***********************  *  "
"  **********************   *  "
"  *********************    *  "
"  *****               *    *  "
"  *****  ** *  * * *       *  "
"  *****  ********  *  *    *  "
"  *****   ****** * *       *  "
"  *****  ***     * *  *    *  "
"  *****   **     * *       *  "
"  *****  ***     * *  *    *  "
"  *****   **     * *       *  "
"  *****  ***     * *  *    *  "
"  *****   **     * *       *  "
"  *****  ***     * *  *    *  "
"  *****   **     * *       *  "
"  *****  ***     * *  *    *  "
"  *****    ******* *       *  "
"  *****  *         *  *    *  "
"  *****  ***********       *  "
"  *****               *    *  "
"  ****** * * * * * * **    *  "
"  ***                      *  "
"  **                       *  "
"  *                        *  "
"  **************************  "
"                              "
"                              ",
"******************************"
"******************************"
"**                          **"
"**                       ** **"
"**                      *** **"
"**                     **** **"
"**     *************** **** **"
"**     **  * ** * * ******* **"
"**     ** ********  ** **** **"
"**     **********   ******* **"
"**     ** *******   ** **** **"
"**     **********   ******* **"
"**     ** *******   ** **** **"
"**     **********   ******* **"
"**     ** *******   ** **** **"
"**     **********   ******* **"
"**     ** *******   ** **** **"
"**     **********   ******* **"
"**     ** *******   ** **** **"
"**     ****         ******* **"
"**     **           ** **** **"
"**     **           ******* **"
"**     *************** **** **"
"**      * * * * * * *  **** **"
"**   ********************** **"
"**  *********************** **"
"** ************************ **"
"**                          **"
"******************************"
"******************************",
1,0,0,1,0
};     




DLLEXPORT void dxemod_init()
{
    if( g->dxe_bitmap==NULL )
        g->dxe_bitmap = v_create_bitmap( g->sx+2, g->sy+2 );
}
DLLEXPORT void dxemod_deinit(){}


#define UP   11
#define DOWN 22

/*
 * Changes greater than threshold mark an edge.
 * Should be used after EMBOSS method, to detect edges
 * return -1 on error
 */
DLLEXPORT int dxemod_method (BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     x=0, y=0,ylim,xlim;
    int     x2,x3;
    int     y2,y3;
    int     d1, d2, da, db;
    int     black, white, grey, growl, p, color;

    if( src==NULL ) return -1;
    dxemod_init();    if( g->dxe_bitmap==NULL ) return -1;
    white = 255;
    grey = growl = 128;
    black = 0;
    v_clear_to_color(  g->dxe_bitmap, growl );

    ylim = y1+sy;
    xlim = x1+sx;
    for(y=y1;y<ylim;y++){
    for(x=x1;x<xlim;x++){
    x2 = x-1;   if( x2 < x1 ) x2 = x1;  // don't go negative
    x3 = x;
    da = v_getpixel( src, x2, y ) & 255;
    db = v_getpixel( src, x3, y ) & 255;
    d1 = da-db;    d2 = db-da;
    grey = d1;    if( d1 < 0 ) grey = d2;
//    grey *= 2;
    if( grey > 255 ) grey = 255;
    v_putpixel( g->dxe_bitmap,x,y, grey & 255 );
    }}



    for(x=x1;x<xlim;x++){
    for(y=y1;y<ylim;y++){
    y2 = y-1;   if( y2 < y1 ) y2 = y1;  // don't go negative
    y3 = y;
    da = v_getpixel( src, x, y2 ) & 255;
    db = v_getpixel( src, x, y3 ) & 255;
    d1 = da-db;    d2 = db-da;
    grey = d1;    if( d1 < 0 ) grey = d2;
    color = grey;
    p = v_getpixel( g->dxe_bitmap,x,y ) & 255;
    if( p > grey )  color = p;
//    color *= 2;
    if( color > 255 ) color = 255;
    v_putpixel( g->dxe_bitmap,x,y, color&255 );
    }}


    v_blit( g->dxe_bitmap, src, x1,y1,x1,y1,sx,sy );
    return 0;
}


