/*
 * The skeleton of a region
 * Algorithm as described in book 'Digital Image processing'
 *  by Rafael C. Gonzalez and Richard E. Woods
 *  Addison Wesley Publishing Company - world student series
 *   ISBN 0-201-60078-1
 *  page 491 to 494.
 *
 * Only one pixel shrink implemented at a time, so the user can see
 * the incremental effect by calling the function many times over.
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"BINOP",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"skeletics",
"Shrink binary image by one pixel",
"Skeletizise image one pixel, make image thinner by one pixel",
"                              "
"                              "
"                              "
"                              "
"                              "
"           *******            "
"         **********           "
"         **   **  **          "
"         **   **  **          "
"         ***********          "
"          **** ****           "
"           *** ***            "
"            *****             "
"              *               "
"              **              "
"          *********           "
"         **   **   **         "
"        **    **    **        "
"              **              "
"             ***              "
"            ** **             "
"           **   **            "
"          **     **           "
"          **     **           "
"          **     **           "
"                              "
"                              "
"                              "
"                              "
"                              ",
"******************************"
"******************************"
"******************************"
"******************************"
"******************************"
"***********       ************"
"*********          ***********"
"*********  ***  **  **********"
"*********  ***  **  **********"
"*********           **********"
"*********     *     **********"
"************  *  *************"
"************     *************"
"************** ***************"
"************** ***************"
"************     *************"
"**********  ** **  ***********"
"********  **** ****  *********"
"******* ****** ****** ********"
"*************  ***************"
"************ ** **************"
"*********** **** *************"
"********** ****** ************"
"********** ****** ************"
"********** ****** ************"
"******************************"
"******************************"
"******************************"
"******************************"
"******************************",
1,2,0,1,0
};     

static int removed_pixels = 0;
static unsigned char puxil( BITMAP *, int, int );
static void mark_for_removal( BITMAP *src, int x1, int y1, int sx, int sy, BITMAP *remov, int fg, int step );

// return a pixel, 0=background color, 1=foreground color
static unsigned char puxil( BITMAP *src, int x, int y )
{
    int     a;
    unsigned char retval = 0;

    a = v_getpixel( src,x,y );
    if( a <= 33 )  retval = 0;
    if( a >  33  ) retval = 1;
    return  retval;
}

static void mark_for_removal( BITMAP *src, int x1, int y1, int sx, int sy, BITMAP *remov, int fg, int step )
{
    int     x,y;
    unsigned char    p1,p2,p3,p4,p5,p6,p7,p8,p9;
    unsigned char    s, n;

    for(y=y1; y<(y1+sy); y++) {
    for(x=x1; x<(x1+sx); x++) {
    p9=puxil(src,x+0,y+0);   p2=puxil(src,x+1,y+0);   p3=puxil(src,x+2,y+0);
    p8=puxil(src,x+0,y+1);   p1=puxil(src,x+1,y+1);   p4=puxil(src,x+2,y+1);
    p7=puxil(src,x+0,y+2);   p6=puxil(src,x+1,y+2);   p5=puxil(src,x+2,y+2);
    n = p2+p3+p4+p5+p6+p7+p8+p9;
    s = 0;
    if( p2==0 && p3==1 ) s++;
    if( p3==0 && p4==1 ) s++;
    if( p4==0 && p5==1 ) s++;
    if( p5==0 && p6==1 ) s++;
    if( p6==0 && p7==1 ) s++;
    if( p7==0 && p8==1 ) s++;
    if( p8==0 && p9==1 ) s++;
    if( p9==0 && p2==1 ) s++;
        if( n == 2 || n == 3 || n == 4 || n == 5 ||  n == 6 ){
        if( s == 1){
        if( step==1 ){
        if( (p4==0 || p6==0) ||
            (p2==0 && p8==0)            ){
            removed_pixels++;
            v_putpixel( remov, x+1,y+1, fg );
            }}
        if( step==2 ){
        if( (p2==0 || p8==0) ||
            (p4==0 && p6==0)            ){
            removed_pixels++;
            v_putpixel( remov, x+1,y+1, fg );
            }}
        }}
    }}
}


DLLEXPORT void dxemod_init()
{
    if( g->dxe_bitmap==NULL )
        g->dxe_bitmap = v_create_bitmap( g->sx+2, g->sy+2 );
}
DLLEXPORT void dxemod_deinit(){}
DLLEXPORT int dxemod_method (BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     x,y;
    int     bk, fg;

    dxemod_init();    if( g->dxe_bitmap==NULL ) return -1;
    if( src==NULL ) return -1;
    bk = 0;         // backgropund
    fg = 255;       // foreground
//    bk = g->usercolor3;
//    fg = g->usercolor1;
    v_clear_to_color(  g->dxe_bitmap, bk );

//    for(;;){
    removed_pixels = 0;     // number of removed pixels
    mark_for_removal(  src, x1, y1, sx, sy,  g->dxe_bitmap, fg, 1 );   // step 1
    // remove pixels marked for removal;
    for(y=y1; y<(y1+sy); y++) {
    for(x=x1; x<(x1+sx); x++) {
    if( v_getpixel(  g->dxe_bitmap, x+1,y+1) == fg ){
        v_putpixel( src,     x+1,y+1, bk );      // remove pixel
        v_putpixel( g->dxe_bitmap , x+1,y+1, bk );
        }
    }}
    mark_for_removal(  src, x1, y1, sx, sy,  g->dxe_bitmap, fg, 2 );   // step 2
     // remove pixels marked for removal;
    for(y=y1; y<(y1+sy); y++) {
    for(x=x1; x<(x1+sx); x++) {
    if( v_getpixel(  g->dxe_bitmap, x+1,y+1) == fg ){
        v_putpixel( src,     x+1,y+1, bk );      // remove pixel
        v_putpixel(  g->dxe_bitmap, x+1,y+1, bk );
        }
    }}
//    if( removed_pixels == 0 ) break;
//    }
    // if removed_pixels == 0 on reaching here, then we are done
    return 0;
}

