/*
 *
 * TODO: x1,y2,sx,sy ...make sure methods work in a box
 *       Allocation of graphic block should be done globally
 *
 * Make Linked lists to store hlines and vlines in them
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../dlg.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"PATTERN",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"to 4x4box",
"Link boxes of 4x4 pixels",
"Make image into 4x4 pixel boxes, linked if equal, remove separated boxes",
"                              "
"                              "
"           ********           "
"           *      *           "
"    ********  **  ********    "
"    *      *      *      *    "
"    *      ********      *    "
"    *                    *    "
"    *                    *    "
"    *                    *    "
"    *                    *    "
"  **************************  "
"  **************************  "
"  ***  **  ****  ****  *****  "
"  ***  **  ****  ****  *****  "
"  ***      *****  **  ******  "
"  ***  **  ******    *******  "
"  ***  **  *******  ********  "
"  **************************  "
"    *                    *    "
"    *                    *    "
"    *                    *    "
"    *                    *    "
"    *      ********      *    "
"    *      *      *      *    "
"    ********  **  ********    "
"           *      *           "
"           ********           "
"                              "
"                              ",
"******************************"
"******************************"
"***********        ***********"
"*********** ****** ***********"
"****        **  **        ****"
"**** ****** ****** ****** ****"
"**** ******        ****** ****"
"**** ******************** ****"
"**** ******************** ****"
"**** ******************** ****"
"**** ******************** ****"
"**                          **"
"**                          **"
"**   **  **    **    **     **"
"**   **  **    **    **     **"
"**   ******     **  **      **"
"**   **  **      ****       **"
"**   **  **       **        **"
"**                          **"
"**** ******************** ****"
"**** ******************** ****"
"**** ******************** ****"
"**** ******************** ****"
"**** ******        ****** ****"
"**** ****** ****** ****** ****"
"****        **  **        ****"
"*********** ****** ***********"
"***********        ***********"
"******************************"
"******************************",
1,0,1,1,0
};     





// *******************************************************

#define INTERPRET_GREY_MIDRANGE   11
#define INTERPRET_GREY_LOWRANGE   22
#define INTERPRET_GREY_HIGHRANGE  33


typedef struct HV_BOX {     // 4x4 pixels box
    int     minval;         // minimum grey value
    int     maxval;         // maximum grey value
    int     average;        // Average grey value
    int     median;         // Median grey value
    int     type;      // TYPE_UNDEF (default), TYPE_0, ... TYPE_9
    int     x,y;            // original bitmap coordinates, top, left for this block
    int     asis[16];       // as-is binaryzed pixel
} HV_BOX;

#define TYPE_UNDEF   0      // default undefined
#define TYPE_0       254    // background full block
#define TYPE_1       253    // foreground full block
#define TYPE_2       252    // horizontal down, the down part is foreground
#define TYPE_3       251    // hv down
#define TYPE_4       250    // vertical right
#define TYPE_5       249    // hv up left
#define TYPE_6       248    // horizontal up
#define TYPE_7       247    // hv up right
#define TYPE_8       246    // vertical left
#define TYPE_9       245    // hv down left
#define TYPE_UNKNOWN 244    // Could not determine type, not of 8 types

/*
Allocated image size/4 of pointers to structures of type:  HV_BOX
If pointer is NULL, assumed type is 0 (background) for the current 4x4 block,
although this should not happen, since all 4x4 blocks should be allocated.
objects consists of 4x4 boxes linked together, of same kind of properties.
*/

static HV_BOX **boxes = NULL;       // allocated structure
static int  maxboxindex = 0;        // maximum size of allocation (do not exceed)
// global data relating to source picture
static int  box_sx = 0;          // image size horizontal (X) / 4
static int  box_sy = 0;          // image size vertical   (Y) / 4
static int  box_minval = 255;    // minimum grey value
static int  box_maxval = 0;      // maximum grey value
static int  box_sum = 0;         // sum of grey values
static int  box_num = 0;         // number of pixels
static int  box_average = 0;     // average grey levels. ( sum / num )
static byte box_histogram[256];  // Histogram of image
static BITMAP *source = NULL;    // copy of source bitmap, globally accesible

/*
    Bitmap - Source image
    Box    - Source image statistics
    hv_box - Single 4x4 pixels image
    Obj    - Object consisting of 4x4 linked blocks
*/

// *******************************************************






static int grey_to_binary( int, int  );
static void inspect_block( HV_BOX * );
static int scan_boxes_into_types();
static int scan_boxes_into_types2();
static int scan_bitmap_into_boxes( BITMAP *src, int x1, int y1, int sx, int sy );
static HV_BOX *alloc_box( int, int, int, int );
static void free_boxes();
static int remove_isolated_boxes( int bk_type, int fg_type );
static void set_box( HV_BOX *hv, int x, int y );
static HV_BOX *get_box( int x, int y );
static void paste_into_bitmapb( BITMAP * );





static unsigned char pix( BITMAP *src, int x, int y );
// return a pixel, 0=background color, 1=foreground color
static unsigned char pix( BITMAP *src, int x, int y )
{
    int     a=0;
    unsigned char retval = 0;

    a = v_getpixel( src,x,y ) & 255;
    retval = a;
    return  retval;
}












//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************


static int col_bk = 0, col_undef = 128, col_fg = 255;  // global colors for bitmap
static int hysteres_positive = 32, retval1 = -1;
static int hysteres_negative = 64, retval2 = -1;

DLLEXPORT void dxemod_init()
{
    retval1 = v_dlg_request_uchar( "positive distance", 1, hysteres_positive, 127);
    retval2 = v_dlg_request_uchar( "negative distance", 1, hysteres_negative, 127);
    if( retval1 > 0 ) hysteres_positive = retval1;
    if( retval2 > 0 ) hysteres_negative = retval2;
    if( g->dxe_bitmap == NULL ){
       if( g->sx < 3 || g->sy < 3 ) return;
       g->dxe_bitmap = v_create_bitmap( g->sx+2, g->sy+2  );
    }
}
DLLEXPORT void dxemod_deinit(){}
DLLEXPORT int dxemod_method ( BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     i;

    if( src==NULL ) return -1;
    if( retval1 < 0 ) return -1;         // cancel was pressed
    if( retval2 < 0 ) return -1;         // cancel was pressed
    if( hysteres_positive <= 0) return -1;
    if( hysteres_negative <= 0) return -1;
    if( g->dxe_bitmap==NULL) return -1;
    maxboxindex = ((sx+6)/4) * ((sy+6)/4);
    if( boxes == NULL ){
        boxes = (HV_BOX **) malloc ( maxboxindex * sizeof( HV_BOX * ) );
        if( boxes == NULL ){    // allocation failed
            maxboxindex = 0; return -1;
        }else{
            for(i=0;i< maxboxindex ;i++) boxes[i] = NULL;
        }
    }
    col_bk    = 0;
    col_undef = 128;
    col_fg    = 255;
    //...
    box_maxval = 0;
    box_minval = 255;
    box_sum = box_num = box_average = 0;
    box_sx = sx / 4;
    box_sy = sy / 4;
    for(i=0;i<256;i++) box_histogram[i] = 0;
    source = src;
    //...
    i = scan_bitmap_into_boxes( src, x1, y1, sx, sy );
        if( i ==-1 ){   // out-of-memory
        free_boxes();
        return -1;
        }
    i = scan_boxes_into_types();    // background, foreground, etc.
    i = scan_boxes_into_types2();   // additional adjustment

    // ---------------------------------------------
    remove_isolated_boxes( TYPE_0, TYPE_1 );

    // ---------------------------------------------
    v_clear_bitmap(  g->dxe_bitmap );
    paste_into_bitmapb( g->dxe_bitmap );        // extract data from linked list into TMP bitmap
    // ---------------------------------------------

    v_blit(  g->dxe_bitmap, src, 0,0,x1,y1, sx,sy );
    free_boxes();
    return 0;
}

//        *************************************************
//        *************************************************
//        *************************************************














static HV_BOX *alloc_box( int tx, int ty, int x, int y )
{
    HV_BOX  *hv = NULL;
    int     i;

    if(boxes==NULL) return NULL;

    hv = (HV_BOX *) malloc ( sizeof(HV_BOX) + 16  );  if( hv == NULL ) return NULL;
    hv->minval         = 255;
    hv->maxval         = 0;
    hv->average        = 0;
    hv->median         = 0;
    hv->type      = TYPE_UNDEF;
    hv->x              = x;
    hv->y              = y;
    for(i=0;i<16;i++) hv->asis[i] = 0;
    //... insert into place
    set_box( hv, tx, ty );
    return hv;
}
static void free_boxes()
{
    HV_BOX  *hv = NULL;
    int     i;

    if( boxes == NULL ) return;
    for(i=0;i< (maxboxindex-4) ;i++){
    hv = boxes[i];
    if( hv != NULL ){ free( hv ); boxes[i] = NULL; }
    }
    if( boxes != NULL ) free( boxes );    boxes = NULL;    maxboxindex = 0;
}
// This is the only way to get a box of 4x4 structure
static HV_BOX *get_box( int x, int y )
{
    HV_BOX  *hv;
    int     i;

    if( y < 0 ) y = box_sy - 1;
    if( x < 0 ) x = box_sx - 1;
    if( boxes == NULL ) return NULL;
    i =  y * box_sx + x;
    if( i > maxboxindex ) i = maxboxindex; // make sure we don't get outsize buffer
    hv = boxes[ i ];
    return hv;
}
// This is the only way to set a box of a 4x4 structure
static void set_box( HV_BOX *hv, int x, int y )
{
    int     i;

    if( boxes == NULL ) return;
    i =  y * box_sx + x;
    if( i > maxboxindex ) i = maxboxindex; // make sure we don't get outsize buffer
    boxes[ i ] = hv;
}


static int grey_to_binary( int value, int interpret_type  )
{
    int     lim1, lim2, retval=0;

    lim1 = (box_maxval - hysteres_positive);
    lim2 = (box_minval + hysteres_negative);
    if( interpret_type == INTERPRET_GREY_MIDRANGE ){
        if( value >= lim1 || value <= lim2 )
            retval = 1;  // above or below is set
        else
            retval = 0;  // background, undefined greyscales (midranges)
    }
    if( interpret_type == INTERPRET_GREY_HIGHRANGE ){
        if( value >= lim1 )
            retval = 1;  // above is set
        else
            retval = 0;  // background, lower greyscales (darker)
    }
    if( interpret_type == INTERPRET_GREY_LOWRANGE ){  // (inverted picture)
        if( value <= lim2 )
            retval = 1;  // below is set
        else
            retval = 0;  // background, higher greyscales (lighter)
    }
    return retval;
}










// Not ready yet
// Remove isolated boxes of fg_type (foreground),
// surrounded by boxes of bk_type (background)
static int remove_isolated_boxes( int bk_type, int fg_type )
{

/*
    if( boxes == NULL ) return;
    for( y=0 ; y < box_sy ; y++ ) {
    for( x=0 ; x < box_sx ; x++ ) {
        hv = get_box( x, y );        if( hv == NULL ) return;
            if( hv != NULL ){
            if( hv->type == TYPE_0 )
                v_rectfill( zmp, x*4, y*4, x*4+4, y*4+4, col_bk );
            if( hv->type == TYPE_1 )
                v_rectfill( zmp, x*4, y*4, x*4+4, y*4+4, col_fg );
            }
    }}
*/
    return 0;
}





static int scan_bitmap_into_boxes( BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     i, j, x, y, tx,ty, ylim,xlim, sum;
    unsigned char    a, b, c[16];
    HV_BOX  *hv;

    box_minval = 255;
    box_maxval = 0;
    box_sum = 0;
    box_num = 0;
    box_average = 0;
    for(i=0;i<256;i++) box_histogram[i] = 0;
    ylim = y1+sy;
    xlim = x1+sx;
    for(y = y1, ty=0; y < ylim ; y += 4, ty++) {
    for(x = x1, tx=0; x < xlim ; x += 4, tx++) {
    hv = alloc_box( tx, ty, x,y );   if( hv==NULL ) return -1;
    c[ 0]=pix(src,x+0,y+0); c[ 1]=pix(src,x+1,y+0); c[ 2]=pix(src,x+2,y+0); c[ 3]=pix(src,x+3,y+0);
    c[ 4]=pix(src,x+0,y+1); c[ 5]=pix(src,x+1,y+1); c[ 6]=pix(src,x+2,y+1); c[ 7]=pix(src,x+3,y+1);
    c[ 8]=pix(src,x+0,y+2); c[ 9]=pix(src,x+1,y+2); c[10]=pix(src,x+2,y+2); c[11]=pix(src,x+3,y+2);
    c[12]=pix(src,x+0,y+3); c[13]=pix(src,x+1,y+3); c[14]=pix(src,x+2,y+3); c[15]=pix(src,x+3,y+3);
        for( i = 0 ; i<16 ; i++ ){        // bubble sort for this block
            if( c[ 0] > c[ 1] ){ b = c[ 0]; c[ 0] = c[ 1]; c[ 1] = b; }
            if( c[ 1] > c[ 2] ){ b = c[ 1]; c[ 1] = c[ 2]; c[ 2] = b; }
            if( c[ 2] > c[ 3] ){ b = c[ 2]; c[ 2] = c[ 3]; c[ 3] = b; }
            if( c[ 3] > c[ 4] ){ b = c[ 3]; c[ 3] = c[ 4]; c[ 4] = b; }
            if( c[ 4] > c[ 5] ){ b = c[ 4]; c[ 4] = c[ 5]; c[ 5] = b; }
            if( c[ 5] > c[ 6] ){ b = c[ 5]; c[ 5] = c[ 6]; c[ 6] = b; }
            if( c[ 6] > c[ 7] ){ b = c[ 6]; c[ 6] = c[ 7]; c[ 7] = b; }
            if( c[ 7] > c[ 8] ){ b = c[ 7]; c[ 7] = c[ 8]; c[ 8] = b; }
            if( c[ 8] > c[ 9] ){ b = c[ 8]; c[ 8] = c[ 9]; c[ 9] = b; }
            if( c[ 9] > c[10] ){ b = c[ 9]; c[ 9] = c[10]; c[10] = b; }
            if( c[10] > c[11] ){ b = c[10]; c[10] = c[11]; c[11] = b; }
            if( c[11] > c[12] ){ b = c[11]; c[11] = c[12]; c[12] = b; }
            if( c[12] > c[13] ){ b = c[12]; c[12] = c[13]; c[13] = b; }
            if( c[13] > c[14] ){ b = c[13]; c[13] = c[14]; c[14] = b; }
            if( c[14] > c[15] ){ b = c[14]; c[14] = c[15]; c[15] = b; }
        }
        for( i=0,j=0,sum=0 ; i<16 ; i++ ){     // statistics for this block
            a = c[i];       // byte value
            j = a & 255;    // integer value
            if( j < hv->minval ) hv->minval = j;
            if( j > hv->maxval ) hv->maxval = j;
            box_histogram[j] = box_histogram[j] + 1;
            sum += j;
        }
    if( hv->minval < box_minval )  box_minval  = hv->minval;      // global
    if( hv->maxval > box_maxval )  box_maxval  = hv->maxval;      // global
    box_sum += sum;    // global sum of all pixels in a image
    box_num += 16;     // global quantity of pixels in a image
    hv->average = sum / 16;
    hv->median  = c[8];
    }}
    box_average = box_sum / box_num;      // global
    return 0;
}
static void paste_into_bitmapb( BITMAP *zmp )
{
    HV_BOX  *hv;
    int     x = 0, y=0;

    if( boxes == NULL ) return;
    v_clear_to_color( zmp, col_undef );

    for( y=0 ; y < box_sy ; y++ ) {
    for( x=0 ; x < box_sx ; x++ ) {
        hv = get_box( x, y );        if( hv == NULL ) return;
            if( hv->type == TYPE_0 ){ v_rectfill( zmp, x*4, y*4, x*4+3, y*4+3, col_bk ); }
            if( hv->type == TYPE_1 ){ v_rectfill( zmp, x*4, y*4, x*4+3, y*4+3, col_fg ); }
            if( hv->type == TYPE_2 ){ v_rectfill( zmp, x*4, y*4+2, x*4+3, y*4+3, col_fg );  }
            if( hv->type == TYPE_3 ){
                v_putpixel( zmp, x*4+1 , y*4+3  , col_fg);    // ....
                v_putpixel( zmp, x*4+2 , y*4+3  , col_fg);    // ...*
                v_putpixel( zmp, x*4+3 , y*4+3  , col_fg);    // ..**
                v_putpixel( zmp, x*4+2 , y*4+2  , col_fg);    // .***
                v_putpixel( zmp, x*4+3 , y*4+2  , col_fg);
                v_putpixel( zmp, x*4+3 , y*4+1  , col_fg);
            }
            if( hv->type == TYPE_4 ){ v_rectfill( zmp, x*4+2, y*4, x*4+3, y*4+3, col_fg ); }
            if( hv->type == TYPE_5 ){
                v_putpixel( zmp, x*4+1 , y*4+0  , col_fg);    // .***
                v_putpixel( zmp, x*4+2 , y*4+0  , col_fg);    // ..**
                v_putpixel( zmp, x*4+3 , y*4+0  , col_fg);    // ...*
                v_putpixel( zmp, x*4+2 , y*4+1  , col_fg);    // ....
                v_putpixel( zmp, x*4+3 , y*4+1  , col_fg);
                v_putpixel( zmp, x*4+3 , y*4+2  , col_fg);
            }
            if( hv->type == TYPE_6 ){ v_rectfill( zmp, x*4, y*4, x*4+3, y*4+1, col_fg ); }
            if( hv->type == TYPE_7 ){
                v_putpixel( zmp, x*4+0 , y*4+0  , col_fg);    // ***.
                v_putpixel( zmp, x*4+1 , y*4+0  , col_fg);    // **..
                v_putpixel( zmp, x*4+2 , y*4+0  , col_fg);    // *...
                v_putpixel( zmp, x*4+0 , y*4+1  , col_fg);    // ....
                v_putpixel( zmp, x*4+1 , y*4+1  , col_fg);
                v_putpixel( zmp, x*4+0 , y*4+2  , col_fg);
            }
            if( hv->type == TYPE_8 ){ v_rectfill( zmp, x*4, y*4, x*4+1, y*4+3, col_fg ); }
            if( hv->type == TYPE_9 ){
                v_putpixel( zmp, x*4+0 , y*4+3  , col_fg);    // ....
                v_putpixel( zmp, x*4+1 , y*4+3  , col_fg);    // *...
                v_putpixel( zmp, x*4+2 , y*4+3  , col_fg);    // **..
                v_putpixel( zmp, x*4+0 , y*4+2  , col_fg);    // ***.
                v_putpixel( zmp, x*4+1 , y*4+2  , col_fg);
                v_putpixel( zmp, x*4+0 , y*4+1  , col_fg);
            }
              if( hv->type == TYPE_UNKNOWN ){   // could not determine type
                v_putpixel( zmp, x*4+0 , y*4+0  , hv->asis[0] );
                v_putpixel( zmp, x*4+1 , y*4+0  , hv->asis[1] );
                v_putpixel( zmp, x*4+2 , y*4+0  , hv->asis[2] );
                v_putpixel( zmp, x*4+3 , y*4+0  , hv->asis[3] );
                v_putpixel( zmp, x*4+0 , y*4+1  , hv->asis[4] );
                v_putpixel( zmp, x*4+1 , y*4+1  , hv->asis[5] );
                v_putpixel( zmp, x*4+2 , y*4+1  , hv->asis[6] );
                v_putpixel( zmp, x*4+3 , y*4+1  , hv->asis[7] );
                v_putpixel( zmp, x*4+0 , y*4+2  , hv->asis[8] );
                v_putpixel( zmp, x*4+1 , y*4+2  , hv->asis[9] );
                v_putpixel( zmp, x*4+2 , y*4+2  , hv->asis[10] );
                v_putpixel( zmp, x*4+3 , y*4+2  , hv->asis[11] );
                v_putpixel( zmp, x*4+0 , y*4+3  , hv->asis[12] );
                v_putpixel( zmp, x*4+1 , y*4+3  , hv->asis[13] );
                v_putpixel( zmp, x*4+2 , y*4+3  , hv->asis[14] );
                v_putpixel( zmp, x*4+3 , y*4+3  , hv->asis[15] );
            }

    }}
}



/*
    // todo: scan bitmap into delta edges, like emboss function
    x2 = x-1;   if( x2 < x1 ) x2 = x1;      // don't go negative
    x3 = x;
    dx1 = v_getpixel( src, x2, y ) & 255;
    dx2 = v_getpixel( src, x3, y ) & 255;
    dx  = dx1 - dx2;    idx = dx2 - dx1;

//    grey = 128 + idx;         // emboss
//    if( grey < 0 )   grey = 0;
//    if( grey > 255 ) grey = 255;
*/

static int scan_boxes_into_types()
{
    HV_BOX  *hv = NULL;
    int     x, y;

    for( y=0 ; y < box_sy ; y++ ){
    for( x=0 ; x < box_sx ; x++ ){
    hv = get_box( x, y );
    hv->type = TYPE_UNDEF;
    if( grey_to_binary( hv->average, INTERPRET_GREY_HIGHRANGE) == 1 )
        hv->type = TYPE_1;
    if( grey_to_binary( hv->average, INTERPRET_GREY_LOWRANGE)  == 1 )
        hv->type = TYPE_0;
    }}
    return 0;
}



static int scan_boxes_into_types2()
{
    HV_BOX  *hv = NULL;
    HV_BOX  *n1 = NULL; // neighbor x+1
    HV_BOX  *n2 = NULL; // neighbor x-1
    HV_BOX  *n3 = NULL; // neighbor y+1
    HV_BOX  *n4 = NULL; // neighbor y-1
    int     x, y;

    for( y=0 ; y < box_sy ; y++ ) {
    for( x=0 ; x < box_sx ; x++ ) {

                                n4=get_box( x, y-1 );
        n2=get_box( x-1, y );   hv=get_box( x, y );     n1=get_box( x+1, y );
                                n3=get_box( x, y+1 );

        if( hv->type == TYPE_1 || hv->type == TYPE_0 ){
            if( n1!=NULL ){     // horizontal
                if( n1->type == TYPE_UNDEF )    inspect_block( n1 );
            }
            if( n2!=NULL ){     // horizontal
                if( n2->type == TYPE_UNDEF )    inspect_block( n2 );
            }
            if( n3!=NULL ){     // vertical
                if( n3->type == TYPE_UNDEF )    inspect_block( n3 );
            }
            if( n4!=NULL ){     // vertical
                if( n4->type == TYPE_UNDEF )    inspect_block( n4 );
            }
        }
    }}
    return 0;
}



static void inspect_block( HV_BOX *n )    // take a closer look
{
    int     i;
    int     x=0, y=0;
    int     a=0, b=0, c[16];
    int     xs1, xs2, xs3, xs4;
    int     ys1, ys2, ys3, ys4;
    int     da1, da2, da3, da4, da5;
    int     db1, db2, db3, db4, db5;

    if( n->type != TYPE_UNDEF ) return;
    x = n->x;
    y = n->y;
    c[ 0]=v_getpixel(source,x+0,y+0); c[ 1]=v_getpixel(source,x+1,y+0); c[ 2]=v_getpixel(source,x+2,y+0); c[ 3]=v_getpixel(source,x+3,y+0);
    c[ 4]=v_getpixel(source,x+0,y+1); c[ 5]=v_getpixel(source,x+1,y+1); c[ 6]=v_getpixel(source,x+2,y+1); c[ 7]=v_getpixel(source,x+3,y+1);
    c[ 8]=v_getpixel(source,x+0,y+2); c[ 9]=v_getpixel(source,x+1,y+2); c[10]=v_getpixel(source,x+2,y+2); c[11]=v_getpixel(source,x+3,y+2);
    c[12]=v_getpixel(source,x+0,y+3); c[13]=v_getpixel(source,x+1,y+3); c[14]=v_getpixel(source,x+2,y+3); c[15]=v_getpixel(source,x+3,y+3);
        for( i = 0 ; i<16 ; i++ ){
        n->asis[i] = c[i];
        a = c[i];               // grey value to binary value
//        c[i] = grey_to_binary( a, INTERPRET_GREY_MIDRANGE  );
//        c[i] = grey_to_binary( a, INTERPRET_GREY_LOWRANGE  );
        b = grey_to_binary( a, INTERPRET_GREY_HIGHRANGE  );
        c[i] = b;
        if( b == 1 )  b = col_fg; else b = col_bk;
        n->asis[i] = b;
    }


    // now compare cases, where it's not a 4x4 full background or full foreground
    //...
    xs1 = c[ 0] + c[ 1] + c[ 2] + c[ 3];    // ....
    xs2 = c[ 4] + c[ 5] + c[ 6] + c[ 7];    // ....
    xs3 = c[ 8] + c[ 9] + c[10] + c[11];    // ****
    xs4 = c[12] + c[13] + c[14] + c[15];    // ****
    //...
    ys1 = c[ 0] + c[ 4] + c[ 8] + c[12];    // ..**
    ys2 = c[ 1] + c[ 5] + c[ 9] + c[13];    // ..**
    ys3 = c[ 2] + c[ 6] + c[10] + c[14];    // ..**
    ys4 = c[ 3] + c[ 7] + c[11] + c[15];    // ..**
    //...
    da1 = c[11] + c[14] + c[15];            // ....
    da2 = c[ 7] + c[10] + c[13];            // ...*
    da3 = c[ 3] + c[ 6] + c[ 9] + c[12];    // ..**
    da4 = c[ 2] + c[ 5] + c[ 8];            // .***
    da5 = c[ 0] + c[ 4] + c[ 1];
    //...
    db1 = c[ 8] + c[12] + c[13];            // .***
    db2 = c[ 4] + c[ 9] + c[14];            // ..**
    db3 = c[ 0] + c[ 5] + c[10] + c[15];    // ...*
    db4 = c[ 1] + c[ 6] + c[11];            // ....
    db5 = c[ 2] + c[ 3] + c[ 7];
    //...

    if( da1 == 3 &&         // 00??
        da2 == 3 &&         // 0??*
//      da3 == 4 &&         // ??**
//        da4 >= 1 &&       // ?***
        da5 == 0 )
        n->type = TYPE_3;

    if( db1 == 0 &&         // ?***
//      db2 == 0 &&         // ??**
//      db3 == 4 &&         // 0??*
        db4 == 3 &&         // 00??
        db5 == 3 )
        n->type = TYPE_5;

    if( da1 == 0 &&         // ***?
//      da2 == 0 &&         // **??
//      da3 == 4 &&         // *??0
        da4 == 3 &&         // ??00
        da5 == 3 )
        n->type = TYPE_7;

    if( db1 == 3 &&         // ??00
        db2 == 3 &&         // *??0
//      db3 == 4 &&         // **??
//      db4 == 0 &&         // ***?
        db5 == 0 )
        n->type = TYPE_9;

// ********************************+


// ********************************+








    if( xs1 == 0 &&                            // 0000
                                               // ????
        xs3 == 4 &&                            // ****
        xs4 == 4 )        n->type = TYPE_2;    // ****

    if( ys1 == 0 &&                            // 0?**
                                               // 0?**
        ys3 == 4 &&                            // 0?**
        ys4 == 4 )        n->type = TYPE_4;    // 0?**

    if( xs1 == 4 &&                            // ****
        xs2 == 4 &&                            // ****
                                               // ????
        xs4 == 0 )        n->type = TYPE_6;    // 0000

    if( ys1 == 4 &&                            // **?0
        ys2 == 4 &&                            // **?0
                                               // **?0
        ys4 == 0 )        n->type = TYPE_8;    // **?0

    if( n->type == TYPE_UNDEF ) n->type = TYPE_UNKNOWN; // could not determine type!
}





