/*
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../dlg.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"RGB",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"color similar",
"Replace similar colors with buttoncolor 1",
"replace all colors with different palette index that have the same RGB equal to 'color' to be replaced with 'color'.precision:  range 0 to 310 means exact match.1 means a variance of +- 1  for each RGB.",
"                              "
"                              "
"  *****   *****               "
"  *****   *****               "
"  *****   *****               "
"  *****   *****               "
"                              "
"                              "
"   **      **                 "
"   **      **                 "
"   **      **                 "
"   **      **    *     *****  "
"   ***      **   **    *****  "
"    ***      **  ***   *****  "
"     ****************  *****  "
"     ****************  *****  "
"    ***      **  ***   *****  "
"   ***      **   **    *****  "
"   **      **    *            "
"   **      **                 "
"   **      **                 "
"   **      **                 "
"                              "
"                              "
"  *****   *****               "
"  *****   *****               "
"  *****   *****               "
"  *****   *****               "
"                              "
"                              ",
"******************************"
"******************************"
"**     ***     ***************"
"**     ***     ***************"
"**     ***     ***************"
"**     ***     ***************"
"******************************"
"******************************"
"***  ******  *****************"
"***  ******  *****************"
"***  ******  *****************"
"***  ******  **** *****     **"
"***   ******  ***  ****     **"
"****   ******  **   ***     **"
"*****                **     **"
"*****                **     **"
"****   ******  **   ***     **"
"***   ******  ***  ****     **"
"***  ******  **** ************"
"***  ******  *****************"
"***  ******  *****************"
"***  ******  *****************"
"******************************"
"******************************"
"**     ***     ***************"
"**     ***     ***************"
"**     ***     ***************"
"**     ***     ***************"
"******************************"
"******************************",
1,0,1,1,0
};     

static int precision=0, retval = -1;


DLLEXPORT void dxemod_init()  // before "ALL" is processed so popup is only once
{
    retval = v_dlg_request_uchar(" PRECISION ",0,precision,31);
    if( retval >= 0 ) precision = retval;
}
DLLEXPORT void dxemod_deinit(){}
/*
 * replace all colors with different palette index that have the same
 * RGB equal to 'color' to be replaced with 'color'.
 *
 * precision:  range 0 to 31,
 *             0 means exact match.
 *             1 means a variance of +- 1  for each RGB
 *            31 means a variance of +- 31 for each RGB
 *
 * if compared ranges are above 255, the limit will be set at 255.
 * if compared ranges are below 0, the limit will be set at 0.
 *
 * example:
 * A source RGB value of 30,30,30 with a precision of 5 will match a
 * RGB of 25,35,33 or a RGB of 31,25,35 but not a RGB of 20,45,10 (out of range).
 */
DLLEXPORT int dxemod_method ( BITMAP *src, int x1, int y1, int sx, int sy )
{
    int x,y,i,j=0,r_,g_,b_;
    unsigned char r0,g0,b0;     /* -source- */
    unsigned char r2a,g2a,b2a;  /* above */
    unsigned char r2b,g2b,b2b;  /* below */
    PALETTE above_palette, below_palette;
    int     color=0;

    if( retval < 0 ) return -1;         // cancel was pressed
    if( precision < 0 ) return -1;      // fail, illegal number

    color = g->usercolor1;
    i = color;
    r0 = g->palette[ i ].r;
    g0 = g->palette[ i ].g;
    b0 = g->palette[ i ].b;

    if(precision==0){        /* compare with precision zero */
        for(y=y1; y<(y1+sy); y++) {
        for(x=x1; x<(x1+sx); x++) {
        i = v_getpixel(src,x,y) & 0xff;
        if( r0==g->palette[i].r && g0==g->palette[i].g && b0==g->palette[i].b )
            v_putpixel(src,x,y, color );
        }}
    return -1;
    }
    for(y=0; y<256; y++) {      // make ranges
    r_ = g->palette[ y ].r;
    i = r_ + precision;      if(i>255) i=255;
    j = r_ - precision;      if(j<0  ) j=0;
    above_palette[ y ].r = i;
    below_palette[ y ].r = j;
    g_ = g->palette[ y ].g;
    i = g_ + precision;      if(i>255) i=255;
    j = g_ - precision;      if(j<0  ) j=0;
    above_palette[ y ].g = i;
    below_palette[ y ].g = j;
    b_ = g->palette[ y ].b;
    i = b_ + precision;      if(i>255) i=255;
    j = b_ - precision;      if(j<0  ) j=0;
    above_palette[ y ].b = i;
    below_palette[ y ].b = j;
    }

    for(y=y1; y<(y1+sy); y++) {
    for(x=x1; x<(x1+sx); x++) {
    i = v_getpixel(src,x,y) & 0xff;
    r2a = above_palette[ i ].r;
    r2b = below_palette[ i ].r;
    g2a = above_palette[ i ].g;
    g2b = below_palette[ i ].g;
    b2a = above_palette[ i ].b;
    b2b = below_palette[ i ].b;
    /* compare with varying precision */
    if( r0 >= r2b && r0 <= r2a ) {    /* red match */
    if( g0 >= g2b && g0 <= g2a ) {    /* green match */
    if( b0 >= b2b && b0 <= b2a ) {    /* blue match */
    v_putpixel(src,x,y, color );
    }}}
    }}
    return 0;
}

