/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\





      Coordinate calculations on zoomed / unzoomed types.

    terms:

    ucoord - unzoomed coordinates. pixel by pixel.
    zcoord - zoomed coordinates (screen type), pixel size varies with zoom.

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <allegro.h>
#include "data.h"
#include "coord.h"





/* mouse input (zcoord), binary output (ucoord)
   returns FALSE if pixel is outside sprite block
*/
int coord_screen2bin( int mx, int my, int *px, int *py)
{
    int    i, j;
    int    ef;
    int    x1, y1;

    if( mx > (md_x+md_sx-1) ) mx = md_x+md_sx-1;       /* limit range */
    if( my > (md_y+md_sy-1) ) my = md_y+md_sy-1;
    if( mx < md_x ) mx = md_x;
    if( my < md_y ) my = md_y;
    i = mx - md_x;
    j = my - md_y;
    if (g.zoom > 0){
        if( i != 0 ){ x1 = (i / (g.zoom+1)) + g.ox; }
        if( i == 0 ){ x1 = g.ox; }
        if( j != 0 ){ y1 = (j / (g.zoom+1)) + g.oy; }
        if( j == 0 ){ y1 = g.oy; }
        *px = x1 ;
        *py = y1 ;
        if( x1 >= g.sx && y1 >= g.sy )  return FALSE;
        return TRUE;
    }
    if (g.zoom == 0){
        x1 = i + g.ox;
        y1 = j + g.oy;
        ef=0;
        if( x1 > g.sx ) ef++;
        if( y1 > g.sy ) ef++;
        *px = x1 ;
        *py = y1 ;
        if(ef==0) return TRUE;
        return FALSE;
    }
    return FALSE;
}











/*
 * get mouse coordinates on mx, my.
 * Input:   address to store integers.
 * Output:  mouse coordinates within MD block.
 *          Coordinates outside MD will be clipped.
 *
 */
void get_mousexy_md(int *_mx, int *_my)
{
    int     mx, my, zoom = g.zoom;

    mx = *_mx;
    my = *_my;
    mx = mouse_x;
    my = mouse_y;
    if( mx > (md_sx+md_x-1-zoom) ) mx = md_sx+md_x-1-zoom;
    if( my > (md_sy+md_y-1-zoom) ) my = md_sy+md_y-1-zoom;
    if( mx < md_x ) mx = md_x;
    if( my < md_y ) my = md_y;
    *_mx = mx;
    *_my = my;
}


/*
 * Limit pixel coordinates so they are inside block.
 * inside the pixel buffer.
 *
 *
 */
void limit_ucoord ( int *_lx1, int *_ly1, int *_lx2, int *_ly2 )
{
    int lx1 = *_lx1;
    int ly1 = *_ly1;
    int lx2 = *_lx2;
    int ly2 = *_ly2;

    if( lx1 < 0 ) lx1 = 0;
    if( lx2 < 0 ) lx2 = 0;
    if( ly1 < 0 ) ly1 = 0;
    if( ly2 < 0 ) ly2 = 0;
    if( lx1 > (g.sx-1) ) lx1 = g.sx-1;
    if( ly1 > (g.sy-1) ) ly1 = g.sy-1;
    if( lx2 > (g.sx-1) ) lx2 = g.sx-1;
    if( ly2 > (g.sy-1) ) ly2 = g.sy-1;
    *_lx1 = lx1;
    *_ly1 = ly1;
    *_lx2 = lx2;
    *_ly2 = ly2;
}


/*
 * Limit pixel coordinates so they are inside block.
 * inside the zoomed screen buffer.
 */
void limit_zcoord ( int *_lx1, int *_ly1, int *_lx2, int *_ly2 )
{
    int lx1 = *_lx1;
    int ly1 = *_ly1;
    int lx2 = *_lx2;
    int ly2 = *_ly2;

    if( lx1 < md_x ) lx1 = md_x;
    if( ly1 < md_y ) ly1 = md_y;
    if( lx2 > ( md_x+md_sx-1 ) ) lx2 = ( md_x+md_sx-1 );
    if( ly2 > ( md_y+md_sy-1 ) ) ly2 = ( md_y+md_sy-1 );
    if(lx1!=0) lx1--;
    if(ly1!=0) ly1--;
    if(lx2!=0) lx2--;
    if(ly2!=0) ly2--;
    *_lx1 = lx1;
    *_ly1 = ly1;
    *_lx2 = lx2;
    *_ly2 = ly2;
}







/* ********************************************************************* */
/* ********************************************************************* */
/* ********************************************************************* */
/* ********************************************************************* */
/* ********************************************************************* */


/* Mouse input (ix,iy), screen output (ox,oy) relative to 0  */
/* returns FALSE if pixel is outside md block                */
int coord_mouse2screen( int ix, int iy, int *ox, int *oy )
{
    int    x1, y1;
    int    ef = 0;

    x1 = ix - md_x;
    y1 = iy - md_y;
    if( x1 < 0 )    { x1=0; ef++; }
    if( y1 < 0 )    { y1=0; ef++; }
    if( x1 > md_sx ){ x1 = md_sx;  ef++; }
    if( y1 > md_sy ){ y1 = md_sy;  ef++; }
    *ox = x1;
    *oy = y1;
    if(ef!=0) return FALSE;     // outside
    return TRUE;                // inside
}


/* screen input (mx,my) relative to 0,0. 0,0 correspond to md_x, md_y.
   binary output (px,py)
  returns FALSE if pixel is outside sprite block
*/
int coord_screen2bin2( int mx, int my, int *px, int *py)
{
    int    x1, y1;
    int    ef = 0;

    if( mx > (md_sx-1) ) mx = md_sx-1;       // limit range
    if( my > (md_sy-1) ) my = md_sy-1;
    if( mx < 0 ) mx = 0;
    if( my < 0 ) my = 0;
    if (g.zoom > 0){
        if( mx != 0 )  x1 = (mx / (g.zoom+1)) + g.ox;
        if( mx == 0 )  x1 = g.ox;
        if( my != 0 )  y1 = (my / (g.zoom+1)) + g.oy;
        if( my == 0 )  y1 = g.oy;
        *px = x1;
        *py = y1;
        if( x1 >= g.sx && y1 >= g.sy ) return FALSE;
        return TRUE;
    }
    if (g.zoom == 0){
        x1 = mx + g.ox;
        y1 = my + g.oy;
        if( x1 > g.sx ) ef++;
        if( y1 > g.sy ) ef++;
        *px = x1 ;
        *py = y1 ;
        if(ef==0) return TRUE;
        return FALSE;
    }
    return FALSE;
}

/*
 Returns screen coordinates relative to md_x, md_y.
 returns FALSE if pixel is outside window else TRUE
 binary input (ucoord), screen output (zcoord)
*/
int coord_bin2screen( int mx, int my, int *px, int *py )
{
    int    x1, y1, ef;

    *px = mx;
    *py = my;
    ef = 0;


    if ( g.zoom == 0 ){
    x1 = (mx-g.ox);
    y1 = (my-g.oy);
    if( x1 <= 0 ){ x1 = 0; ef++; }
    if( y1 <= 0 ){ y1 = 0; ef++; }
    if( x1 >= g.sx ) ef++;
    if( y1 >= g.sy ) ef++;
    *px = x1;
    *py = y1;
    if( ef==0 ) return TRUE;
    return FALSE;
    }

    if ( g.zoom > 0 ){
    x1 = ((mx-g.ox) * (g.zoom+1) );
    y1 = ((my-g.oy) * (g.zoom+1) );

    // **********
    if( g.flag_pixelgrid==FALSE ){
    if( g.zoom==3||g.zoom==7||g.zoom==15||g.zoom==31||g.zoom==63||g.zoom==127||g.zoom==255||g.zoom==511){
        x1--;y1--;
    }
    if( g.zoom >= 2 ){
        x1++;y1++;
    }}
    if( g.flag_pixelgrid==TRUE && g.zoom >= 1 ){
        x1++;y1++;
    }
    // **********
    if( x1 <= 0 ){ x1 = 0; ef++; }
    if( y1 <= 0 ){ y1 = 0; ef++; }
    *px = x1;
    *py = y1;
    if(ef==0) return TRUE;  // inside rectangle
    return FALSE;           // outside rectangle
    }
    return FALSE;
}


/*
 * Limit pixel coordinates so they are inside MD block.
 * from abs. 0.
 */
void coord_limit_screen ( int *_lx1, int *_ly1, int *_lx2, int *_ly2 )
{
    int lx1 = *_lx1;
    int ly1 = *_ly1;
    int lx2 = *_lx2;
    int ly2 = *_ly2;
    if( lx1 < 0 ) lx1 = 0;
    if( ly1 < 0 ) ly1 = 0;
    if( lx2 < 0 ) lx2 = 0;
    if( ly2 < 0 ) ly2 = 0;
    if( lx1 > ( md_sx-1 ) ) lx1 = ( md_sx-1 );
    if( ly1 > ( md_sy-1 ) ) ly1 = ( md_sy-1 );
    if( lx2 > ( md_sx-1 ) ) lx2 = ( md_sx-1 );
    if( ly2 > ( md_sy-1 ) ) ly2 = ( md_sy-1 );
    *_lx1 = lx1;
    *_ly1 = ly1;
    *_lx2 = lx2;
    *_ly2 = ly2;
}


/*
 * Limit pixel coordinates so they are inside block.
 * inside the pixel buffer.
 *
 *
 */
void coord_limit_bin( int *_lx1, int *_ly1, int *_lx2, int *_ly2 )
{
    int lx1 = *_lx1;
    int ly1 = *_ly1;
    int lx2 = *_lx2;
    int ly2 = *_ly2;
    if( lx1 < 0 ) lx1 = 0;
    if( lx2 < 0 ) lx2 = 0;
    if( ly1 < 0 ) ly1 = 0;
    if( ly2 < 0 ) ly2 = 0;
    if( lx1 > (g.sx-1) ) lx1 = g.sx-1;
    if( ly1 > (g.sy-1) ) ly1 = g.sy-1;
    if( lx2 > (g.sx-1) ) lx2 = g.sx-1;
    if( ly2 > (g.sy-1) ) ly2 = g.sy-1;
    *_lx1 = lx1;
    *_ly1 = ly1;
    *_lx2 = lx2;
    *_ly2 = ly2;
}


