/*
 *
 *
 *
 *  rad * 180                     PI *degree
 * ------------ = degree         ------------ = radians
 *    PI                            180
 *
 *
 *
 *
 */



/*
    Annihilation of Selected Government Officials = ASGO
*/


#include <math.h>
#include <allegro.h>




#define PI 3.1415926


/* dialog object for rotating angle.
 * Rotating angle is in the d1 field. Range 0 to 255 means 0 to 360 degrees.
 * The height and width must be equal. The height determines size.
 * uses dp2 for internal use (contains pointer to dots coordinates).
 * uses d2 for internal use.
 * uses MSG_USER for internal use.
 *
 */
int ed_rotatebox2(int msg,DIALOG *d, int c)
{
    double  x,y, fi, angle, radius,c;
    double  x1,y1,x2,y2,x3,y3;
    int     mx,my,mb,px,py, flag_reverse, angle2=0, angle3=0, x_center, y_center;

    int     i,j, flag_reverse;

    if(msg==MSG_START) d->w = d->h;

    w  = d->w;
    h  = d->h;
    x1 = d->x;
    y1 = d->y;
    x2 = x1+w;
    y2 = y1+h;

    x_center = x1 + w/2;
    y_center = y1 + h/2;
    radius = w/2;



    switch( msg ){
    case MSG_IDLE:
    return D_O_K;
    break;

    case MSG_END:
    if(d->dp2!=NULL)free(d->dp2);
    d->d2=0;
    rx=ry=rotdots=0;
    return D_O_K;
    break;


    case MSG_START:


    for(fi=0.0;fi< 2*PI; fi += PI/180 ){
    x = sin( fi ) * radius + d->x;
    y = cos( fi ) * radius + d->y;
    putpixel( screen, x,y, d->fg );
    }

    msg=D_O_K;
    break;


    case MSG_DRAW:

    rectfill(screen, x1,y1,x2,y2,d->bg);    // fill background
    rect(    screen, x1,y1,x2,y2,d->fg);    // outer quadrant

    for(fi=0.0;fi< 2*PI; fi += PI/180 ){
    x = sin( fi ) * radius + x1;
    y = cos( fi ) * radius + y1;
    putpixel( screen, x,y, d->fg );
    }

    i = d->flags;    if( (i&D_DISABLED) != 0 );  // do nothing






    case MSG_USER:
    /* undraw */
/*
    if( rx!=0 && ry!=0 && rx<x2 && rx>x1 && ry<y2 && ry>y1 ){
    line(screen,px1+radius,py1+radius, rx,ry, d->bg);
    rect(screen, rx-PAD+1,ry-PAD+1,rx+PAD-1,ry+PAD-1, d->bg);
    }
    vline(screen, px1+radius, py1, py2, d->fg);
    hline(screen, px1, py1+radius, px2, d->fg);
    circle(screen,px1+radius,py1+radius,radius, d->fg); /* main circle */
    do_arc(screen,px1+radius,py1+radius, ((d->d1)<<(16)), (d->d1+1)<<16, radius, 0, rot_getrotbox );/* rx,ry= returned coordinates */
*/
    /* draw */
/*
    line(screen,px1+radius,py1+radius, rx,ry, d->fg);  /* draw angledline */
    rect(screen, rx-PAD+1,ry-PAD+1,rx+PAD-1,ry+PAD-1, d->fg);
*/
    msg = D_O_K;
    break;


    case MSG_CLICK:
    mx = mouse_x;
    my = mouse_y;
    /* inside pad */
    mb = mouse_b;
    if( mb&1 )
        line( screen, x_center,y_center,mx,my, makecol( 220,100,50) );

    flag_reverse = FALSE;

    px = mx - x_center;
    py = my - y_center;

    if( px > 0 && py > 0 ){    // quad 1
//    textprintf(screen,font,10,10,makecol(220,220,0),"*1*");
    }
    if( px > 0 && py <= 0 ){   // quad 2
//    textprintf(screen,font,10,10,makecol(220,220,0),"*2*");
    }
    if( px <= 0 && py <= 0 ){  // quad 3
//    textprintf(screen,font,10,10,makecol(220,220,0),"*3*");
    flag_reverse = TRUE;
    }
    if( px <= 0 && py > 0 ){  // quad 4
//    textprintf(screen,font,10,10,makecol(220,220,0),"*4*");
    flag_reverse = TRUE;
    }


    radius = sqrt (px*px + py*py);
    angle  = asin ( (double) (py/radius) ); // angle in radians
    angle2 = (angle*180.0)/PI;              // angle2 in degrees
    angle3 = (angle*127.0)/PI;              // angle3 in degrees 16.16 fixed data format. 360 degrees is 255.

    if( px > 0 && py > 0 ){    // quad 1
    }
    if( px > 0 && py <= 0 ){   // quad 2
    angle2 = ((360) - -angle2);
    angle3 = ((255) - -angle3);
    }
    if( px <= 0 && py <= 0 ){  // quad 3
    angle2 = (180 + -angle2);
    angle3 = (127 + -angle3);
    }
    if( px <= 0 && py > 0 ){  // quad 4
    angle2 = (180 - angle2);
    angle3 = (127 - angle3);
    }


    y = sin( angle )*100.0 + 160;
    x = cos( angle )*100.0 + 160;
    if( flag_reverse == TRUE )
        x = -cos( angle )*100.0 + 160;


    line( screen, 160,160,x,y, makecol( 220,220,50) );
    textprintf( screen, font, x_center,y_center, d->fg, "%3d", angle2 );
    d->d1 = angle3;

    msg = D_O_K;
    break;
        default:
    msg = D_O_K;
    break;
    }
    return msg;
}



