
#include <allegro.h>
#define AVOID_WIN32_FILEIO
#include <tiffio.h>
#include <tiffiop.h>
#include <string.h>
#include "tif.h"
#include "data.h"




BITMAP *load_tif( const char *filename, RGB *pal);
int save_tif( const char *filename, BITMAP *map, const RGB *pal );








BITMAP *load_tif( const char *filename, RGB *pal )
{
    BITMAP  *map;
    uint32  w, h, nsamples=0,bitspersample=0,orientation=0, photometric=0;
    uint16  red[256+1],green[256+1],blue[256+1];
    size_t  npixels;
    uint32  *raster32=NULL;
    uint8   *raster = NULL;
    TIFF       *tif;
    int         x,y,n,i,bpp=8, bppr;
    uint32      r,g,b;
//    RGB_MAP     rgb_map;
    TIFFDirectory *td;
//    FILE        *fd;
    uint8       c;
    uint8       xors[]={128,64,32,16,8,4,2,1};


    tif =  TIFFOpen(filename, "rb");    if(tif==NULL) return NULL;
//    fd =  fopen("test.txt", "w");    if(fd==NULL) return NULL;
    td = &tif->tif_dir;

    TIFFGetField(tif, TIFFTAG_IMAGEWIDTH,      &w);
    TIFFGetField(tif, TIFFTAG_IMAGELENGTH,     &h);
    TIFFGetField(tif, TIFFTAG_SAMPLESPERPIXEL, &nsamples     ); // 1,2,3
    TIFFGetField(tif, TIFFTAG_BITSPERSAMPLE,   &bitspersample); // 1,4,8
    TIFFGetField(tif, TIFFTAG_ORIENTATION,     &orientation  );
    TIFFGetField(tif, TIFFTAG_PHOTOMETRIC,     &photometric  );

    if( nsamples==1) bpp = 8;
    if( nsamples==2) bpp = 16;
    if( nsamples==3) bpp = 24;
    if( nsamples==4) bpp = 32;
    if( nsamples==1 && bitspersample == 1 ) bpp = 1;
    if( nsamples==1 && bitspersample == 4 ) bpp = 4;
    if( nsamples==1 && bitspersample == 6 ) bpp = 6;


    if( photometric==PHOTOMETRIC_PALETTE ) bpp=8;
//    if( photometric==PHOTOMETRIC_RGB || photometric==PHOTOMETRIC_PALETTE );
//    if( photometric==PHOTOMETRIC_MINISWHITE || photometric==PHOTOMETRIC_MINISBLACK );
    i = TIFFIsTiled(tif);
    i = TIFFIsByteSwapped(tif);
    i = TIFFIsUpSampled(tif);
    i = TIFFIsMSB2LSB(tif);
    i = TIFFIsBigEndian(tif);

//    TIFFPrintDirectory(tif,  fd, TIFFPRINT_COLORMAP);   // TIFFPRINT_CURVES | TIFFPRINT_STRIPS
//return NULL;

    if( bpp==8 && pal != NULL ){      // 8 bit paletted
    memset(red,   0, sizeof(red));
    memset(green, 0, sizeof(green));
    memset(blue,  0, sizeof(blue));
    TIFFGetField(tif, TIFFTAG_COLORMAP, &red, &green, &blue);// can be 8 bit or 16 bit palette?
    n = 1 << bitspersample;
    for (i = 0; i < n; i++) {
         pal[i].r = td->td_colormap[0][i]>>10;
         pal[i].g = td->td_colormap[1][i]>>10;
         pal[i].b = td->td_colormap[2][i]>>10;
    }
    }

    bppr = bpp;
    if( bpp < 8 ) bppr = 8;
    map = create_bitmap_ex( bppr, w, h );    if( map==NULL ) return NULL;
    npixels = w * h;

    if( bpp <= 8 ){
        raster = (uint8*) _TIFFmalloc( npixels * sizeof (uint8));  if( raster == NULL ) return NULL;
        for(y=0;y< h ;y++){
        TIFFReadScanline( tif, raster + w * y, y, 0 );
        }
        for(y=0;y< h ;y++){
        for(x=0;x< w ;x++){
        if( bpp==8 )
            putpixel( map,x,y, raster[ x + y * w ] );
            if( bpp==1 ){
            c = raster[ x/7 + y * w ] & xors[ x&7 ];
            if( c ) c = 255;
            putpixel( map,x,y, c ); //  b/w pixel
            }
        }}

    }else{
        raster32 = (uint32*) _TIFFmalloc(npixels * sizeof (uint32));    if( raster32 == NULL ) return NULL;
        if(TIFFReadRGBAImageOriented(tif, w, h, raster32, 0,ORIENTATION_TOPLEFT )){
        for(y=0;y< h ;y++){
        for(x=0;x< w ;x++){
        r=g=b= raster32[ y*w + x ];  // RGBA data
        g = (g >> 8)  & 255;
        b = (b >> 16) & 255;
        putpixel( map,x,y, makecol24(r,g,b) );
        }}
        }
    }
    _TIFFfree(raster);
	TIFFClose(tif);
    return map;
}




























// #define SPP 3       /* Samples per pixel */


static struct SingleTags {
	ttag_t		tag;
	uint16		value;
} short_single_tags[] = {
    { TIFFTAG_COMPRESSION,    COMPRESSION_NONE }, // COMPRESSION_LZW
    { TIFFTAG_FILLORDER,      FILLORDER_MSB2LSB },
    { TIFFTAG_ORIENTATION,    ORIENTATION_TOPLEFT /* ORIENTATION_BOTRIGHT */ },
    { TIFFTAG_RESOLUTIONUNIT, RESUNIT_INCH },
//    { TIFFTAG_INKSET,         INKSET_MULTIINK },
//    { TIFFTAG_MINSAMPLEVALUE, 23 },
//    { TIFFTAG_MAXSAMPLEVALUE, 241 },
//    { TIFFTAG_NUMBEROFINKS,   SPP },
    { TIFFTAG_SAMPLEFORMAT,   SAMPLEFORMAT_UINT }
};
#define NSINGLETAGS   (sizeof(short_single_tags) / sizeof(short_single_tags[0]))






// returns zero on OK
// returns 1    on ERROR
//
int save_tif( const char *filename, BITMAP *map, const RGB *pal )
{
      uint16    width;
      uint16    height;
      uint16    samplesperpixel = 1;
      uint16    bitspersample = 8;
      uint16    photometric = PHOTOMETRIC_RGB;
//      uint16    rows_per_strip = 1;
//      uint16    planarconfig = PLANARCONFIG_CONTIG;
    TIFF            *tif;
    int         x,y, bpp=0;
//    unsigned char   buf[3] = { 0, 127, 255 };
    uint16      red[256],
                green[256],
                blue[256];
    static char *version = "exa " VERSIONNUMBER_STR;
    static char *datetime = "2005:11:28 12:00:00";
    TIFFDirectory *td;
    uint8       *raster;
    int         i,j,r,g,b,color;



    if( filename==NULL||map==NULL) return 1;
//    if( filename==NULL||map==NULL||pal==NULL) return 1;
    width  = map->w;
    height = map->h;
    bpp    = bitmap_color_depth( map );


    switch (bpp) {
    case 1:
	samplesperpixel = 1;
	bitspersample = 1;
	photometric = PHOTOMETRIC_MINISBLACK;
	break;

    case 8:
	samplesperpixel = 1;
	bitspersample = 8;
	photometric = PHOTOMETRIC_PALETTE;
	break;

    case 15:
    case 16:
    samplesperpixel = 2;
	bitspersample = 8;
	photometric = PHOTOMETRIC_RGB;
	break;

    case 24:
	samplesperpixel = 3;
	bitspersample = 8;
	photometric = PHOTOMETRIC_RGB;
	break;

    case 32:
	samplesperpixel = 4;
	bitspersample = 8;
	photometric = PHOTOMETRIC_RGB;
	break;
    }


    tif = TIFFOpen(filename, "wb");
	if (!tif) {
		fprintf (stderr, "Can't create test TIFF file %s.\n", filename);
		return 1;
	}
    td = &tif->tif_dir;

    TIFFSetField(tif, TIFFTAG_IMAGEWIDTH, width);
    TIFFSetField(tif, TIFFTAG_IMAGELENGTH, height);
    TIFFSetField(tif, TIFFTAG_BITSPERSAMPLE, bitspersample);
    TIFFSetField(tif, TIFFTAG_ORIENTATION, ORIENTATION_TOPLEFT);
    TIFFSetField(tif, TIFFTAG_COMPRESSION, COMPRESSION_NONE); // COMPRESSION_LZW
    TIFFSetField(tif, TIFFTAG_PHOTOMETRIC, photometric);
    TIFFSetField(tif, TIFFTAG_SAMPLESPERPIXEL, samplesperpixel);
//    TIFFSetField(tif, TIFFTAG_ROWSPERSTRIP,    rowsperstrip);
//    TIFFSetField(tif, TIFFTAG_STRIPBYTECOUNTS, height / rowsperstrip);
    TIFFSetField(tif, TIFFTAG_PLANARCONFIG, PLANARCONFIG_CONTIG);
    TIFFSetField(tif, TIFFTAG_DOCUMENTNAME, "Documentname");
    TIFFSetField(tif, TIFFTAG_IMAGEDESCRIPTION, "Converted Image");
    TIFFSetField(tif, TIFFTAG_SOFTWARE, version);
    TIFFSetField(tif, TIFFTAG_DATETIME, datetime);
    for (i = 0; i < NSINGLETAGS; i++) {
        if (!TIFFSetField(tif, short_single_tags[i].tag, short_single_tags[i].value)) {
            fprintf(stderr, "Can't set tag %d.\n", (int)short_single_tags[i].tag);
			goto failure;
		}
	}


    if ( bpp <= 8 && pal != NULL ) {
        memset(red,   0, sizeof(red));
        memset(green, 0, sizeof(green));
        memset(blue,  0, sizeof(blue));
        for (i = 0; i < 256; i++) {
        red[i]   = pal[i].r << 2;
        green[i] = pal[i].g << 2;
        blue[i]  = pal[i].b << 2;
        }
        TIFFSetField(tif, TIFFTAG_COLORMAP, &red, &green, &blue);
        for (i = 0; i < 256; i++) {
        td->td_colormap[0][i] = pal[i].r <<10;
        td->td_colormap[1][i] = pal[i].g <<10;
        td->td_colormap[2][i] = pal[i].b <<10;
        }
    }

    if ( bpp <= 8) {

        for(y=0;y<height;y++){
        if (!TIFFWriteScanline(tif, map->line[y], y, 0) < 0) {
		fprintf (stderr, "Can't write image data.\n");
		goto failure;
        }
        }
    }else{

        raster = ( uint8 *) malloc( width * sizeof(uint32) );   if( raster==NULL ) goto failure;

        for(y=0;y<height;y++){
        for(x=0,j=0,i=0;x<width;x++){
        color = getpixel( map, x,y );
        r = getr_depth( 24, color );
        g = getg_depth( 24, color );
        b = getb_depth( 24, color );
//        b = map->line[y][i++];
//        g = map->line[y][i++];
//        r = map->line[y][i++];
        raster[j++] = r;
        raster[j++] = g;
        raster[j++] = b;
        }
        if (!TIFFWriteScanline(tif, raster, y, 0) < 0) {
		fprintf (stderr, "Can't write image data.\n");
		goto failure;
        }
        }
    }
    TIFFFlushData(tif);
    TIFFClose(tif);
    return 0;

failure:
	/* Something goes wrong; close file and return unsuccessful status. */
	TIFFClose(tif);
	unlink(filename);
	return 1;
}





/*
main(int argc, char *argv[])
{
    PALETTE     palette;
    BITMAP      *map;
    int         i;

    allegro_init();


    install_timer();
    install_keyboard();
    if(install_mouse()==-1){puts("Error initializing mouse");
        remove_timer();
        remove_keyboard();
        return -1;
        }
    set_color_depth( 8 );
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320,200, 0, 0) != 0) {
        allegro_message("Unable to set graphic mode\n%s", allegro_error);
        exit(-1);
    }


    map = load_tif( argv[1], (RGB *)&palette );     if(map==NULL) return 0;
    i = save_tif( "test.tif", map, (RGB *)&palette );
//allegro_message("* e *");
    set_palette( (RGB *)&palette );
    blit( map, screen,0,0,0,0,map->w, map->h );


//        textprintf(screen,font, 0,0,makecol(255,255,255)," nsamples:%d, bitspersample: %d",nsamples, bitspersample);
//        textprintf(screen,font, 0,9,makecol(225,225,225)," orientation: %d photometric:%d", orientation, photometric );

readkey();

    allegro_exit();
    exit(0);
}
END_OF_MAIN();

*/

