/*
   TB    TooBar  sub functions

*/
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "tb.h"
#include "data.h"
#include "method.h"
#include "fnt.h"
#include "clip.h"
#include "zoom.h"
#include "grey.h"
#include "md.h"
#include "ed.h"
#include "btn.h"
#include "ll.h"
#include "butil.h"
#include "subs.h" /* for mousi system */



/* base index of beginning of graphic */
#define BASETB 24

/**** prototypes ****/
void tb_init(void);
void tb_deinit(void);
void tb_display_group(int);
void tb_undisplay_group(int);
int tb_bar(int,DIALOG *,int);
/**** prototypes ****/


/*
 * g.draw_method is used for sticky methods and the MTD_ flags
 * sticky methods are executed from 'md.c' and 'md2.c' modules instead.
 * a new flag is needed to control the hourwatch mouse shape 'dialog'.
 *
 */



TBLINK main_tb[]={
/*
 is_dxe, dialog, mouse_number, stickyflag,   // mouse shape will change when method is sticky
    loop_flag, method_index,
    pre_callback, callback, post_callback,
    dxecallback,
    clickedbmp, unclickedbmp, "description"
*/
 { 0,0, 2,1,0,MTD_PUTPIXEL     ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"putpixel"},
 { 0,0, 3,1,0,MTD_PUTPIXELCONT ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"freedraw"},
 { 0,0, 4,1,0,MTD_PUTTEXT      ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"put text, mousebutton 1 color, mousebutton2 - paste"},
 { 0,0, 5,1,0,MTD_COLORPICK    ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"color picker"},
 { 0,0, 6,1,0,MTD_SOLIDFILL    ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"solid fill"},
 { 0,0, 7,1,0,MTD_PATFILL      ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"patterned fill, mous btns:1&3"},
 { 0,0, 8,1,0,MTD_DRAWLINE     ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"draw line"},
 { 0,0, 9,1,0,MTD_DRAWRECT     ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"draw rectangle"},
 { 0,0,10,1,0,MTD_DRAWTRIANGLE ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"draw triangle"},
 { 0,0,11,1,0,MTD_DRAWELLIPS   ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"draw ellipse"},
 { 0,0,11,1,0,MTD_DRAWCIRCLE   ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"draw circle"},
 { 0,0, 8,1,0,MTD_DRAWPOLYLINE ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"polyline"},

 { 0,0, 8,1,0,MTD_TAPER        ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"Taper. measures angle and length"},

 { 0,0,12,1,0,MTD_DEFSRCRECT   ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"define source rectangle"},
 { 0,0,13,1,0,MTD_DEFDSTRECT   ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"define destination rectangle"},
 { 0,0,14,1,0,MTD_CHANGESRC    ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"change source rect"},
 { 0,0,15,1,0,MTD_CHANGEDST    ,NULL,      NULL,                NULL,       NULL,NULL,NULL,  NULL,NULL,"change destination rect"},
 { 0,0, 0,0,1,0                ,precall_2, mtd_copysrc2dst,     NULL,       NULL,NULL,NULL,  NULL,NULL,"copy source -> dest"},
 { 0,0, 0,0,1,0                ,precall_2, mtd_copysrc2dsttr,   NULL,       NULL,NULL,NULL,  NULL,NULL,"copy source -> dest.transparent"},
 { 0,0, 0,0,1,0                ,precall_2, mtd_copysrc2dstov,   NULL,       NULL,NULL,NULL,  NULL,NULL,"copy source -> dest.overlay"},
 { 0,0, 0,0,1,0                ,precall_2, mtd_copyscale,       NULL,       NULL,NULL,NULL,  NULL,NULL,"copy with scale"},
 { 0,0, 0,0,1,0                ,precall_2, mtd_copyscaletr,     NULL,       NULL,NULL,NULL,  NULL,NULL,"copy with scale.transparent"},
 { 0,0, 0,0,1,0                ,precall_2, mtd_copyscaleov,     NULL,       NULL,NULL,NULL,  NULL,NULL,"copy with scale.overlay"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_flipprms,        postcall_1, NULL,NULL,NULL,  NULL,NULL,"flip blocks src/dst"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_adap_size_src,   postcall_1, NULL,NULL,NULL,  NULL,NULL,"adapt size: [src] <- dst"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_adap_pos_src,    postcall_1, NULL,NULL,NULL,  NULL,NULL,"adapt position: [src] <- dst"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_assign_blk_src,  postcall_1, NULL,NULL,NULL,  NULL,NULL,"assign block: [src] <- dst"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_adap_size_dst,   postcall_1, NULL,NULL,NULL,  NULL,NULL,"adapt size: src -> [dst] "},
 { 0,0, 0,0,0,0                ,NULL,      mtd_adap_pos_dst,    postcall_1, NULL,NULL,NULL,  NULL,NULL,"adapt position: src -> [dst]"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_assign_blk_dst,  postcall_1, NULL,NULL,NULL,  NULL,NULL,"assign block: src -> [dst] "},
 { 0,0, 0,0,0,0                ,NULL,      mtd_destroysrcdst,   postcall_2, NULL,NULL,NULL,  NULL,NULL,"destroy src/dst"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_getsrcbrush,     NULL,       NULL,NULL,NULL,  NULL,NULL,"get src bitmap into brush"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_splitplane,      postcall_2, NULL,NULL,NULL,  NULL,NULL,"Split into bitplanes"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_joinplane,       postcall_2, NULL,NULL,NULL,  NULL,NULL,"Join bitplanes"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_new_test,        postcall_2, NULL,NULL,NULL,  NULL,NULL,"Error diffusion"},
 { 0,1, 0,0,0,0                ,NULL,      mtd_gamma_pal,       NULL,       NULL,NULL,NULL,  NULL,NULL,"Apply gammacorrection on palette"},
 { 0,1, 0,0,0,0                ,NULL,      mtd_resizecanvas,    NULL,       NULL,NULL,NULL,  NULL,NULL,"Resize canvas, all"},
 { 0,1, 0,0,0,0                ,NULL,      mtd_rescalecanvas,   NULL,       NULL,NULL,NULL,  NULL,NULL,"Rescale canvas, all"},
 { 0,1, 0,0,0,0                ,NULL,      mtd_loadpalgraphic,  NULL,       NULL,NULL,NULL,  NULL,NULL,"Load Palette from graphic"},
 { 0,1, 0,0,0,0                ,NULL,      mtd_loadpal,         NULL,       NULL,NULL,NULL,  NULL,NULL,"Load Palette from file"},
 { 0,1, 0,0,0,0                ,NULL,      mtd_savepal,         NULL,       NULL,NULL,NULL,  NULL,NULL,"Save Palette to file"},

 { 0,0, 0,0,0,0                ,NULL,      mtd_shiftpal1,       NULL,       NULL,NULL,NULL,  NULL,NULL,"Shift Palette indexes upward"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_shiftpal2,       NULL,       NULL,NULL,NULL,  NULL,NULL,"Shift palette indexes downward"},

 { 0,0, 0,0,0,0                ,NULL,      mtd_sort_light_up,   postcall_2, NULL,NULL,NULL,  NULL,NULL,"Sort pal colors, light up."},
 { 0,0, 0,0,0,0                ,NULL,      mtd_binop_or,        postcall_2, NULL,NULL,NULL,  NULL,NULL,"binary operation: OR"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_binop_xor,       postcall_2, NULL,NULL,NULL,  NULL,NULL,"binary operation: XOR"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_binop_and,       postcall_2, NULL,NULL,NULL,  NULL,NULL,"binary operation: AND"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_binop_copymask,  postcall_2, NULL,NULL,NULL,  NULL,NULL,"COPY with MASK, first image, second mask"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_split_into_rgb,  postcall_2, NULL,NULL,NULL,  NULL,NULL,"Split into rgb"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_join_from_rgb,   postcall_2, NULL,NULL,NULL,  NULL,NULL,"Join rgb into single"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_grey_avg,        postcall_2, NULL,NULL,NULL,  NULL,NULL,"average grey pictures"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_grey_add,        postcall_2, NULL,NULL,NULL,  NULL,NULL,"add grey pictures"},
 { 0,0, 0,0,0,0                ,NULL,      mtd_grey_sub,        postcall_2, NULL,NULL,NULL,  NULL,NULL,"sub grey pictures"},
 { 0,1, 0,0,0,0                ,NULL,      mtd_selbrush,        NULL,       NULL,NULL,NULL,  NULL,NULL,"Select brush"},
 { 0,1, 0,0,0,0                ,NULL,      mtd_selbkmap,        NULL,       NULL,NULL,NULL,  NULL,NULL,"Select backgroundmap"},

 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" }, // suitable for DXE
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },
 { 1,0, 0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,"???" },  // suitable for DXE

 { 0,0, 0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,NULL }, /* if description is NULL then end */
 { 0,0, 0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,NULL }, /* if description is NULL then end */
 { 0,0, 0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,NULL }, /* if description is NULL then end */
 { 0,0, 0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,  NULL,NULL }  /* if description is NULL then end */
};


/* prototypes for helper functions */
void tb_draw_outlines(void);
void tb_display_group(int grp);
/* prototypes for helper functions */




static int tb_group = 0;    /* current group        */
static int grptot   = 0;    /* total number of buttons  */
static int grpgrp   = 0;    /* number of groups     */
static int grpnum   = 0;    /* number of buttons in one group   */
static int grpnummod= 0;    /* number of buttons in last group  */





int tb_fix_bitmapbuttons()
{
    int     i=0,j=0;
    BITMAP  *bm=NULL, *bm2=NULL;


    bm  = create_bitmap_ex( g.bpp, 30, 30 );    if( bm==NULL ) error_("cant create bitmap 30x30");
    clear_bitmap( bm );
    for(i=0;;i++){
    if( main_tb[i].description==NULL ) break;
        if( main_tb[i].is_dxe==0){
        main_tb[i].unclickedbmp = bm;
        main_tb[i].clickedbmp   = bm;
        }
    }

    for(i=0,j=0;;i++){
    if( main_tb[i].description==NULL ) break;

    if( main_tb[i].is_dxe==0){
        bm  = create_bitmap_ex( g.bpp, tb_esx, tb_esy );    if( bm==NULL ) error_("grrr2...");
        bm2 = create_bitmap_ex( g.bpp, tb_esx, tb_esy );    if( bm2==NULL) error_("grrr2...");
        stretch_blit( g.bitmap_buttons_remap, bm,
            0, 30 *  (BASETB + j + 1) ,
            30, 30, 0, 0, tb_esx, tb_esy );
        blit( bm, bm2, 0,0,0,0, tb_esx, tb_esy);

        if(g.bpp==8){
            remap_bitmap( bm,  255, g.buttoncolor );   // 255 -> g.buttoncolor
            remap_bitmap( bm2, 255, g.buttoncolor );   //
        }
        xchg_bitmap(  bm2, 0,   g.buttoncolor );   // exchange colors (swap)
        main_tb[i].unclickedbmp = bm;
        main_tb[i].clickedbmp   = bm2;
        j++;
    }

    }
    return i;
}



int tb_remap_bitmapbuttons( int oldcolor, int newcolor )
{
    int     i=0,j=0;
    BITMAP  *bm1=NULL, *bm2=NULL;

    if(g.bpp!=8) return;

    for(i=0,j=0;;i++){
    if( main_tb[i].description==NULL ) break;

    bm1 = main_tb[i].clickedbmp;
    bm2 = main_tb[i].unclickedbmp;

    remap_bitmap( bm1, oldcolor, newcolor );
    remap_bitmap( bm2, oldcolor, newcolor );


/*
    xchg_bitmap(  bm2, 0,   g.buttoncolor );   // exchange colors (swap)
    remap_bitmap( bm1, 255, g.buttoncolor );   // 255 -> g.buttoncolor
    remap_bitmap( bm2, 255, g.buttoncolor );   //
*/


    }
}









void tb_init(void)      /* once */
{
    int     i=0;
    int     sx, width;
//    BITMAP  *bm=NULL, *bm2=NULL;


    i = tb_fix_bitmapbuttons();

    grptot = i;
    tb_group = 0;   /* current button group number */
    tb_spx = 4;     /* space between elements */
    tb_spy = 5;
    tb_x = in_x + in_sx + 8;    /* dependency of position */
    tb_y = sp_y + sp_sy + 1;

    // fit maximum number of buttons on screen
    sx     =  g.screen_w - 7 - tb_x;

    width  =  ( tb_esx + tb_spx );      // width + space of one button
    grpnum =    sx / width;
    grpnum--;
    grpgrp = grptot / grpnum;            // numbers of groups
    /* fit maximum number of buttons on screen */
    grpnummod = grptot - grpnum * grpgrp;      // modulus

    tb_sx  = 1 + tb_spx + (tb_esx+tb_spx)*(grpnum+1) + 1 + tb_spx + 1;
    tb_sy  = 1 + tb_spx + tb_esy + tb_spx + 1 + 1;
    tb_asx =     tb_spx + (tb_esx+tb_spx)* grpnum;
    tb_asy =     tb_sy - 1 ;

    i = IDX_EXCHNG;       /* button exchanger */
    main_dialog[i].x     = tb_x + 1 + tb_spx;
    main_dialog[i].y     = tb_y + 1 + tb_spy;
    main_dialog[i].w     = tb_esx;
    main_dialog[i].h     = tb_esy;
    main_dialog[i].fg    = g.syscolor1;
    main_dialog[i].bg    = 0;
    main_dialog[i].flags = D_EXIT;

    i = IDX_TOOLBR;      /* define clickable area */
    main_dialog[i].x     = tb_x + 1 + tb_esx + tb_spx*3;
    main_dialog[i].y     = tb_y + 1 + tb_spy;
    main_dialog[i].w     = (tb_esx+tb_spx) * grpnum;
    main_dialog[i].h     = tb_esy + tb_spy;
    main_dialog[i].fg    = g.syscolor1;
    main_dialog[i].bg    = 0;
    main_dialog[i].flags = 0;

    tb_isx2 = text_length( font, "sx:0000 Sy:0000" );
    tb_isx2 = 2;    // testing...

    tb_ix = tb_x;
    tb_iy = tb_y + tb_sy + 1;
    tb_isx = (md_x + md_sx) - tb_ix - 2 - 102 - tb_isx2;
    tb_isy = 17;

    tb_ix2 = tb_ix + tb_isx;

    i = IDX_BUTTONCOPY;      /* copy to clipboard */
    main_dialog[i].x     = tb_ix + tb_isx+tb_isx2;
    main_dialog[i].y     = tb_iy+1;
    main_dialog[i].w     = 49;
    main_dialog[i].h     = tb_isy;
    main_dialog[i].fg    = g.syscolor1;
    main_dialog[i].bg    = 0;
    main_dialog[i].flags = 0;

    i = IDX_BUTTONPASTE;      /* paste from clipboard */
    main_dialog[i].x     = tb_ix + tb_isx+tb_isx2+50;
    main_dialog[i].y     = tb_iy+1;
    main_dialog[i].w     = 49;
    main_dialog[i].h     = tb_isy;
    main_dialog[i].fg    = g.syscolor1;
    main_dialog[i].bg    = 0;
    main_dialog[i].flags = 0;


    if( g.vga_type == 0 ){
        i = IDX_BUTTONCOPY;      /* copy to clipboard */
        main_dialog[i].x     = tb_ix + tb_sx - 100;
        i = IDX_BUTTONPASTE;      /* paste from clipboard */
        main_dialog[i].x     = tb_ix + tb_sx - 50;
        tb_isx = tb_sx - 102 - tb_isx2;
    }


    tb_ibmp = create_bitmap_clear( tb_isx, tb_isy);   // text information line
//    tb_ibmp2 = create_bitmap_clear( tb_isx2, tb_isy);   // text information line
    tb_draw_outlines();           /* draw outlines */



    for(i=0;;i++){
        if(main_dialog[i].proc  == NULL ) break;
        main_dialog[i].fg    = g.syscolor1;
        main_dialog[i].bg    = 0;
    }

// readkey();
}


void tb_draw_outlines(void)
{
    vline(screen,
          tb_x+ tb_spx*2 + tb_esx + 2,
          tb_y,
          tb_y+tb_sy, g.syscolor1);

    //toolbar block rectangle
    rect(screen, tb_x, tb_y, tb_x+tb_sx, tb_y+tb_sy, g.syscolor1);
    //information block rectangle
    rect(screen, tb_ix, tb_iy, tb_ix+tb_isx, tb_iy+tb_isy, g.syscolor1);

    if( g.flag_dialog_init == TRUE ){
        object_message( &main_dialog[IDX_EXCHNG], MSG_DRAW, 0 );
        object_message( &main_dialog[IDX_TOOLBR], MSG_START, 0 );
        object_message( &main_dialog[IDX_TOOLBR], MSG_DRAW, 0 );
    }
}


void tb_deinit(void)
{
    main_dialog[IDX_TOOLBR].flags = D_DISABLED | D_HIDDEN;
    destroy_bitmap( tb_ibmp );  tb_ibmp = NULL;
}





void tb_display_group( int grp )
{
    broadcast_dialog_message(  MSG_DRAW, 0 );
}


static  BITMAP  *tmpmap = NULL;


/* swap toolbars buttons               */
int tb_exchanger(int msg, DIALOG *d, int c)
{
    int     z=0;

    z = BASETB + MTD_EXCHANGER;

    switch (msg){


    case MSG_GOTMOUSE:
      if(d->dp!=NULL){
        printout_infoblock( d->dp );
        }
    break;


    case MSG_LOSTMOUSE:
        printout_infoblock( " " );
    break;
/*
void stretch_blit(BITMAP *source, BITMAP *dest,
                  int source_x, source_y, source_width, source_height,
                  int dest_x, dest_y, dest_width, dest_height);
   Like blit(), except it can scale images so the source and destination 
   rectangles don't need to be the same size. This routine doesn't do as 
   much safety checking as the regular blit: in particular you must take 
   care not to copy from areas outside the source bitmap, and you cannot 
   blit between overlapping regions, ie. you must use different bitmaps for 
   the source and the destination. Also, the source must be a memory bitmap 
   or sub-bitmap, not the hardware screen.
void blit(BITMAP *source, BITMAP *dest, int source_x, int source_y,
          int dest_x, int dest_y, int width, int height);
*/

    case MSG_DRAW:
    scare_mouse();
    acquire_screen();
//    blit( g.bitmap_buttons_remap, screen,0,30*(z), d->x+2, d->y+2, d->w-3, d->h-3);

    if( g.bpp > 8 ){
    if( tmpmap ==NULL ) tmpmap = create_bitmap_ex( g.bpp, 30,30 );
    if( tmpmap ==NULL ) return D_O_K;
    blit( g.bitmap_buttons_remap, tmpmap,0,30*(z), 0,0, 30,30 );
    stretch_blit( tmpmap, screen,
         0,0,
         30,30,
         d->x+2, d->y+2,
         d->w-3, d->h-3
         );
    }
    if( g.bpp == 8 )
    stretch_blit( g.bitmap_buttons_remap, screen,
         0,30*(z),
         30,30,
         d->x+2, d->y+2,
         d->w-3, d->h-3
         );
    rect(screen, d->x-1, d->y-1, d->x+d->w, d->y+d->h, g.buttoncolor );
    release_screen();
    unscare_mouse();
    break;

    case MSG_CLICK:
    if( mouse_y <= d->y+d->h/2  ){
/* up */
    scare_mouse();
    xchg_bitmap_rect(screen, 0, g.buttoncolor, d->x+1, d->y+1, d->w-1, d->h/2-2 );
    unscare_mouse();
    while((mouse_b&1)==1){}
    scare_mouse();
    xchg_bitmap_rect(screen, 0, g.buttoncolor, d->x+1, d->y+1, d->w-1, d->h/2-1 );
    tb_group++;
    if( tb_group >= grpgrp && grpnummod==0) tb_group=0;
    if( tb_group >  grpgrp && grpnummod!=0) tb_group=0;

    }else{

/* down */
    scare_mouse();
    xchg_bitmap_rect(screen, 0, g.buttoncolor, d->x+1, d->y+d->h/2+1, d->w-1, d->h/2-1 );
    unscare_mouse();
    while((mouse_b&1)==1){}
    scare_mouse();
    if( tb_group == 0 ){
        tb_group = grpgrp;
        if( grpnummod!=0 ) tb_group = grpgrp+1;
    }
    tb_group--;
    }
    tb_display_group( tb_group );
    unscare_mouse();

    break;
    }
    return D_O_K;
}





















int tb_bar( int msg, DIALOG *d, int c )
{
    int sticky, sel_index, v=0;
    static int prevmx, prevmy;
    int x,y,i,j;
    int mx,my;          /* mouse x,y */
    int btx,bty;        /* button x,y in screen coords */
    int x1,x2,y1,y2;    /* button range */
    int top;
    char flag_inside=0;
    BITMAP *pspr1 = NULL;



    if( msg==MSG_XCHAR || msg==MSG_KEY || msg==MSG_CHAR ) return D_O_K;

    if( msg == MSG_START){
    d->fg = g.buttoncolor;
    prevmx = mouse_x;
    prevmy = mouse_y;
    scare_mouse();
        drawing_mode(DRAW_MODE_COPY_PATTERN, g.fillmap2, 0, 0);
        x = tb_x + 1 + 1 + tb_esx + tb_spx*2;
        rectfill(screen, x+1, tb_y+1, x+tb_asx, tb_y+tb_asy, 0);
        drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
    unscare_mouse();
    return D_O_K;
    }/* msg_start */


    if(msg==MSG_DRAW){
    if( tb_group == grpgrp ){
        drawing_mode(DRAW_MODE_COPY_PATTERN, g.fillmap2, 0, 0);
//        drawing_mode(DRAW_MODE_COPY_PATTERN, g.fillmap3, 0, 0); //TEST
        x = tb_x + 1 + 1 + tb_esx + tb_spx*2;
        rectfill( screen, x+1, tb_y+1, x+tb_asx, tb_y+tb_asy, 0);
        drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
        top = grpnummod;
    }else{
     top = grpnum;
    }
    for(i=0; i < top ;i++) {
        x = d->x+(tb_esx+tb_spx)*i+1;
        y = d->y;
        if( main_tb[ tb_group * grpnum + i ].unclickedbmp != NULL )
            blit( main_tb[ tb_group * grpnum + i ].unclickedbmp, screen,0, 0,x, y,tb_esx, tb_esy );
        rect( screen, x-1,y-1, x + tb_esx+0, y + tb_esy+0, 0);
    }// for()
    return D_O_K;
    } /* msg_draw */


    if( msg == MSG_LOSTMOUSE){
        printout_infoblock( " " );
    return D_O_K;
    }/* msg_lostmouse */




    btx= d->x;
    bty= d->y;
    mx = mouse_x;
    my = mouse_y;
    sel_index=0;

    if( msg==MSG_GOTMOUSE || msg==MSG_CLICK ){

    set_mousi_bitmap( MOUS_POINTER );
//    set_mousi_bitmap( MOUS_HOURWATCH );


    sel_index=-1;
        if(tb_group==grpgrp){ top=grpnummod;
            }else{  top = grpnum;   }
    for(i=0;i<top+1;i++){
        x1 = d->x+((tb_esx+tb_spx)*i+2);
        x2 = x1+tb_esx-tb_spx;
        y1 = d->y+2;
        y2 = y1+tb_esy;
        if( x1 > mx && mx < x2 ){
            btx = d->x+((tb_esx+tb_spx)*(i-1));
            bty = d->y;
            sel_index = tb_group*grpnum + (i-1);
            i=grpnum+2;
            flag_inside = 1;
            break;
            }
        }/* for */
    if( sel_index==-1 ) return D_O_K;
    }/* msg_gotmouse or msg==msg_click */




    if( msg == MSG_CLICK && flag_inside==1 ){
    scare_mouse();
//CLICKED BITMAP
    if( main_tb[sel_index].clickedbmp != NULL )
        acquire_screen();
        blit( main_tb[sel_index].clickedbmp, screen,0, 0, btx+1, bty, tb_esx, tb_esy );
        release_screen();
    unscare_mouse();

//    set_mousi_bitmap( MOUS_POINTER );

    sticky   = main_tb[sel_index].stickyflag;
    i = g.draw_method;
    g.draw_method = main_tb[sel_index].method_index;

//    if(sticky==1)
//        set_mousi_bitmap( main_tb[sel_index].mouse_number );

    if(sticky==0){
        v = get_mousi_number();
//        if(main_tb[sel_index].dialog==0) set_mousi_bitmap( MOUS_HOURWATCH );  /* set hourwatch */
        }


    if(sticky==0){
        if( main_tb[sel_index].loop_flag == 0 ){

        if(main_tb[sel_index].pre_dxecallback!=NULL)  main_tb[sel_index].pre_dxecallback();
        pspr1 = ll_get_sprite(g.block_current);
        if(main_tb[sel_index].pre_callback !=NULL)    main_tb[sel_index].pre_callback( pspr1 );
        if(main_tb[sel_index].callback     !=NULL)    main_tb[sel_index].callback( pspr1 );
        if(main_tb[sel_index].dxecallback  !=NULL)    main_tb[sel_index].dxecallback( dxeclip_bmp,dxeclip_x1,dxeclip_y1,dxeclip_sx,dxeclip_sy);
        if(main_tb[sel_index].post_callback!=NULL)    main_tb[sel_index].post_callback( pspr1 );
        if(main_tb[sel_index].post_dxecallback!=NULL) main_tb[sel_index].post_dxecallback();

        }else{

        if( main_tb[sel_index].pre_dxecallback!=NULL) main_tb[sel_index].pre_dxecallback();
//        if(main_tb[sel_index].pre_callback !=NULL) main_tb[sel_index].pre_callback( pspr1 );
        CLOOP1
        pspr1 = ll_get_sprite(g.block_current);
        if(main_tb[sel_index].pre_callback !=NULL) main_tb[sel_index].pre_callback( pspr1 );
        if(main_tb[sel_index].callback     !=NULL) main_tb[sel_index].callback( pspr1 );
        if(main_tb[sel_index].dxecallback  !=NULL) main_tb[sel_index].dxecallback( dxeclip_bmp,dxeclip_x1,dxeclip_y1,dxeclip_sx,dxeclip_sy);
//        if(main_tb[sel_index].post_callback!=NULL) main_tb[sel_index].post_callback( pspr1 );
        CLOOP2
        if(main_tb[sel_index].post_callback!=NULL) main_tb[sel_index].post_callback( pspr1 );
        if( main_tb[sel_index].post_dxecallback!=NULL) main_tb[sel_index].post_dxecallback();

        refresh_screen();
        }
    }

    if(sticky==0){
        g.draw_method = i;
        set_mousi_bitmap( v );  // restore
//        mousi_number = v;    // in subs.c (must fix this mousi thingy...)
        }
//    if( sticky==0 )        g.draw_method = i;

        do j=mouse_b; while((j&1)!=0 );         /* Left mouse btn */
    scare_mouse();
//UNCLICKED BITMAP
    if( main_tb[sel_index].unclickedbmp != NULL )
        acquire_screen();
        blit( main_tb[sel_index].unclickedbmp, screen,0, 0, btx+1, bty, tb_esx, tb_esy );
        release_screen();
    unscare_mouse();
    set_mousi_bitmap( MOUS_POINTER );
    return D_O_K;
    }/* msg_click */


    if( msg==MSG_IDLE ){
    i = prevmx - mouse_x;
    j = prevmy - mouse_y;
        if( i != 0 || j != 0){
        prevmx = mouse_x;
        prevmy = mouse_y;

        btx= d->x;
        bty= d->y;
        mx = mouse_x;
        my = mouse_y;
        sel_index=-1;
        if(tb_group==grpgrp){ top=grpnummod;
            }else{  top = grpnum;   }
    for(i=0;i<top+1;i++){
        x1 = d->x+((tb_esx+tb_spx)*i);
        x2 = x1+tb_esx-tb_spx;
        y1 = d->y+2;
        y2 = y1+tb_esy;
        if( x1 > mx && mx < x2 ){
            btx = d->x+((tb_esx+tb_spx)*(i-1));
            bty = d->y;
            sel_index = tb_group*grpnum + (i-1);
            i=grpnum+2;
            break;
            }
        }
    if( sel_index==-1 ) return D_O_K;
    if( mx > d->x && my > d->y && mx < (d->x+d->w) && my < (d->y+d->h) ){
    if( main_tb[sel_index].description!=NULL){
        printout_infoblock( main_tb[sel_index].description );
    }}}}

    return D_O_K;
}



void printout_infoblock( char *_message )
{
    char *message = _message;
    FNT  *fntx = NULL;
    int   tbb=0;

    if( tb_ibmp == NULL ) return;
    clear_to_color( tb_ibmp, 0 );
    if( message == NULL ) message=" ";
    if( g.vga_type == 0 ){
        fntx = fnt1;    tbb = 4;
    }else{
        fntx = fnt2;    tbb=0;
    }
    fnt_textout( tb_ibmp, fntx, message, 2,0, g.syscolor1, 0, 0 );
    scare_mouse();
    acquire_screen();
    blit( tb_ibmp, screen,0,0, tb_ix+1, tb_iy+1 +tbb , tb_isx-1, tb_isy-1-tbb );
    release_screen();
    unscare_mouse();
}

