/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\

         Extra Subroutines used by main window
*/
//#include <stdarg.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <allegro.h>
#include "data.h"
#include "ll.h"
#include "dlg.h"
#include "comdlg.h"
#include "fsel.h"
#include "zoom.h"
#include "ed.h"
#include "btnsub.h"
#include "method.h"
#include "butil.h"
#include "tb.h"
#include "btn.h"
#include "md.h"
#include "subs.h"
#include "libfli/fli.h"
#include "libgif/gif_lib.h"

/**** prototypes ****/
#include "subs.h"
static void free_buttonarray_buttons();
/**** prototypes ****/


/*** Prototypes for helper functions ***/
/***                                 ***/
static void handle_bkmap();
static void handle_brush();
static void parse_flags( char *s_flags );
static void parse_usrcolors( char *tmpstr, char *colors );
static void parse_syscolors( char *tmpstr, char *colors );
// static void handle_colormapping( int, int, int );
static int load_graphic_blocks();
static void handle_fillstructure( char *fillflags );
static void create_default_palette(void);
int rt_closest_map(unsigned char r, unsigned char g, unsigned char b, int precision);
/***                                 ***/
/*** Prototypes for helper functions ***/


/****************************************/
/******** data for mouse system *********/
static int mousi_sx;               /* size x */
static int mousi_sy;               /* size y */
static BITMAP *mou_bmps;           /* all mouses bitmap        */
static BITMAP *mou_se;             /* single mouse bitmap      */
static BITMAP *mou_se2;            /* single mouse bitmap, 8 bpp only      */
static BITMAP *mou_se3;            /* single mouse bitmap, g.bpp  only      */
static int mousi_number=0;           /* last mouse index number */
static int mousi_count;            /* how many mouse bitmaps are available */
static int *mhx, *mhy;             /* mouse-hot-spot arrays, allocated sizes */
/*  prototypes */
static int init_mousi_system(void);
static BITMAP *get_mousi_bitmap( int number, int typedraw );
static void arrange_mousi_arrays();

/******** data for mouse system *********/
/****************************************/



static void request_unknown_file( int number_of_blocks );




/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
typedef struct{
int ssx,       ssy;            /* screen size x,     screen size y    */
int btn_sx,    btn_sy;         /* button_size_x,     button_size_y    */
int space;                     /* space between buttons               */
int tb_btn_sx, tb_btn_sy;      /* tb_btn_size_x,     tb_btn_size_y    */
int pal_esx,   pal_esy;        /* palette_e_size_x,  palette_e_size_y */
int slider_width;              /* slider_width                        */
}_BUILTINCONFIGS_;
/* vga types:  0    1    2    3    4    5    6    7    */


static _BUILTINCONFIGS_ config[]={      // windower
{ 600, 400,24,24, 2, 20,20, 8, 8,12  },
{ 620, 420,24,24, 4, 27,27, 9, 9,13  }, // { 640, 480,30,30, 4, 30,30,11,11,13  },
{ 700, 500,32,32, 4, 30,30,11,11,15  }, // { 800, 600,40,40, 4, 30,30,14,14,15  },
{ 940, 700,40,40, 4, 30,30,16,16,18  }, // {1024, 768,51,51, 4, 30,30,20,18,19  },
{1000, 800,45,45, 4, 30,30,20,19,19  }, // {1152, 864,45,45, 4, 30,30,20,18,19  },
{1100, 920,50,50, 4, 35,35,22,22,19  }, // {1280,1024,50,50, 4, 40,40,23,24,20  },
{1500,1100,60,60, 4, 40,40,26,26,20  }, // {1600,1200,60,60, 4, 40,40,26,26,20  },
{1600,1200,60,60, 4, 40,40,26,26,20  }, // 2048 x 1536
};

static _BUILTINCONFIGS_ config2[]={     // fullscreen
{ 640, 480,24,24, 2, 20,20, 8,10,12  },
{ 640, 480,24,24, 4, 27,27, 9,10,13  }, // { 640, 480,30,30, 4, 30,30,11,11,13  },
{ 800, 600,32,32, 4, 30,30,11,14,15  }, // { 800, 600,40,40, 4, 30,30,14,14,15  },
{1024, 768,40,40, 4, 30,30,16,18,18  }, // {1024, 768,51,51, 4, 30,30,20,18,19  },
{1152, 864,45,45, 4, 30,30,20,20,19  }, // {1152, 864,45,45, 4, 30,30,20,18,19  },
{1280,1024,50,50, 4, 35,35,22,25,19  }, // {1280,1024,50,50, 4, 40,40,23,24,20  },
{1600,1200,60,60, 4, 40,40,26,26,20  }, // {1600,1200,60,60, 4, 40,40,26,26,20  },
{1920,1080,60,60, 4, 40,40,26,26,20  }, // HDTV
};








ED_BUTTONARRLNK my_main_buttons[]={
/*
    int dialog;             // 1= invoke dialog, 0=no
    int mouse_shape_index;  // number of mouse shape, should be 0 for non-sticky
    int stickyflag;         // 1-sticky, 0-nonsticky
    char *main_description;         // normal
    char *tooltips_description;     // short
    BITMAP *shape;                  // normal button shape
    BITMAP *shape_clicked;          // clicked button shape
    void (*button_function)(char,char); // called when button is pressed argument 1: mouse button number, 2: dblclick flag
*/
 { 0,0,0, "Copy to buffer",     "copy",     NULL, NULL , b_copy    },
 { 0,0,0, "Previous block",     "prev",     NULL, NULL , b_prev    },
 { 0,0,0, "Next block",         "next",     NULL, NULL , b_next    },
 { 0,0,0, "Paste from buffer",  "paste",    NULL, NULL , b_paste   },
 { 0,0,0, "Go to first block",  "first",    NULL, NULL , b_first   },
 { 0,0,0, "Go to last block",   "last",     NULL, NULL , b_last    },
 { 0,0,0, "cut block",          "cut",      NULL, NULL , b_cut     },
 { 0,0,0, "shift up",           "up",       NULL, NULL , b_shu     },
 { 0,0,0, "insert block",       "insert",   NULL, NULL , b_insert  },
 { 0,0,0, "shift left",         "left",     NULL, NULL , b_shl     },
 { 0,0,0, "rotate free degrees","rotate",   NULL, NULL , b_rotINT  },
 { 0,0,0, "shift right",        "right",    NULL, NULL , b_shr     },
 { 0,0,0, "zoom minus",         "zoom -",   NULL, NULL , b_zoomm   },
 { 0,0,0, "shift down",         "down",     NULL, NULL , b_shd     },
 { 0,0,0, "zoom plus",          "zoom +",   NULL, NULL , b_zoomp   },
 { 0,0,0, "flip upsidedown",    "flip y",   NULL, NULL , b_flip    },
 { 0,0,0, "flip sideways",      "flip x",   NULL, NULL , b_mirror  },
 { 0,0,0, "rotate 90 degrees",  "rotate90", NULL, NULL , b_rot90   },
 { 0,0,0, "clear image",        "clear",    NULL, NULL , b_cls     },
 { 0,0,0, "play images",        "play",     NULL, NULL , b_play    },
 { 0,0,0, "fill image",         "fill",     NULL, NULL , b_fillpat },
 { 0,0,0, "unused",             "unused",   NULL, NULL , b_textfont},
 { 0,0,0, "File import/export", "file",     NULL, NULL , b_import  },
 { 0,0,0, "save all images",    "save all", NULL, NULL , b_save    },
 { 0,0,0, "nothing",            "nothing",  NULL, NULL , NULL },
 { 0,0,0, NULL,NULL,                        NULL, NULL , NULL }    // END marker
};



static int tobool( int i )
{
    i&=1;
    if(i==0) return FALSE;
    if(i==1) return TRUE;
    return FALSE;
}
static int itobool( int i )
{
    if(i==FALSE) return 0;
    if(i==TRUE) return 1;
    return 0;
}

//typedef struct { int r,g,b; } CC;
//CC c[3];
struct { int r,g,b; } c[4], cc[4];



PALETTE grey_palette;




static char string2[ FILENAME_MAX+44 ];



void load_config_data( char *configfilename, int screen_size, int cmdl_alternate )
{
    int     newlen=0;
    char    *newpath = NULL;
    BITMAP *tmp1 = NULL;
    int     mouse_speedx, mouse_speedy;
    int     i = 0;
    ED_BUTTONARRAY_WINDOW *ed_btnarr = NULL;
    int     t_slidepos  = 0,
            t_spr_count = 0;

    char    *s_str_mouse    = NULL,
            *s_rgbs         = NULL,
            *s_fillflags    = NULL,
            *s_graphic_name = NULL,
            *s_flags        = NULL,
            *s_sysfiles     = NULL,
            *s_project_name = NULL,
            *s_zoom_xy   = NULL,
            *s_usrcolors = NULL,
            *s_syscolors = NULL;
    char    *s = NULL;
    char    *tmpstr = NULL;
    int     desktop_width=0, desktop_height=0, desktop_bpp=8;
    int     flag_format=0;

    g.syscol1.r = g.syscol1.g = g.syscol1.b = 200;
    g.syscol2.r = g.syscol2.g = g.syscol2.b = 200;
    g.syscol3.r = g.syscol3.g = g.syscol3.b = 200;
    g.block_count = 0;




    create_default_palette();
    select_palette( (RGB *)&grey_palette );
    set_palette( (RGB *)&g.palette );       // set loaded palette

    g.configfilename = configfilename;
    if( exists( configfilename ) == 0 )  error_("config file don't exists: %s", configfilename );

    set_config_file( configfilename );

    g.bpp           = (int)    get_config_int(NULL,"bpp", 8 );
    g.vga_type      = (int)    get_config_int(NULL,"vga", -1 );
    g.flag_fullscreen = tobool( get_config_int(NULL,"fullscreen", 0 )&1);

    t_slidepos      = tobool( get_config_int(NULL,"slidepos",0)&1 );
    s_str_mouse     = (char *) get_config_string(NULL, "mouse_speed","1 1" );
    s_rgbs          = (char *) get_config_string(NULL, "rgbs", "175 175 175 100 200 120 120 130 145");
    s_sysfiles      = (char *) get_config_string(NULL, "sysfiles", "exa1.pcx exa2.pcx exa3.pcx " );
    s_fillflags     = (char *) get_config_string(NULL, "fillflags", "0 0 0 0 0 0 0 0 0");
    s_project_name  = (char *) get_config_string(NULL, "current_project",NULL );


    desktop_bpp = desktop_color_depth();
    if( get_desktop_resolution( &desktop_width, &desktop_height ) == -1 ) error_("can't get desktop resolution");
    set_color_depth( g.bpp );  // Valid depths are 8 (the default), 15, 16, 24, and 32

    if(g.flag_fullscreen == FALSE ){
          if(g.vga_type<0){
            for(i=0;i<7;i++){
            if(config[7-i].ssx <= desktop_width ){
                if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, config[7-i].ssx,config[7-i].ssy, 0, 0) == 0) {
                g.vga_type = 7-i;
                break;
                }
            }
            }
        }else{
        if( g.vga_type > 7 ) g.vga_type = 7;
            if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, config[g.vga_type].ssx, config[g.vga_type].ssy, 0, 0) != 0) {
            allegro_message("Unable to set graphic mode: %s", allegro_error);
            exit(0);
            }
        }
    }else{  // fullscreen type
        if(g.vga_type<0){
            for(i=0;i<7;i++){
            if(config2[7-i].ssx <= desktop_width ){
                if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, config2[7-i].ssx,config2[7-i].ssy, 0, 0) == 0) {
                g.vga_type = 7-i;
                break;
                }
            }
            }
        }else{
        if( g.vga_type > 7 ) g.vga_type = 7;
            if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, config2[g.vga_type].ssx, config2[g.vga_type].ssy, 0, 0) != 0) {
            allegro_message("Unable to set graphic mode: %s", allegro_error);
            exit(0);
            }
        }

    }


//    GFX_AUTODETECT, GFX_AUTODETECT_FULLSCREEN or GFX_AUTODETECT_WINDOWED, or

    clear_bitmap( screen );
    create_vga_palette( (RGB *)&g.palette );
    set_palette( (RGB *)&g.palette );


/*
    scare_mouse();
    select_mouse_cursor( MOUSE_CURSOR_ARROW );
    set_mouse_sprite( NULL );   // default shape
    set_mouse_sprite_focus( 0,0  );
    unscare_mouse();
    show_mouse( screen );
*/


//    enable_hardware_cursor();
/*
    scare_mouse();
    select_mouse_cursor( MOUSE_CURSOR_ARROW );
    show_mouse( screen );
    unscare_mouse();
*/

/*

    scare_mouse();
    set_mouse_sprite( NULL );   // default shape
    set_mouse_sprite_focus( 0,0  );
    show_mouse( screen );
    unscare_mouse();
*/



    scare_mouse();
    set_mouse_sprite( NULL );   // default shape
    set_mouse_sprite_focus( 0,0  );
    select_mouse_cursor( MOUSE_CURSOR_ARROW );
    enable_hardware_cursor();
    show_mouse( screen );
    unscare_mouse();



    // process
    // ...
    // handle sysfiles
    g.buttonfile = alloc_string( s_sysfiles, -1 );
    g.mousefile  = alloc_string( s_sysfiles, -1 );
    g.fillfile   = alloc_string( s_sysfiles, -1 );
    sscanf( s_sysfiles,"%s %s %s", g.buttonfile, g.mousefile, g.fillfile );
    if( exists( g.buttonfile )==0 ) error_("Button bitmap file %s don't exist", g.buttonfile );
    if( exists( g.mousefile  )==0 ) error_("mouse bitmap file %s don't exist",  g.mousefile  );
    if( exists( g.fillfile   )==0 ) error_("fill pattern file %s don't exist",  g.fillfile   );


    // ...
    if( sscanf( s_rgbs,"%d %d %d %d %d %d %d %d %d",\
        &cc[0].r, &cc[0].g, &cc[0].b, &cc[1].r, &cc[1].g, &cc[1].b, &cc[2].r, &cc[2].g, &cc[2].b) <9)
        error_("too few colors in rgbs= field, (must be 9 numbers with range 0-255)");
    parse_syscolors( NULL, s_rgbs );


    g.project_name = alloc_string( s_project_name, -1 );
    if( g.project_name==NULL ) error_("no project specified at all.");


    // ...
    /*----------------------------------------------------------------------*/
    g.vga_type &= 7;
    if(g.flag_fullscreen == FALSE ){
        g.screen_w = config[ g.vga_type ].ssx;
        g.screen_h = config[ g.vga_type ].ssy;
        bt_esx     = config[ g.vga_type ].btn_sx;
        bt_esy     = config[ g.vga_type ].btn_sy;
        tb_esx     = config[ g.vga_type ].tb_btn_sx;
        tb_esy     = config[ g.vga_type ].tb_btn_sy;
        pl_esx     = config[ g.vga_type ].pal_esx;
        pl_esy     = config[ g.vga_type ].pal_esy;
        mc_s       = config[ g.vga_type ].slider_width;
    }else{
        g.screen_w = config2[ g.vga_type ].ssx;
        g.screen_h = config2[ g.vga_type ].ssy;
        bt_esx     = config2[ g.vga_type ].btn_sx;
        bt_esy     = config2[ g.vga_type ].btn_sy;
        tb_esx     = config2[ g.vga_type ].tb_btn_sx;
        tb_esy     = config2[ g.vga_type ].tb_btn_sy;
        pl_esx     = config2[ g.vga_type ].pal_esx;
        pl_esy     = config2[ g.vga_type ].pal_esy;
        mc_s       = config2[ g.vga_type ].slider_width;
    }
    /*----------------------------------------------------------------------*/


    // load drax1,2,3 ...


    // ----------------------------------------------------------
    //            DRAX1.PCX     BUTTONSfile
    if( g.flag_verbose == TRUE )
        printf("loading buttonfile : %s\n", g.buttonfile );
    g.bitmap_buttons       = load_bitmap( g.buttonfile, (RGB *)&g.palette_remap );    if(g.bitmap_buttons==NULL) error_("loading button bitmap file '%s'",g.buttonfile);
    g.bitmap_buttons_remap = create_bitmap_ex( g.bpp, g.bitmap_buttons->w, g.bitmap_buttons->h );    if(g.bitmap_buttons_remap==NULL) error_("creating button bitmap copy for remap");
    // testing g.bpp instead of 8
    // ----------------------------------------------------------
    //            DRAX2.PCX     MOUSESHAPEfile
    // mouse stuff init
    sscanf(s_str_mouse,"%d %d ", (int *)&mouse_speedx,(int *)&mouse_speedy);
    if( g.flag_verbose == TRUE ){
        printf("mouse speeds (x,y) : %d,%d\n", mouse_speedx, mouse_speedy );
        printf("loading mousefile  : %s\n", g.mousefile );
    }
    mou_bmps = load_bitmap( g.mousefile, (RGB *)&g.palette_remap );    if( mou_bmps == NULL ) error_("loading mousefile '%s'",g.mousefile);
    if( init_mousi_system()==FALSE) error_("init mouse stuff");
    set_mouse_speed( mouse_speedx, mouse_speedy );
    set_mousi_bitmap( MOUS_POINTER );
    // ----------------------------------------------------------
    //            DRAX3.PCX     FILLfile
    //     DRAX3.pcx
        if( g.flag_verbose == TRUE )
            printf("loading fillfile   : %s\n", g.fillfile );
        fillstruct.bmpfixed    = load_bitmap ( g.fillfile, (RGB *)&g.palette_remap );
        if( fillstruct.bmpfixed == NULL) error_("can't load bitmap: '%s'", g.fillfile );
        fillstruct.bmpfixed2   =create_bitmap_ex( g.bpp, fillstruct.bmpfixed->w, fillstruct.bmpfixed->h );
        if( fillstruct.bmpfixed2 == NULL) error_("can't create bitmap, ec=100" );
    // ----------------------------------------------------------
    // ...


// error_( "<%s> <%s>",g.project_name,s_project_name);






    // Scan current project
    s_graphic_name  = (char *) get_config_string(g.project_name, "filename", NULL );
    s_project_name  = (char *) get_config_string(g.project_name, "size_xy", "0 0" );
    s_zoom_xy       = (char *) get_config_string(g.project_name, "zoom_xy", "0 0" );
    g.zoom          = (int) get_config_int(g.project_name,    "zoom_am", 0     );
    g.draw_method   = MTD_PUTPIXELCONT;
    g.block_current = (int) get_config_int(   g.project_name, "block_current",0);
    t_spr_count     = (int) get_config_int(   g.project_name, "block_amount", 0);
    s_usrcolors     = (char *) get_config_string(g.project_name, "usrcolors","0 0 0" );
    s_syscolors     = (char *) get_config_string(g.project_name, "syscolors","-1 -1 -1" );
    s_flags         = (char *) get_config_string(g.project_name, "flags", "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 " );

    if( s_graphic_name == NULL )  error_("project don't exist: '%s'", g.project_name );
    g.graphic_name = alloc_string( s_graphic_name, FILENAME_MAX+99 );
    sscanf( s_project_name,"%d %d", (int *)&g.sx, (int *)&g.sy );
    sscanf( s_zoom_xy ,"%d %d", (int *)&g.ox, (int *)&g.oy );

    parse_usrcolors( s_usrcolors, s_rgbs );
    parse_syscolors( s_syscolors, s_rgbs );
    parse_flags( s_flags );


    /*----------------------------------------------------------------------*/
    if( mc_s   < 10 ) mc_s   = 10;
    if( pl_esx < 3  ) pl_esx = 3;
    if( pl_esy < 3  ) pl_esy = 3;
    /*----------------------------------------------------------------------*/
    // to do: search for a plus sign after the end of filename
    s = strrchr(g.graphic_name, '+' );
    if( s==NULL ){    // not found
        }else{        // found
        g.flag_multi_archives = TRUE;
        g.flag_multi_positive = TRUE;
        s[0] = 0;   // cut out + sign
    }

    s = strrchr(g.graphic_name, '-' );
    if( s==NULL ){    // not found
        }else{        // found
        g.flag_multi_archives = TRUE;
        g.flag_multi_positive = FALSE;
        s[0] = 0;   // cut out - sign
    }
    str_right( g.graphic_name );    // remove leading spaces
    /*----------------------------------------------------------------------*/
    if( g.ox > g.sx ) g.ox = g.sx-1;
    if( g.oy > g.sy ) g.oy = g.sy-1;
    if( t_spr_count <= 0 ){
        g.block_current = 0;
    }

    if( t_spr_count != 0 )
        if( g.block_current >= t_spr_count ){ t_spr_count = g.block_current+1; }

    /*----------------------------------------------------------------------*/
    handle_bkmap();
    handle_brush();
    /*----------------------------------------------------------------------*/
    if( t_spr_count == 0 ) t_spr_count = 1;



    flag_format=0;
    if(find_flx_extension( get_extension(g.graphic_name))==TRUE) flag_format=1;
    if(find_gif_extension( get_extension(g.graphic_name))==TRUE) flag_format=2;
    if(strlen(get_extension(g.graphic_name)) == 0 )              flag_format=3; //invalid file

    if( exists( g.graphic_name ) == 0 ){    // *** file don't exists ***
        request_unknown_file(t_spr_count);
    }

    





















    // ----------------------------------
    textprintf(screen, font, 100,100, 255, "Loading...");
    i = load_graphic_blocks( t_spr_count );     // palette is now available
    if(i == -1) error_("can't load main graphic file %s", g.graphic_name );
    textprintf(screen, font, 200,100, 255, "OK");

//msgbox_("* a *");

    if( g.bpp <= 8 )
        set_palette( (RGB *)&g.palette );       // set loaded palette
    // ----------------------------------
    handle_colormapping(  g.syscol1.index1, g.syscol2.index1, g.syscol3.index1 );
    bestfit_main_graphic_to_g_palette();

    g.buttoncolor = g.syscolor1;
    // ----------------------------------
    // do a new remap of buttons based on current colors
    remap_bitmap2( g.bitmap_buttons, g.bitmap_buttons_remap, 255, g.buttoncolor );


printf(" g.bpp      = %d\n", g.bpp );
printf(" g.syscolor1= %d\n", g.syscolor1 );
printf(" g.syscolor2= %d\n", g.syscolor2 );
printf(" g.syscolor3= %d\n", g.syscolor3 );



    // ----------------------------
    if( alloc_buttonarray_buttons() == FALSE ) error_("Allocating system buttons");
    // ----------------------------
    ed_btnarr = allocate_buttonarray(
                &main_dialog[ IDX_BUTTONARRAY ],    // which dialog is to be used
                99,99,              // position
                bt_esx,bt_esy,      // buttonsize
        config[ g.vga_type ].space,config[ g.vga_type ].space,   // buttonspace
                3,8,                // amount of buttons in x,y
                (ED_BUTTONARRLNK *)&my_main_buttons, // all buttons
                g.syscolor1,        // linecolor
                g.syscolor3,        // fillcolor
                g.syscolor1,        // fgcolor
                g.syscolor2,        // bkcolor
                1,                  // linewidth
                0,                  // header height, 0 means disabled
                0,                  // header position from 0 to 3
                0,                  // fill pattern type,  0,1,6,7 from 0 to 9
                0,                  // flag moveable, 0=do not move, 1=move
                NULL                // caption
                );







    if( ed_btnarr == NULL) error_("allocating buttonarray structure");
    ed_btnarr->foreach_button_before = b_clickare; // callback for ALL buttons, let's enable it...
    ed_btnarr->foreach_button_after  = b_clickade; // callback for ALL buttons, let's enable it...

//msgbox_("* c *");
//error_("exit");
//printf(" g.buttoncolor = %d \n", g.buttoncolor );

    handle_fillstructure( s_fillflags );
    g.flag_alternate = t_slidepos;
//    clear_bitmap(screen);



/*
    scare_mouse();
    select_mouse_cursor( MOUSE_CURSOR_ARROW );
//    show_os_cursor( MOUSE_CURSOR_ARROW );
    set_mouse_sprite( NULL );   // default shape
    set_mouse_sprite_focus( 0,0  );
    unscare_mouse();
    show_mouse( screen );
*/
/*
    set_mousi_bitmap(0);
    show_mouse( screen );
    disable_hardware_cursor();
*/

    disable_hardware_cursor();
    remove_mouse();
    install_mouse();


//    scare_mouse();
//    select_mouse_cursor( MOUSE_CURSOR_ARROW );
//    set_mouse_sprite( NULL );   // default shape
//    set_mouse_sprite_focus( 0,0  );
//    unscare_mouse();


    set_mouse_speed( mouse_speedx, mouse_speedy );
    set_mousi_bitmap( MOUS_POINTER );


//    show_mouse( screen );

}












// return value:  TRUE = ok,  FALSE= allocation error happened
// error: memory leak
int alloc_buttonarray_buttons()
{
    BITMAP *bmp2=NULL, *bmp3=NULL;
    int     i;

// allegro_message("g.buttoncolor=%d", g.buttoncolor );

    for(i=0;i<999;i++){
        if( my_main_buttons[i].main_description == NULL &&
        my_main_buttons[i].tooltips_description == NULL ) return TRUE; // ready...
        bmp2 = create_bitmap_ex( g.bpp, bt_esx, bt_esy ); if( bmp2 == NULL ) break;
        bmp3 = create_bitmap_ex( g.bpp, bt_esx, bt_esy ); if( bmp3 == NULL ) break;
        stretch_blit( g.bitmap_buttons_remap, bmp2, 0, (i*30), 30,30,0,0,bt_esx,bt_esy);
        stretch_blit( g.bitmap_buttons_remap, bmp3, 0, (i*30), 30,30,0,0,bt_esx,bt_esy);
    if(g.bpp==8){
        remap_bitmap( bmp2, 255, g.buttoncolor );   // 255 -> g.buttoncolor
        remap_bitmap( bmp3, 255, g.buttoncolor );   //
    }
        xchg_bitmap(  bmp3, 0,   g.buttoncolor );   // exchange colors (swap)

    my_main_buttons[i].shape         = bmp2;
    my_main_buttons[i].shape_clicked = bmp3;
    }   // for(...)
    return FALSE;
}










































/*
 * savetype is: 1 = config and graphic data,
 *              0 = config only
 *
 */
void save_config_data( char savetype )
{
    int     sf=0, df=0;
    int     a=0,b=0,c=0;
    int     i=0;
    int     zz, zi, z;
    BITMAP  *tmp1, *tmp2;
    char    tmpstring[ 150 ];
    int     oi[10], flag_type=0;
    INFOWIN *inf;
    FLI     *fliw;

    set_config_int( NULL,  "vga",  ( g.vga_type & 7 )  );
    set_config_int( NULL,  "bpp",   g.bpp & 63       );
    if( g.flag_alternate==TRUE  )
        set_config_int( NULL, "slidepos",1 );
    else
        set_config_int( NULL, "slidepos",0 );

    set_config_string( NULL,  "current_project", g.project_name );

    /**** fillstructure ****/

    sprintf((char *)&tmpstring,"%d %d %d %d %d %d %d %d %d ",
    fillstruct.selected,
    fillstruct.operation,
    fillstruct.type,
    fillstruct.class,
    fillstruct.bk,
    fillstruct.fg,
    fillstruct.sx,
    fillstruct.sy,
    fillstruct.fi_group);
    set_config_string( NULL,        "fillflags", (char *)&tmpstring       );

    /**** fillstructure ****/


    set_config_string( g.project_name,   "filename", g.graphic_name    );
    sprintf( (char *)&tmpstring,"%d %d", g.sx, g.sy );
    set_config_string( g.project_name,   "size_xy", (char *)&tmpstring );
    sprintf( (char *)&tmpstring,"%d %d", g.ox, g.oy );
    set_config_string( g.project_name,   "zoom_xy", (char *)&tmpstring );
    set_config_int(    g.project_name, "zoom_am",       g.zoom            );
    set_config_int(    g.project_name, "block_current", g.block_current   );
    set_config_int(    g.project_name, "block_amount",  g.block_count     );
    if( g.bpp <= 8 ){
        sprintf( (char *)&tmpstring,"%d %d %d",
        g.usercolor1, g.usercolor2, g.usercolor3);
        set_config_string(g.project_name,   "usrcolors", (char *)&tmpstring );
        a = g.syscolor1;    if( g.syscol1.flag_bestfit == -1 ) a = -1;
        b = g.syscolor2;    if( g.syscol2.flag_bestfit == -1 ) b = -1;
        c = g.syscolor3;    if( g.syscol3.flag_bestfit == -1 ) c = -1;
        sprintf( (char *)&tmpstring,"%d %d %d",a,b,c);
        set_config_string(g.project_name, "syscolors", (char *)&tmpstring );
    }else{
        sprintf( (char *)&tmpstring,"%d %d %d %d %d %d %d %d %d %d %d %d",
        g.usercolor1, g.usercolor2, g.usercolor3,
        g.usrcol1.r, g.usrcol1.g, g.usrcol1.b,
        g.usrcol2.r, g.usrcol2.g, g.usrcol2.b,
        g.usrcol3.r, g.usrcol3.g, g.usrcol3.b );
        set_config_string(g.project_name,   "usrcolors", (char *)&tmpstring );
        a = g.syscolor1;    if( g.syscol1.flag_bestfit == -1 ) a = -1;
        b = g.syscolor2;    if( g.syscol2.flag_bestfit == -1 ) b = -1;
        c = g.syscolor3;    if( g.syscol3.flag_bestfit == -1 ) c = -1;
        sprintf( (char *)&tmpstring,"%d %d %d %d %d %d %d %d %d %d %d %d",
        a,b,c,
        g.syscol1.r, g.syscol1.g, g.syscol1.b,
        g.syscol2.r, g.syscol2.g, g.syscol2.b,
        g.syscol3.r, g.syscol3.g, g.syscol3.b );
        set_config_string(g.project_name, "syscolors", (char *)&tmpstring );
    }


    /*----------------------------------------------------------------------*/
    sf    = itobool( clips.flag   );
    df    = itobool( clipd.flag   );
    oi[0] = itobool( g.flag_pixelgrid  );
    oi[1] = itobool( g.flag_grid   );
    oi[2] = itobool( g.flag_brush );
    oi[3] = itobool( g.flag_bkmap );
    oi[4] = itobool( g.flag_fill  );
    oi[5] = itobool( g.flag_all   );
    oi[6] = itobool( g.flag_src   );
    oi[7] = itobool( g.flag_dst   );
    oi[8] = itobool( g.flag_cad   );
    oi[9] = itobool( g.flag_animate );
    sprintf((char *)&tmpstring,                        \
    "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d " \
    "%d %d %d %d %d %d %d %d %d "                         \
    "%d %d %d %d %d %d %d %d %d %d %d",
    clips.x1,clips.y1,clips.x2,clips.y2,clips.sx,clips.sy,clips.block,sf,
    clipd.x1,clipd.y1,clipd.x2,clipd.y2,clipd.sx,clipd.sy,clipd.block,df,
    oi[0],oi[1],oi[2],oi[3],oi[4],oi[5],oi[6],oi[7],oi[8],oi[9],
    g.bkmap.type, g.bkmap.nr,
    g.brush.size, g.brush.type, g.brush.sx, g.brush.sy, g.grid_sx, g.grid_sy,
    g.animate_type, g.animate_delay
    );
    set_config_string(  g.project_name, "flags", (char *)&tmpstring );
    /*----------------------------------------------------------------------*/



    /*----------------------------------------------------------------------*/
    if(savetype==1){


    flag_type = 0;
    if(find_flx_extension( get_extension(g.graphic_name))==TRUE) flag_type=1;
    if(find_gif_extension( get_extension(g.graphic_name))==TRUE) flag_type=2;
    if(strlen(get_extension(g.graphic_name)) == 0 )              flag_type=3; //invalid file


    if(flag_type != 3 )
        inf = infowin_on("Saving graphic blocks...",g.syscolor1,g.syscolor3);


    if(flag_type==2){    // *** GIF save
        GifFileType  *gif;
        zi = g.block_count;





        tmp1 = ll_get_sprite(0);

        if( bitmap_color_depth(tmp1) > 8 ){
        // color reduction is about to happen
        // set_color_conversion( COLORCONV_REDUCE_TO_256 | COLORCONV_DITHER  );
        set_color_conversion( COLORCONV_REDUCE_TO_256  );
//        create_default_palette2( (RGB *)&g.palette );
//        g.palette[255].r = g.palette[255].g = g.palette[255].b = 255;
        if( g.flag_animate==TRUE)
            set_palette( (RGB *)&g.animate_tmp );
        else
            set_palette( (RGB *)&g.palette );
        }




        if( g.flag_animate==TRUE)
            gif = gif_opensave(g.graphic_name, 8, g.sx, g.sy, 256, (RGB *)&g.animate_tmp );
        else
            gif = gif_opensave(g.graphic_name, 8, g.sx, g.sy, 256, (RGB *)&g.palette );

        if( bitmap_color_depth(screen) > 8 ){
            tmp2 = create_bitmap_ex( 8, g.sx, g.sy );   if( tmp2==NULL) error_("cant create bitmap. ec=102");
        }
        for( z = 0; z < zi; z++ )
        {
            tmp1 = ll_get_sprite(z);
            if( bitmap_color_depth(screen) > 8 ){
                blit( tmp1, tmp2, 0,0,0,0,g.sx,g.sy);// color reduction happens here
                gif_save( gif,  g.sx, g.sy, tmp2 );
            }else{
                gif_save( gif,  g.sx, g.sy, tmp1 );
            }
        }
        gif_saveclose( gif );
        set_color_conversion( COLORCONV_NONE );
        if( bitmap_color_depth(screen) > 8 ){
            destroy_bitmap( tmp2 ); tmp2 = NULL;
        }
    }



    if(flag_type==1){    // *** FLx save
        fliw = fli_open_file_write(g.graphic_name, g.bpp, g.sx, g.sy, 0, 0 );
        if(fliw==NULL){
        msgbox_("Memory allocation error");
        return;
        }
        if( fliw->errnumber != FERR_OK ){
        msgbox_("error: %s", fli_return_errstring( fliw ) );
        return;
        }
        if( g.flag_animate==TRUE)
            fli_reverse_copy_pal( fliw, (RGB *)&g.animate_tmp );
        else
            fli_reverse_copy_pal( fliw, (RGB *)&g.palette );
        for( z = 0; z < g.block_count; z++ )
        {
            tmp1 = ll_get_sprite(z);
            fli_reverse_compose_image( fliw, tmp1 ); // there's still bugs here
            fli_write_frame( fliw );                // there's still bugs here
        }
        fli_close( fliw );
    }



    if( flag_type == 0){    // *** regular save
        zi = g.block_count;
        zz = g.sy;
        tmp2 = create_bitmap_ex( g.bpp, g.sx, g.sy * zi );
        for( z = 0; z < zi; z++ )
        {
            tmp1 = ll_get_sprite(z);
            if(tmp1 != NULL) blit(tmp1, tmp2, 0, 0, 0, zz * z, g.sx, g.sy);
        }
        if( g.flag_animate==TRUE){
            i = save_bitmap( g.graphic_name, tmp2, (RGB *)&g.animate_tmp );
        }else{
            i = save_bitmap( g.graphic_name, tmp2, (RGB *)&g.palette );
        }
        destroy_bitmap( tmp2 );
    }



    infowin_off( inf );
    }

}















/* not ready yet */
void unload_config_data()
{
    int i,j;

    ll_init( g.sx, g.sy, 8 );    /* init linked list nodes in ll.c with bpp:8 */
    j = ll_return_spr_count();
    for( i = 0 ; i < j ; i++ )
        ll_remove( i );
    free( g.project_name );
    free( g.graphic_name );
    return;
}













int rt_closest_map(unsigned char r_, unsigned char g_, unsigned char b_, int precision)
{
        RGB *mptr;
        int i;

        unsigned char r1,g1,b1;
        r_ = r_ & (255 - precision);
        g_ = g_ & (255 - precision);
        b_ = b_ & (255 - precision);
        mptr = (RGB *)&g.palette;
        for( i = 0 ; i<256 ; i++)
        {
        r1 = mptr->r;
        g1 = mptr->g;
        b1 = mptr->b;
        mptr++;
        r1 = r1 & (255 - precision);
        g1 = g1 & (255 - precision);
        b1 = b1 & (255 - precision);
        if( r_ == r1){
                if( g_==g1 ){
                        if( b_==b1 ){
                                return i;
                                }
                        }
                }
        }
        return -1;
}




/*
 *     this changes fromcolor to tocolor (remapping of one color).
 *
 *   remap_bitmap( g.bitmap_buttons, 255, g.buttoncolor );
 *
 */
void remap_bitmap(BITMAP *bmp, int fromcolor, int tocolor )
{
    int x, y, sx, sy;
    int c=0;

    sx = bmp->w;
    sy = bmp->h;
    for(y=0; y < sy; y++){
    for(x=0; x < sx; x++){
    c = getpixel(bmp,x,y);
    if ( c==fromcolor ) putpixel(bmp,x,y,tocolor);
    }}
}

/*
 *     this changes fromcolor to tocolor (remapping of one color).
 *
 *   remap_bitmap( g.bitmap_buttons, 255, g.buttoncolor );
 *
 */
void remap_bitmap2(BITMAP *in, BITMAP *out, int fromcolor, int tocolor )
{
    int x, y, sx, sy;
    int c=0;

    sx = in->w;
    sy = in->h;
    for(y=0; y < sy; y++){
    for(x=0; x < sx; x++){
    c = getpixel(in,x,y);
    if ( c==fromcolor )
        putpixel(out,x,y,tocolor);
    else
        putpixel(out,x,y,c);
    }}
}
/*
 *     this changes fromcolor to tocolor (remapping of one color).
 *  Also remaps the mask color!
 *
 */
void remap_bitmap3(BITMAP *in, BITMAP *out, int fromcolor, int tocolor )
{
    int x, y, sx, sy;
    int c;

    sx = in->w;
    sy = in->h;
    for(y=0; y < sy; y++){
    for(x=0; x < sx; x++){
    c = getpixel(in,x,y);
        if ( c==fromcolor ){
            putpixel(out,x,y,tocolor);
        }else{
            if( c == 0 ) c = bitmap_mask_color( out );
            putpixel(out,x,y,c);
        }
    }}
}








/* This changes any color that is not 0 to tocolor (remapping of colors).*/
void remap_bitmap_to_color(BITMAP *bmp, int tocolor)
{
    int x, y, sx, sy;
    int c;

    sx = bmp->w;
    sy = bmp->h;
    for(y=0; y < sy; y++)      {
    for(x=0; x < sx; x++)      {
    c = getpixel(bmp,x,y);
    if ( c!=0 ) putpixel(bmp,x,y,tocolor);
    }}
}


/* remap picture & palette so background is black */
/* not ready yet... */
void remap_pal_bkgr(BITMAP *bmp,  RGB *palette )
{
      int const precision = 7;
      unsigned char r,g,b;
      r = palette->r;
      g = palette->g;
      b = palette->b;
        r = r & (255 - precision);
        g = g & (255 - precision);
        b = b & (255 - precision);
        if( r!=0 ){
                if( g!=0 ){
                        if( b!=0 ){
                                /* do remap */
                                }
                        }
                }
}










static unsigned char vgacolors[]={
    0,   0,   0,
    0,   0,   170,
    0,   170, 0,
    0,   170, 170,
    170, 0,   0,
    170, 0,   170,
    170, 85,  0,
    170, 170, 170,
    85,  85,  85,
    85,  85,  255,
    85,  255, 85,
    85,  255, 255,
    255, 85,  85,
    255, 85,  255,
    255, 255, 85,
    255, 255, 255,
    0,0,0,0,0,0
};

/*
    { 0,   0,   0   },      // black
    { 0,   0,   170 },      // blue
    { 0,   170, 0   },      // green
    { 0,   170, 170 },      // cyan
    { 170, 0,   0   },      // red
    { 170, 0,   170 },      // magenta
    { 170, 85,  0   },      // brown
    { 170, 170, 170 },      // light gray
    { 85,  85,  85  },      // dark gray
    { 85,  85,  255 },      // light blue
    { 85,  255, 85  },      // light green
    { 85,  255, 255 },      // light cyan
    { 255, 85,  85  },      // light red
    { 255, 85,  255 },      // light magenta
    { 255, 255, 85  },      // yellow
    { 255, 255, 255 }       // white
*/


void create_vga_palette( RGB *pal )
{
    unsigned char r_, g_, b_;
    int     i,j;

    for( i=j=0 ; i < 255 ; i++ )
    {
    pal[i].r = 0;
    pal[i].g = 0;
    pal[i].b = 0;
    }
    pal[i].r = 63;
    pal[i].g = 63;
    pal[i].b = 63;

    for( i=j=0 ; i < 16 ; i++ )
    {
    r_ = vgacolors[j++];
    g_ = vgacolors[j++];
    b_ = vgacolors[j++];
    pal[i].r = r_ >> 2;
    pal[i].g = g_ >> 2;
    pal[i].b = b_ >> 2;
    }
}


static unsigned char defpal[]={ /* uniform palette */
0,0,0,0,0,84,0,0,168,0,0,252,0,28,0,0,28,84,0,28,168,0,28,252,0,60,0,0,60,84,0,
60,168,0,60,252,0,92,0,0,92,84,0,92,168,0,92,252,0,124,0,0,124,84,0,124,168,0,
124,252,0,156,0,0,156,84,0,156,168,0,156,252,0,188,0,0,188,84,0,188,168,0,188,
252,0,220,0,0,220,84,0,220,168,0,220,252,0,252,0,0,252,84,0,252,168,0,252,252,
40,0,0,40,0,84,40,0,168,40,0,252,40,28,0,40,28,84,40,28,168,40,28,252,40,60,0,
40,60,84,40,60,168,40,60,252,40,92,0,40,92,84,40,92,168,40,92,252,40,124,0,40,
124,84,40,124,168,40,124,252,40,156,0,40,156,84,40,156,168,40,156,252,40,188,0,
40,188,84,40,188,168,40,188,252,40,220,0,40,220,84,40,220,168,40,220,252,40,252,
0,40,252,84,40,252,168,40,252,252,84,0,0,84,0,84,84,0,168,84,0,252,84,28,0,84,
28,84,84,28,168,84,28,252,84,60,0,84,60,84,84,60,168,84,60,252,84,92,0,84,92,84,
84,92,168,84,92,252,84,124,0,84,124,84,84,124,168,84,124,252,84,156,0,84,156,84,
84,156,168,84,156,252,84,188,0,84,188,84,84,188,168,84,188,252,84,220,0,84,220,
84,84,220,168,84,220,252,84,252,0,84,252,84,84,252,168,84,252,252,124,0,0,124,0,
84,124,0,168,124,0,252,124,28,0,124,28,84,124,28,168,124,28,252,124,60,0,124,60,
84,124,60,168,124,60,252,124,92,0,124,92,84,124,92,168,124,92,252,124,124,0,124,
124,84,124,124,168,124,124,252,124,156,0,124,156,84,124,156,168,124,156,252,124,
188,0,124,188,84,124,188,168,124,188,252,124,220,0,124,220,84,124,220,168,124,
220,252,124,252,0,124,252,84,124,252,168,124,252,252,168,0,0,168,0,84,168,0,168,
168,0,252,168,28,0,168,28,84,168,28,168,168,28,252,168,60,0,168,60,84,168,60,
168,168,60,252,168,92,0,168,92,84,168,92,168,168,92,252,168,124,0,168,124,84,
168,124,168,168,124,252,168,156,0,168,156,84,168,156,168,168,156,252,168,188,0,
168,188,84,168,188,168,168,188,252,168,220,0,168,220,84,168,220,168,168,220,252,
168,252,0,168,252,84,168,252,168,168,252,252,212,0,0,212,0,84,212,0,168,212,0,
252,212,28,0,212,28,84,212,28,168,212,28,252,212,60,0,212,60,84,212,60,168,212,
60,252,212,92,0,212,92,84,212,92,168,212,92,252,212,124,0,212,124,84,212,124,
168,212,124,252,212,156,0,212,156,84,212,156,168,212,156,252,212,188,0,212,188,
84,212,188,168,212,188,252,212,220,0,212,220,84,212,220,168,212,220,252,212,252,
0,212,252,84,212,252,168,212,252,252,252,0,0,252,0,84,252,0,168,252,0,252,252,
28,0,252,28,84,252,28,168,252,28,252,252,60,0,252,60,84,252,60,168,252,60,252,
252,92,0,252,92,84,252,92,168,252,92,252,252,124,0,252,124,84,252,124,168,252,
124,252,252,156,0,252,156,84,252,156,168,252,156,252,252,188,0,252,188,84,252,
188,168,252,188,252,252,220,0,252,220,84,252,220,168,252,220,252,252,252,0,252,
252,84,252,252,168,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0
};



static void create_default_palette(void)    /* uniform palette */
{
    unsigned char r_,g_,b_;
    int     i, j;
    RGB     *pal;

    pal = (RGB *)&g.palette;
    for( i=j=0 ; i < 256 ; i++ )
    {
    r_ = defpal[j++];
    g_ = defpal[j++];
    b_ = defpal[j++];
    pal->r = r_ >> 2;
    pal->g = g_ >> 2;
    pal->b = b_ >> 2;
    pal++;
    }
    pal = (RGB *)&grey_palette;
    for( i=j=0 ; i < 256 ; i++ )
    {
    r_ = g_ = b_ = i;     // default palette is grey
    pal->r = r_ >> 2;
    pal->g = g_ >> 2;
    pal->b = b_ >> 2;
    pal++;
    }
    return;
}

void create_default_palette2( RGB *_pal )    /* uniform palette */
{
    unsigned char r_,g_,b_;
    int     i,j;
    RGB     *pal = _pal;

    for( i=j=0 ; i < 256 ; i++ )
    {
    r_ = defpal[j++];
    g_ = defpal[j++];
    b_ = defpal[j++];
    pal->r = r_ >> 2;
    pal->g = g_ >> 2;
    pal->b = b_ >> 2;
    pal++;
    }
    return;
}
















/************ COLOR MAPPING FUNCTIONS ************/
static RGB magic;

/*
 * index range: 0 to 2
 */
RGB *get_original_rgb_from_palette(int index)
{
    int i=0;

    if(g.bpp>8) return (RGB *)&magic;

    if(index==0) i = g.syscolor1;
    if(index==1) i = g.syscolor2;
    if(index==2) i = g.syscolor3;
    magic.r = g.store_rgb[index].r = g.palette[ i ].r; /* get original color */
    magic.g = g.store_rgb[index].g = g.palette[ i ].g; /* get original color */
    magic.b = g.store_rgb[index].b = g.palette[ i ].b; /* get original color */

    return (RGB *)&magic;
}
void set_original_rgb_on_palette(int index)
{
    int i=0;

    if(g.bpp>8) return;

    if(index==0) i = g.syscolor1;
    if(index==1) i = g.syscolor2;
    if(index==2) i = g.syscolor3;
    set_color( i, get_original_rgb( index ) );
}
void set_user_rgb_on_palette(int index)
{
    int i=0;

    if(g.bpp>8) return;

    if(index==0) i = g.syscolor1;
    if(index==1) i = g.syscolor2;
    if(index==2) i = g.syscolor3;
    set_color( i, get_user_rgb( index ) );
}
RGB *get_user_rgb( int index )
{
    if(g.bpp>8) return (RGB *)&magic;


    magic.r = g.adapt_rgb[index].r;
    magic.g = g.adapt_rgb[index].g;
    magic.b = g.adapt_rgb[index].b;

    return (RGB *)&magic;
}
RGB *get_original_rgb( int index )
{
    if(g.bpp>8) if(g.bpp>8) return (RGB *)&magic;

    magic.r = g.store_rgb[index].r;
    magic.g = g.store_rgb[index].g;
    magic.b = g.store_rgb[index].b;

    return (RGB *)&magic;
}

/* find new index in palette that match user color */
int bestfit_user_color_from_this_palette(int index, RGB *palette)
{
    if(g.bpp>8) return 0;

    if(index==0){
    if( g.flag_rgb[0] == FALSE ){   // do bestfit
    g.syscolor1 = bestfit_color( palette, g.fixed_rgb[0].r, g.fixed_rgb[0].g, g.fixed_rgb[0].b);
    g.adapt_rgb[0].r = g.palette[ g.syscolor1 ].r;
    g.adapt_rgb[0].g = g.palette[ g.syscolor1 ].r;
    g.adapt_rgb[0].b = g.palette[ g.syscolor1 ].r;
    return g.syscolor1;
    }}
    if(index==1){
    if( g.flag_rgb[1] == FALSE ){
    g.syscolor2 = bestfit_color( palette, g.fixed_rgb[1].r, g.fixed_rgb[1].g, g.fixed_rgb[1].b);
    g.adapt_rgb[1].r = g.palette[ g.syscolor1 ].r;
    g.adapt_rgb[1].g = g.palette[ g.syscolor1 ].r;
    g.adapt_rgb[1].b = g.palette[ g.syscolor1 ].r;
    return g.syscolor2;
    }}
    if(index==2){
    if( g.flag_rgb[2] == FALSE ){
    g.syscolor3 = bestfit_color( palette, g.fixed_rgb[2].r, g.fixed_rgb[2].g, g.fixed_rgb[2].b);
    g.adapt_rgb[2].r = g.palette[ g.syscolor1 ].r;
    g.adapt_rgb[2].g = g.palette[ g.syscolor1 ].r;
    g.adapt_rgb[2].b = g.palette[ g.syscolor1 ].r;
    return g.syscolor3;
    }}

    return 0;
}


/* find new index in palette that match user color */
int bestfit_user_color_from_palette(int index)
{
    if(g.bpp>8) return 0;
    // **** do bestfit ****
    return bestfit_user_color_from_this_palette( index, (RGB *)&g.palette );
}



/****************************************************/
/* adapt the current color indexes to a new palette */
/* if which==0 then get from palette                */
/* if which==1 then get from mouse buttons          */

void bestfit_main_graphic_to_g_palette()
{
    char which = 0;

    if(g.bpp>8) return;

    which &= 1;
    if( g.flag_rgb[0] == FALSE ){
        g.syscolor1 = bestfit_user_color_from_palette( 0 );
    }else{
    }

    if( g.flag_rgb[1] == FALSE  ){
        g.syscolor2 = bestfit_user_color_from_palette( 1 );
    }else{
    }

    if( g.flag_rgb[2] == FALSE  ){
        g.syscolor3 = bestfit_user_color_from_palette( 2 );
    }else{
    }

    get_handle_on_palette();

    g.buttoncolor = g.syscolor1;

    if( g.flag_dialog_init == TRUE ){
        set_dialog_color( main_dialog, g.syscolor1, 0 );
        broadcast_dialog_message( MSG_DRAW,0 );
        dialog_message( main_dialog, MSG_DRAW,0, NULL );
    }
}








/****************************************************/
/* get a grip on global palette                     */
void get_handle_on_palette()
{
    if(g.bpp>8) return;

    if( g.flag_rgb[0] == FALSE  ){
    get_original_rgb_from_palette( 0 );
    }else{
    get_original_rgb_from_palette( 0 );
    set_user_rgb_on_palette( 0 );
    }
    if( g.flag_rgb[1] == FALSE ){
    get_original_rgb_from_palette( 1 );
    }else{
    get_original_rgb_from_palette( 1 );
    set_user_rgb_on_palette( 1 );
    }
    if( g.flag_rgb[2] == FALSE ){
    get_original_rgb_from_palette( 2 );
    }else{
    get_original_rgb_from_palette( 2 );
    set_user_rgb_on_palette( 2 );
    }
}



/****************************************************/
/* drop a grip off global palette                   */
void release_handle_from_palette()
{
    if(g.bpp>8) return;
    if( g.flag_rgb[0] == FALSE  ){
    }else{
    set_original_rgb_on_palette(0);
    }
    if( g.flag_rgb[1] == FALSE  ){
    }else{
    set_original_rgb_on_palette(1);
    }
    if( g.flag_rgb[2] == FALSE  ){
    }else{
    set_original_rgb_on_palette(2);
    }
}




























void destroy_old_fillmaps()
{
    if(g.fillmap1!=NULL)  destroy_bitmap(g.fillmap1); g.fillmap1=NULL;
    if(g.fillmap2!=NULL)  destroy_bitmap(g.fillmap2); g.fillmap2=NULL;
    if(g.fillmap3!=NULL)  destroy_bitmap(g.fillmap3); g.fillmap3=NULL;
}
void make_new_fillmaps()
{
    g.fillmap1 = create_fill_map( 0, g.syscolor3 ,g.syscolor1 );
    g.fillmap2 = create_fill_map( 0, g.syscolor2 ,g.syscolor1 );
    g.fillmap3 = create_fill_map( 2, 0           ,g.syscolor2 );
}
















/* remap all colors and update display to fix into new colors   */
/* if which==0 then get from palette                            */
/* if which==1 then get from mouse buttons                      */
void refix_all_display()
{
    int     iold,i;

    if( g.bpp != 8 ) return;

    iold = g.buttoncolor;   /* fromcolor */

    scare_mouse();

    release_handle_from_palette();  /* put back original colors on palette */
    /*...*/
    bestfit_main_graphic_to_g_palette();      /* new g_colors...*/

    remap_bitmap( g.bitmap_buttons, iold, g.buttoncolor );
    destroy_old_fillmaps();
    make_new_fillmaps();



    // TESTING ................................
    handle_colormapping(  g.syscol1.index1, g.syscol2.index1, g.syscol3.index1 );
//    bestfit_main_graphic_to_g_palette();
    // TESTING ................................
    g.buttoncolor = g.syscolor1;
    // ----------------------------------
    remap_bitmap2( g.bitmap_buttons, g.bitmap_buttons_remap, 255, g.buttoncolor );

    tb_fix_bitmapbuttons();

    for(i=0;;i++){
        if(main_dialog[i].proc  == NULL ) break;
        main_dialog[i].fg    = g.syscolor1;
        main_dialog[i].bg    = 0;
    }



//...                        /* button array */
    ed_hide_buttonarray    ( g_buttonarray_handle );
    subs_refix_buttonarray_btncolors( g_buttonarray_handle );
    ed_rerender_buttonarray( g_buttonarray_handle,g.syscolor1,g.syscolor3,g.syscolor1,g.syscolor2 );
    ed_show_buttonarray    ( g_buttonarray_handle );
    bt_draw_outlines();
//...                        /* button array */
    sp_draw_outlines(); /* spritebar */
    tb_draw_outlines(); /* toolbar buttons */
    md_draw_outlines(); /* main draw */
    in_display();
    update_pl(1);       /* display blocks on palette window */
    display_zoomed_md();
    broadcast_dialog_message(MSG_DRAW,0);

    unscare_mouse();
    unscare_mouse();

    /***** REFIX ALL DISPLAY *****/
}








// remap all colors and update display to fix into new colors
void refix_all_display2()
{
    int     iold,i;
    COLORMAPPING_TWO  old1,old2,old3,    new1,new2,new3;

    if( g.bpp != 8 ) return;


/*
printf(" ---before ---- \n");
printf(" g.syscolor1 = %d, %d,%d,%d\n", g.syscolor1 ,g.syscol1.r,g.syscol1.g,g.syscol1.b );
printf(" g.syscolor2 = %d, %d,%d,%d\n", g.syscolor2 ,g.syscol2.r,g.syscol2.g,g.syscol2.b );
printf(" g.syscolor3 = %d, %d,%d,%d\n", g.syscolor3 ,g.syscol3.r,g.syscol3.g,g.syscol3.b );
*/




    // assume the palette has changed

    old1.index = g.syscolor1;
    old1.r     = g.syscol1.r;
    old1.g     = g.syscol1.g;
    old1.b     = g.syscol1.b;
    old2.index = g.syscolor2;
    old2.r     = g.syscol2.r;
    old2.g     = g.syscol2.g;
    old2.b     = g.syscol2.b;
    old3.index = g.syscolor3;
    old3.r     = g.syscol3.r;
    old3.g     = g.syscol3.g;
    old3.b     = g.syscol3.b;

    clip_remap_colors_from_old_to_new( &old1, &old2, &old3, &new1,&new2, &new3);

    g.syscol1.r   =  new1.r;
    g.syscol1.g   =  new1.g;
    g.syscol1.b   =  new1.b;
    g.syscolor1   =  new1.index;
    g.syscol2.r   =  new2.r;
    g.syscol2.g   =  new2.g;
    g.syscol2.b   =  new2.b;
    g.syscolor2   =  new2.index;
    g.syscol3.r   =  new3.r;
    g.syscol3.g   =  new3.g;
    g.syscol3.b   =  new3.b;
    g.syscolor3   =  new3.index;

    //
    //
    g.buttoncolor = g.syscolor1;
    destroy_old_fillmaps();
    make_new_fillmaps();
//    remap_bitmap(  g.bitmap_buttons, old1.index, g.buttoncolor ); // remap buttons to color
//    remap_bitmap2( g.bitmap_buttons, g.bitmap_buttons_remap, 255, g.buttoncolor );
    tb_remap_bitmapbuttons( old1.index, g.buttoncolor );
    set_dialog_color( main_dialog, g.syscolor1, 0 );
    ed_hide_buttonarray    (            g_buttonarray_handle );
    subs_refix_buttonarray_btncolors(   g_buttonarray_handle );
    ed_rerender_buttonarray( g_buttonarray_handle,g.syscolor1,g.syscolor3,g.syscolor1,g.syscolor2 );
    ed_show_buttonarray    ( g_buttonarray_handle );
    bt_draw_outlines();
//...                       // button array
    sp_draw_outlines();     // spritebar
    tb_draw_outlines();     // toolbar buttons
    md_draw_outlines();     // main draw
    in_display();
    update_pl(1);       // display blocks on palette window
    display_zoomed_md();
    dialog_message( main_dialog, MSG_DRAW,0, NULL );
    broadcast_dialog_message(MSG_DRAW,0);
    set_palette( (RGB * )&g.palette );
/*
printf(" ---after ---- \n");
printf(" g.syscolor1 = %d, %d,%d,%d\n", g.syscolor1 ,g.syscol1.r,g.syscol1.g,g.syscol1.b );
printf(" g.syscolor2 = %d, %d,%d,%d\n", g.syscolor2 ,g.syscol2.r,g.syscol2.g,g.syscol2.b );
printf(" g.syscolor3 = %d, %d,%d,%d\n", g.syscolor3 ,g.syscol3.r,g.syscol3.g,g.syscol3.b );
*/

}



/*...copying to/from screen + g.zoom   */

void get_rect_bmp(int x, int y, int sx, int sy)
{
    if(x<0||x==0) x=1;
    if(y<0||y==0) y=1;
    if(sx<=0) sx=1;
    if(sy<=0) sy=1;
    scare_mouse();
    blit( screen, g.screen_state_buffer,
                        md_x + x - 1, md_y + y - 1,
                        0,0,
                        sx + g.zoom*2 + 2, sy + g.zoom*2 + 2 );
    unscare_mouse();
}
void set_rect_bmp(int x, int y, int sx, int sy)
{
    if(x<0||x==0) x=1;
    if(y<0||y==0) y=1;
    if(sx<=0) sx=1;
    if(sy<=0) sy=1;
    scare_mouse();
    blit( g.screen_state_buffer, screen,
                        0,0,
                        md_x + x - 1, md_y + y - 1,
                        sx + g.zoom*2 + 2, sy + g.zoom*2 + 2 );
    unscare_mouse();
}


/****************************************************/
/*          centered textblock                      */
/*   information window, Infowin                    */
/*                                                  */
INFOWIN *infowin_on( unsigned char *string, int color_fg, int color_bg )
{
    INFOWIN *wbk;

    wbk = (INFOWIN *) malloc( sizeof(INFOWIN)  );if( wbk == NULL ) return NULL;
    wbk->sx    = text_length( font, string );
    wbk->sy    = text_height( font );
    wbk->x     = g.screen_w/2 - wbk->sx/2;
    wbk->y     = g.screen_h/2 - wbk->sy/2;
    wbk->bgmap = create_bitmap( wbk->sx, wbk->sy );
    wbk->fgmap = create_bitmap( wbk->sx, wbk->sy );
    if (wbk->bgmap == NULL || wbk->fgmap == NULL){ free(wbk); return NULL;}
    wbk->color_fg = color_fg;
    wbk->color_bg = color_bg;
    clear_bitmap (wbk->bgmap);
    clear_to_color (wbk->fgmap,  wbk->color_bg );
    blit( screen, wbk->bgmap, wbk->x,wbk->y ,0,0, wbk->sx, wbk->sy);
    infowin_textout( wbk, string );
    return wbk;
}

void infowin_textout( INFOWIN *wbk, const char *fmt, ... )
{
    int     i;
    char    linestring[100];
    va_list args;

    linestring[0] = 0;
    va_start(args, fmt);
    _vsnprintf( (char *)&linestring, 99, fmt, args );
    linestring[99] = 0;
    va_end(args);
    clear_to_color (wbk->fgmap,  wbk->color_bg );
    rect( wbk->fgmap, 0,0,wbk->sx-1,wbk->sy-1, wbk->color_fg  );
    rect( wbk->fgmap, 1,1,wbk->sx-2,wbk->sy-2, wbk->color_fg  );
    rect( wbk->fgmap, 4,4,wbk->sx-5,wbk->sy-5, wbk->color_fg  );
    i = text_mode(  -1 );
    textout(    wbk->fgmap ,font, linestring, 16, 16, wbk->color_fg  );
//  textout_ex( wbk->fgmap ,font, linestring, 16, 16, wbk->color_fg, -1 );
    text_mode(i);
    scare_mouse();
    acquire_screen();
    blit( wbk->fgmap, screen, 0,0,wbk->x,wbk->y,wbk->sx,wbk->sy);     /* put onscreen */
    release_screen();
    unscare_mouse();
}


void infowin_off( INFOWIN *wbk )
{
    if( wbk == NULL ) return;
    scare_mouse();
    acquire_screen();
    blit( wbk->bgmap, screen, 0,0,wbk->x,wbk->y,wbk->sx,wbk->sy);
    release_screen();
    unscare_mouse();
    free( wbk );
}
/*                                                  */
/*                                                  */
/****************************************************/










void subs_refix_buttonarray_btncolors( int handle )
{
    ED_BUTTONARRAY_WINDOW *ed_btnarr;

    if( all_buttonarray_alloc[ handle ] != 1 ) return;  // illegal handle
    ed_btnarr = all_buttonarray_structs[ handle ];

    remap_bitmap2( g.bitmap_buttons, g.bitmap_buttons_remap, 255, g.buttoncolor );

    // ----------------------------------------------------------
    free_buttonarray_buttons();
    // ----------------------------------------------------------
    if( alloc_buttonarray_buttons() == FALSE ) error_("Allocating system buttons");
    // ----------------------------
}











void wait_for_mousebutton_release(void)
{
    char i;
    do i=mouse_b; while((i&7)!=0 );
}



static int init_mousi_system(void)
{
    mousi_sx = 46;              // hardwired limit
    mousi_sy = 46;              // hardwired limit
    mou_se  = create_bitmap_ex( 8, mousi_sx, mousi_sy );          if( mou_se   == NULL ) return FALSE;
    mou_se2 = create_bitmap_ex( 8, mousi_sx, mousi_sy );    if( mou_se2  == NULL ) return FALSE;
    mou_se3 = create_bitmap_ex( g.bpp, mousi_sx, mousi_sy );    if( mou_se3  == NULL ) return FALSE;
    mousi_count = mou_bmps->h / mousi_sy;
    mhx = (int *) malloc( (mousi_count + 99 ) * sizeof(int) );
    mhy = (int *) malloc( (mousi_count + 99 ) * sizeof(int) );
    if( mhx==NULL || mhy==NULL ) return FALSE;
    arrange_mousi_arrays();
    // color are rgb, index 253,254,255
    // make green solid
    // make red transparent (mask)
    // black is already mask
    remap_bitmap( mou_bmps, 254, 255 );
    remap_bitmap( mou_bmps, 253, bitmap_mask_color(mou_bmps)   );
    mousi_number = MOUS_POINTER ;
    set_mousi_bitmap( MOUS_POINTER  );
    return TRUE;
}


void deinit_mousi_system(void)
{
    if( mhx!=NULL ) free( mhx );
    if( mhy!=NULL ) free( mhy );
    if( mou_bmps!=NULL ) destroy_bitmap( mou_bmps );
    if( mou_se!=NULL   ) destroy_bitmap( mou_se );
    if( mou_se2!=NULL  ) destroy_bitmap( mou_se2 );
    if( mou_se3!=NULL  ) destroy_bitmap( mou_se3 );
    mhx = mhy = NULL;
    mou_bmps = mou_se = mou_se2 = mou_se3 =  NULL;
}


static BITMAP *get_mousi_bitmap( int number, int typedraw )
{
    int x,y,x1,y1,x2,y2,radius, brushsize;


    if(number>mousi_count) number=mousi_count;
    x = mhx[number];
    y = mhy[number];
    brushsize = g.brush.size/2;
    blit( mou_bmps, mou_se, 0,( mousi_sy * number), 0,0,mousi_sx, mousi_sy );

    if(g.bpp==8)
        remap_bitmap( mou_se, 255, g.syscolor2 );

    if(g.bpp>8){
        remap_bitmap3( mou_se, mou_se3, 255, g.syscolor2 );
    }

    if( typedraw == 0){ // square
        x1 = x - brushsize * (g.zoom+2);  if(x1<0) x1=0;
        y1 = y - brushsize * (g.zoom+2);  if(y1<0) y1=0;
        x2 = x + brushsize * (g.zoom+2);  if(x2>mou_se->w) x2=mou_se->w;
        y2 = y + brushsize * (g.zoom+2);  if(y2>mou_se->h) y2=mou_se->h;
        if(g.bpp>8)
            rect( mou_se3, x1,y1,x2,y2, g.syscolor2 );
        rect( mou_se, x1,y1,x2,y2, g.syscolor2 );
    }
    if( typedraw == 1){     // circle
        radius = brushsize * (g.zoom+2);
        if( radius > brushsize * (12+2) ) radius = brushsize * (12+2);
        if(g.bpp>8)
            circle( mou_se3, x,y, radius, g.syscolor2 );
        circle( mou_se, x,y, radius, g.syscolor2 );
    }
    if(g.bpp>8)
        return (BITMAP *)mou_se3;
    return (BITMAP *)mou_se;
}
static void arrange_mousi_arrays()  /* fill in array with hotspots */
{
    int x,y,i,c;

    for(i=0; i < mousi_count+1 ;i++){
    blit( mou_bmps, mou_se2, 0,( mousi_sy * i), 0,0,mousi_sx, mousi_sy );
    mhx[i] = mhy[i] = 1;
    for(y=0;y<mou_se2->h;y++){
    for(x=0;x<mou_se2->w;x++){
    c = getpixel(mou_se2,x,y);
    if(c==253||c==254){ mhx[i]=x; mhy[i]=y; }
    }}  // for for
    }   // for
}
int get_mousi_number(void)
{
    return mousi_number;
}
void set_mousi_bitmap( int number )
{
    int typedraw = -1;
    if( number > mousi_count ){ number = mousi_count; }
    if( number!=0 ) mousi_number = number;

    scare_mouse();
        if( number==2){
        if( g.flag_brush==TRUE && g.brush.size > 1 ){
            if( g.brush.type == 0 ){    // square
            typedraw = 0;
            }
            if( g.brush.type == 1 ){    // circle
            typedraw = 1;

            }

        }

        }

    set_mouse_sprite( get_mousi_bitmap( number, typedraw ) );
    set_mouse_sprite_focus( mhx[number], mhy[number] );
    unscare_mouse();
}












static void free_buttonarray_buttons()
{
    int i;

    for(i=0;i<999;i++){
    if( my_main_buttons[i].main_description == NULL && my_main_buttons[i].tooltips_description ==NULL ) break;
        if( my_main_buttons[i].shape!=NULL ){
            destroy_bitmap( my_main_buttons[i].shape );
            my_main_buttons[i].shape=NULL;
        }
        if( my_main_buttons[i].shape_clicked!=NULL ){
            destroy_bitmap( my_main_buttons[i].shape_clicked );
            my_main_buttons[i].shape_clicked=NULL;
        }
    }
}




static void handle_fillstructure( char *fillflags )
{
    int     i=0;

    if( g.fillfile == NULL )
        fillstruct.enabled = FALSE;
    else
        fillstruct.enabled = TRUE;

    fillstruct.bmp8x8    = create_bitmap_ex(8,8,8); if(fillstruct.bmp8x8   ==NULL ) error_("allocating graphic");
    fillstruct.bmp8x8tmp = create_bitmap_ex(g.bpp,8,8); if(fillstruct.bmp8x8tmp==NULL ) error_("allocating graphic");
    clear_bitmap( fillstruct.bmp8x8 );
    clear_bitmap( fillstruct.bmp8x8tmp );
    fillstruct.filefixed = g.fillfile;
    // ----------------------------------------------------------
    //              DRAX3.PCX
//    alert("g.fillfile=", g.fillfile, "...", "ok", NULL,0,0);
    // ----------------------------------------------------------
    fillstruct.blocks = 0;      /* exact amount will be determined later */
    if(sscanf( fillflags,"%d %d %d %d %d %d %d %d %d",
    (int *)&fillstruct.selected,(int *)&fillstruct.operation,
    (int *)&fillstruct.type,    (int *)&fillstruct.class,
    (int *)&fillstruct.bk,      (int *)&fillstruct.fg,
    (int *)&fillstruct.sx,      (int *)&fillstruct.sy,
    (int *)&fillstruct.fi_group) < 9 ) error_("too few fillflags");
    if( fillstruct.enabled == TRUE ){
        i = fillstruct.selected;
        blit( fillstruct.bmpfixed, fillstruct.bmp8x8, 0, (i*8), 0,0,8,8 );
        blit( fillstruct.bmp8x8,   fillstruct.bmp8x8tmp, 0,0,0,0,8,8  );

//        remap_bitmap(fillstruct.bmp8x8tmp, 255, g.syscolor1 );
        if( g.bpp == 8 )
            remap_bitmap(fillstruct.bmp8x8tmp, 255, g.syscolor1 );
        else
            remap_bitmap2( fillstruct.bmp8x8,fillstruct.bmp8x8tmp, 255, g.syscolor1 );


        blit( fillstruct.bmpfixed, fillstruct.bmpfixed2, 0,0,0,0, fillstruct.bmpfixed->w,fillstruct.bmpfixed->h );
        if( g.bpp == 8 ){
            remap_bitmap( fillstruct.bmpfixed2, 255, g.syscolor1 );
        }else{
            remap_bitmap2( fillstruct.bmpfixed,fillstruct.bmpfixed2, 255, g.syscolor1 );
        }


    }
}























PALETTE nopalette;





// If file extension is one of these:   FLA/FLB/FLT/FLH/FLC/FLI
//        Then multi load.
static int load_graphic_blocks( int amount )
{
    BITMAP  *tmp1=NULL, *tmp2=NULL, *img=NULL;
    int     i,j,k;
    char    *s=NULL, *prefix = NULL, *numeric=NULL, *suffix = NULL, *d = NULL;
    int     numeric_value = 0, len=0, numlen=0, flag_type=0;
    FLI     *fli=NULL, *tf=NULL;
    GifFileType  *gif;
    char    zox[] = "%.3d";
//    char    *zox = NULL;


    //debug_display( 0,255, 0,50, "[***1***]");


    if( g.flag_multi_archives == TRUE ){

        s = g.graphic_name;
        len = strlen( s );
        prefix = alloc_string( s, len+8 );
        numeric= alloc_string( s, len+8 );
        suffix = alloc_string( s, len+8 );
        d      = alloc_string( s, len+8 );
        if( prefix ==NULL || numeric==NULL || suffix ==NULL || d ==NULL ) error_("allocating string.subs.c %d", __LINE__ );
        numeric[0]=suffix[0]=d[0]=0;
        for(i=0,j=0,k=0;i<len;i++){
            if( isdigit( s[i] ) != 0 ){
                prefix[i] = 0;      // cut filename
                numeric[j++] = s[i];
                k = i;          // last number before suffix
            }
        }
        numeric[j++] = 0;
        k++;
        for(i=0,j=0;i<len;i++){
            if( s[ k+i ] == 0 ) break;
            suffix[i] = s[ k+i ];
        }
        suffix[i] = 0;

    numlen = strlen( numeric );     if( numlen > 9 ) numlen = 9;
    numeric_value = atoi( numeric );
    zox[2] = numlen + '0';
    if(g.flag_verbose==TRUE) printf("first filename: <%s>\n", s );


    textprintf(screen, font, 120,120, 255, "%s", s);
    if( numlen==0 ) error_("Filename '%s' has not a numeric value, can't load multiple",s);


    // -----------------------------------------
    // check filename extension of first file


    flag_type = 0;
    if(find_flx_extension( get_extension(s))==TRUE) flag_type=1;
    if(find_gif_extension( get_extension(s))==TRUE) flag_type=2;
    if(strlen(get_extension(s)) == 0 )              flag_type=3; //invalid file



    if(flag_type==1){   // FLx
        fli = fli_open_file_read( s, 0, 0 ); if( fli==NULL ) error_("opening FLx file: %s",s );
        tf = fli_read_frame( fli );   if(tf==NULL){ msgbox_("Error reading FLx frame"); }
        tmp1 = create_bitmap( g.sx, g.sy );    if( tmp1 == NULL ){ msgbox_("creating bitmap for block copy/paste");}
        fli_compose_image( tmp1, fli->image, fli->img_begin,fli->img_end, fli->width, fli->depth );
        fli_copy_pal( fli, (RGB *)&g.palette );
        fli_close( fli );
    }
    if(flag_type==2){   // GIF
        gif = gif_openload( s );   if( gif==NULL ) error_("allocating memory" );
        tmp1 = gif_load( gif, (RGB *)&g.palette );
        gif_loadclose( gif );
    }
    if(flag_type==0){
        // we are using the palette of the first loaded image only
        tmp1 = load_bitmap( s, (RGB *)&g.palette );
    }


    if(tmp1==NULL) error_ ("unrecognized file format of file: '%s'", g.graphic_name );
    set_palette( (RGB *)&g.palette );       // set loaded palette
        if( g.sx <= 0 || g.sy <= 0 ){
        g.sx = tmp1->w;
        g.sy = tmp1->h;
        }

    ll_init( g.sx, g.sy, g.bpp );   // init linked list nodes in ll.c with bpp:8

    tmp2 = create_bitmap_ex( g.bpp, g.sx+0, g.sy+0 ); if( tmp2 == NULL ) error_("creating bitmap for block copy/paste");
    blit( tmp1, tmp2, 0, 0, 0, 0, g.sx, g.sy );
    ll_append_tail( tmp2 );     // make copy and append into linked list

    for(;;){
    if( g.flag_multi_positive == TRUE)  numeric_value++;
    if( g.flag_multi_positive == FALSE) numeric_value--;
    sprintf( numeric, (char *)&zox, numeric_value );
    d[0] = 0;
    strncpy( d, prefix,  len );
    strncat( d, numeric, numlen );
    strncat( d, suffix,  len );
    // string 'd' is now a working string
    textprintf(screen, font, 120,120, 255, "%s", d);
    if( exists( d ) == FALSE ) break;


    // now process image....Load etc.
    if(g.flag_verbose==TRUE) printf(" prefix: <%s> numeric: <%s> suffix: <%s> destination: <%s>\n", prefix, numeric, suffix, d );
    // ************************************************************
    // *****                                                  *****
    if(flag_type==1){
        fli = fli_open_file_read( d, 0, 0 ); if( fli==NULL ) error_("opening FLx file: %s",d );
        tf = fli_read_frame( fli );   if(tf==NULL){ msgbox_("Error reading FLx frame"); break; }
        tmp1 = create_bitmap( g.sx, g.sy );    if( tmp1 == NULL ){ msgbox_("creating bitmap for block copy/paste"); break;}
        fli_compose_image( tmp1, fli->image, fli->img_begin,fli->img_end, fli->width, fli->depth );
        //        fli_copy_pal( fli, (RGB *)&g.palette );
        fli_close( fli );
    }
    if(flag_type==2){
        gif = gif_openload( d );   if( gif==NULL ) error_("allocating memory" );
        tmp1 = gif_load( gif, NULL );
        gif_loadclose( gif );
    }


    if(flag_type==0){
        tmp1 = load_bitmap( d, NULL );
    }
    if( tmp1 == NULL ) error_ ("can't load graphic file: %s\n", d );

//.................

    if( bitmap_color_depth(tmp1) > 8 && bitmap_color_depth(tmp2) == 8 ){
    // color reduction is about to happen
    set_color_conversion( COLORCONV_REDUCE_TO_256  );
    create_default_palette2( (RGB *)&g.palette );
    set_palette( (RGB *)&g.palette );       // set new palette
    }

    blit( tmp1, tmp2, 0, 0, 0, 0, g.sx, g.sy ); // color reduction may happen here
    ll_append_tail( tmp2 );     // make copy and append into linked list
    destroy_bitmap( tmp1 );    tmp1 = NULL;
    // *****                                                  *****
    // ************************************************************
    }







    // -------------------------------
    // close files
    if(flag_type==1){
    }
    if(flag_type==2){
    }
    if(flag_type==0){
    }

    if(g.flag_verbose==TRUE) printf("last filename: <%s> (don't exist)\n", d );


/*
     free_string(s      );
     free_string(prefix );
     free_string(numeric);
     free_string(suffix );
     free_string(d      );
     free_string(zox    );
*/








    }else{      //      if( g.flag_multi_archives == TRUE ){






//debug_display( 0,255, 0,50, "[***2***]");



    // single archive
    //    printf("loading graphic    : %s\n",g.graphic_name);


    // ---------------------------------
    // check filename extension


    flag_type = 0;
    if(find_flx_extension( get_extension(g.graphic_name))==TRUE) flag_type=1;
    if(find_gif_extension( get_extension(g.graphic_name))==TRUE) flag_type=2;
    if(strlen(get_extension(g.graphic_name)) == 0 )              flag_type=3; //invalid file



//debug_display( 0,255, 0,50, "[***3***]");


    if(flag_type==2){    // *** GIF load
        gif = gif_openload( g.graphic_name );   if( gif==NULL ) error_("allocating memory for gif" );
        if( _GifError !=0 ) PrintGifError();
        for(i=0;;i++){
        // we don't know image dimensions until first image is loaded in.

        img = gif_load( gif, (RGB *)&g.palette );        if( img==NULL ) break;

//        textprintf(screen, font, 100,130, 255, "image read: (%d)", i);


        if( _GifError !=0 ) PrintGifError();
            if( g.sx<=0 || g.sy<=0 ){
                g.sx = img->w;
                g.sy = img->h;
            }


        if(i==0) ll_init( g.sx, g.sy, 8 );   // init linked list nodes in ll.c with bpp:8
        ll_append_tail( img );     // make copy and append into linked list
        destroy_bitmap( img ); img=NULL;
        }

        gif_loadclose( gif );
        if( _GifError !=0 ) PrintGifError();
        set_palette( (RGB *)&g.palette );       // set loaded palette
        g.block_count = ll_return_spr_count();
        return 0;
    }



    if(flag_type==1){   // load all using FLI LIbrary
            fli = fli_open_file_read( g.graphic_name, 0, 1 );   // verobse flag on
            if( fli==NULL ) error_("allocating memory" );
            if( fli->errnumber != FERR_OK ){
            msgbox_("error: %s : %s",g.graphic_name, fli_return_errstring( fli ) );
            return -1;
            }
        // check if sizes are 0.
        if(g.sx==0 || g.sy==0){
            // get dimensions from fli lib
            g.sx = fli->width;
            g.sy = fli->height;
        }
        k = amount;
        if(amount==0){ amount = k = fli->frames;}

        textprintf(screen, font, 100,120, 255, "frames: %d, sx:%d, sy:%d", amount, g.sx, g.sy );

            ll_init( g.sx, g.sy, g.bpp );   // init linked list nodes in ll.c with bpp:8
            for(j=0;j<k;j++){

            tf = fli_read_frame( fli );
            if(tf==NULL){ msgbox_("Allocation Error"); return -1;}
                if( fli->errnumber != FERR_OK ){
                    msgbox_("error: %s ", fli_return_errstring( fli ) );
                    return -1;
                }

            textprintf(screen, font, 100,130, 255, "image read: (%d)", j);

            // *** crash ERROR on jpeg file ***
            img = create_bitmap_ex( g.bpp, g.sx, g.sy );    if( img == NULL ) error_("creating bitmap for block copy/paste");
            // *** crash ERROR on jpeg file ***
            fli_compose_image( img, fli->image, fli->img_begin,fli->img_end, fli->width, fli->depth );
            ll_append_tail( img );     // make copy and append into linked list
            if( img  != NULL ) destroy_bitmap( img  ); img = NULL;
            if( fli->images_to_go == 0 ) fli_rewind( fli );
            }
            fli_copy_pal( fli, (RGB *)&g.palette );
            fli_close( fli );       // deallocate fli structure
    set_palette( (RGB *)&g.palette );       // set loaded palette
    g.block_count = ll_return_spr_count();
    if( img  != NULL ) destroy_bitmap( img  ); img = NULL;
    return 0;
    }




    // ---------------------------------

    if(amount==0) amount=1;

    if(amount==1){


//debug_display( 0,255, 0,50, "[***4***] %s", g.graphic_name );

        tmp1 = load_bitmap( g.graphic_name, (RGB *)&g.palette );        if(tmp1==NULL) error_ ("loading file: %s", g.graphic_name );

        if(bitmap_color_depth( screen ) == 8 && bitmap_color_depth( tmp1 ) > 8){
        // we must fix color mapping to a palette
        // reducing color depth
        }

        if(bitmap_color_depth( screen ) > 8 )
            g.palette[255].r = g.palette[255].g = g.palette[255].b = 255;


        set_palette( (RGB *)&g.palette );       // set loaded palette



        if( g.sx <= 0 || g.sy <= 0 ){
            g.sx = tmp1->w;
            g.sy = tmp1->h;
        }

        ll_init( g.sx, g.sy, g.bpp );   // init linked list nodes in ll.c with bpp:8
        tmp2 = create_bitmap_ex( g.bpp, g.sx, g.sy );    if( tmp2 == NULL ) error_("creating bitmap for block copy/paste, ec=101");


        if( bitmap_color_depth(tmp1) > 8 && bitmap_color_depth(tmp2) == 8 ){
        // color reduction is about to happen
        // set_color_conversion( COLORCONV_REDUCE_TO_256 | COLORCONV_DITHER  );
        set_color_conversion( COLORCONV_REDUCE_TO_256  );
        create_default_palette2( (RGB *)&g.palette );
        g.palette[255].r = g.palette[255].g = g.palette[255].b = 255;
        set_palette( (RGB *)&g.palette );       // set new palette
        }


        blit( tmp1, tmp2, 0, 0, 0, 0, g.sx, g.sy ); // color reduction happens here!

        if( tmp1 != NULL ) destroy_bitmap( tmp1 );  tmp1 = NULL;
        if(ll_append_tail( tmp2 )==FALSE) error_("fatal: cannot create copy of bitmap");     // make copy and append into linked list




    }else{

//debug_display( 0,255, 0,50, "[***8***]");


        tmp1 = load_bitmap( g.graphic_name, (RGB *)&g.palette );        if(tmp1==NULL) error_ ("loading file: %s", g.graphic_name );
        set_palette( (RGB *)&g.palette );       // set loaded palette
        if( g.sx <= 0 || g.sy <= 0 ){
            g.sx = tmp1->w;
            g.sy = tmp1->h;
        }
        ll_init( g.sx, g.sy, g.bpp );   // init linked list nodes in ll.c with bpp:8
        tmp2 = create_bitmap_ex( g.bpp, g.sx, g.sy );    if( tmp2 == NULL ) error_("creating bitmap for block copy/paste");
        for( i = 0 ; i < amount ; i++ ){
            blit( tmp1, tmp2, 0, g.sy * i, 0, 0, g.sx, g.sy );
            ll_append_tail( tmp2 );     // make copy and append into linked list
        }
    }

    }


//msgbox_("* c *");

    g.block_count = ll_return_spr_count();
    if( tmp1 != NULL ){ destroy_bitmap( tmp1 ); tmp1=NULL;}
    if( tmp2 != NULL ){ destroy_bitmap( tmp2 ); tmp2=NULL;}
    return 0;
}


























void handle_colormapping( int t_syscolor1, int t_syscolor2, int t_syscolor3 )
{
    if( g.bpp == 8 ){

        if(g.syscol1.index1 ==-1) g.syscol1.index2 = bestfit_color( g.palette, g.syscol1.r,g.syscol1.g,g.syscol1.b );
        if(g.syscol2.index1 ==-1) g.syscol2.index2 = bestfit_color( g.palette, g.syscol2.r,g.syscol2.g,g.syscol2.b );
        if(g.syscol3.index1 ==-1) g.syscol3.index2 = bestfit_color( g.palette, g.syscol3.r,g.syscol3.g,g.syscol3.b );
        g.usercolor1 = g.usrcol1.index1;
        g.usercolor2 = g.usrcol2.index1;
        g.usercolor3 = g.usrcol3.index1;

        if(g.syscol1.index1 != -1)        g.syscolor1  = g.syscol1.index1;
        if(g.syscol2.index1 != -1)        g.syscolor2  = g.syscol2.index1;
        if(g.syscol3.index1 != -1)        g.syscolor3  = g.syscol3.index1;

    }else{

        g.usercolor1 = makecol( g.usrcol1.r,g.usrcol1.g,g.usrcol1.b );
        g.usercolor2 = makecol( g.usrcol2.r,g.usrcol2.g,g.usrcol2.b );
        g.usercolor3 = makecol( g.usrcol3.r,g.usrcol3.g,g.usrcol3.b );
        g.syscolor1  = makecol( g.syscol1.r,g.syscol1.g,g.syscol1.b );
        g.syscolor2  = makecol( g.syscol2.r,g.syscol2.g,g.syscol2.b );
        g.syscolor3  = makecol( g.syscol3.r,g.syscol3.g,g.syscol3.b );

    }

    if( g.bpp == 8 ){
        if( t_syscolor1 < 0 ){
            g.flag_rgb[0] = FALSE;  // FALSE = adapted color
        }else{
            g.flag_rgb[0] = TRUE;   // TRUE = fixed color,
        }

    if( g.bpp == 8 ){

        if( t_syscolor2 < 0 ){ g.flag_rgb[1]=FALSE; }else{ g.flag_rgb[1]=TRUE; g.syscolor2 = t_syscolor2; }
        if( t_syscolor3 < 0 ){ g.flag_rgb[2]=FALSE; }else{ g.flag_rgb[2]=TRUE; g.syscolor3 = t_syscolor3; }

        c[0].r = cc[0].r;
        c[0].g = cc[0].g;
        c[0].b = cc[0].b;
        c[1].r = cc[1].r;
        c[1].g = cc[1].g;
        c[1].b = cc[1].b;
        c[2].r = cc[2].r;
        c[2].g = cc[2].g;
        c[2].b = cc[2].b;

        c[0].r >>= 2;   c[0].g >>= 2;   c[0].b >>= 2;   // do only on vga
        c[1].r >>= 2;   c[1].g >>= 2;   c[1].b >>= 2;
        c[2].r >>= 2;   c[2].g >>= 2;   c[2].b >>= 2;

        if( g.syscolor1 > 255 ) g.syscolor1 = 255;
        if( g.syscolor2 > 255 ) g.syscolor2 = 255;
        if( g.syscolor3 > 255 ) g.syscolor3 = 255;
        }
    }

    g.fixed_rgb[0].r = c[0].r; g.fixed_rgb[0].g = c[0].g; g.fixed_rgb[0].b = c[0].b;
    g.fixed_rgb[1].r = c[1].r; g.fixed_rgb[1].g = c[1].g; g.fixed_rgb[1].b = c[1].b;
    g.fixed_rgb[2].r = c[2].r; g.fixed_rgb[2].g = c[2].g; g.fixed_rgb[2].b = c[2].b;
    g.adapt_rgb[0].r = c[0].r; g.adapt_rgb[0].g = c[0].g; g.adapt_rgb[0].b = c[0].b;
    g.adapt_rgb[1].r = c[1].r; g.adapt_rgb[1].g = c[1].g; g.adapt_rgb[1].b = c[1].b;
    g.adapt_rgb[2].r = c[2].r; g.adapt_rgb[2].g = c[2].g; g.adapt_rgb[2].b = c[2].b;
}

static void parse_usrcolors( char *tmpstr, char *colors )
{
    sscanf( tmpstr,"%d %d %d",
            (int *)&g.usrcol1.index1,       // palette index
            (int *)&g.usrcol2.index1,       // palette index
            (int *)&g.usrcol3.index1);       // palette index

    sscanf( colors,"%d %d %d %d %d %d %d %d %d",
            (int *)&g.usrcol1.r,            // red
            (int *)&g.usrcol1.g,            // green
            (int *)&g.usrcol1.b,            // blue
            (int *)&g.usrcol2.r,            // red
            (int *)&g.usrcol2.g,            // green
            (int *)&g.usrcol2.b,            // blue
            (int *)&g.usrcol3.r,            // red
            (int *)&g.usrcol3.g,            // green
            (int *)&g.usrcol3.b);           // blue
    g.usrcol1.flag_bestfit = g.usrcol2.flag_bestfit = g.usrcol3.flag_bestfit = 0;
    g.usercolor1    = g.usrcol1.index1;
    g.usercolor2    = g.usrcol2.index1;
    g.usercolor3    = g.usrcol3.index1;
}
static void parse_syscolors( char *tmpstr, char *colors )
{
    if(tmpstr != NULL ){
    sscanf( tmpstr,"%d %d %d",
            (int *)&g.syscol1.index1,       // palette index
            (int *)&g.syscol2.index1,       // palette index
            (int *)&g.syscol3.index1);       // palette index
    if( g.syscol1.index1 == -1 ) g.syscol1.flag_bestfit = -1; else g.syscol1.flag_bestfit = 0;
    if( g.syscol2.index1 == -1 ) g.syscol2.flag_bestfit = -1; else g.syscol1.flag_bestfit = 0;
    if( g.syscol3.index1 == -1 ) g.syscol3.flag_bestfit = -1; else g.syscol1.flag_bestfit = 0;
    }

    if( sscanf( colors,"%d %d %d %d %d %d %d %d %d",
            (int *)&g.syscol1.r,            // red
            (int *)&g.syscol1.g,            // green
            (int *)&g.syscol1.b,            // blue
            (int *)&g.syscol2.r,            // red
            (int *)&g.syscol2.g,            // green
            (int *)&g.syscol2.b,            // blue
            (int *)&g.syscol3.r,            // red
            (int *)&g.syscol3.g,            // green
            (int *)&g.syscol3.b) <9)
    error_("too few colors in rgbs= field, (must be 9 numbers with range 0-255)");
}

static void parse_flags( char *s_flags )
{
    sscanf( s_flags,                                   \
    "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d " \
    "%d %d %d %d %d %d %d %d %d "                         \
    "%d %d %d %d %d %d %d %d %d %d %d",
    (int *)&clips.x1,    (int *)&clips.y1,    (int *)&clips.x2,
    (int *)&clips.y2,    (int *)&clips.sx,    (int *)&clips.sy,
    (int *)&clips.block, (int *)&clips.flag,
    (int *)&clipd.x1,    (int *)&clipd.y1,    (int *)&clipd.x2,
    (int *)&clipd.y2,    (int *)&clipd.sx,    (int *)&clipd.sy,
    (int *)&clipd.block,(int *)&clipd.flag,
    (int *)&g.flag_pixelgrid,
    (int *)&g.flag_grid,
    (int *)&g.flag_brush,  (int *)&g.flag_bkmap,
    (int *)&g.flag_fill,    (int *)&g.flag_all,    (int *)&g.flag_src,
    (int *)&g.flag_dst,     (int *)&g.flag_cad,
    (int *)&g.flag_animate,
    (int *)&g.bkmap.type,
    (int *)&g.bkmap.nr,
    (int *)&g.brush.size, (int *)&g.brush.type,
    (int *)&g.brush.sx,   (int *)&g.brush.sy,
    (int *)&g.grid_sx,    (int *)&g.grid_sy,
    (int *)&g.animate_type, (int *)&g.animate_delay
    );
    clips.flag     = tobool( clips.flag );
    clipd.flag     = tobool( clipd.flag );
    g.flag_pixelgrid = tobool( g.flag_pixelgrid );
    g.flag_grid    = tobool( g.flag_grid  );
    g.flag_brush   = tobool( g.flag_brush );
    g.flag_bkmap   = tobool( g.flag_bkmap );
    g.flag_fill    = tobool( g.flag_fill  );
    g.flag_all     = tobool( g.flag_all   );
    g.flag_src     = tobool( g.flag_src   );
    g.flag_dst     = tobool( g.flag_dst   );
    g.flag_cad     = tobool( g.flag_cad   );
    g.flag_animate = tobool( g.flag_animate );
}


static void handle_bkmap()
{
    // bkmap
    g.bkmap.file = NULL;    // filename (type 3)
    g.bkmap.sx   = g.sx;    // size x
    g.bkmap.sy   = g.sy;    // size y
    g.bkmap.sMD  = NULL;
    g.bkmap.map  = NULL;
    g.bkmap.type &= 3;
    // Warning!  flips out if image dimensions are 0!!!
    g.bkmap.map     =  create_bitmap_ex( g.bpp, (g.bkmap.sx+1), (g.bkmap.sy+1) );
    if( g.bkmap.map==NULL ){
        error_("allocating bitmap for background ");
    }
    clear_bitmap( g.bkmap.map );
    if( g.flag_verbose == TRUE ){
        puts("-----------------------");
        puts("background map things.");
        printf("TRUE = %d  FALSE = %d\n",TRUE,FALSE);
        printf("g.flag_bkmap = %d \n", g.flag_bkmap);
        printf("g.bkmap.type <%d>\ng.bkmap.nr   <%d>\ng.bkmap.file <%s>\ng.bkmap.sx   <%d>\ng.bkmap.sy   <%d>\n",g.bkmap.type,g.bkmap.nr,g.bkmap.file,g.bkmap.sx,g.bkmap.sy);
    }
}
static void handle_brush()
{
    // brush
    if( g.flag_brush==TRUE && g.brush.type==2 ){
        g.brush.bmp = create_bitmap_ex( g.bpp, g.brush.sx, g.brush.sy );
        clear_bitmap( g.brush.bmp );
    }else{
        g.brush.bmp = NULL;
    }
}




/* Compare input with FLx tokens to find if it matches
 * input: extension string to compare with.
 * return TRUE on FLx found
 * else returns FALSE.
 */
int find_flx_extension( char *_ext )
{
    int     i;
    char    ext[12];
    char    tokens[]="FLA FLB FLT FLH FLC FLI";

    if ( _ext == NULL ) _ext = "";
    strncpy( (char *)&ext, _ext, 12 );
    for ( i = 0; i < 6; i++ )   // only 6 types defined
		{
		char	buf [100+1], *s;

        for ( s  = strtok(strcpy(buf, tokens), " \t,");
		      s != NULL;
		      s  = strtok(NULL, " \t,") )
            if( strncmp( strupr(s), strupr(ext), 12 ) == 0 ){
            // we got a hit.
            return TRUE;    // we found FLx extension
            }
        }
    return FALSE;   // not found
}

/* Compare input with GIF token to find if it matches
 * input: extension string to compare with.
 * return TRUE on FLx found
 * else returns FALSE.
 */
int find_gif_extension( char *_ext )
{
    int     i;
    char    ext[12];
    char    tokens[]="GIF";

    if ( _ext == NULL ) _ext = "";
    strncpy( (char *)&ext, _ext, 12 );
    for ( i = 0; i < 1; i++ )   // only 1 type defined
		{
		char	buf [100+1], *s;

        for ( s  = strtok(strcpy(buf, tokens), " \t,");
		      s != NULL;
		      s  = strtok(NULL, " \t,") )
            if( strncmp( strupr(s), strupr(ext), 12 ) == 0 ){
            // we got a hit.
            return TRUE;    // we found gif extension
            }
        }
    return FALSE;   // not found
}








typedef struct {
    int r;
    int g;
    int b;
    int index;      // color index in palette
    int busy;       // already busy or free
}INDEXED_PALETTE;
INDEXED_PALETTE diff[256];


//  We'll remap the loaded bitmap and palette to current global palette.
//  calculate one color of the least distance to another color.
void remap_bitmap_to_gpalette( BITMAP *bmp, RGB *pal )
{
    int value1, value2, indexes, i,j,k,m,  a,b,c,d,e;
    int onecolor_r,onecolor_g, onecolor_b;
    int destination_indexes[256],source_indexes[256];
    int source_index=0, destination_index=0;

    if( g.bpp != 8 ) return;
    indexes = 0;
    for(k=0;k<256;k++){     // prepare table
    diff[k].r = 0;
    diff[k].g = 0;
    diff[k].b = 0;
    diff[k].index = 0;
    diff[k].busy = FALSE;
    destination_indexes[k] = source_indexes[k]=0;
    }

    for(i=0;i<256;i++){
    onecolor_r = (int) pal[i].r;
    onecolor_g = (int) pal[i].g;
    onecolor_b = (int) pal[i].b;
    source_index = i;

    for(j=0;j<256;j++){
        diff[j].r =    onecolor_r - (int) g.palette[j].r;
        diff[j].g =    onecolor_g - (int) g.palette[j].g;
        diff[j].b =    onecolor_b - (int) g.palette[j].b;
        diff[j].index = j;
    }
    // we got the distances, both positive and negative,
    //  now make the values positive
        for(k=0;k<256;k++){
            if( diff[k].r < 0 ) diff[k].r =  -diff[k].r;
            if( diff[k].g < 0 ) diff[k].g =  -diff[k].g;
            if( diff[k].b < 0 ) diff[k].b =  -diff[k].b;
        }
        // find the rgb value with the smallest distance
        // now sort the table to find the smallest distance
        // smallest values gets in the beginning
        for(m=0;m<256;m++){
        for(k=0;k<256;k++){
            value1 = (diff[k].r  +  diff[k].g  +  diff[k].b)/3;
            value2 = (diff[k+1].r + diff[k+1].g + diff[k+1].b)/3;
            if( value1 > value2 ){
            // swap values
            a = diff[k].r;
            b = diff[k].g;
            c = diff[k].b;
            d = diff[k].index;
            e = diff[k].busy;
            diff[k].r      = diff[k+1].r     ;
            diff[k].g      = diff[k+1].g     ;
            diff[k].b      = diff[k+1].b     ;
            diff[k].index  = diff[k+1].index ;
            diff[k].busy   = diff[k+1].busy  ;
            diff[k+1].r    = a;
            diff[k+1].g    = b;
            diff[k+1].b    = c;
            diff[k+1].index= d;
            diff[k+1].busy = e;
            // ...
            }
        }}
        // after sorting, we have the result in the lowest indexes
        for(k=0;k<256;k++){
        // search for a free color index
            if( diff[k].busy == FALSE ){ // this is free
            // we got a hit...
            // mark busy
            diff[k].busy = TRUE;
            destination_index = diff[k].index;
            // store indexes in arrays
            destination_indexes[ indexes  ] = destination_index;
            source_indexes[     indexes++ ] = source_index;
            // ...
            break;
            }
        }
    }
    // now we can begin pixel mapping
    // ...
    for(i=0;i< bmp->h ; i++){
    for(j=0;j< bmp->w ; j++){
    a = getpixel( bmp, j,i ) & 255;
    b = destination_indexes[ a ];
    putpixel( bmp, j,i, b );
    }}
    // ...
}


static void request_unknown_file( int number_of_blocks )
{
    GifFileType *gif;
    FLI         *fli;
    BITMAP  *bmp1 = NULL;
    char    *tmpstr, *str1=NULL;
    int     flag_format = 0, i=0;

    sprintf( (char *)&string2, "unknown file:'%s'", g.graphic_name );
    tmpstr = commdlg_load( (char *)&string2,
                        NULL,        // (unused)
                        filemasks,   // defined in dlg.c
                        g.graphic_name,
                        NULL );    // selected filter index (ret value)

    // CANCEL action

    if( tmpstr == NULL ){ msgbox_("Cancel: exiting..."); exit(-4); }


    // OK     action





    if( exists( tmpstr ) == 0 ){    // don't exists

        str1 = dlg_request_string2( "create a new file", tmpstr, FILENAME_MAX );
        if( str1==NULL ){ msgbox_("Cancel: exiting..."); exit(-4);}



        flag_format=0;
        if(find_flx_extension( get_extension(g.graphic_name))==TRUE) flag_format=1;
        if(find_gif_extension( get_extension(g.graphic_name))==TRUE) flag_format=2;
        if(strlen(get_extension(g.graphic_name)) == 0 )              flag_format=3; //invalid file

        strncpy( g.graphic_name, str1, FILENAME_MAX );






        if(flag_format!=3){
            if( g.sx <= 0 )      // request image dimensions
                g.sx = dlg_request_int("image size X", 1, 100, 12000 );
            if( g.sy <= 0 )      // request image dimensions
                g.sy = dlg_request_int("image size Y", 1, 100, 12000 );
            if( g.sx <=0 || g.sy <=0 ) //Cancel was pressed
                error_("cannot create %d x %d image", g.sx, g.sy );
        }






        // ...
        if(flag_format==0){
//            msgbox_( "creating file: %s ...", g.graphic_name );
            bmp1 = create_bitmap_ex( g.bpp, g.sx, g.sy * number_of_blocks );        if(bmp1==NULL) error_("fatal: creating auxiliary bitmap, sx:%d,sy:&d",g.sx, g.sy*number_of_blocks);
            clear_bitmap(bmp1);
            create_vga_palette( (RGB *)&g.palette );
            save_bitmap( g.graphic_name, bmp1, (RGB *)&g.palette);
            destroy_bitmap( bmp1 ); bmp1=NULL;
        }
        if(flag_format==1){  //FLx
//            msgbox_( "creating FLx file: %s ...", g.graphic_name );
            fli = fli_open_file_write( g.graphic_name, 8, g.sx, g.sy, 0, 0 );
            if( fli==NULL ) error_("opening FLx file: %s",g.graphic_name );
            if( fli->errnumber != FERR_OK )
                error_("error: %s", fli_return_errstring( fli ) );
            create_vga_palette( (RGB *)&g.palette );
            fli_reverse_copy_pal( fli, (RGB *)&g.palette );
            bmp1 = create_bitmap_ex( g.bpp, g.sx, g.sy );        if(bmp1==NULL) error_("creating auxiliary bitmap, sx:%d,sy:&d",g.sx, g.sy);
            clear_bitmap(bmp1);
            fli_reverse_compose_image( fli, bmp1 );
            for(i=0;i<number_of_blocks;i++)
                fli_write_frame( fli );
            fli_close( fli );
        }
        if(flag_format==2){  //GIF
//            msgbox_( "creating GIF file: %s ...", g.graphic_name );
            bmp1 = create_bitmap_ex( g.bpp, g.sx, g.sy );        if(bmp1==NULL) error_("creating auxiliary bitmap, sx:%d, sy:&d",g.sx, g.sy);
            clear_bitmap(bmp1);
            create_vga_palette( (RGB *)&g.palette );
            gif = gif_opensave(g.graphic_name, 8, g.sx, g.sy, 256, (RGB *)&g.palette );
            for(i=0;i<number_of_blocks;i++)
                gif_save( gif,  g.sx, g.sy, bmp1 );
            destroy_bitmap( bmp1 ); bmp1=NULL;
            gif_saveclose( gif );
        }
        if(flag_format==3){  //.....error......exit
            error_("unknown format, exiting...");
        }



        if( exists( g.graphic_name ) == 0 ) error_("creating file error");
        set_config_string( g.project_name, "filename", g.graphic_name );
        flush_config_file();
        msgbox_("file: %s was created", g.graphic_name );

    }else{  //tmpstr, file exists...

        strncpy( g.graphic_name, tmpstr, FILENAME_MAX );
        set_config_string( g.project_name, "filename", g.graphic_name );
        flush_config_file();
    }
}







