/*      MD = Main Display

*/
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <math.h>
#include "data.h"
#include "method.h"
#include "md.h"
#include "ll.h"
#include "tb.h"
#include "fnt.h"
#include "md2.h"
#include "dlg.h"
#include "subs.h"
#include "btn.h"
#include "zoom.h"
#include "coord.h"
#include "subs.h"
#include "main.h"
#include "butil.h"
#define min( a,b ) ( a<b ? a:b )
#define max( a,b ) ( a>b ? a:b )


#ifndef PI
#define PI 3.1415926535897932384626433832795f
#endif
            

/* prototypes for helper functions */

static int validate_clip_block( EXA_CLIP *clip, int u, int v, int mx,int my,int *ax1,int *ay1 );
int mousecatch_coords_screen( int *mo_x, int *mo_y, int *bn_x, int *bn_y );

       void puttext_on_md();
       void md_draw_outlines( void );
       void md_init( void );
       void md_deinit( void );
       void put_blockbrush( BITMAP *, int , int , int );
static void



onestate_on_md( );
static void twostate_on_md( );
static void multistate_on_md( );
static void copyfillmap_from8_to24_( BITMAP *input, BITMAP *output );
/* prototypes for helper functions */





/*
 * clb_xxxxxxx   = callbacks for displaying on screen
 *
 *
 */

static void clb_line(   int,int,int,int );
static void clb_ellips( int,int,int,int );
static void clb_circle( int,int,int,int );
static void clb_circle2(int,int,int,int );
static void clb_rect(   int,int,int,int );
static void clb_cad(    int,int,int,int );
static void bin_clb_drawcircle ( BITMAP *, int, int, int, int, int );
static void bin_clb_drawellips ( BITMAP *, int, int, int, int, int );



/*
 * Draw angle, length, position x, position y
 *
 */
void draw_infoblock( int x1, int y1, int x2, int y2)
{
    int     px,py, nx,ny;
    double  angle, radius;
    int     angle2=0;
    char    sline[80];

    px = x2-x1;   // x1,y1 is midpoint
    py = y2-y1;   // x1,y1 is midpoint
    radius = sqrt (px*px + py*py);
    angle  = asin ( (double) (py/radius) ); // angle in radians
    angle2 = (angle*180.0)/PI;              // angle2 in degrees 0-360
    if( px > 0 && py > 0 ){    // quad 1
    }
    if( px > 0 && py <= 0 ){   // quad 2
    angle2 = ((360) - -angle2);
    }
    if( px <= 0 && py <= 0 ){  // quad 3
    angle2 = (180 + -angle2);
    }
    if( px <= 0 && py > 0 ){  // quad 4
    angle2 = (180 - angle2);
    }
    if( g.zoom != 0 ) radius = radius / g.zoom;
    coord_screen2bin( x2, y2, (int *)&nx, (int *)&ny );
    sprintf((char *)&sline,"angle:%d, length:%d x:%d y:%d", angle2, (int) radius,nx,ny );
    printout_infoblock( (char *)&sline );
}

void clear_infoblock()
{
    printout_infoblock( " " );
}


static void clb_line(   int x1, int y1, int x2, int y2 )
{
    x1 += md_x;
    y1 += md_y;
    x2 += md_x;
    y2 += md_y;
    line( screen, x1,y1,x2,y2, g.syscolor2 );
    draw_infoblock( x1,y1,x2,y2);
}




static void clb_circle( int x1, int y1, int x2, int y2 )
{
    int     sx,sy, nx,ny,radius=0;
    char    sline[80];

    sx = x2 - x1;       if( sx < 0 ) sx = x1 - x2;
    sy = y2 - y1;       if( sy < 0 ) sy = y1 - y2;
    if( sx < sy )  radius = sx;
    if( sx >= sy ) radius = sy;
    x1 += md_x;
    y1 += md_y;
    x2 += md_x;
    y2 += md_y;

    acquire_screen();
    set_clip( screen, md_x,md_y,md_x+md_sx, md_y+md_sy );
    circle( screen, x1+g.zoom/2, y1+g.zoom/2, radius, g.syscolor2 );
    set_clip( screen, 0,0,0,0 );  // restore clipping rectangles
    coord_screen2bin( x2, y2, (int *)&nx, (int *)&ny);

    if( g.zoom )
        radius = radius / g.zoom;

    sprintf((char *)&sline,"radius:%d, x:%d y:%d", radius,nx,ny );
    printout_infoblock( (char *)&sline );
    release_screen();

}

static int  linelength=0;

void countpixels( BITMAP *map, int x, int y, int d)
{
    linelength++;
}



static void clb_circle2( int bx1, int by1, int bx2, int by2 )
{
    int     px,py;
    double  x,y, angle, newangle,radius,deg;
    int     sx,sy, radius0=0;
    int     flag_reverse, angle2=0, angle3=0;
    char    sline[80];

    //.....
    flag_reverse = FALSE;
    sx = bx2 - bx1;       if( sx < 0 ) sx = bx1 - bx2;
    sy = by2 - by1;       if( sy < 0 ) sy = by1 - by2;
    if( sx < sy )  radius0 = sx;
    if( sx >= sy ) radius0 = sy;
    bx1 += md_x;
    by1 += md_y;
    bx2 += md_x;
    by2 += md_y;
    line( screen, bx1,by1,bx2,by2, g.syscolor2 );
    linelength=0;
    do_line( screen, bx1,by1,bx2,by2, g.syscolor2, countpixels );
    //.....

    px = bx2-bx1;   // bx1,by1 is midpoint
    py = by2-by1;   // bx1,by1 is midpoint
    if( px > 0 && py > 0 ){    // quad 1
//    textprintf(screen,font,10,10,makecol(220,220,0),"*1*");
    }
    if( px > 0 && py <= 0 ){   // quad 2
//    textprintf(screen,font,10,10,makecol(220,220,0),"*2*");
    }
    if( px <= 0 && py <= 0 ){  // quad 3
//    textprintf(screen,font,10,10,makecol(220,220,0),"*3*");
    flag_reverse = TRUE;
    }
    if( px <= 0 && py > 0 ){  // quad 4
//    textprintf(screen,font,10,10,makecol(220,220,0),"*4*");
    flag_reverse = TRUE;
    }
    radius = sqrt (px*px + py*py);
    angle  = asin ( (double) (py/radius) ); // angle in radians
    angle2 = (angle*180.0)/PI;              // angle2 in degrees 0-360
    angle3 = (angle*127.0)/PI;              // angle3 in degrees 255 for 16.16 fixed data format. 360 degrees is 255.

    if( px > 0 && py > 0 ){    // quad 1
    }
    if( px > 0 && py <= 0 ){   // quad 2
    angle2 = ((360) - -angle2);
    angle3 = ((255) - -angle3);
    }
    if( px <= 0 && py <= 0 ){  // quad 3
    angle2 = (180 + -angle2);
    angle3 = (127 + -angle3);
    }
    if( px <= 0 && py > 0 ){  // quad 4
    angle2 = (180 - angle2);
    angle3 = (127 - angle3);
    }

//    textprintf(screen,font,10,30,makecol(100,220,0),"angle: %f", angle);
//    textprintf(screen,font,10,50,makecol(100,220,0),"angle: %3d", angle2);
//    textprintf(screen,font,10,60,makecol(100,220,0),"angle: %3d", angle3);

    if( g.zoom )
        linelength = linelength / g.zoom;
    sprintf((char *)&sline,"angle:%d, length:%d", angle2, linelength );
    printout_infoblock( (char *)&sline );

    radius = radius - (radius * 0.2 );  // diminish 20%
    acquire_screen();
    set_clip( screen, md_x,md_y, md_x+md_sx, md_y+md_sy );
    circle( screen, bx1, by1, radius, g.syscolor2 );

    deg = 45;
    newangle = PI * deg / 180;
    y = sin( newangle ) * ( (double)radius ) + by1;
    x = cos( newangle ) * ( (double)radius ) + bx1;
    textprintf(screen,font,x,y,g.syscolor2,"%d", (int) deg);
    deg = 90;
    newangle = PI * deg / 180;
    y = sin( newangle ) * ( (double)radius ) + by1;
    x = cos( newangle ) * ( (double)radius ) + bx1;
    textprintf(screen,font,x,y,g.syscolor2,"%d", (int) deg);
    deg = 90+45;
    newangle = PI * deg / 180;
    y = sin( newangle ) * ( (double)radius ) + by1;
    x = cos( newangle ) * ( (double)radius ) + bx1;
    textprintf(screen,font,x,y,g.syscolor2,"%d", (int) deg);
    deg = 180;
    newangle = PI * deg / 180;
    y = sin( newangle ) * ( (double)radius ) + by1;
    x = cos( newangle ) * ( (double)radius ) + bx1;
    textprintf(screen,font,x,y,g.syscolor2,"%d", (int) deg);
    deg = 180+45;
    newangle = PI * deg / 180;
    y = sin( newangle ) * ( (double)radius ) + by1;
    x = cos( newangle ) * ( (double)radius ) + bx1;
    textprintf(screen,font,x,y,g.syscolor2,"%d", (int) deg);
    deg = 180+90;
    newangle = PI * deg / 180;
    y = sin( newangle ) * ( (double)radius ) + by1;
    x = cos( newangle ) * ( (double)radius ) + bx1;
    textprintf(screen,font,x,y,g.syscolor2,"%d", (int) deg);
    deg = 180+90+45;
    newangle = PI * deg / 180;
    y = sin( newangle ) * ( (double)radius ) + by1;
    x = cos( newangle ) * ( (double)radius ) + bx1;
    textprintf(screen,font,x,y,g.syscolor2,"%d", (int) deg);
    deg = 360;
    newangle = PI * deg / 180;
    y = sin( newangle ) * ( (double)radius ) + by1;
    x = cos( newangle ) * ( (double)radius ) + bx1;
    textprintf(screen,font,x,y,g.syscolor2,"%d", (int) deg);

    set_clip( screen, 0,0,0,0 );  // restore clipping rectangles
    release_screen();
//    if( flag_reverse == TRUE )
//        x = -cos( newangle )* ( (double)radius0 ) + bx1;
//    textprintf(screen,font,x,y,makecol(100,220,0),"45");
//    line( screen, bx1,by1,x,y, makecol( 220,220,50) );
}









static void bin_clb_drawcircle ( BITMAP *pspr1, int x1, int y1, int x2, int y2, int color )
{
    int sx,sy, radius;

    sx = x2 - x1;       if( sx < 0 ) sx = x1 - x2;
    sy = y2 - y1;       if( sy < 0 ) sy = y1 - y2;
    if( sx < sy )  radius = sx;
    if( sx >= sy ) radius = sy;

    if( g.flag_fill == TRUE ){
            circlefill( pspr1, x1, y1, radius , color );
    }else{
        if( g.flag_brush == TRUE ){
            do_circle(  pspr1, x1, y1, radius , color, put_blockbrush );
        }else{
            circle(     pspr1, x1, y1, radius , color );
        }
    }
}
static void clb_ellips( int x1, int y1, int x2, int y2 )
{
    int sx,sy, radiusx, radiusy;

    sx = x2 - x1;       if( sx < 0 ) sx = x1 - x2;
    sy = y2 - y1;       if( sy < 0 ) sy = y1 - y2;
    radiusx = sx;
    radiusy = sy;
    x1 += md_x;
    y1 += md_y;
    x2 += md_x;
    y2 += md_y;
    acquire_screen();
    set_clip( screen, md_x,md_y,md_x+md_sx, md_y+md_sy );
    ellipse( screen, x1+g.zoom/2, y1+g.zoom/2, radiusx, radiusy, g.syscolor2 );
    set_clip( screen, 0,0,0,0 );  // restore clipping rectangles
    release_screen();
}
static void bin_clb_drawellips ( BITMAP *pspr1, int x1, int y1, int x2, int y2, int color )
{
    int sx,sy, radiusx, radiusy;

    sx = x2 - x1;       if( sx < 0 ) sx = x1 - x2;
    sy = y2 - y1;       if( sy < 0 ) sy = y1 - y2;
    radiusx = sx;
    radiusy = sy;
    if( g.flag_fill == TRUE ){
        ellipsefill( pspr1,x1, y1, radiusx, radiusy, color );
    }else{
        if( g.flag_brush == TRUE ){
        do_ellipse( pspr1, x1, y1, radiusx, radiusy, color,put_blockbrush );
        }else{
        ellipse( pspr1,    x1, y1, radiusx, radiusy, color );
    }
    }
}



















static void clb_rect(   int x1, int y1, int x2, int y2 )
{
    int     sx,sy;
    int     ax1, ay1, ax2, ay2;
    char    sline[80];


    coord_screen2bin2( x1, y1, (int *)&ax1, (int *)&ay1 );
    coord_screen2bin2( x2, y2, (int *)&ax2, (int *)&ay2 );
    sx = (ax2-ax1);
    sy = (ay2-ay1);


    x1 += md_x;
    y1 += md_y;
    x2 += md_x;
    y2 += md_y;
    if(x1>( md_x + md_sx ) ) x1 = md_x + md_sx - 1;
    if(x2>( md_x + md_sx ) ) x2 = md_x + md_sx - 1;
    rect( screen, x1,y1,x2,y2, g.syscolor2 );


    sprintf((char *)&sline,"sx:%d,sy:%d", sx,sy );
    printout_infoblock( (char *)&sline );

}
static void clb_cad (   int x1, int y1, int x2, int y2 )
{
    int sx,sy;

    x1 += md_x;
    y1 += md_y;
    x2 += md_x;
    y2 += md_y;
    sx = x2 - x1;
    sy = y2 - y1;
    rect( screen, x1, y1, x2, y2, g.syscolor2 );
    if( x1!=0 && y1!=0 && x2!=0 && y2!=0 )
        rect( screen, x1+1, y1+1, x2-1, y2-1, 0 );  // shadow
    if( sy > ( g.zoom ) )
        vline( screen, x1+sx/2+g.zoom, y1, y2+g.zoom, g.syscolor2 );
    if( sx > ( g.zoom ) )
        hline( screen, x1, y1+sy/2+g.zoom, x2+g.zoom, g.syscolor2 );
}


/*
 * bin_clb_xxxxxxx   = callbacks for editing on binary graphic
 *
 *
 */


static void bin_clb_drawline   ( BITMAP *, int, int, int, int, int );
static void bin_clb_drawrect   ( BITMAP *, int, int, int, int, int );
static void bin_clb_def_clip( EXA_CLIP *clip, int x1, int y1, int x2, int y2, int color );
static void bin_clb_change_clip( EXA_CLIP *clip, int x1, int y1, int x2, int y2, int color );



static void bin_clb_drawline ( BITMAP *pspr1, int x1, int y1, int x2, int y2, int color )
{
    if( g.flag_brush == TRUE ){
        do_line( pspr1,   x1, y1, x2, y2, color, put_blockbrush );
    }else{
        line(    pspr1,   x1, y1, x2, y2, color );
    }

    draw_infoblock( x1,y1,x2,y2);


}
static void bin_clb_drawrect ( BITMAP *pspr1, int x1, int y1, int x2, int y2, int color )
{
    if( g.flag_fill==FALSE ){
    if( g.flag_brush == TRUE ){
        do_line( pspr1, x1, y1, x2, y1, color , put_blockbrush );
        do_line( pspr1, x2, y1, x2, y2, color , put_blockbrush );
        do_line( pspr1, x2, y2, x1, y2, color , put_blockbrush );
        do_line( pspr1, x1, y2, x1, y1, color , put_blockbrush );
        }else{
        rect( pspr1, x1,y1,x2,y2, color );
        }
    }else{
    rectfill( pspr1, x1,y1,x2,y2, color );
    }
}


static void bin_clb_def_clip( EXA_CLIP *clip, int x1, int y1, int x2, int y2, int color )
{
    int     sx, sy;

    coord_limit_bin ( (int *)&x1, (int *)&y1, (int *)&x2, (int *)&y2 );
    sx = x2 - x1;
    sy = y2 - y1;
    if( sx >= 1 && sy >= 1 ){
        clip->x1 = x1;    clip->y1 = y1;
        clip->x2 = x2;    clip->y2 = y2;
        clip->sx = clip->x2 - clip->x1;
        clip->sy = clip->y2 - clip->y1;
        clip->flag = TRUE;
        clip->block = g.block_current;
    }
}
static void bin_clb_change_clip( EXA_CLIP *clip, int x1, int y1, int x2, int y2, int color )
{
    coord_limit_bin ( (int *)&x1, (int *)&y1, (int *)&x2, (int *)&y2 );
    if( clip->areaselected ==0 ) return;
       if( clip->areaselected==1 ){         /* top left */
           clip->x1 = x1;
           clip->y1 = y1;
           }
       if( clip->areaselected==2 ){         /* down right */
           clip->x2 = x2;
           clip->y2 = y2;
           }
       if( clip->areaselected==3 ){
           clip->x1 = x1;
           clip->y2 = y2;
           }
       if( clip->areaselected==4 ){
           clip->y1 = y1;
           clip->x2 = x2;
           }
       if( clip->areaselected==5 ){
//           clip->y1 = y2;
           clip->x2 = x2;
           }
       if( clip->areaselected==6 ){
           clip->y2 = y2;
//           clip->x2 = x2;
           }
       if( clip->areaselected==7 ){
           clip->y1 = y1;
//           clip->x2 = x2;
           }
       if( clip->areaselected==8 ){
//           clip->y1 = y2;
           clip->x1 = x1;
           }



       clip->sx = clip->x2 - clip->x1;
       clip->sy = clip->y2 - clip->y1;
}

























void md_init( void )
{
/* MD */
    md_x = bt_x + bt_sx + 4;
    md_y = bt_y + 1;
    //............
    md_sx = pl_x - md_x - 3;
    md_sy = g.screen_h - bt_y - 2;
/* MD */

/* MD2 */
    /* fix range for slider bars */
    main_dialog[IDX_SLIDEX].d1 = g.sx-1;
    main_dialog[IDX_SLIDEX].d2 = g.ox;
    main_dialog[IDX_SLIDEY].d1 = g.sy-1;
    main_dialog[IDX_SLIDEY].d2 = g.sy - g.oy - 1;
    main_dialog[IDX_SCLICK].w = mc_s;
    main_dialog[IDX_SCLICK].h = mc_s;
    main_dialog[IDX_SLIDEX].w = md_sx - mc_s - 1;
    main_dialog[IDX_SLIDEX].h = mc_s-2;
    main_dialog[IDX_SLIDEY].w = mc_s-2;
    main_dialog[IDX_SLIDEY].h = md_sy - mc_s - 1;
    main_dialog[IDX_SLIDEX].fg = main_dialog[IDX_SLIDEY].fg = main_dialog[IDX_SCLICK].fg = g.syscolor1;
    main_dialog[IDX_SLIDEX].bg = main_dialog[IDX_SLIDEY].bg = main_dialog[IDX_SCLICK].bg = g.syscolor3;
    // ................................
    if(g.flag_alternate==FALSE){
    main_dialog[IDX_SLIDEX].x = md_x + mc_s;
    main_dialog[IDX_SLIDEX].y = md_y;
    main_dialog[IDX_SLIDEY].x = md_x;
    main_dialog[IDX_SLIDEY].y = md_y + mc_s;
    main_dialog[IDX_SCLICK].y = main_dialog[IDX_SLIDEX].y - 1;
    main_dialog[IDX_SCLICK].x = main_dialog[IDX_SLIDEY].x - 1;
    md_x = md_x + mc_s;
    md_y = md_y + mc_s;
    }else{
    main_dialog[IDX_SLIDEX].x = md_x;
    main_dialog[IDX_SLIDEX].y = md_y + md_sy - mc_s+1;
    main_dialog[IDX_SLIDEY].x = md_x + md_sx - mc_s+1;
    main_dialog[IDX_SLIDEY].y = md_y;
    main_dialog[IDX_SCLICK].y = md_y + md_sy - mc_s;
    main_dialog[IDX_SCLICK].x = md_x + md_sx - mc_s;
    }
    // ................................
/* MD2 */

/* MD */
    md_sx = md_sx - mc_s;
    md_sy = md_sy - mc_s;
    md_draw_outlines( );
    main_dialog[IDX_MAINMD].x = md_x;       /**** Fix clickable area ****/
    main_dialog[IDX_MAINMD].y = md_y;
    main_dialog[IDX_MAINMD].w = md_sx+0;
    main_dialog[IDX_MAINMD].h = md_sy+0;
    main_dialog[IDX_MAINMD].fg = 0;
    main_dialog[IDX_MAINMD].bg = 0;
    ScaledMD = create_bitmap( md_sx, md_sy );
    clear_bitmap( ScaledMD );
    main_dialog[IDX_MAINMD].dp = ScaledMD;
/* MD */
    return;
}




void md_draw_outlines( void )
{
    int x,y,sx,sy;

    if(g.flag_alternate==FALSE){
    x = md_x-mc_s-1;
    y = md_y-mc_s-1;
    sx = md_sx+mc_s+1;
    sy = md_sy+mc_s+1;
    rect( screen,x, y,x+sx, y+sy,g.syscolor1 );
    vline(screen,       md_x-1,          md_y,md_y+md_sy, g.syscolor1);
    hline(screen, x,    md_y-1                 ,x+sx, g.syscolor1);
    }else{
    x = md_x;
    y = md_y;
    sx = md_sx+mc_s;
    sy = md_sy+mc_s;
    rect( screen,x-1, y-1,x+sx, y+sy,g.syscolor1 );
    vline(screen, x+sx-mc_s,  md_y, md_y+md_sy, g.syscolor1);
    hline(screen, x,  md_y+md_sy , x+sx, g.syscolor1);
    }

//    if( g.flag_dialog_init == TRUE )
//        SEND_MESSAGE( main_dialog + IDX_MAINMD, MSG_DRAW, 0 );
}
void md_deinit( void )
{
    main_dialog[IDX_MAINMD].flags = D_DISABLED | D_HIDDEN;
    destroy_bitmap( ScaledMD );     /* screen sub-bitmap */
}






int b_md( int msg, DIALOG *d, int c )
{
    int     mx = mouse_x, my = mouse_y, mb = mouse_b;
    int     x1,y1,x2,y2;
    int     mux,muy, u,v, i, tmp_x,tmp_y;
    BITMAP  *tmp1 = NULL;

    if( msg==MSG_IDLE ){
        main_idle_function_callback();  /* located in main.c, main.h */
        return D_O_K;
    }
    if( msg==MSG_DRAW ) return D_O_K;

    switch ( msg ){

    case MSG_START:
        scare_mouse();
        display_zoomed_md();
        unscare_mouse();
        unscare_mouse();
        set_mousi_bitmap( MOUS_POINTER );
    break;

    case MSG_GOTMOUSE:
        set_mousi_bitmap( get_mousi_number() );
    break;

    case MSG_LOSTMOUSE:
        set_mousi_bitmap( MOUS_POINTER );
    break;

    case MSG_CHAR:
    return D_USED_CHAR;

    case MSG_KEY:

    if(key[KEY_S]){  // on press, take a snapshot of the screen and save into a file

    broadcast_dialog_message(MSG_DRAW, 0);

    get_desktop_resolution((int *)&tmp_x, (int *)&tmp_y);
    tmp1 = create_bitmap(tmp_x,tmp_y);  if( tmp1==NULL) error_("fant create bitmap. ec=100");
    blit( screen, tmp1, 0,0,0,0, tmp_x,tmp_y);
    save_bitmap("out.pcx", tmp1, g.palette);

//    save_bitmap("screen.pcx", screen, (RGB *)&g.palette);

    destroy_bitmap(tmp1);

    do{} while( key[KEY_S] );
    allegro_message("Saving screen capture in 'out.pcx'");
    return D_O_K;
    }


    x1 = d->x;
    y1 = d->y;
    x2 = x1+d->w;
    y2 = y1+d->h;
    if( mx > x1 && mx < x2 && my > y1 && my < y2 ){   // accept keyclick only if inside dialog
    if(!key[KEY_SPACE])     return D_O_K;
    if(key[KEY_SPACE]){
    scare_mouse();
    mux = mouse_x;
    muy = mouse_y;
    get_mouse_mickeys(&mx, &my); mx=my=0;

    do{
    get_mouse_mickeys(&mx, &my);
    g.ox += mx;
    g.oy += my;
    mb = mouse_b;
    if(mb&1){
        wait_for_mousebutton_release();
        vsync();
        g.zoom++;
    }
    if(mb&2){
        wait_for_mousebutton_release();
        vsync();
        if ( g.zoom != 0 ) g.zoom--;
    }
    if( g.ox< 0 )      g.ox = 0;
    if( g.ox >= g.sx ) g.ox = g.sx-1;
    if( g.oy< 0 )      g.oy = 0;
    if( g.oy >= g.sy ) g.oy = g.sy-1;
    display_zoomed_md();
//    position_mouse(mux, muy);   // testing
//    get_mouse_mickeys(&mx, &my);// testing




    } while( key[KEY_SPACE] );

    if( in_infostate==3 ) in_display();   // only call if relevant

    main_dialog[IDX_SLIDEX].d2 = g.ox;
    main_dialog[IDX_SLIDEY].d2 = main_dialog[IDX_SLIDEY].d1 - g.oy;
    main_dialog[IDX_SLIDEX].proc( MSG_DRAW, (DIALOG *)&main_dialog[IDX_SLIDEX],0 );
    main_dialog[IDX_SLIDEY].proc( MSG_DRAW, (DIALOG *)&main_dialog[IDX_SLIDEY],0 );
    position_mouse(mux, muy);
    unscare_mouse();
    mx=my=0;
    display_zoomed_md();
    }
    }
    return D_O_K;
    break;




// void position_mouse(int x, int y);




/*
    case MSG_DRAW:
    blit( d->dp, screen, 0,0,md_x,md_y, md_sx, md_sy );
    break;
*/

    case MSG_CLICK:
    if( d->x < mx   &&  mx <  ( d->x+d->w ) &&\
        d->y < my   &&  my <  ( d->y+d->h ) ){

/********************************/
/********************************/
/* All these methods are sticky */
/*                              */

    if( g.draw_method == MTD_PUTTEXT ){

        if( text.enabled == TRUE ){     // if text is enabled...
        x1 = text.x1;
        y1 = text.y1;
        x2 = text.x1 + text.sx;
        y2 = text.y1 + text.sy;
        i = mousecatch_coords_screen( (int *)&mx, (int *)&my, (int *)&u, (int *)&v );
        if (mb&1){// action: if nitial click is inside text rectangle, then
                  // keep movement button until released.
            if( x1 <= u && u <= x2 && y1 <= v && v <= y2 ){   // clicked inside rectangle
            puttext_on_md3();
            wait_for_mousebutton_release();
            }else{  // outside rectangle
        puttext_on_md();  // disable old first, then puttext again
        }
        }
        if (mb&4){} // middle button
        if (mb&2){ //right mouse button, action: place into bitmap
            puttext_on_md2();
            wait_for_mousebutton_release();
        }

        }else{  // text is disabled
        puttext_on_md();
        }
    }



    if( g.draw_method == MTD_PUTPIXEL || g.draw_method == MTD_SOLIDFILL ||\
        g.draw_method == MTD_PATFILL || g.draw_method == MTD_COLORPICK ||\
        g.draw_method == MTD_PUTPIXELCONT ){
        onestate_on_md( );
    }
    /* MTD_DEFSRCRECT  define source rectangle for copy */
    /* MTD_DEFDSTRECT  define destination rectangle for copy  */
    /* MTD_CHANGESRC   edit source clip rectangle */
    /* MTD_CHANGEDST   edit destination clip rectangle */
    if( g.draw_method == MTD_DRAWLINE   || g.draw_method == MTD_DRAWRECT ||\
        g.draw_method == MTD_DRAWELLIPS || g.draw_method == MTD_DRAWCIRCLE ||\
        g.draw_method == MTD_DEFSRCRECT || g.draw_method == MTD_DEFDSTRECT ||\
        g.draw_method == MTD_CHANGESRC  || g.draw_method == MTD_CHANGEDST ||
        g.draw_method == MTD_TAPER ){
        twostate_on_md( );
    }
    if( g.draw_method == MTD_DRAWTRIANGLE ){
        tristate_on_md2( );
        return D_O_K;
    }
    if( g.draw_method == MTD_DRAWPOLYLINE ){
        multistate_on_md( );
        return D_O_K;
    }


/*                              */
/* All these methods are sticky */
/********************************/
/********************************/
    scare_mouse( );
    refresh_screen_quick();
    unscare_mouse( );
    }
    break;
    default:
    break;
    }
    return D_O_K;
}










/* Put text where user clicks */
void    puttext_on_md()
{
    BITMAP *pspr1=NULL;
    int     px, py;            /* binary coordinates */
    int     draw_color;
    int     mb;
    unsigned char *string = NULL;

    mb = mouse_b;

    mousecatch_coords_screen( NULL,NULL, (int *)&px, (int *)&py );

    if( ((mb)&1) ){

    draw_color = 0;
    if (mb&1){ draw_color = g.usercolor1; }
    if (mb&4){ draw_color = g.usercolor2; }
    if (mb&2){ draw_color = g.usercolor3; }
    wait_for_mousebutton_release();
    string = dlg_request_string(NULL, 128 );
    wait_for_mousebutton_release();    if( string==NULL ) return;  // cancel was pressed
    pspr1 = ll_get_sprite( g.block_current );


    if( text.enabled == TRUE ){ // if text is already enabled, disable first
    if( text.map != NULL ) destroy_bitmap( text.map );
    if( text.string != NULL ) free( text.string );
    text.enabled = FALSE;
    }

    text.enabled = TRUE;  // enabled
    text.x1 = px;
    text.y1 = py;
    text.block = g.block_current;
    text.string = string;
//....
    write_into_text( );
//....


    }


//    else{  // other mousebutton click
//    }
}



//....
void write_into_text()
{
    int draw_color = g.usercolor1;

    if( text.enabled == FALSE ) return;
    text.fnt = fnt8;        // fnt 8,7,6,5,4,...
    text.sx = fnt_text_length(text.fnt, text.string);
    text.sy = fnt_text_height(text.fnt);
    if( text.map!=NULL ) destroy_bitmap( text.map );
    text.map = create_bitmap_clear( text.sx,text.sy );
    if( text.map == NULL ){
        text.enabled = FALSE;
        free_string( text.string );
        return;
    }
    if( text.fnt != NULL )
        fnt_textout( text.map, text.fnt, text.string,  0,  0, draw_color, -1, 0 );
}
//....










// put text onto bitmap
void    puttext_on_md2()
{
    BITMAP *pspr1=NULL;

    if( text.enabled == FALSE ) return;
    if( g.block_current != text.block ) return;
    pspr1 = ll_get_sprite( text.block );
    masked_blit( text.map, pspr1, 0,0, text.x1, text.y1, text.sx, text.sy );
    if( text.map != NULL ) destroy_bitmap( text.map );
    if( text.string != NULL ) free( text.string );
    text.enabled = FALSE;
}


// keep moving and tracking text object until user releases mouse button
void    puttext_on_md3()
{
    int dx,dy,mx=0,my=0,ox=0,oy=0,u,v, moved,j;
    int ix,iy;

    if( text.block != g.block_current ) return;
    mousecatch_coords_screen( (int *)&mx, (int *)&my, (int *)&u, (int *)&v );
    ix = u - text.x1;
    iy = v - text.y1;
    do{         // LOOP while mouse button is pressed
    moved = 1;
    mousecatch_coords_screen( (int *)&mx, (int *)&my, (int *)&u, (int *)&v );
    dx = mx - ox;
    dy = my - oy;
    if( dx==0 && dy==0 ) moved=0; // make sure to update screen only when user moves mouse
    if( moved==1 ){     //      MOVED
    text.x1 = u-ix;
    text.y1 = v-iy;
    display_zoomed_md();    // redraw md
    moved = 0;
    ox = mx;
    oy = my;
    }
    j=mouse_b;
    } while( ( j&7 ) !=0 ); /* while mouse is pressed... */
}

















/*  ONE STATE MOUSE CLICKS  */
/* input: mouse x, mouse y, mouse buttons    */
static void onestate_on_md()
{
    BITMAP *pspr1=NULL;
    char    sticky=0;
    int     i, j, ret1, c1=0,c2=0, drw_mode=0;
    int     px, py;            /* binary coordinates */
    int     opx,opy;           /* old px,py          */
    int     x1,y1,x2,y2;       /* screen coordinates */
    int     draw_color;
    int     mx,my,mb;
    int     ox,oy,dx,dy,moved=0;
    char    sline[80];


    mousecatch_coords_screen( (int *)&mx, (int *)&my, (int *)&px, (int *)&py );
    ox = -1;
    oy = -1;
    opx = px;
    opy = py;
    draw_color = 0;

    //----------------------------------------------------------------------
    do{

    moved = 0;
    ret1 = mousecatch_coords_screen( (int *)&mx, (int *)&my,  (int *)&px, (int *)&py );
    dx = mx;
    dy = my;
    dx -= ox;    if( dx != 0 ){ ox = mx; moved = 1; }
    dy -= oy;    if( dy != 0 ){ oy = my; moved = 1; }
    if( dx==0 && dy==0 ) moved=0; else moved=1; // make sure to update screen only when user moves mouse



if( moved==1 ){


    sprintf((char *)&sline,"x:%d y:%d",px,py );
    printout_infoblock( (char *)&sline );

    x1 = mx;
    y1 = my;
    x2 = mx + g.zoom;
    y2 = my + g.zoom;

    if( g.flag_pixelgrid==TRUE && g.zoom >= 1 ){        x2--; y2--;    }
    if( x1==1 && g.flag_pixelgrid==FALSE ) x1 = 0;
    if( y1==1 && g.flag_pixelgrid==FALSE ) y1 = 0;
    if( x2 > ( md_sx-1 ) ){ x2 = md_sx-1; if( g.flag_pixelgrid==TRUE ) x2++; }
    if( y2 > ( md_sy-1 ) ){ y2 = md_sy-1; if( g.flag_pixelgrid==TRUE ) y2++; }

    mb = mouse_b;    if (mb&1){ draw_color = g.usercolor1; }
    mb = mouse_b;    if (mb&4){ draw_color = g.usercolor2; }
    mb = mouse_b;    if (mb&2){ draw_color = g.usercolor3; }

    // only perform methods if mouse is inside the graphic block

    if ( px < g.sx && py < g.sy && ret1 == TRUE && moved==1 ){

    // ...non-tracking method
    /**************************************************/
    /***                                            ***/
    /***   Method: color picker                     ***/
    /***                                            ***/
    if( g.draw_method == MTD_COLORPICK ){
        pspr1 = ll_get_sprite( g.block_current );
        i = getpixel( pspr1, px, py );
        update_pl( 0 );                         // undraw color boxes
        if (mb&1) {g.usercolor1 = i;
            g.usrcol1.r = getr(i);
            g.usrcol1.g = getg(i);
            g.usrcol1.b = getb(i);
            }
        if (mb&4) {g.usercolor2 = i;
            g.usrcol2.r = getr(i);
            g.usrcol2.g = getg(i);
            g.usrcol2.b = getb(i);
            }
        if (mb&2) {g.usercolor3 = i;
            g.usrcol3.r = getr(i);
            g.usrcol3.g = getg(i);
            g.usrcol3.b = getb(i);
            }
        update_pl( 1 );                         //   draw color boxes
        return;
    }
    /***                                            ***/
    /***                                            ***/
    /**************************************************/







CLOOP1
    pspr1 = ll_get_sprite( g.block_current );

    // ...tracking methods

    /**************************************************/
    /***                                            ***/
    /***   Method: putpixel                         ***/
    /***                                            ***/
    if( g.draw_method == MTD_PUTPIXEL ){
        if( g.flag_brush == FALSE )
            putpixel (       pspr1, px, py, draw_color );
        else
            put_blockbrush ( pspr1, px, py, draw_color );
    }
    /***                                            ***/
    /***                                            ***/
    /**************************************************/


    /**************************************************/
    /***                                            ***/
    /***   Method: putpixel continued               ***/
    /***                                            ***/
    if( g.draw_method == MTD_PUTPIXELCONT ){
        if( opx==px && opy==py ){
            if( g.flag_brush==FALSE )
                putpixel(       pspr1, px, py, draw_color );
            if( g.flag_brush==TRUE )
                put_blockbrush( pspr1, px, py, draw_color );
        }else{
            if( g.flag_brush==FALSE )
                line(    pspr1, px, py, opx, opy, draw_color );
            if( g.flag_brush==TRUE )
                do_line( pspr1, px, py, opx, opy, draw_color, put_blockbrush );
        }
    }
    /***                                            ***/
    /***                                            ***/
    /**************************************************/


    /**************************************************/
    /***                                            ***/
    /***   Method: SolidFill                        ***/
    /***                                            ***/
    if( g.draw_method == MTD_SOLIDFILL )
        floodfill( pspr1, px, py, draw_color );
    /***                                            ***/
    /***                                            ***/
    /**************************************************/


    /**************************************************/
    /***                                            ***/
    /***   Method: PatternedFill                    ***/
    /***                                            ***/
    if( g.draw_method == MTD_PATFILL ){
        /*     L R M  1 2 4        */
        j=mb; j &= 7;  /* dual mousebutton press are "stickier" */
        if( j==0 ){c1=0; c2=0;}
        if( j==1&&sticky==0 ){c1=g.usercolor1; c2=0;     }/* Left   */
        if( j==2&&sticky==0 ){c1=g.usercolor3; c2=0;     }/* Right  */
        if( j==4&&sticky==0 ){c1=g.usercolor2; c2=0;     }/* Middle */
        if( j==3 ){c1=g.usercolor1; c2=g.usercolor3;sticky=1;}/* L+R    */
        if( j==5 ){c1=g.usercolor1; c2=g.usercolor2;sticky=1;}/* L+M    */
        if( j==6 ){c1=g.usercolor2; c2=g.usercolor3;sticky=1;}/* R+M    */
        if( j==7 ){c1=0; c2=0; sticky=0;}         /* L+R+M  */

        //............................................................



       if(g.bpp == 8 ){
       blit( fillstruct.bmp8x8, fillstruct.bmp8x8tmp,  0,0,0,0,8,8 );
       remap_bitmap( fillstruct.bmp8x8tmp, 255, c1 );
       remap_bitmap( fillstruct.bmp8x8tmp,   0, c2 );
       }else{
       // TEST
       remap_bitmap2( fillstruct.bmp8x8,fillstruct.bmp8x8tmp, 255, c1 );
       remap_bitmap( fillstruct.bmp8x8tmp,   0, c2 );
//       remap_bitmap2( fillstruct.bmp8x8,fillstruct.bmp8x8tmp, 0,   c2 );
       }


        /* 0=normal, 1=mask, 2=xor */
        if( fillstruct.operation==0 )   drw_mode = DRAW_MODE_COPY_PATTERN;
        if( fillstruct.operation==1 )   drw_mode = DRAW_MODE_MASKED_PATTERN;
        if( fillstruct.operation==2 )   drw_mode = DRAW_MODE_SOLID_PATTERN;



        if(fillstruct.class==0){    // use 8x8 standard fills
            drawing_mode( drw_mode, fillstruct.bmp8x8tmp, 0, 0 );

        }
        if(fillstruct.class==1){    // fill from source(SRC) rectangle
            if( fillstruct.bmpfree != NULL ){
                drawing_mode( drw_mode, fillstruct.bmpfree, 0, 0 );
            }

        }
        floodfill( pspr1, px, py, c1 );
        drawing_mode( DRAW_MODE_SOLID, NULL,0,0 );
    }
    /***                                            ***/
    /***                                            ***/
    /**************************************************/


CLOOP2


    // ------------------ display on screen section ----------------
    if( g.draw_method == MTD_PUTPIXEL ){
        if( g.flag_brush == TRUE ){
            display_zoomed_md();
        }else{
            scare_mouse( );
            if ( g.zoom == 0 )      // unzoomed
                putpixel( screen, x1+md_x, y1+md_y, draw_color );
            else                    // zoomed
                rectfill( screen, x1+md_x, y1+md_y, x2+md_x, y2+md_y, draw_color );
            unscare_mouse( );
        }
    }
    if( g.draw_method == MTD_PUTPIXELCONT ) display_zoomed_md();
    if( g.draw_method == MTD_PATFILL )      display_zoomed_md();
    if( g.draw_method == MTD_SOLIDFILL )    display_zoomed_md();
    // ------------------ display on screen section ----------------

    }    // only perform methods if mouse is inside the graphic block

//moved=0;
}   // if moved == 1 ...


    opx = px;
    opy = py;

    j=mouse_b;
    } while( ( j&7 ) != 0 );   /* while mouse button is pressed */
    //----------------------------------------------------------------------


    clear_infoblock();
}










static void copyfillmap_from8_to24_( BITMAP *input, BITMAP *output )
{
/*
    int     x,y,i,j,k;


    if( output != NULL ){
        destroy_bitmap(output);
        output = create_bitmap(8,8);
    }

    for(y=0;y<8;y++){
    for(x=0;x<8;x++){

    i = getpixel( input, x,y );
    if(i)
        putpixel( output,x,y, g.usercolor1 );
    else
        putpixel( output,x,y, 0 );
    }}
*/
}





















/*
 *  TWO STATE MOUSE CLICKS:  CLICK,  DRAW-WHILE-CLICKED
 * First state begins when user presses mouse button
 * During first state, the user can move the mouse to change shape of objects
 * Second state begins when user releases mouse button
 */
static void twostate_on_md( )
{
    BITMAP *pspr1=NULL;
    int     quad=0, i,j;
    int    ex1,ey1;
    int  ax1, ay1, ax2, ay2;               /* zooomed set */
    int   x1, y1,  x2,  y2, sx, sy;        /* pixel set   */
    int  lx1, ly1, lx2, ly2, lsx, lsy;     /* limited set */
    int  ix1, iy1, ix2, iy2          ;     /* unlimited   */
    int   mx,my,mb;
    int   ox, oy;
    int   dx, dy, moved, zoom;
    int   draw_color = 0;
    int   u=0,v=0;
    int   v_x1, v_y1, v_x2, v_y2;
    int   w_x1, w_y1, w_x2, w_y2;
    int   posx, posy;

    zoom = g.zoom;
    posx=mx = mouse_x;    posy=my = mouse_y;    mb = mouse_b;
    if (mb&1){ draw_color = g.usercolor1; }
    if (mb&4){ draw_color = g.usercolor2; }
    if (mb&2){ draw_color = g.usercolor3; }

    mousecatch_coords_screen( (int *)&mx, (int *)&my, (int *)&u, (int *)&v );
    ax1 = ax2 = ox = mx;    // 1st anchor
    ay1 = ay2 = oy = my;
    sx=sy=x1=x2=y1=y2=1;
    // ---------------------------------
    //  u,v    = binary coordinates
    // mx,my   = chopped screen coordinates ( aligned to pixels )
    // ax1,ay1 = anchor of type (x1,y1) catches the chopped screen coordinates
    //

    /******************************************/
    /* check if the click is in allowed range */
    /*                                        */
    if ( g.draw_method==MTD_CHANGESRC || g.draw_method==MTD_CHANGEDST ){
    if ( clips.flag==FALSE && clipd.flag==FALSE ) return;

        // changes the area selected

        validate_clip_block( (EXA_CLIP *)&clips, u,v,mx,my, (int *)&ax1, (int *)&ay1 );
        validate_clip_block( (EXA_CLIP *)&clipd, u,v,mx,my, (int *)&ax1, (int *)&ay1 );
        // if no handle is selected, return.
        if ( clips.areaselected==0 && clipd.areaselected==0 ) return;
    }
    /*                                        */
    /* check if the click is in allowed range */
    /******************************************/



    if( g.draw_method==MTD_TAPER  )
        get_rect_bmp( 0, 0, md_sx, md_sy );  // GETSCREEN FULL
    else
        get_rect_bmp( x1, y1, sx, sy );     // GETSCREEN (first)








    do{         // LOOP while mouse button is pressed
    moved = 1;

    mousecatch_coords_screen( (int *)&mx, (int *)&my, NULL, NULL );
    dx = mx - ox;
    dy = my - oy;
    if( dx==0 && dy==0 ) moved=0; // make sure to update screen only when user moves mouse

    // ----------------------------------------------------------------- //
    //                               MOVED



//    debug_display( 250,255, 10,80, "dx: %d, dy: %d",    dx,dy  );




    if( moved==1 ){
    moved=0;    //testing...

    if( g.draw_method==MTD_DRAWCIRCLE || g.draw_method==MTD_DRAWELLIPS ){    // uses quadrant (drawing from center)
        if( quad==1 )
          set_rect_bmp( x1, y1, sx*2, sy*2 );     // PUTSCREEN
        if( quad==2 )
          set_rect_bmp( x1-sx, y1, sx*2, sy*2 );     // PUTSCREEN
        if( quad==3 )
          set_rect_bmp( x1-sx, y1-sy, sx*2, sy*2 );     // PUTSCREEN
        if( quad==4 )
          set_rect_bmp( x1, y1-sy, sx*2, sy*2 );     // PUTSCREEN
    }else{
        if( g.draw_method==MTD_TAPER  )
            set_rect_bmp( 0, 0, md_sx, md_sy );     // PUTSCREEN FULL
        else
            set_rect_bmp( x1, y1, sx, sy );     // PUTSCREEN
    }







//testing...
//    mousecatch_coords_screen( (int *)&mx, (int *)&my, NULL, NULL );

    ax2 = ox = mx;    // 2nd anchor
    ay2 = oy = my;

    // determine which quadrant from anchors
    //     -----------
    //     | 1  |  2 |
    //     |----|----|
    //     | 4  |  3 |
    //     -----------
    //
    i = (ax1-ax2);
    j = (ay1-ay2);
    if( i>0 && j>0) quad = 1;
    if( i<0 && j>0) quad = 2;
    if( i<0 && j<0) quad = 3;
    if( i>0 && j<0) quad = 4;
    //...
    x1 = lx1 = min ( ax1, ax2 );
    x2 = lx2 = max ( ax1, ax2 );
    y1 = ly1 = min ( ay1, ay2 );
    y2 = ly2 = max ( ay1, ay2 );
    sx = x2 - x1;
    sy = y2 - y1;

    if( g.draw_method==MTD_DRAWCIRCLE || g.draw_method==MTD_DRAWELLIPS ){    // uses quadrant (drawing from center)
        if( quad==1 )
            get_rect_bmp( x1, y1, sx*2, sy*2 );  // GETSCREEN
        if( quad==2 )
            get_rect_bmp( x1-sx, y1, sx*2, sy*2 );  // GETSCREEN
        if( quad==3 )
            get_rect_bmp( x1-sx, y1-sy, sx*2, sy*2 );  // GETSCREEN
        if( quad==4 )
            get_rect_bmp( x1, y1-sy, sx*2, sy*2 );  // GETSCREEN
    }else{
        if( g.draw_method==MTD_TAPER  )
            get_rect_bmp( 0, 0, md_sx, md_sy );  // GETSCREEN FULL
        else
            get_rect_bmp( x1, y1, sx, sy );      // GETSCREEN
    }



    // -------------------------------------- //
    //             WITHIN RANGE




//    debug_display( 250,255, 10,110, " sx: %d, sy: %d g.zoom %d", sx, sy, g.zoom );



    if( sx > g.zoom || sy > g.zoom ){

    coord_limit_screen ( (int *)&lx1, (int *)&ly1, (int *)&lx2, (int *)&ly2 );
    lsx = lx2 - lx1;
    lsy = ly2 - ly1;
    // coordinates are screen coordinates
    // sorted coordinates
    v_x1 = lx1;
    v_y1 = ly1;
    v_x2 = lx2 + g.zoom - 1;
    v_y2 = ly2 + g.zoom - 1;
    // unsorted coordinates
    w_x1 = ax1 ;
    w_y1 = ay1 ;
    w_x2 = ax2 ;
    w_y2 = ay2 ;
    scare_mouse();

    if( g.flag_cad==TRUE )  clb_cad   ( v_x1,v_y1,v_x2,v_y2 );
    //...
    coord_screen2bin2( w_x1, w_y1, (int *)&ex1, (int *)&ey1 );
    coord_bin2screen( ex1,  ey1,  (int *)&ex1, (int *)&ey1 );

    if(g.zoom>1){
        ex1  += (g.zoom/2);
        ey1  += (g.zoom/2);
        w_x2 += (g.zoom/2);
        w_y2 += (g.zoom/2);
    }
    //...

    if( g.draw_method==MTD_DRAWLINE ){
        clb_line  ( ex1, ey1, w_x2, w_y2 );


//    debug_display( 250,255, 10,99, "x1: %d, y1: %d, x2: %d, y2: %d", ex1, ey1, w_x2, w_y2 );

    }



    if( g.draw_method==MTD_DRAWELLIPS ) clb_ellips( ax1,ay1,ax2,ay2 );
    if( g.draw_method==MTD_DRAWCIRCLE ) clb_circle( ax1,ay1,ax2,ay2 );
    if( g.draw_method==MTD_TAPER      ) clb_circle2( ex1, ey1, w_x2, w_y2 );
    if( g.draw_method==MTD_DRAWRECT ||
        g.draw_method==MTD_DEFSRCRECT ||
        g.draw_method==MTD_DEFDSTRECT ||
        g.draw_method==MTD_CHANGESRC ||
        g.draw_method==MTD_CHANGEDST )   clb_rect  ( v_x1,v_y1,v_x2,v_y2 );
    unscare_mouse();

    }//             WITHIN RANGE
    // -------------------------------------- //
    }//                               MOVED
    // ----------------------------------------------------------------- //
    j=mouse_b;
    } while( ( j&7 ) !=0 ); /* while mouse is pressed... */
    clear_infoblock();






    /**************************************/
    /**************************************/
    /******                          ******/
    /****** mouse has been unclicked ******/
    coord_screen2bin2( ax1, ay1,  (int *)&x1, (int *)&y1 );
    coord_screen2bin2( ax2, ay2,  (int *)&x2, (int *)&y2 );
    //
    // all coordinates are binary coordinates
    //
    ix1 = min ( x1, x2 );
    iy1 = min ( y1, y2 );
    ix2 = max ( x1, x2 );
    iy2 = max ( y1, y2 );
    // sorted and uncutted coordinates
    w_x1 = ix1;
    w_y1 = iy1;
    w_x2 = ix2;
    w_y2 = iy2;
    if( g.draw_method == MTD_CHANGESRC){
        bin_clb_change_clip  ((EXA_CLIP *)&clips, w_x1, w_y1, w_x2, w_y2, 0 );    return;}
    if( g.draw_method == MTD_CHANGEDST){
        bin_clb_change_clip  ((EXA_CLIP *)&clipd, w_x1, w_y1, w_x2, w_y2, 0 );    return;}
    if( g.draw_method == MTD_DEFSRCRECT){
        bin_clb_def_clip((EXA_CLIP *)&clips, w_x1, w_y1, w_x2, w_y2, 0 );   return;}
    if( g.draw_method == MTD_DEFDSTRECT){
        bin_clb_def_clip((EXA_CLIP *)&clipd, w_x1, w_y1, w_x2, w_y2, 0 );   return;}

/** **** APPLY METHOD NOW, ON PIXEL BUFFER **** **/
/**                                             **/
CLOOP1
    pspr1 = ll_get_sprite( g.block_current );
    if( g.draw_method == MTD_DRAWLINE )
        bin_clb_drawline   (pspr1,  x1,   y1,   x2,   y2, draw_color );
    if( g.draw_method == MTD_DRAWRECT)
        bin_clb_drawrect   (pspr1,w_x1, w_y1, w_x2, w_y2, draw_color );
    if( g.draw_method == MTD_DRAWELLIPS){   position_mouse(posx, posy);
        bin_clb_drawellips (pspr1,  x1,   y1,   x2,   y2, draw_color );}
    if( g.draw_method == MTD_DRAWCIRCLE){   position_mouse(posx, posy);
        bin_clb_drawcircle (pspr1,  x1,   y1,   x2,   y2, draw_color );}
CLOOP2
/**                                             **/
/** **** APPLY METHOD NOW, ON PIXEL BUFFER **** **/

    printout_infoblock( " " );
    return;
}





/* MULTIPLE STATE MOUSE CLICKS:  CLICK, CLICK, ...       */
/* First state begins when user presses mouse button     */
/* State change occurs when user presses mouse again     */
/* states are ended when mouse is outside window         */
static void multistate_on_md()
{
    BITMAP *pspr1=NULL;
    int   x0,  y0,  x1,  y1,  x2,  y2, sx0, sy0, sx, sy ;
    int            ax1, ay1, ax2, ay2;
    int            ix1, iy1, ix2, iy2;
    int     ox,  oy;
    int     dx,  dy, zoom;
    int     draw_color=0;
    int     i, j;
    char    clickstate;    /* states for triangle */
    int     mx,my,mb;


    mb = mouse_b;

    mousecatch_coords_screen( (int *)&mx, (int *)&my, NULL, NULL );
    ox = ax1 = ax2 = mx;    //     1st anchor
    oy = ay1 = ay2 = my;
    clickstate = 0;
    zoom = g.zoom;
    if (mb&1){ draw_color = g.usercolor1; }
    if (mb&4){ draw_color = g.usercolor2; }
    if (mb&2){ draw_color = g.usercolor3; }


rebegin2:
    x1=y1=0;
    sx=sy=x2=y2=sx0=sy0=x0=y0=1;

    /* GETSCREEN  */
    get_rect_bmp( x1, y1, sx, sy );

    do j=mouse_b; while( ( j&7 )!=0 );  /* wait until user releases mouse button*/

    for( ;; ){                  /* forever loop */

//    mx=mouse_x;   my=mouse_y;

    i = mousecatch_coords_screen( (int *)&mx, (int *)&my, NULL, NULL );
    dx = mx;
    dy = my;
    dx -= ox;    if(dx!=0) ox = mx;
    dy -= oy;    if(dy!=0) oy = my;
//    i = mousecatch_coords_screen( (int *)&mx, (int *)&my, NULL, NULL );
//    i = coord_mouse2screen( mx, my, (int *)&mx, (int *)&my );
//    coord_screen2bin2( mx,my, (int *)&mx, (int *)&my);
//    coord_bin2screen( mx,my, (int *)&mx, (int *)&my);

    if(  dx!=0 || dy!=0 ){         /*************  MOUSE MOVED  **************/
    set_rect_bmp( x1, y1, sx, sy ); // PUTSCREEN
    if(i==FALSE) return;        // if mouse is outside MD...return
    ax2 = mx;    // 2nd anchor
    ay2 = my;

    x1 = min ( ax1, ax2 );
    x2 = max ( ax1, ax2 );
    y1 = min ( ay1, ay2 );
    y2 = max ( ay1, ay2 );
    sx = x2 - x1 ;
    sy = y2 - y1 ;

    get_rect_bmp( x1, y1, sx, sy );
    /* GETSCREEN */


/** **** APPLY METHOD ON ZOOMED SCREEN **** **/
/**                                              **/
    scare_mouse();

    /* the "cad" look */
    if( g.flag_cad==TRUE ){
    x1--;y1--;x2--;y2--;
    rect( screen,  md_x + x1, md_y + y1, md_x + x2+g.zoom, md_y + y2+g.zoom,  g.syscolor2 );
    vline( screen,
            md_x + x1 + sx/2 + g.zoom,
            md_y + y1,
            md_y + y2 + g.zoom,
            g.syscolor2 );

    hline( screen,
            md_x + x1,
            md_y + y1 + sy/2 + g.zoom,
            md_x + x2 + g.zoom,
            g.syscolor2 );

    x1++;y1++;x2++;y2++;
    }
    /* the "cad" look */

    /* multiline */
    if( g.draw_method==MTD_DRAWPOLYLINE ){
        line( screen,
            md_x + ax1+g.zoom/2,  md_y + ay1+g.zoom/2,
            md_x + ax2+g.zoom/2,  md_y + ay2+g.zoom/2,
        g.syscolor2 );
        draw_infoblock( md_x + ax1+g.zoom/2,  md_y + ay1+g.zoom/2, md_x + ax2+g.zoom/2,  md_y + ay2+g.zoom/2 );
        }
    unscare_mouse();
/**                                         **/
/** **** APPLY METHOD ON ZOOMED SCREEN **** **/

    }    /* MOVED */





    mb = j = mouse_b;

    if( ( j&7 )!=0 ){       /* ON CLICK ... */

    if (mb&1){ draw_color = g.usercolor1; }
    if (mb&4){ draw_color = g.usercolor2; }
    if (mb&2){ draw_color = g.usercolor3; }

// allegro_message("draw_color: %d", draw_color);

    set_rect_bmp( x1, y1, sx, sy ); // PUTSCREEN

    coord_screen2bin2( ax1, ay1, ( int * )&ix1, ( int * )&iy1 );
    coord_screen2bin2( ax2, ay2, ( int * )&ix2, ( int * )&iy2 );

/** **** APPLY METHOD NOW, ON PIXEL BUFFER **** **/
/**                                             **/
CLOOP1
    pspr1 = ll_get_sprite( g.block_current );
    /* multiline */
    if( g.draw_method==MTD_DRAWPOLYLINE ){
        if( g.flag_brush == TRUE ){
        do_line ( pspr1, ix1,iy1,ix2,iy2, draw_color, put_blockbrush );
        }else{
           line ( pspr1, ix1,iy1,ix2,iy2, draw_color );
        }
    }
CLOOP2
/**                                             **/
/** **** APPLY METHOD NOW, ON PIXEL BUFFER **** **/
    scare_mouse( );
    refresh_screen_quick();
    unscare_mouse( );
    ax1 = ax2;     // 1st anchor = 2nd anchor
    ay1 = ay2;
    if (mb&1){ draw_color = g.usercolor1; }
    if (mb&4){ draw_color = g.usercolor2; }
    if (mb&2){ draw_color = g.usercolor3; }

    goto rebegin2;
    }    /* when mouse is pressed */
    }    /* forever loop */
}
















   


/* put bitmap block on graphic method
 * used to implement the brush functions
 * d = draw color
 */
void put_blockbrush( BITMAP *bmp, int x, int y, int d )
{
    int size;
    int x1,y1,x2,y2,sx,sy,rx=0,ry=0;

    if( g.flag_brush==FALSE ) return;
    if( bmp==NULL ) return;
    size = g.brush.size;
    if( g.brush.type==2 && g.brush.bmp!=NULL ){     /* bitmap */
        x1 = x - g.brush.sx/2;
        y1 = y - g.brush.sy/2;
        x2 = x + g.brush.sx/2;
        y2 = y + g.brush.sy/2;
        rx = ry = 0;
        if(x1<0){ rx = -x1; x1=0; }
        if(y1<0){ ry = -y1; y1=0; }
        sx = x2 - x1;
        sy = y2 - y1;
        masked_blit( g.brush.bmp, bmp,rx,ry,x1,y1, sx, sy );
        return;
        }
    if( size>1){
        if(g.brush.type==0){                /* square */
            x1 = x - size/2;
            y1 = y - size/2;
            x2 = x + size/2;
            y2 = y + size/2;
            if(x1<0) x1=0;
            if(y1<0) y1=0;
            rectfill(bmp,x1,y1,x2,y2, d );
            }
        if(g.brush.type==1)                 /* circle */
            circlefill(bmp,x,y,size/2, d );
    }else{
        putpixel( bmp,x,y,d );
    }
}



















    /* Determine which area of clip rectangle are pressed

       Areaselected Handles:
                 8
              1  ?  4
              #--#--#
              |:::::|
            7?#::?::#?5
              |:::::|
              #--#--#
              3  ?  2
                 6
      input:
        u,v     = binary coordinates
        mx,my   = Mouse coordinates
        ax1,ay1 = anchor x,y ( changed, on area selected )
      output:
        Returns     FALSE on nothing selected.
        Returns     TRUE if clicked on anchor
     */
static int validate_clip_block( EXA_CLIP *clip, int u, int v, int mx,int my,int *ax1,int *ay1 )
{
    int   vx1,vy1,vx2,vy2;        // virtual screen coords
    int   aax=0, aay=0, retval;
//    int   lsx,lsy;

    retval = FALSE;
    aax = *ax1;
    aay = *ay1;
    clip->areaselected = 0;       // no area selected yet

    // validation rule
    if( clip->block == g.block_current && clip->flag == TRUE &&
        u >= clip->x1 && v >= clip->y1 && u <= clip->x2 && v <= clip->y2 )
    {
        coord_bin2screen(  clip->x1, clip->y1, (int *)&vx1, (int *)&vy1 );
        coord_bin2screen(  clip->x2, clip->y2, (int *)&vx2, (int *)&vy2 );


    // left top handle
        if( mx >= vx1          && my >= vy1          &&
            mx <= ( vx1+g.hs ) && my <= ( vy1+g.hs ) ){
            coord_bin2screen( clip->x2, clip->y2,  (int *)&aax, (int *)&aay );
            clip->areaselected = 1;
            retval = TRUE;
    }   /* up left 25% */

    // right down handle
        if( mx >= ( vx2 - g.hs ) && my >= ( vy2 - g.hs ) &&
            mx <= vx2            && my <= vy2 ){
            coord_bin2screen( clip->x1, clip->y1,  (int *)&aax, (int *)&aay );
            clip->areaselected = 2;
            retval = TRUE;
    }   /* down right 25% */

    // left down handle
        if( mx <= ( vx1 + g.hs ) && my >= ( vy2 - g.hs ) &&
            mx >= vx1            && my <= vy2 ){
            coord_bin2screen( clip->x2, clip->y1,  (int *)&aax, (int *)&aay );
            clip->areaselected = 3;
            retval = TRUE;
    }   /* down left 25% */

    // right top handle
        if( mx <= vx2          && my >= vy1 &&
            mx >= ( vx2-g.hs ) && my <= ( vy1+g.hs ) ){
            coord_bin2screen( clip->x1, clip->y2,  (int *)&aax, (int *)&aay );
            clip->areaselected = 4;
            retval = TRUE;
    }   /* up right 25% */

/*
//...............
lsx = (vx2 -vx1)/2 - g.hs*2;
lsy = (vy2 -vy1)/2 - g.hs*2;

    // right middle handle
        if( mx >= ( vx2 - g.hs ) && my > ( vy1 + g.hs + lsy ) &&
            mx <= vx2            && my < ( vy2 - g.hs - lsy ) ){
            coord_bin2screen( clip->x1, clip->y2,  (int *)&aax, (int *)&aay );
            clip->areaselected = 5;
            retval = TRUE;
    }   // middle right
//...............

    // right down handle
        if( mx >= vx1 + g.hs  && my >= ( vy2 - g.hs ) &&
            mx <= vx2 - g.hs  && my <= vy2 ){
            coord_bin2screen( clip->x1, clip->y1,  (int *)&aax, (int *)&aay );
            clip->areaselected = 6;
            retval = TRUE;
    }   // down right
*/

//    textprintf(screen, font, 10,10, makecol(220,180,0),"*%d*", clip->areaselected );



    }   // validated!


    *ax1 = aax;
    *ay1 = aay;
    return  retval;
}













/*
 * Returns:  chopped screen coordinates ( aligned to pixels )
 * returned values in:
 *      mo_x, mo_y   = screen coordinates  x,y
 *      bn_x, bn_y   = binary coordinates  x,y
 * return value = FALSE if outside drawing area, else value is TRUE
 */
int mousecatch_coords_screen( int *mo_x, int *mo_y, int *bn_x, int *bn_y )
{
    int mox,moy,zu,zv,i;

    mox = mouse_x;   moy = mouse_y;
    i = coord_mouse2screen( mox, moy, (int *)&mox, (int *)&moy );
    coord_screen2bin2(  mox, moy, (int *)&mox, (int *)&moy );
    coord_bin2screen(  mox, moy, (int *)&mox, (int *)&moy );
    //...
    coord_screen2bin2(  mox, moy, (int *)&zu, (int *)&zv );
    if( mo_x != NULL ) *mo_x = mox;
    if( mo_y != NULL ) *mo_y = moy;
    if( bn_x != NULL ) *bn_x = zu;
    if( bn_y != NULL ) *bn_y = zv;
    return i;
}








