#ifndef _DXELOD__H
#define _DXELOD__H

// #include <dlfcn.h>
#include "dllbtn/mtds.h"
#include "types.h"
#include "global.h"

// structure for linked list of DXE loaded in memory
typedef struct LODUSERDATA
{
    byte    *dxefilename;   // allocated string
    int     status;         // 0 = unloaded, 1 = ok, 2 = error ocurred w/ dxe
    byte    error[183];      // copied from dlerror(), reason for failure.
    void    (*dxe_init)(void);
    void    (*dxe_deinit)(void);
    int     (*dxe_method)(BITMAP *,int,int,int,int);
    MTDS    *mtds;          // dxe module data
}LODUSERDATA;


void lod_initsys();
void lod_rewind();
void lod_store(
    byte    *dxefilename,
    void    (*init)(void),
    void    (*deinit)(void),
    int     (*method)(BITMAP *,int,int,int,int),
    MTDS    *mtds,
    char    *errstr);
void lod_next();
int  lod_sort_criteria1();// first sort criteria is mtds->class
int  lod_sort_criteria2();// second sort criteria is mtds->type

void lod_set_error( byte *error );
MTDS *lod_get_mtds();
void *lod_get_init();
void *lod_get_deinit();
void *lod_get_method();
LODUSERDATA *lod_get_loduserdata();


#endif
