/*
 * Allegro layer
 * for loading/saving multiple images
 *
 *
 *
 */

#include <stdlib.h>
#include <string.h>
#include <allegro.h>
#include <gif_lib.h>


static void     reverse_map( BITMAP *map, unsigned char *buffer );
static void     reverse_mapcol( RGB *mapcol, GifColorType *buffer, int colormapsize );
static void     mapcol( RGB *map, GifColorType *buffer, int colormapsize  );




static void    reverse_map( BITMAP *map, unsigned char *buffer )
{
    int     x,y,w,h;
    unsigned char a;

    w = map->w;
    h = map->h;
    for(y=0;y<h;y++){
    for(x=0;x<w;x++){
    a = getpixel( map, x,y );
    buffer[ y*w+x ] = a;
    }}
}

static void    reverse_mapcol( RGB *mapcol, GifColorType *buffer, int colormapsize )
{
    int     y,j;
    unsigned char r,g,b;

    j=0;
    if( colormapsize > 256 ) colormapsize = 256;
    for(y=0;y<colormapsize;y++){
    r = mapcol[y].r;
    g = mapcol[y].g;
    b = mapcol[y].b;
    buffer[ y ].Red   = r<<2;
    buffer[ y ].Green = g<<2;
    buffer[ y ].Blue  = b<<2;
    }
}
static void    mapcol( RGB *map, GifColorType *buffer, int colormapsize  )
{
    int     y,j;
    unsigned char r,g,b;

    j=0;
    if( colormapsize > 256 ) colormapsize = 256;
    for(y=0;y<colormapsize;y++){
    r = buffer[ y ].Red   ;
    g = buffer[ y ].Green ;
    b = buffer[ y ].Blue  ;
    map[y].r = r>>2;
    map[y].g = g>>2;
    map[y].b = b>>2;
    }
}















// open the gif file and write a screen descriptor into it
//
GifFileType  *gif_opensave(char *filename,
            int ExpColorMapSize, int Width, int Height, int ColorMapSize, RGB *pal )
{
    GifFileType     *GifFile;

    GifFile = EGifOpenFileName( filename, 0 );
        if (GifFile == NULL){
        _GifError = LAYER_GIF_ERR_WRITE;
        PrintGifError();
        return NULL;
        }

    if ((GifFile->OutputColorMap = (GifColorType *) malloc (ColorMapSize * sizeof(GifColorType))) == NULL ||
        (GifFile->OutputBuffer   = (GifByteType *)  malloc(Width * Height * sizeof(GifByteType))) == NULL){
    _GifError = LAYER_GIF_ERR_MALLOC_ERROR;
    PrintGifError();
    return NULL;
    }

    reverse_mapcol( pal, GifFile->OutputColorMap, ColorMapSize );

    if (EGifPutScreenDesc(GifFile,
			  Width, Height, ExpColorMapSize, 0, ExpColorMapSize,
              GifFile->OutputColorMap) == GIF_ERROR ){
        PrintGifError();
        return NULL;
        }

    GifFile->ExpColorMapSize = ExpColorMapSize;

    return GifFile;
}



// write a frame into a gif file
//
void gif_save(GifFileType *GifFile, int Width, int Height, BITMAP *map )
{
    int             i;
    GifByteType     *Ptr = GifFile->OutputBuffer;

    reverse_map( map, GifFile->OutputBuffer );
    if ( EGifPutImageDesc(GifFile, 0, 0, Width, Height, IFALSE, GifFile->ExpColorMapSize, NULL) ==  GIF_ERROR){ PrintGifError(); return; }
    Ptr = GifFile->OutputBuffer;
    for (i = 0; i < Height; i++) {
    if (EGifPutLine(GifFile, Ptr, Width) == GIF_ERROR){ PrintGifError(); return; }
    Ptr += Width;
    }
    return;
}


// close gif file
void    gif_saveclose(GifFileType *GifFile)
{
//    EGifPutComment(GifFile, "Made with EXA4.0");

    if(GifFile->OutputColorMap != NULL) free(GifFile->OutputColorMap);
    if(GifFile->OutputBuffer   != NULL) free(GifFile->OutputBuffer  );
    if(GifFile->ScreenBuffer   != NULL) free(GifFile->ScreenBuffer  );
    GifFile->OutputColorMap = NULL;
    GifFile->OutputBuffer   = NULL;
    GifFile->ScreenBuffer   = NULL;
    if (EGifCloseFile(GifFile) == GIF_ERROR){PrintGifError();  return;}
}

























GifFileType  *gif_openload( char *filename )
{
    int             i;
    int             Size;
    GifFileType     *GifFile;


    if ((GifFile = DGifOpenFileName(filename)) == NULL) return NULL;
    Size = GifFile -> SWidth * sizeof(GifPixelType);    /* Size in bytes one row.*/

//allegro_message("Debug: *1*, size: %d", Size );

    if ((GifFile->ScreenBuffer = (GifRowType *) malloc((GifFile->SHeight+1)*sizeof(GifRowType))) == NULL){
    _GifError = LAYER_GIF_ERR_MALLOC_ERROR;
    PrintGifError();
    return NULL;
    }


//allegro_message("Debug: *1b*, size: %d", Size );

    if ((GifFile->ScreenBuffer[0] = (GifRowType) malloc(Size)) == NULL){ /* First row. */
    _GifError = LAYER_GIF_ERR_MALLOC_ERROR;
    PrintGifError();
    return NULL;
    }
//allegro_message("Debug: *2*");


    for (i = 0; i < GifFile -> SWidth; i++)     /* Set its color to BackGround. */
    GifFile->ScreenBuffer[0][i] = GifFile -> SBackGroundColor;

//allegro_message("Debug: *3*");


    for (i = 1; i < GifFile -> SHeight; i++) {
    /* Allocate the other rows, and set their color to background too:   */
    if ((GifFile->ScreenBuffer[i] = (GifRowType) malloc(Size)) == NULL){
    _GifError = LAYER_GIF_ERR_MALLOC_ERROR;
    PrintGifError();
    return NULL;
    }
    memcpy(GifFile->ScreenBuffer[i], GifFile->ScreenBuffer[0], Size);
    }
    return  GifFile;
}



// returns NULL on end-of-images to load.
BITMAP *gif_load( GifFileType *GifFile, RGB *pal )
{
    int             i,j,x,y, Row=0, Col=0, Width=0, Height=0,  ExtCode, Count;
    GifByteType     *Extension;
    GifRecordType   RecordType;
    unsigned char   color;
    BITMAP          *map= NULL;
    int             flag=0;
    int BackGround = 0,  ColorMapSize = 256,
    InterlacedOffset[] = { 0, 4, 2, 1 }, /* The way Interlaced image should  */
    InterlacedJumps[]  = { 8, 8, 4, 2 }; /* be read - offsets and jumps... */
    GifColorType    *ColorMap;



    flag = 0;
    /* Scan the content of the GIF file and load the image(s) in: */
    do {
	if (DGifGetRecordType(GifFile, &RecordType) == GIF_ERROR) {
	    PrintGifError();
        return NULL;
	}
	switch (RecordType) {
	    case IMAGE_DESC_RECORD_TYPE:
		if (DGifGetImageDesc(GifFile) == GIF_ERROR) {
		    PrintGifError();
            return NULL;
		}
		Row = GifFile -> ITop; /* Image Position relative to Screen. */
		Col = GifFile -> ILeft;
		Width = GifFile -> IWidth;
		Height = GifFile -> IHeight;
		if (GifFile -> ILeft + GifFile -> IWidth > GifFile -> SWidth ||
		   GifFile -> ITop + GifFile -> IHeight > GifFile -> SHeight) {
            _GifError = LAYER_GIF_ERR_IMAGE_OUTSIZE_SCREEN;
            PrintGifError();
            return NULL;
		}
		if (GifFile -> IInterlace) {
		    /* Need to perform 4 passes on the images: */
		    for (Count = i = 0; i < 4; i++)
			for (j = Row + InterlacedOffset[i]; j < Row + Height;
						 j += InterlacedJumps[i]) {
                if (DGifGetLine(GifFile, &GifFile->ScreenBuffer[j][Col],Width) == GIF_ERROR) {
				PrintGifError();
                return NULL;
			    }
			}
		}
		else {
		    for (i = 0; i < Height; i++) {
            if (DGifGetLine(GifFile, &GifFile->ScreenBuffer[Row++][Col],Width) == GIF_ERROR) {
			    PrintGifError();
                return NULL;
			}
		    }
		}
        flag=1;
        break;
	    case EXTENSION_RECORD_TYPE:
		/* Skip any extension blocks in file: */
		if (DGifGetExtension(GifFile, &ExtCode, &Extension) == GIF_ERROR) {
		    PrintGifError();
            return NULL;
		}
		while (Extension != NULL) {
		    if (DGifGetExtensionNext(GifFile, &Extension) == GIF_ERROR) {
			PrintGifError();
            return NULL;
		    }
		}
        flag=0;
        break;
	    case TERMINATE_RECORD_TYPE:
        Width=Height=0;
        flag=1;
        return NULL;    // end of images to load
        break;
	    default:		    /* Should be traps by DGifGetRecordType. */
        Width=Height=0;
        flag=1;
        break;
	}
    }while ( flag==0 );
//    }while (RecordType != TERMINATE_RECORD_TYPE);


// ....
    /* Lets display it - set the global variables required and do it: */
    BackGround = GifFile -> SBackGroundColor;
    ColorMap = (GifFile -> IColorMap ? GifFile -> IColorMap : GifFile -> SColorMap);
    ColorMapSize = 1 << (GifFile -> IColorMap ? GifFile -> IBitsPerPixel : GifFile -> SBitsPerPixel);
    if( pal != NULL ){
        mapcol( pal, ColorMap, ColorMapSize );
        set_palette( pal ); // TESTING
    }
// ....


//allegro_message("width: %d height: %d ", Width, Height);
        map = create_bitmap_ex( 8, Width, Height );   if( map==NULL) return NULL;
        for( y=0;y< Height; y++){
        for( x=0;x< Width; x++){
        color = GifFile->ScreenBuffer[y][x];
        putpixel( map, x, y, color );
        }}
    return map;         //readkey();
//    DumpScreen2Epsn(GifFile->ScreenBuffer, GifFile -> SWidth, GifFile -> SHeight);
}




void gif_loadclose(GifFileType *GifFile)
{
    if(GifFile->OutputColorMap != NULL) free(GifFile->OutputColorMap);
    if(GifFile->OutputBuffer   != NULL) free(GifFile->OutputBuffer  );
    if(GifFile->ScreenBuffer   != NULL) free(GifFile->ScreenBuffer  );
    GifFile->OutputColorMap = NULL;
    GifFile->OutputBuffer   = NULL;
    GifFile->ScreenBuffer   = NULL;
    if (DGifCloseFile(GifFile) == GIF_ERROR) {
        PrintGifError();
        return;
    }
}









