/******************************************************************************
* In order to make life a little bit easier when using the GIF file format,   *
* this library was written, and which does all the dirty work...	      *
*									      *
*					Written by Gershon Elber,  Jun. 1989  *
*******************************************************************************
* History:                                                                    *
* 14 Jun 89 - Version 1.0 by Gershon Elber.                                   *
*  3 Sep 90 - Version 1.1 by Gershon Elber (Support for Gif89, Unique names). *
* 18 Nov 2005 - Version 1.3 by Victor Mena (Modernization).                  *
******************************************************************************/

#ifndef GIF_LIB_H
#define GIF_LIB_H

#include <allegro.h>


#define GIF_LIB_VERSION " Version 1.3, "

#define	GIF_ERROR	0
#define GIF_OK		1

#ifndef ITRUE
#define ITRUE        1
#define IFALSE       0
#endif

#define GIF_FILE_BUFFER_SIZE 16384  /* Files uses bigger buffers than usual. */

int _GifError;


typedef	int		GifBooleanType;
typedef	unsigned char	GifPixelType;
typedef unsigned char *	GifRowType;
typedef unsigned char	GifByteType;

#define GIF_MESSAGE(Msg) fprintf(stderr, "\n%s: %s\n", "zox", Msg)
#define GIF_EXIT(Msg)	{ GIF_MESSAGE(Msg); exit(-3); }

#define VoidPtr void *

typedef struct GifColorType {
    GifByteType Red, Green, Blue;
} GifColorType;

/* Note entries prefixed with S are of Screen information, while entries     */
/* prefixed with I are of the current defined Image.			     */
typedef struct GifFileType {
    int SWidth, SHeight,			       /* Screen dimensions. */
	SColorResolution, SBitsPerPixel, /* How many colors can we generate? */
	SBackGroundColor,		/* I hope you understand this one... */
	ILeft, ITop, IWidth, IHeight,		/* Current image dimensions. */
	IInterlace,			     /* Sequential/Interlaced lines. */
	IBitsPerPixel;			  /* How many colors this image has? */
    GifColorType *SColorMap, *IColorMap;	      /* NULL if not exists. */
    VoidPtr Private;	  /* The regular user should not mess with this one! */
    // ------------------ extra, not used by library ------------------
    GifByteType     *OutputBuffer;      // used by user code only
    GifColorType    *OutputColorMap;    // used by user code only
    GifRowType      *ScreenBuffer;      // used by user code only
//    unsigned char   **ScreenBuffer;      // used by user code only
    int             ExpColorMapSize;    // used by user code only
    // ------------------ extra, ................... ------------------
} GifFileType;

typedef enum {
    UNDEFINED_RECORD_TYPE,
    SCREEN_DESC_RECORD_TYPE,
    IMAGE_DESC_RECORD_TYPE,				   /* Begin with ',' */
    EXTENSION_RECORD_TYPE,				   /* Begin with '!' */
    TERMINATE_RECORD_TYPE				   /* Begin with ';' */
} GifRecordType;


/******************************************************************************
* O.k. here are the routines one can access in order to encode GIF file:      *
* (GIF_LIB file EGIF_LIB.C).						      *
******************************************************************************/

GifFileType *EGifOpenFileName(char *GifFileName, int GifTestExistance);
GifFileType *EGifOpenFileHandle(char *FileName);
void EGifSetGifVersion(char *Version);
int EGifPutScreenDesc(GifFileType *GifFile,
	int GifWidth, int GifHeight, int GifColorRes, int GifBackGround,
	int GifBitsPerPixel, GifColorType *GifColorMap);
int EGifPutImageDesc(GifFileType *GifFile,
	int GifLeft, int GifTop, int Width, int GifHeight, int GifInterlace,
	int GifBitsPerPixel, GifColorType *GifColorMap);
int EGifPutLine(GifFileType *GifFile, GifPixelType *GifLine, int GifLineLen);
int EGifPutPixel(GifFileType *GifFile, GifPixelType GifPixel);
int EGifPutComment(GifFileType *GifFile, char *GifComment);
int EGifPutExtension(GifFileType *GifFile, int GifExtCode, int GifExtLen,
							VoidPtr GifExtension);
int EGifPutCode(GifFileType *GifFile, int GifCodeSize,
						   GifByteType *GifCodeBlock);
int EGifPutCodeNext(GifFileType *GifFile, GifByteType *GifCodeBlock);
int EGifCloseFile(GifFileType *GifFile);

#define	E_GIF_ERR_OPEN_FAILED	1		/* And EGif possible errors. */
#define	E_GIF_ERR_WRITE_FAILED	2
#define E_GIF_ERR_HAS_SCRN_DSCR	3
#define E_GIF_ERR_HAS_IMAG_DSCR	4
#define E_GIF_ERR_NO_COLOR_MAP	5
#define E_GIF_ERR_DATA_TOO_BIG	6
#define E_GIF_ERR_NOT_ENOUGH_MEM 7
#define E_GIF_ERR_DISK_IS_FULL	8
#define E_GIF_ERR_CLOSE_FAILED	9
#define E_GIF_ERR_NOT_WRITEABLE	10

/******************************************************************************
* O.k. here are the routines one can access in order to decode GIF file:      *
* (GIF_LIB file DGIF_LIB.C).						      *
******************************************************************************/

GifFileType *DGifOpenFileName(char *GifFileName);
GifFileType *DGifOpenFileHandle(char *FileName);
int DGifGetScreenDesc(GifFileType *GifFile);
int DGifGetRecordType(GifFileType *GifFile, GifRecordType *GifType);
int DGifGetImageDesc(GifFileType *GifFile);
int DGifGetLine(GifFileType *GifFile, GifPixelType *GifLine, int GifLineLen);
int DGifGetPixel(GifFileType *GifFile, GifPixelType GifPixel);
int DGifGetComment(GifFileType *GifFile, char *GifComment);
int DGifGetExtension(GifFileType *GifFile, int *GifExtCode,
						GifByteType **GifExtension);
int DGifGetExtensionNext(GifFileType *GifFile, GifByteType **GifExtension);
int DGifGetCode(GifFileType *GifFile, int *GifCodeSize,
						GifByteType **GifCodeBlock);
int DGifGetCodeNext(GifFileType *GifFile, GifByteType **GifCodeBlock);
int DGifGetLZCodes(GifFileType *GifFile, int *GifCode);
int DGifCloseFile(GifFileType *GifFile);

#define	D_GIF_ERR_OPEN_FAILED	101		/* And DGif possible errors. */
#define	D_GIF_ERR_READ_FAILED	102
#define	D_GIF_ERR_NOT_GIF_FILE	103
#define D_GIF_ERR_NO_SCRN_DSCR	104
#define D_GIF_ERR_NO_IMAG_DSCR	105
#define D_GIF_ERR_NO_COLOR_MAP	106
#define D_GIF_ERR_WRONG_RECORD	107
#define D_GIF_ERR_DATA_TOO_BIG	108
#define D_GIF_ERR_NOT_ENOUGH_MEM 109
#define D_GIF_ERR_CLOSE_FAILED	110
#define D_GIF_ERR_NOT_READABLE	111
#define D_GIF_ERR_IMAGE_DEFECT	112
#define D_GIF_ERR_EOF_TOO_SOON	113



#define LAYER_GIF_ERR_MALLOC_ERROR 200
#define LAYER_GIF_ERR_IMAGE_OUTSIZE_SCREEN 201
#define LAYER_GIF_ERR_WRITE 202



/******************************************************************************
* O.k. here are the routines from GIF_LIB file QPRINTF.C.		      *
******************************************************************************/
//extern int GifQuitePrint;
//void GifQprintf(char *Format, ...);

/******************************************************************************
* O.k. here are the routines from GIF_LIB file GIF_ERR.C.		      *
******************************************************************************/
char *PrintGifError(void);
int GifLastError(void);






/******************************************************************************
* Declarations, global to other of the GIF-HASH.C module.                     *
*                                                                             *
*                   Written by Gershon Elber,  Jun 1989                       *
*******************************************************************************
* History:                                                                    *
* 14 Jun 89 - Version 1.0 by Gershon Elber.                                   *
******************************************************************************/

#define HT_SIZE			8192	   /* 12bits = 4096 or twice as big! */
#define HT_KEY_MASK		0x1FFF			      /* 13bits keys */
#define HT_KEY_NUM_BITS		13			      /* 13bits keys */
#define HT_MAX_KEY		8191	/* 13bits - 1, maximal code possible */
#define HT_MAX_CODE		4095	/* Biggest code possible in 12 bits. */

/* The 32 bits of the long are divided into two parts for the key & code:   */
/* 1. The code is 12 bits as our compression algorithm is limited to 12bits */
/* 2. The key is 12 bits Prefix code + 8 bit new char or 20 bits.	    */
#define HT_GET_KEY(l)	(l >> 12)
#define HT_GET_CODE(l)	(l & 0x0FFF)
#define HT_PUT_KEY(l)	(l << 12)
#define HT_PUT_CODE(l)	(l & 0x0FFF)

typedef struct GifHashTableType {
    unsigned long HTable[HT_SIZE];
} GifHashTableType;

GifHashTableType *_InitHashTable(void);
void _ClearHashTable(GifHashTableType *HashTable);
void _InsertHashTable(GifHashTableType *HashTable, unsigned long Key, int Code);
int _ExistsHashTable(GifHashTableType *HashTable, unsigned long Key);





/* ****************************************************************************
*  Allegro Layer to load/save multiple images in gif89a                       *
*                                                                             *
*                                                                             *
**************************************************************************** */



GifFileType *gif_opensave(char *filename, int ExpColorMapSize, int Width, int Height, int ColorMapSize, RGB *pal );
void        gif_save(GifFileType *GifFile, int Width, int Height, BITMAP *map );
void        gif_saveclose(GifFileType *GifFile);
GifFileType *gif_openload( char *filename );
BITMAP      *gif_load( GifFileType *GifFile, RGB *pal );
void        gif_loadclose(GifFileType *GifFile);




#endif
