/******************************************************************************
 *                                                                            *
 *  Redistribution and use in source and binary forms are permitted           *
 *  provided that source distributions retain this entire copyright           *
 *  notice and comment.                                                       *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR            *
 *  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED            *
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.       *
 *  USE THIS SOFTWARE AT OWN RISK.                                            *
 *                                                                            *
 *  IN NO EVENT SHALL THE AUTHOR OF THIS SOFTWARE BE LIABLE FOR               *
 *  ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,   *
 *  OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,    *
 *  WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF *
 *  LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE    *
 *  OF THIS SOFTWARE.                                                         *
 *                                                                            *
 ******************************************************************************/
/* example program to use the fli library */
/*                                        */
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>

#include <string.h>
#include <ctype.h>


#include "fli.h"
#include "flilib.h"
//#include "flifile.h"
//#include "flisubs.h"



static BITMAP *img1, *img2;
static PALETTE pal1, pal2;


/*** helper functions ***/
static void inith13(FLI *);
static void deinith13(void);
static void putpal( BYTE *, int  );
/*** helper functions ***/





FLI *fli;       /* for read  */
FLI *fliw;      /* for write */


void copy_pal( FLI *fliw, RGB *pal )
{
    int i,j;

    for(i=j=0;i<(fliw->palentry-1);i++){
        fliw->palette[j++] = pal[i].r;
        fliw->palette[j++] = pal[i].g;
        fliw->palette[j++] = pal[i].b;
    }
}


void  copy_prev_image( FLI *fliw )
{
    int i;

    if( fliw->frames != 0 ){   // all but first frame
    for(i=0;i< fliw->framesize; i++)
        fliw->image_prev[i] = fliw->image[i];
    }


}







static void put_palpixelS();

static void msgbox_( const char *fmt, ... );


int main(int argc, char *argv[])
{
    int     i,j, verbose_flag = 1;
    BITMAP *img;
    BITMAP *img1, *img2, *img3, *img4, *img5;
    FLI     *tf;
    FILE    *fp;
    BYTE    b, zax[99]="Zax";

/*
    allegro_init();
    install_keyboard();
    install_timer();
    i = set_gfx_mode( GFX_AUTODETECT_WINDOWED,640, 480,0,0);
    if(i!=0){ allegro_message("Unable to set any graphic mode\n%s\n", allegro_error); exit(-1);}
    fp =    fopen("a.a","rb");  if(fp==NULL) exit(-1);
    b = (BYTE) fgetc( fp );    j= feof( fp ); msgbox_("b=%d, j=%d",b,j);
    b = (BYTE) fgetc( fp );    j= feof( fp ); msgbox_("b=%d, j=%d",b,j);
    b = (BYTE) fgetc( fp );    j= feof( fp ); msgbox_("b=%d, j=%d",b,j);
    b = (BYTE) fgetc( fp );    j= feof( fp ); msgbox_("b=%d, j=%d",b,j);
    b = (BYTE) fgetc( fp );    j= feof( fp ); msgbox_("b=%d, j=%d",b,j);
    b = (BYTE) fgetc( fp );    j= feof( fp ); msgbox_("b=%d, j=%d",b,j);
    fclose(fp);
    exit(0);
*/


    allegro_init();


    /* open and read header */
    if(argc==1){    allegro_message("need 1 argument, FLI file");    exit(0);    }


    verbose_flag=1;
    fli = fli_open_file_read( argv[1], 0, verbose_flag );
    if( fli == NULL ){    allegro_message("error: Memory allocation");    return 0;    }
    if( fli->errnumber != FERR_OK ){
    sprintf( (char *)&zax, "%s: %s", fli->filename, fli_return_errstring( fli ) );
    allegro_message( (char *)&zax );
    return 0;
    }


    // create a bitmap for displaying

//    fli->verbose=1;     // set verbose on, into debug

    inith13( fli );

//    fli->depth = 24;
//    msgbox_(" depth: %d", fli->depth );


    img = create_bitmap( fli->width, fli->height );
    if(img==NULL){
    msgbox_("Cannot create bitmap, sx: %d  sy:%d",fli->width, fli->height );
    exit(-1);}



    for(;;){

    tf = fli_read_frame( fli );
        if( fli->errnumber != FERR_OK ){
            textprintf( screen, font, 3,23, 125, "ERROR reading frame"  );
            msgbox_("error: %s", fli_return_errstring( fli ) );
        }

//    debug_addprintf( fli, "This is a test\n" );
//    debug_addprintf( fli, "This is a test\n" );



    /* when do we need to update palette?
     *  which palette entries do we need to update?
     * when do we need to update picture?
     *  which image lines do we need to update?
     */

    if(fli->update_palette==1)
        putpal( fli->palette, fli->palentry  );


//    display2( img, fli->image, fli->img_begin,fli->img_end, fli->width, fli->depth );
    fli_compose_image( img, fli->image, fli->img_begin,fli->img_end, fli->width, fli->depth );

    acquire_screen();
    blit( img, screen,0,0,0,0, img->w, img->h );
    textprintf( screen, font, 3,3, 125, "i=%d", fli->images_to_go );
     textprintf( screen, font, 225,40,  makecol(200,200,200), fli->debuglevel1  );
     textprintf( screen, font, 225,60,  makecol(200,200,200), fli->debuglevel2  );
     textprintf( screen, font, 225,80,  makecol(200,200,200), fli->debuglevel3  );
     textprintf( screen, font, 225,100, makecol(200,200,200), fli->debuglevel4  );
//     textprintf( screen, font, 225,110, makecol(200,200,200), "feof(): %d",  feof(fli->fp)  );
    put_palpixelS();

    release_screen();






//    delay(120);
    rest(20);
    readkey();

    if( key[KEY_ESC] ) break;
    if( fli->images_to_go == 0 ) fli_rewind( fli );  // after this, we are ready to replay
    }
    fli_rewind( fli );  // after this, we are ready to replay
    fli_close( fli );



//    msgbox_("-------------");
//    puts("-----------------------------------------------------------");
    img1 = load_bitmap("dta_cat1.pcx", (RGB *)&pal1);
    img2 = load_bitmap("dta_cat2.pcx", (RGB *)&pal2);
    img3 = load_bitmap("dta_cat3.pcx", (RGB *)&pal2);
    img4 = load_bitmap("dta_cat4.pcx", (RGB *)&pal2);
    img5 = load_bitmap("dta_cat5.pcx", (RGB *)&pal2);
//allegro_message("*** a ***");
    fliw = fli_open_file_write("test.fli", 1, 320, 200, 0, verbose_flag );
//allegro_message("*** b ***");
    if( fliw == NULL ){    allegro_message("error: Memory allocation,save");    return 0;    }
    if( fliw->errnumber != FERR_OK ){
    msgbox_("error: %s", fli_return_errstring( fliw ) );
    exit(-1);
    }
        fli_reverse_copy_pal( fliw, (RGB *)&pal1 );

    set_palette( (RGB *)&pal1 );
        fli_reverse_compose_image( fliw, img1 );
        fli_write_frame( fliw );
        fli_reverse_compose_image( fliw, img2 );
        fli_write_frame( fliw );
        fli_reverse_compose_image( fliw, img3 );
        fli_write_frame( fliw );
        fli_reverse_compose_image( fliw, img4 );
        fli_write_frame( fliw );
        fli_reverse_compose_image( fliw, img5 );
        fli_write_frame( fliw );
    fli_close( fliw );



//    readkey();
//    deinith13();
    allegro_exit();
    return 0;
}


END_OF_MAIN();







static void putpal( BYTE *pal, int entries )
{
    int i,y;
    PALETTE pam;

    if( entries!=0 && fli->depth<=8 && pal!=NULL ){
    for(i=0;i<(entries&255);i++){
    y = i*3;
    pam[i].r = pal[y];
    pam[i].g = pal[y+1];
    pam[i].b = pal[y+2];
    }
    set_palette( pam );
    }
}



static void inith13(FLI *fli)
{
    int i;

    allegro_init();
    install_keyboard();
    install_timer();
    if(install_mouse()==-1){puts("Error initializing mouse");
        remove_timer();
        remove_keyboard();
        exit(-1);
    }

    switch(fli->depth){
    case 1:
    case 8:
    set_color_depth(8);
    break;
    case 15:
    case 16:
    case 24:
    set_color_depth(24);
    break;
    default:
    set_color_depth(fli->depth);
    }
    i = set_gfx_mode( GFX_AUTODETECT_WINDOWED,600, 400,0,0);
    if(i!=0){ allegro_message("Unable to set graphic mode:bpp=%d: %s", fli->depth, allegro_error); exit(-1);}
}
static void deinith13(void)
{
    allegro_exit();
}




static char errstring[99+1];

static void msgbox_( const char *fmt, ... )
{
    va_list args;
    errstring[0] = 0;
    va_start(args, fmt);
    _vsnprintf( (char *)&errstring, 99, fmt, args );
    errstring[99] = 0;
    va_end(args);
    alert("   ", (char *)&errstring , "   ","OK",NULL,1,2);
}
static void put_palpixelS()
{
}


