/*
 * Header file used by user.
 *
 */
#ifndef _H_main_ftypes_h_
#define _H_main_ftypes_h_

#define FLILIB_VERSION_STR "V 1.2"
#define FLILIB_VERSION_MAJ 1
#define FLILIB_VERSION_MIN 1

// #define DEBUG    // only use this define when developing the library

#include <stdio.h>



// Return values used by errnumber
#define FERR_OK                  0
#define FERR_CANTREADHEADER      1
#define FERR_CANTWRITEHEADER     2
#define FERR_CANTOPENFILEREAD    3
#define FERR_CANTOPENFILEWRITE   4
#define FERR_FILEDONTEXIST       5
#define FERR_BITDEPTHUNSUP       6
#define FERR_FIRSTSECONDOFFZERO  7
#define FERR_UNKNOWNFLITYPE      8
#define FERR_CFBWTUNSUPPORTED    9
#define FERR_SFBWTUNSUPPORTED    10
#define FERR_IMAGEALLOCERROR     11
#define FERR_IMAGE2ALLOCERROR    12
#define FERR_PALETTEALLOCERROR   13
#define FERR_PALETTE2ALLOCERROR  14
#define FERR_FIRSTFRAMEZERO      15
#define FERR_BITDEPTHISZERO      16
#define FERR_NOFILENAMEGIVEN     17
#define FERR_WRITEFLI1HEADER     18
#define FERR_WRITEFLI2HEADER     19
#define FERR_EOF                 20










/*
 * Many FLIC types.
 *
 * used types.
 * DWORD  - unsigned 32 bit.
 * WORD   - unsigned 16 bit.
 * BYTE   - unsigned 8 bit.
 *
 * TYPE_FLI  0xAF11    standard FLI file 320x200, 256 colors
 * TYPE_FLC  0xAF12    standard FLC file ---x---, 256 colors
 * TYPE_EFLC 0xAF44    dta Extended FLC file, bpp's: 1,8,15,16,24
 * TYPE_CFLC 0xAF30    FLC file, Huffman or BWT compression (unsupported...)
 * TYPE_SFLC 0xAF31    "Frame shift" compressed       (unsupported...)
 *
 */

#ifndef DWORD
typedef unsigned long  DWORD;
typedef unsigned short WORD;
typedef unsigned char  BYTE;
#endif

#define TYPE_FLI  0xaf11
#define TYPE_FLC  0xaf12
#define TYPE_EFLC 0xaf44
#define TYPE_CFLC 0xaf30
#define TYPE_SFLC 0xAF31

#define PREFIX_TYPE    0xf100
#define FRAME_TYPE     0xf1fa
#define SEGMENT_TABLE  0xf1fb
#define HUFFMAN_TABLE  0xf1fc

#define COLOR_256   4
#define COLOR_64   11
#define BLACK      13
#define BYTE_RUN   15
#define DELTA_FLI  12
#define FLI_COPY   16
#define DELTA_FLC   7
#define DTA_BRUN   25
#define DTA_COPY   26
#define DTA_LC     27
/* odd types */
#define CEL_DATA    3
#define PSTAMP     18
#define LABEL      31
#define BMP_MASK   32
#define MLEV_MASK  33
#define SEGMENT    34
#define KEY_IMAGE  35
#define KEY_PAL    36
#define REGION     37
#define WAVE       38
#define USERSTRING 39



typedef struct {
/* ... standard FLx header (128 bytes) ... */
 DWORD size;          /* Size of FLIC including this header */
 WORD  type;          /* File type 0xAF11, 0xAF12, 0xAF30, 0xAF44, ... */
 WORD  frames;        /* Number of frames */
                      /* used to count how many frames are stored during write */
                      /* and to know when to change the 'oframe2' field.       */
 WORD  width;         /* FLIC width in pixels */
 WORD  height;        /* FLIC height in pixels */
 WORD  depth;         /* Bits per pixel (usually 8) */
 WORD  flags;         /* Set to zero or to three */
 DWORD speed;         /* Delay between frames */
 WORD  reserved1;     /* Set to zero */
 DWORD created;       /* Date of FLIC creation (FLC only) */
 DWORD creator;       /* Serial number or compiler id (FLC only) */
 DWORD updated;       /* Date of FLIC update (FLC only) */
 DWORD updater;       /* Serial number (FLC only), see creator */
 WORD  aspect_dx;     /* Width of square rectangle (FLC only) */
 WORD  aspect_dy;     /* Height of square rectangle (FLC only) */
 WORD  ext_flags;     /* EGI: flags for specific EGI extensions */
 WORD  keyframes;     /* EGI: key-image frequency */
 WORD  totalframes;   /* EGI: total number of frames (segments) */
 DWORD req_memory;    /* EGI: maximum chunk size (uncompressed) */
 WORD  max_regions;   /* EGI: max. number of regions in a CHK_REGION chunk */
 WORD  transp_num;    /* EGI: number of transparent levels */
 BYTE  reserved2[24]; /* Set to zero */
 DWORD oframe1;       /* Offset to frame 1 (FLC only) */
 DWORD oframe2;       /* Offset to frame 2 (FLC only) */
 BYTE  reserved3[40]; /* Set to zero */

/* ... additional stuff ... */
BYTE    verbose;        /* verbose flag: 0=quiet, 1=verbose     */
FILE    *fp;           /* extended file pointer (file/memory)  */
char    *filename;      /* filename                             */
int     stride;         /* bytes per line, calculated for the current bitdepth */
BYTE    speedflag;      /* time unit to use: 0-use frames, 1-milliseconds      */
WORD    speedunit;      /* unit in frames or milliseconds                     */
WORD    current_frame;  /* number of current frame, from 0 to n              */
DWORD   framesize;      /* size in bytes of one frame                       */
WORD    palentry;       /* how many palette entries. is 0 on bpp > 8        */
/*...new ...*/
BYTE    read_write;     /* 0= opened for reading, 1= opened for writing     */
WORD    images_to_go;   /* how many frames until end of frames, decreased   */
                        /* for each read of frame until zero.               */
                        /* This value is re-set to number of frames on a    */
                        /* rewind operation                                 */
                    /* used to count how many frames are stored during write */
                    /* and to know when to change the 'oframe2' field.       */

DWORD   fileposition;   /* position to rewind back to ( first frame ).      */
BYTE    colormetric;    /* set by user (default 0), 0 = rgb range 0-63 (VGA), 1 = rgb range 0-255    */

BYTE    *image;         /* user image, valid after reading first frame, else NULL */
BYTE    *image_prev;    /* internal use, for saving, previous image     */
BYTE    *image_compr;   /* internal use, for saving, compressed image, is NULL on no compression */
BYTE    *palette;       /* user palette, NULL on more than 8 bit depth       */
BYTE    *palette_prev;  /* internal use, for saving, palette previous   */
BYTE    *palette_compr; /* internal use, for saving, palette compressed,is NULL on no compression */

/* valid while loading t*/
BYTE    update_palette; /* 0 = no update of palette is necessary, 1 = update */
int     upd_pal_begin;  /* update palette begin entry */
int     upd_pal_end;    /* update palette end  entry  */

/* valid while loading */
WORD    img_begin;      /* image update line begin */
WORD    img_end;        /* image update line end   */

// ----------------------------------------
// stuffs for debug
BYTE    debuglevel1[80+1];
BYTE    debuglevel2[80+1];
BYTE    debuglevel3[80+1];
BYTE    debuglevel4[80+1];

BYTE    debugappend[8192];  // to append text on

int     errnumber;      // errcode returned by functions


}FLI;
// }FLI __attribute__ ((packed));




/*
 * these are the only functions needed
 */
FLI *fli_open_file_read( char *, char, int );
FLI *fli_rewind( FLI *f );
FLI *fli_read_frame( FLI * );
FLI *fli_open_file_write( char *, char, int, int, char, int );
FLI *fli_write_frame( FLI * );
void fli_close( FLI * );





#endif
