/*
 * Functions for virtual disk
 * Opening from file or allocated memory (virtual disk).
 * not ready yet.
 *
 * uses functions from stdio.h
 * if "offset" is seeked past "size" then size is increased BLOCKSIZE amount
 * until size is again bigger than "offset". Then it will be reallocated.
 * The new bytes will be filled with 0.
 * all chache info is written when file is closed
 *
 *
 *
 *
 *
 */
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "flilib.h"
#include "flifile.h"
#define BLOCKSIZE 4096






/**************************************************************************
 * open file
 * Input:
 *       filename  - ascii filename   used just like in stdio.h
 *       ascbin    - "rb", "wb"       used just like in stdio.h
 *  -----------------------------------------
 *  The cache is private to this stream only.
 *  -----------------------------------------
 * Output: returns NULL on error.
 *************************************************************************/
FILE *topen( char *filename, char *ascbin )
{
    FILE *fp;

    fp = fopen( filename, ascbin );
    return fp;
}







/* read buffer */
BYTE  tread( FILE *fp, void *_buf, int size )
{
    fread( _buf, size, 1, fp );
    return errno;
}





/* read 8 bit */
BYTE  r_byte( FILE *fp )
{
    BYTE b1=0;

    if(fp==NULL) return -1;
    b1 = (BYTE) fgetc( fp );
    return b1;
}




/* scan past databytes, rthrowing them away
 * returns 0 on success
*/
BYTE  r_bytes( FILE *fp, int nx )
{
    int n;

    n = nx;
    while( n!=0 ){
    r_byte(fp); n--;
    if( errno !=0 ) return n;
    }
    return 0;
}










/* read 16 bit */
WORD  r_word( FILE *fp )
{
    BYTE a=0,b=0;
    WORD c=0,d=0;

    a = r_byte(fp);           /* lsb */
    b = r_byte(fp);
    c = a;
    d = b;
    return ( (d << 8) | c );
}
/* read 32 bit */
DWORD r_dword( FILE *fp )
{
    BYTE    a=0,b=0,c=0,d=0;
    DWORD   b0=0,b1=0,b2=0,b3=0;

    a= r_byte(fp);    /* lsb */
    b= r_byte(fp);
    c= r_byte(fp);
    d= r_byte(fp);
    b3=a;
    b2=b;
    b1=c;
    b0=d;
    return ( (b0<<24) | (b1<<16) | (b2<<8) | (b3) );
}









/* write buffer */
BYTE  twrite( FILE *fp, void *_buf, int size )
{
    fwrite( _buf, size, 1, fp );
    return errno;
}


/* write 8 bit */
BYTE  w_byte( FILE *fp, BYTE a )
{
    int b=0;

    b = a;
    fputc( b, fp );
    return errno;
}

/*
 *  write a number of bytes with value 0, returns 0 on success
*/
BYTE  w_bytes( FILE *fp, int n )
{
    while( n!=0 ){
    w_byte( fp, 0 ); n--;
    if( errno!=0 ) return n;
    }
    return 0;
}


/* write 16 bit */
BYTE  w_word( FILE *fp, WORD w0 )
{
    WORD w1, w2;
    BYTE b1, b2;

    w1 = w2 = w0;
    b1 = (w1 & 255);
    b2 = ((w2 >> 8) & 255);
    w_byte(fp, b1);    if( errno!=0 ) return errno;
    w_byte(fp, b2);
    return errno;
}


/* write 32 bit */
BYTE  w_dword( FILE *fp, DWORD z )
{
    DWORD t=0,u=0,v=0,w=0;
    BYTE  a=0,b=0,c=0,d=0;

    t = u = v = w = z;
    t = t & 255;
    u = (u >> 8) & 255;
    v = (v >> 16) & 255;
    w = (w >> 24) & 255;
    a = t;
    b = u;
    c = v;
    d = w;
    w_byte( fp, a );    if( errno!=0 ) return errno;
    w_byte( fp, b );    if( errno!=0 ) return errno;
    w_byte( fp, c );    if( errno!=0 ) return errno;
    w_byte( fp, d );    if( errno!=0 ) return errno;
    return errno;
}







/* clear errno and rewind */
void  trewind( FILE *fp )
{
    errno=0;
    if(fp==NULL) return;
    rewind( fp );
}

/* clear errno for current stream */
void  tclearerr( FILE *fp )
{
    errno=0;
    if(fp==NULL) return;
    clearerr( fp );
}

/* close file */
void  tclose( FILE *fp )
{
    if(fp==NULL) return;
    fflush( fp );
    fclose( fp );
}






/* seek to position, relative from beginning
 * returns position BEFORE seeking to new position.
 */
DWORD tseek( FILE *fp, long offset, int mode )
{
    int po=0;

    fflush( fp );    /* flush before seeking, or we may loose buffer */
    po = ftell( fp );
    fseek( fp, offset, mode );
    return po;
}








/* report current file pointer position
 */
DWORD ttell( FILE *fp )
{
    int po=0;

    po = ftell(fp);
    return po;
}


/***************************************
    Function Returns 1 if file exist,
    else returns 0.
****************************************/
int tfile_exist( char *filename )
{
    struct _finddata_t findme;
//    FILE *f;
    int     i;

    i = _findfirst ( filename, (struct _finddata_t*)&findme );
    if(i==-1) return 0;
//    _findclose (i);
    return 1;

//    f = fopen( filename, "rb" );    if(f == NULL) return 0;
//    fclose( f );
//    return 1;
}



