/****************************************************************************
 * gbmalleg.c:	load a bitmap with the gbm library; convert it to allegro fmt*
 ***************************************************************************/

/*
#define DEBUG
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <allegro.h>
#include "data.h"
#include "dllgbm/gbminit.h"
#include "gbminit.h"
#include "butil.h"
#include "subs.h"

/* prototypes for helper functions */
unsigned char *BMPtoGBM(GBM *gbm, BITMAP *bmp);
/* prototypes for helper functions */



static unsigned char shift_bits[]={128,64,32,16,8,4,2,1,0};


/* load */
//BITMAP *GBMtoBMP( GBM *gbm, unsigned char *data )
// return allegro bitmap, either bpp 8 or 24
//
BITMAP *GBMtoBMP( GBM *gbm, unsigned char *data, GBMRGB *gbmrgb  )  // New!
{
    BITMAP *bmp = NULL;
    int     i=0,j=0,jj=0;
    int     pos = 0, poss = 0;
    int     color = 0;
    int     stride = 8;



    if( gbm->bpp <= 8 )     // for bpp 1,4,8 create bpp 8
        bmp = create_bitmap_ex(  8, gbm->w, gbm->h );
    else
        bmp = create_bitmap_ex( 24, gbm->w, gbm->h );

    if( bmp==NULL ) return NULL;
    clear_bitmap( bmp );

    if( gbm->bpp == 1 ) stride = ((gbm -> w + 31) / 32) * 4;
    if( gbm->bpp == 4 ) stride = ((gbm -> w * 4 + 31) / 32) * 4;
    if( gbm->bpp == 8 ) stride = ((gbm -> w + 3) & ~3);
    if( gbm->bpp == 24) stride = ((gbm -> w * 3 + 3) & ~3);

    poss = 0;
    color = 0;
    for ( i=0 ; i < gbm->h ; i++ ){
    jj=0;
    pos=0;

    for ( j=0 ;  j < gbm->w ; j++ ){
        if ( gbm->bpp == 1){
            color = data[poss+pos] & shift_bits[  jj  ];
            if(color!=0) color = 255;
            jj++;
            if (jj==8) pos++;
            jj &= 7;
        }
        if ( gbm->bpp == 4){
            color = data[poss+pos]>>4;
            putpixel(bmp,j, i ,color);
            j++;
            if (j==gbm->w)
              j--;
            else
              color = data[poss+pos]&0xf;
            pos++;
        }
        if ( gbm->bpp == 8 ){
           color = data[ poss + pos ];
           pos++;
        }
        if ( gbm->bpp == 24 ){
           color = makecol24( data[poss+pos+2] , data[poss+pos+1] , data[poss+pos] );
           pos += 3;
        }
        putpixel( bmp, j,  i, color );
    }
    poss += stride;
    }
    return bmp;    /* returned bitmap is bpp 8 or 24 */
}









/* save */
unsigned char *BMPtoGBM(GBM *gbm, BITMAP *bmp)
{
    unsigned char *data,c1=0,c2=0,ch=0;
    int i,j,jj;
    int color;
    int pos = 0;

    unsigned char mask = 1<<7;

    int bpp = bitmap_color_depth( bmp );        /* current color depth */

    data = u_malloc( (((bmp->w * bpp+31)/32)*4*bmp->h+2)+99  );    if (!data) return NULL;


    data[pos]=0;

 for ( i=0 ;  i < gbm->h  ; i++ )
    {
    jj=0;
     for ( j=0 ;  j < gbm->w  ; j++ )
        {
        color = getpixel( bmp, j , i );

        if( gbm->bpp == 1 )
            {
/*
            idx = (getr(color) + getg(color) + getb(color))/3;
            if ( idx > 45 ){ idx=1; } else { idx=0; }
            if( idx==1 ){ data[pos] |= mask; }
            if( idx!=1 ){ data[pos] &= (~mask); }
*/
            if( color!=0 ){ data[pos] |= mask; }
            if( color==0 ){ data[pos] &= (~mask); }

            mask >>= 1;
            if (mask==0)
                {
                mask = 128;
                pos++;
                data[pos]=0;
                }
            }
         else if (gbm->bpp == 4)            /* 4 */
           {
        if( jj==0 ){
            c1 = getpixel(bmp,j,i)&15;}
        if( jj==1 ){
            c2 = getpixel(bmp,j,i)&15;
            ch = (c1<<4) | c2;
            data[pos] = ch;
            pos++;
        }
        jj++;
        jj &=1;
           }
         else if (gbm->bpp == 8)            /* 8 */
           {
            data[pos] = color;
            pos++;
           }
         else                               /* 24 */
           {
            data[pos]   = getb_depth( bpp, color );
            data[pos+1] = getg_depth( bpp, color );
            data[pos+2] = getr_depth( bpp, color );
            pos+=3;
           }
        }   /* for j */
        if(gbm->bpp == 1)
            {
            if((gbm->w&7)!=0)
                {
                mask = 128;
                pos++;
                data[pos]=0;
                }
            }
    pos = (pos+3)&(~3);        /* align on dword boundary for each scanline */
    }   /* for i */
 return data;
}


void GBMRGBtoPALETTE( GBMRGB *gbmrgb,PALETTE pal )
{
    int i;
    for (i=0;i<255;i++)
    {
     pal[i].r = gbmrgb[i].r>>2;
     pal[i].b = gbmrgb[i].b>>2;
     pal[i].g = gbmrgb[i].g>>2;
    }
}


void PALETTEtoGBMRGB( GBMRGB *gbmrgb,PALETTE pal )
{
    int i;
    for (i=0;i<255;i++)
    {
     gbmrgb[i].r = pal[i].r<<2;
     gbmrgb[i].b = pal[i].b<<2;
     gbmrgb[i].g = pal[i].g<<2;
    }
}








/* save_gbm:
 *  Saves a bitmap file with the specified pallete using the GBM library,
 *  converting it from the Allegro bitmap & pallete format.
 */
/*
 * Made ONLY to save bitmaps from a bitdepth of 8
 */
int save_gbm(const char *filename, BITMAP *bmp, const RGB *pal)
{
 BITMAP *zbmp=NULL;
 int sx,sy, flag;
 int ft_src, rc;
 int fd;
 GBM gbm;
 GBMRGB gbmrgb[256];
 GBMFT gbmft;
 int bpp = bitmap_color_depth(bmp);     /* get incoming color depth */
 unsigned char *data=NULL;

 data=data;

 if ( gbm_guess_filetype(filename, &ft_src) != GBM_ERR_OK )   return -1;
 if ( (fd = u_open(filename, "wb")) == -1 ) return errno;


    sx = bmp->w;
    sy = bmp->h;

/*
    printf("\n Saving GBM...<%s> \n",filename);
    printf("creating bitmap <%d><%d>...",sx,sy);
*/

    zbmp = create_bitmap( sx, sy );    if( zbmp == NULL ) return -1;
    blit( bmp, zbmp, 0, 0, 0, 0, sx, sy );

    gbm_query_filetype( ft_src, &gbmft );

    gbm.w = sx;
    gbm.h = sy;
    gbm.bpp = bpp;
    flag = (gbmft.flags>>4)&15;       /* save flags */

/*
    printf("flags   <0x%x>\n", gbmft.flags);
    printf("bpp     <%d>\n",bpp);
    printf("gbm.bpp <%d>\n",gbm.bpp);
    printf("flag    <0x%x>\n", flag );
*/

           /*    GBM_FT_W8 */
    if ( (flag&4) == 0 ){   /* graphicstandard can't handle 256 colors */

/*    printf("graphic standard can't handle 256 colors directly\n");*/

 if ( flag == 1 ){   /* graphicstandard is only b/w */
        /*        printf("save Black/White ONLY \n");*/
        /*      scale from 1 bits depth to 8 bits depth    */
        /*                                                 */
        gbm.bpp = 1;
        }

 if ( flag == 2 ){   /* graphicstandard is only 16 colors */
        /*        printf("save 16 colors ONLY \n");*/
        /*      scale from 4 bits depth to 8 bits depth    */
        /*    :                                            */
        gbm.bpp = 4;
        }

 if ( flag == 8 ){   /* graphicstandard is only 24 bits */
        /*        printf("save 16m colors ONLY \n");*/
        /*      scale from 8 bits depth to 24 bits depth    */
        /*  op: increase colors to 16 millions of colors    */
        destroy_bitmap( zbmp );
        zbmp = create_bitmap_ex( 24, sx, sy );
        if( zbmp==NULL ) return -1;
        set_color_conversion(  COLORCONV_EXPAND_256   );
        blit( bmp, zbmp, 0, 0, 0, 0, sx, sy );
        set_color_conversion(  COLORCONV_TOTAL  );
        gbm.bpp = 24;
        }
    }

/*    printf("gbm.bpp <%d>\n",gbm.bpp);*/

    data = BMPtoGBM(&gbm, zbmp );
    PALETTEtoGBMRGB(gbmrgb,pal);

    if(zbmp!=NULL) destroy_bitmap( zbmp );
    if ( (rc = gbm_write(filename, fd, ft_src, &gbm, gbmrgb, data, "")) != GBM_ERR_OK )
    {
    return -1;
    u_close(fd);
    }
    if(data!=NULL) u_free(data);
    u_close(fd);
/*    errno = NULL;*/
    errno = 0;
    return 0;
}















/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
/*********************************************************************/
/*********************************************************************/


/* RGB -> color mapping table. speeds things up */
RGB_MAP rgb_table, *ruga;


/* load_gbm:
 *  Loads a bitmap file using the GBM library, then convert it to the
 *  Allegro bitmap & pallete format & return the bitmap, writing the
 *  pallete data in the specified pallete (this should be an array of
 *  at least 256 RGB structures).
 */
BITMAP *load_gbm( const char *_filename, RGB *pal )
{
    int     ft_src=0, rc=0;
    int     fd=0;
    GBM     gbm;
    GBMRGB  gbmrgb[256];
    unsigned char *data = NULL;
    BITMAP  *bmp = NULL;
    int     i;
    char    *filename = NULL;
    BITMAP  *pspr0 = NULL;
    int     x,y,c,r,g,b;

    filename = fix_filename_case( _filename );
    filename = fix_filename_slashes( filename );

//msgbox_("filename: %s", filename );

    if ( gbm_guess_filetype( filename , &ft_src ) != GBM_ERR_OK ){
    msgbox_("can't determine filetype from extension: %s", filename );
    return NULL;
    }
    if ( (fd = u_open( filename , "rb" )) == -1 ){
    msgbox_("can't open file for reading binary: %s", filename );
    return NULL;
    }


 if ( (rc = gbm_read_header( filename, fd, ft_src, &gbm, "" )) != GBM_ERR_OK )
    {
    // fails often on unsupported bitdepth in file.
    msgbox_("read header: <%s>", gbm_err(rc));
    u_close(fd);
    return NULL;
	}

 if ( (rc = gbm_read_palette( fd, ft_src, &gbm, gbmrgb )) != GBM_ERR_OK )
	{
    msgbox_("read palette: <%s>", gbm_err(rc));
    u_close(fd);
    return NULL;
    }

 if ( (data = u_malloc((((gbm.w * gbm.bpp + 31)/32) * 4*gbm.h))+99) == NULL )
	{
    u_close(fd);
    return NULL;
	}

 if ( (rc = gbm_read_data(fd, ft_src, &gbm, data)) != GBM_ERR_OK )
    {
    msgbox_("read data: <%s>", gbm_err(rc));
    u_free(data);
    u_close(fd);
    return NULL;
	}
    u_close(fd);



    bmp = GBMtoBMP( &gbm, data, (GBMRGB *)&gbmrgb ); if( bmp==NULL ) return NULL;
    u_free( data );


    if( gbm.bpp==1 && pal != NULL ){   /*   b/w image, clear palette   */
        create_vga_palette( pal );
        pal[255].r=pal[255].g=pal[255].b=255;
        return bmp;
    }

    if( gbm.bpp <= 8 && pal != NULL ){
        GBMRGBtoPALETTE( gbmrgb, pal );
        }

/*
    if( gbm.bpp>8 && pal != NULL ){
    }
*/


/*
    if( gbm.bpp >= 24  ){    // reduce to bpp 8 by mapping to closest color
        pspr0 = create_bitmap_ex( 8, gbm.w, gbm.h );
        if( pspr0 == NULL ){
        destroy_bitmap( bmp );
        return NULL;
        }
        ruga = rgb_map;
        if( pal != NULL ) create_rgb_table( &rgb_table, pal, NULL);
        rgb_map = &rgb_table;                        // for reducing colors
        for(i=0;i<255;i++)  pal[i].r = pal[i].g = pal[i].b = (i>>2);
        for(y=0;y<gbm.h;y++){
        for(x=0;x<gbm.w;x++){
        c = getpixel(bmp,x,y);
        r = getr24(c);
        g = getg24(c);
        b = getb24(c);
        //putpixel(pspr0,x,y, makecol8(r,g,b) );    // testing
        c = ((r+g+b)/3) & 255;
        putpixel(pspr0,x,y, c );    // convert 24 bpp to 8 bit greyscale
        }}
        destroy_bitmap( bmp );
        rgb_map = ruga;
        return  pspr0;
    }
*/

    return bmp;
}


