/*
 * Fill handler subroutines.
 * Fill type color may be implemented later on.
 * Black/white fill maps are remapped to current color.
 *
 * Fill operations: Normal, Masked, Xor.
 * Fill Types:      Solid, Black/white, Color.
 * Size classes:    8x8, free sizes.
 *
 * The file containing the fill maps is a regular graphic file.
 *
 *
 *
 *
 *
 *
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <allegro.h>
#include "data.h"
#include "ll.h"
#include "ed.h"
#include "dlg.h"
#include "butil.h"

#include "grey.h"
#include "subs.h"       // remap_bitmap()

int    fi_esx; /* size for each element */
int    fi_esy;
int    fi_spx; /* space between elements */
int    fi_spy;
int    fi_x;   /* position */
int    fi_y;
int    fi_sx;  /* size for all blocks */
int    fi_sy;
static int fi_group;        /* current group */
static int grptot;          /* total number of buttons  */
static int grpgrp;          /* number of groups */
static int grpnum;          /* number of buttons in one group */
static int grpnummod;       /* number of buttons in last group */





/**** prototypes ****/
int dlg_fillselect( int group );
int load_fillpatterns(char *);
/**** prototypes ****/



/**** Common Data for all dialog functions ****/
//static  PALETTE opal;
//static  int file_gui1,   file_gui2;
//static  RGB file_rgb1 = {20,30,34};
//static  RGB file_rgb2 = {40,50,60};
//static  RGB file_rgb3 = {50,50,20};
/**** Common Data for all dialog functions ****/



static  int j;
/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                     DIALOG FOR SELECTING FILL PATTERN

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/


/** helper functions **/
static int s_radio_op(int,DIALOG *,int); /*generic radio button handler*/
static int s_btn_r(int,DIALOG *,int);
static int s_btn_l(int,DIALOG *,int);
static int s_btn_ok7(int,DIALOG *,int);
static int s_btn_cancel6(int,DIALOG *,int); /* generic cancel button */
static int s_fop1(int,DIALOG *,int);
static int s_fop2(int,DIALOG *,int);
static int s_fop3(int,DIALOG *,int);
static int s_fty1(int,DIALOG *,int);
static int s_fty2(int,DIALOG *,int);
static int s_fty3(int,DIALOG *,int);
static int s_fca1(int,DIALOG *,int);
static int s_fca2(int,DIALOG *,int);
static int fi_bmp_block(int,DIALOG *,int);
static int fi_bmp_sblock(int,DIALOG *,int);
/** helper functions **/

static int fillop_int1,fillop_int2,fillop_int3;
static int filltype_int1,filltype_int2,filltype_int3;
static int fillclass_int1, fillclass_int2;


/* (dialog proc)    (x)  (y)    (w)  (h)  (fg)  (bg) (key) (flags) (d1) (d2) (dp) (dp2) (dp3)*/
DIALOG dlg_fill[]={
 { ed_win        ,    0,  0,   320, 240,    0,  0,    0,      0,   1,     1,  "Fill Operations",NULL,NULL },
 { ed_frame      ,    0,  0,    90,  12,    0,  0,    0,      0,   0,    58,  "Fill Op" },
 { s_fop1        ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "Normal",  (int *)&fillop_int1 },
 { s_fop2        ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "or",      (int *)&fillop_int2 },
 { s_fop3        ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "and",     (int *)&fillop_int3 },
 { ed_frame      ,    0,  0,    80,  12,    0,  0,    0,      0,   0,    58,  "Type (N/A)" },
 { s_fty1        ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "solid",   (int *)&filltype_int1 },
 { s_fty2        ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "b/w",     (int *)&filltype_int2 },
 { s_fty3        ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "color",   (int *)&filltype_int3 },
 { ed_frame      ,    0,  0,    80,  12,    0,  0,    0,      0,   0,    58,  "Size" },
 { s_fca1        ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "8x8",     (int *)&fillclass_int1 },
 { s_fca2        ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "SRC rect",(int *)&fillclass_int2 },
 { d_text_proc   ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "Total:  " },
 { d_text_proc   ,    0,  0,    32,  12,    0,  0,    0,      0,   0,     0,  "Current:" },
 { s_btn_l       ,    0,  0,    40,  22,    0,  0,    0, D_EXIT,   0,     0,  "<<"    },
 { s_btn_r       ,    0,  0,    40,  22,    0,  0,    0, D_EXIT,   0,     0,  ">>"    },

 { fi_bmp_block  ,    0,  0,    24,  12,    0,  0,    0,      0,   0,     0,  NULL,NULL,NULL },
 { d_bitmap_proc ,    0,  0,    32,  32,    0,  0,    0,      0,   0,     0,  NULL,NULL,NULL },

 { s_btn_ok7     ,    0,  0,    80,  22,    0,  0,    0, D_EXIT,   0,     0,  "OK"    },
 { s_btn_cancel6 ,    0,  0,    80,  22,    0,  0,   27, D_EXIT,   0,     0,  "CANCEL"},
 { NULL,0,0 },
 { NULL,0,0 },
};
#define FILLOP1 2
#define FILLOP2 3
#define FILLOP3 4
#define FILLTYPE1 6
#define FILLTYPE2 7
#define FILLTYPE3 8
#define FILLCLASS1 10
#define FILLCLASS2 11
#define BTNLL 14
#define BTNRR 15
#define BMPBLOCK 16
#define BMPSMALLBLK 17


DIALOGXYCOORDS dlg_fill2[]={
 {   0,   0 },   /* ed_win       */
 {  20,  30 },   /* ed_frame     */
 {  30,  50 },   /* s_fop1       */
 {  30,  62 },   /* s_fop2       */
 {  30,  74 },   /* s_fop3       */
 { 117,  30 },   /* ed_frame     */
 { 125,  50 },   /* s_fty1       */
 { 125,  62 },   /* s_fty2       */
 { 125,  74 },   /* s_fty3       */
 { 202,  30 },   /* ed_frame     */
 { 210,  50 },   /* s_fca1       */
 { 210,  64 },   /* s_fca2       */
 {  20, 100 },   /* d_text_proc  */
 {  20, 112 },   /* d_text_proc  */
 { 187, 100 },   /* s_btn_l      */
 { 241, 100 },   /* s_btn_r      */
 {  20, 130 },   /*  fi_bmp_block               */
 { 275, 138 },   /*             small showfill  */
 {  20, 190 },   /*  s_btn_ok7       */
 { 130, 190 },   /*  s_btn_cancel6   */
 { 0,0 },
 { 0,0 }
};


static  int firstinit = 0;
static  int color1=0, color2=0, color3=0;
static  BITMAP *fillpat=NULL, *pspr1=NULL;

static BITMAP *pact=NULL;


/*
 * input: group number
 * returns currently selected group
 */
int dlg_fillselect( int group )
{
    int     i, new_sx=0, new_sy=0;
    int     sx,width;

    if(fillstruct.enabled==FALSE) return group;

    fi_group = group;  /* current button group number */


    if(firstinit==0){

    firstinit++;
    fillstruct.blocks =  fillstruct.bmpfixed->h/8;  /* autoadapt amount */
    grptot = fillstruct.blocks;  /* total amount of blocks */
    fi_esx = 8 * 4;   /* size of each element */
    fi_esy = 8 * 4;
    fi_spx = 7;     /* space between elements */
    fi_spy = 7;
    fi_x = 20;      /*  position  */
    fi_y = 130;

    /* fit maximum number of buttons on screen */

    sx     =  280;  /* maximum width */
    width  =  (fi_esx+fi_spx);
    grpnum =    sx / width;
    grpnum--;
    grpgrp = grptot / grpnum;            // numbers of groups
    /* fit maximum number of buttons on screen */

    grpnummod = grptot - grpnum * grpgrp;    /* modulus */
    fi_sx  = 1 + fi_spx + (fi_esx+fi_spx) * (grpnum) + 1 ;
    fi_sy  = fi_esy + fi_spy * 2;
    /* limit range if group number is too big. */
    if( fi_group >= grpgrp && grpnummod==0) fi_group=0;
    if( fi_group >  grpgrp && grpnummod!=0) fi_group=0;

//    if((pspr1 = create_bitmap_ex( 8, fi_sx , fi_sy ))==NULL) error_("cannot create bitmap");
    if((pspr1 = create_bitmap_ex( g.bpp, fi_sx , fi_sy ))==NULL) error_("cannot create bitmap");
    clear_bitmap( pspr1 );
    if((fillpat = create_bitmap_ex( g.bpp, fi_esx , fi_esy ))==NULL) error_("cannot create bitmap");
    clear_bitmap( fillpat );
    dlg_fill[BMPBLOCK].w  = fi_sx;
    dlg_fill[BMPBLOCK].h  = fi_sy;
    dlg_fill[BMPBLOCK].dp = pspr1;
    dlg_fill[BMPSMALLBLK].w  = fi_esx;
    dlg_fill[BMPSMALLBLK].h  = fi_esy;
    dlg_fill[BMPSMALLBLK].dp = fillpat;

    }




    if( g.bpp == 8 ){
        color1 = 128;
        color2 = 130;
        color3 = 129;
    }else{
        color1 = makecol(120,120,120);
        color2 = makecol(150,160,170);
        color3 = makecol(180,190,200);
    }


/*
printf(" fi_sx  %d \n", fi_sx  );
printf(" fi_sy  %d \n", fi_sy  );
printf(" fi_esx %d \n", fi_esx );
printf(" fi_esy %d \n", fi_esy );
*/

    rectfill(pspr1,0,0,fi_sx-1,fi_sy-1, color2     );
    rectfill(fillpat,0,0,fi_esx-1,fi_esy-1, color1 );


    fillop_int1    = fillop_int2    = fillop_int3   = FALSE;
    filltype_int1  = filltype_int2  = filltype_int3 = FALSE;
    fillclass_int1 = fillclass_int2 = FALSE;


    dlg_fill[ FILLCLASS1 ].flags = dlg_fill[ FILLCLASS2 ].flags = D_DIRTY;
    if(fillstruct.operation==0) fillop_int1=TRUE;
    if(fillstruct.operation==1) fillop_int2=TRUE;
    if(fillstruct.operation==2) fillop_int3=TRUE;
    if(fillstruct.type==0)      filltype_int1=TRUE;
    if(fillstruct.type==1)      filltype_int2=TRUE;
    if(fillstruct.type==2)      filltype_int3=TRUE;
    if(fillstruct.class==0){    fillclass_int1=TRUE;}
    if(fillstruct.class==1){    fillclass_int2=TRUE;}


    // make fill pattern
    i = fillstruct.selected;
    blit( fillstruct.bmpfixed, fillstruct.bmp8x8,    0,(i*8),0,0,8,8);
    blit( fillstruct.bmp8x8,   fillstruct.bmp8x8tmp, 0,0,0,0,8,8);


// TEST
    if( g.bpp == 8 )
        remap_bitmap( fillstruct.bmp8x8tmp, 255, color1 );
    else
        remap_bitmap2( fillstruct.bmp8x8,fillstruct.bmp8x8tmp, 255, color1 );

    clear_bitmap(fillpat);
    drawing_mode(DRAW_MODE_COPY_PATTERN, fillstruct.bmp8x8tmp, 0, 0);
    rectfill( fillpat, 0, 0,  fi_esx,  fi_esy, -1 );
//    rectfill( fillpat, 1, 1,  fi_esx,  fi_esy, 0 );     // TEST
    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
    rect(     fillpat, 0, 0, fi_esx-1, fi_esy-1, color1);
    // make fill pattern


//readkey();
    prepare_prefix_dlgs( (DIALOG *)&dlg_fill, (DIALOGXYCOORDS *)&dlg_fill2,-1,-1,128 );
    i = do_dialog( (DIALOG *)&dlg_fill, -1 );
    prepare_suffix_dlgs( (DIALOG *)&dlg_fill, (DIALOGXYCOORDS  *)&dlg_fill2 );






    // ------------- FILL --------------------------------------
    if( fillclass_int2==TRUE && clips.flag == TRUE ){
    // bitmap used for filling operation must be a multiple of two
    //
    new_sx = clips.sx;
    new_sy = clips.sy;
    new_sx &= ~1;
    new_sy &= ~1;
    if( fillstruct.bmpfree != NULL) destroy_bitmap( fillstruct.bmpfree );
    if((fillstruct.bmpfree = create_bitmap( new_sx, new_sy ))==NULL )error_("cannot create bitmap");
    blit( ll_get_sprite( clips.block ), fillstruct.bmpfree, clips.x1, clips.y1, 0,0, new_sx, new_sy  );
    }
    // ------------- FILL --------------------------------------




    return  (fi_group);      /* current button group number */
}


/* on MSG_USER, set flag oto FALSE */
static int s_radio_op(int msg, DIALOG *d, int c) /*fill op radio btns, base*/
{
    int *flagptr;
    flagptr = (int *)d->dp2;
    switch( msg ){
    case MSG_USER:    *flagptr = FALSE;    scare_mouse();
    msg = ed_set(MSG_DRAW,d,c);    unscare_mouse();    msg=D_O_K;    break;
    default:
    msg = ed_set(msg,d,c);    break;
    }
    return msg;
}

static int s_fop1(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_fill[FILLOP2], MSG_USER, 0 );
    object_message( &dlg_fill[FILLOP3], MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int s_fop2(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_fill[FILLOP1], MSG_USER, 0 );
    object_message( &dlg_fill[FILLOP3], MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int s_fop3(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_fill[FILLOP1], MSG_USER, 0 );
    object_message( &dlg_fill[FILLOP2], MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int s_fty1(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_fill[FILLTYPE2], MSG_USER, 0 );
    object_message( &dlg_fill[FILLTYPE3], MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int s_fty2(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_fill[FILLTYPE1], MSG_USER, 0 );
    object_message( &dlg_fill[FILLTYPE3], MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int s_fty3(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_fill[FILLTYPE1], MSG_USER, 0 );
    object_message( &dlg_fill[FILLTYPE2], MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int s_fca1(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_fill[FILLCLASS2], MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int s_fca2(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_fill[FILLCLASS1], MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}



















static int s_btn_ok7(int msg, DIALOG *d, int c)
{
    switch( msg ){
    case MSG_IDLE:
    return D_O_K;
    case MSG_CLICK:

    if(fillop_int1==TRUE)   fillstruct.operation=0;
    if(fillop_int2==TRUE)   fillstruct.operation=1;
    if(fillop_int3==TRUE)   fillstruct.operation=2;
    if(filltype_int1==TRUE) fillstruct.type=0;
    if(filltype_int2==TRUE) fillstruct.type=1;
    if(filltype_int3==TRUE) fillstruct.type=2;
    if(fillclass_int1==TRUE)fillstruct.class=0;
    if(fillclass_int2==TRUE)fillstruct.class=1;

    msg = D_EXIT;
    break;
    default:
    msg = d_button_proc(msg,d,c);
    break;
    }
    return msg;
}
static int s_btn_cancel6(int msg, DIALOG *d, int c) /* generic cancel button */
{   /* standard cancel button */
    switch( msg ){
    case MSG_IDLE:
    return D_O_K;
    case MSG_CLICK:
    do j=mouse_b; while((j&7)!=0 );  /* wait until user releases mouse button*/
    msg = D_EXIT;
    break;
    default:
    msg = d_button_proc(msg,d,c);
    break;
    }
    return msg;
}
static int s_btn_l(int msg, DIALOG *d, int c)
{
    if(msg==MSG_IDLE||msg==MSG_END) return D_O_K;
    if(msg==MSG_CLICK){
    if( fi_group == 0 ) fi_group = grpgrp+1;
    fi_group--;

    d_button_proc(MSG_CLICK,d,c);

//    scare_mouse();
//    d_button_proc(MSG_DRAW,d,c);    /* draw self */
//    SEND_MESSAGE( dlg_fill + BMPBLOCK, MSG_DRAW, 0 );
//    unscare_mouse();

    broadcast_dialog_message( MSG_DRAW, 0);


    return D_O_K;
    }
    return d_button_proc(msg,d,c);
}
static int s_btn_r(int msg, DIALOG *d, int c)
{
    if(msg==MSG_IDLE||msg==MSG_END) return D_O_K;
    if(msg==MSG_CLICK){
    fi_group++;
    if( fi_group >= grpgrp && grpnummod==0) fi_group=0;
    if( fi_group >  grpgrp && grpnummod!=0) fi_group=0;


    d_button_proc(MSG_CLICK,d,c);

//    scare_mouse();
//    d_button_proc(MSG_DRAW,d,c);    /* draw self */
//    SEND_MESSAGE( dlg_fill + BMPBLOCK, MSG_DRAW, 0 );
//    unscare_mouse();

    broadcast_dialog_message( MSG_DRAW, 0);
    return D_O_K;
    }
    return d_button_proc(msg,d,c);
}





/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                END  DIALOG FOR SELECTING FILL PATTERN

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/



/*
 * Loads the actual bitmap
 *
 *
 */
int load_fillpatterns( char *filename )
{
/*    fillstruct.filename = filename;*/
    return 0;
}


static int fi_bmp_block(int msg, DIALOG *d, int c)
{
    int sel_index;
    int mx,my;
    int x,y;
    int top,i;
    int x1,x2,y1,y2;    /* button range */
    int btx,bty;        /* button x,y in screen coords */




    if(msg==MSG_IDLE) return D_O_K;
    if(msg==MSG_XCHAR || msg==MSG_KEY || msg==MSG_CHAR ) return D_O_K;


    btx = d->x;
    bty = d->y;
    mx  = mouse_x;
    my  = mouse_y;
    sel_index = 0;


    if( msg==MSG_CLICK ){
        sel_index=-1;
        if(fi_group==grpgrp) top=grpnummod; else  top = grpnum;
    for(i=0;i<top+1;i++){
        x1 = d->x+fi_spx+((fi_esx+fi_spx)*i);
        x2 = x1+fi_esx-fi_spx;
        y1 = d->y+fi_spy+1;
        y2 = y1+fi_esy;
        if( x1 > mx && mx < x2 ){
            btx = d->x+fi_spx+((fi_esx+fi_spx)*(i-1))+1;
            bty = d->y+fi_spy+1;
            sel_index = fi_group*grpnum + (i-1);
            i=grpnum+2;
            break;
        }
    }/* for */
    }/* msg==msg_click */



    switch(msg){

    case MSG_DRAW:
    rectfill(d->dp,1,1,d->w-2,d->h-2,   color3 );
    rect(    d->dp,0,0,d->w-1,d->h-1,   color1 );
//    textprintf( d->dp, font, 10,10, color3, "%s ",  "hello" );



    if(fillstruct.enabled==TRUE){
    if( fi_group == grpgrp ){
        top = grpnummod;
    }else{  top = grpnum;   }
    for(i=0; i < top ;i++) {
        x = fi_spx+(fi_esx+fi_spx)*i+1;
        y = fi_spy;
        // 400% expansion
        stretch_blit( fillstruct.bmpfixed2, d->dp,   // no error here on bpp 24 anymore
        0, (8 * fi_group * grpnum)+(i * 8), 8, 8,
        x, y, 8*4, 8*4 );
        if( (fi_group*grpnum+i)==fillstruct.selected ){
            rect(d->dp,x-1,y-1,x+fi_esx,y+fi_esy,    0   );
            rect(d->dp,x-2,y-2,x+fi_esx+1,y+fi_esy+1,color1);
            rect(d->dp,x-3,y-3,x+fi_esx+2,y+fi_esy+2,color1);
            }
    }// for
    remap_bitmap(d->dp, 255, color1 );
    }
    acquire_screen();
    blit( (BITMAP *) d->dp, screen, 0,0, d->x, d->y, d->w, d->h);
    release_screen();

//    msg = d_bitmap_proc(msg,d,c);
    return D_O_K;
    break;



    case MSG_CLICK:

    if(sel_index!=-1){
    scare_mouse();
    xchg_bitmap_rect(screen, 0, g.buttoncolor, btx,bty-1, tb_esx+2, tb_esy+2 );
    unscare_mouse();
    do j=mouse_b; while((j&7)!=0 );


    fillstruct.selected = sel_index;


    /* make fill pattern */
    i=fillstruct.selected;
    blit( fillstruct.bmpfixed, fillstruct.bmp8x8,    0,(i*8),0,0,8,8);
    blit( fillstruct.bmp8x8,   fillstruct.bmp8x8tmp, 0,0,0,0,8,8);
    clear_bitmap(fillpat);


// TEST
       if(g.bpp == 8 ){
       remap_bitmap( fillstruct.bmp8x8tmp, 255, color1 );
       }else{
       // TEST
       remap_bitmap2( fillstruct.bmp8x8,fillstruct.bmp8x8tmp, 255, color1 );
       }





    drawing_mode(DRAW_MODE_COPY_PATTERN, fillstruct.bmp8x8tmp, 0, 0 );
//    rectfill(fillpat, 1, 1, fi_esx-2, fi_esy-2, 0 );

     floodfill( fillpat, 0, 0, color1 );




    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
    rect(fillpat, 0, 0, fi_esx-1, fi_esy-1, color1);


//    scare_mouse();
//    SEND_MESSAGE( dlg_fill + BMPBLOCK,    MSG_DRAW, 0 );
//    SEND_MESSAGE( dlg_fill + BMPSMALLBLK, MSG_DRAW, 0 );
//    unscare_mouse();

    broadcast_dialog_message( MSG_DRAW, 0);
    }
    return D_O_K;


    break;
    default:
    }
    return D_O_K;
}






/* ******************************************************* */







